/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.relational.continuation.TypedQueryArgument;
import com.apple.foundationdb.relational.recordlayer.query.LiteralsUtils;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OrderedLiteral {
    static final Comparator<OrderedLiteral> COMPARATOR = (o1, o2) -> {
        String o2Scope;
        if (!o1.isScoped() && !o2.isScoped()) {
            return Integer.compare(o1.getTokenIndex(), o2.getTokenIndex());
        }
        if (!o1.isScoped() || !o2.isScoped()) {
            return o1.isScoped() ? 1 : -1;
        }
        String o1Scope = Assert.optionalUnchecked(o1.getScopeMaybe());
        int scopeComparisonResult = o1Scope.compareTo(o2Scope = Assert.optionalUnchecked(o2.getScopeMaybe()));
        if (scopeComparisonResult != 0) {
            return scopeComparisonResult;
        }
        return Integer.compare(o1.getTokenIndex(), o2.getTokenIndex());
    };
    @Nonnull
    private final Type type;
    @Nullable
    private final Object literalObject;
    @Nullable
    private final Integer unnamedParameterIndex;
    @Nullable
    private final String parameterName;
    private final int tokenIndex;
    @Nonnull
    private final Optional<String> scope;

    OrderedLiteral(@Nonnull Type type, @Nullable Object literalObject, @Nullable Integer unnamedParameterIndex, @Nullable String parameterName, int tokenIndex, @Nonnull Optional<String> scope) {
        Verify.verify(unnamedParameterIndex == null || parameterName == null);
        this.type = type;
        this.literalObject = literalObject;
        this.unnamedParameterIndex = unnamedParameterIndex;
        this.parameterName = parameterName;
        this.tokenIndex = tokenIndex;
        this.scope = scope;
    }

    @Nonnull
    public Type getType() {
        return this.type;
    }

    @Nullable
    public Object getLiteralObject() {
        return this.literalObject;
    }

    @Nullable
    public Integer getUnnamedParameterIndex() {
        return this.unnamedParameterIndex;
    }

    @Nullable
    public String getParameterName() {
        return this.parameterName;
    }

    int getTokenIndex() {
        return this.tokenIndex;
    }

    public boolean isScoped() {
        return this.scope.isPresent();
    }

    @Nonnull
    public Optional<String> getScopeMaybe() {
        return this.scope;
    }

    @Nonnull
    public String getConstantId() {
        return OrderedLiteral.constantId(this.tokenIndex, this.getScopeMaybe());
    }

    public boolean isQueryLiteral() {
        return this.unnamedParameterIndex == null && this.parameterName == null;
    }

    public boolean isUnnamedParameter() {
        return this.unnamedParameterIndex != null;
    }

    public boolean isNamedParameter() {
        return this.parameterName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrderedLiteral)) {
            return false;
        }
        OrderedLiteral that = (OrderedLiteral)o;
        return this.scope.equals(that.scope) && this.tokenIndex == that.tokenIndex;
    }

    public int hashCode() {
        if (this.scope.isPresent()) {
            return Objects.hash(this.scope, this.tokenIndex);
        }
        return Objects.hash(this.tokenIndex);
    }

    public boolean deepEquals(@Nonnull OrderedLiteral other) {
        return this.equals(other) && Objects.equals(this.parameterName, other.parameterName) && Objects.equals(this.unnamedParameterIndex, other.unnamedParameterIndex) && Objects.equals(this.literalObject, other.literalObject);
    }

    public String toString() {
        return this.parameterName != null ? "?" + this.parameterName : (String)(this.unnamedParameterIndex != null ? "?" + this.unnamedParameterIndex : "\u2205") + ":" + String.valueOf(this.literalObject) + "@" + this.scope.orElse("") + this.tokenIndex;
    }

    @Nonnull
    TypedQueryArgument toProto(@Nonnull PlanSerializationContext serializationContext, int literalTableIndex) {
        Type type = this.getType();
        TypedQueryArgument.Builder argumentBuilder = TypedQueryArgument.newBuilder().setType(type.toTypeProto(serializationContext)).setLiteralsTableIndex(literalTableIndex).setTokenIndex(this.getTokenIndex());
        this.scope.ifPresent(argumentBuilder::setScope);
        argumentBuilder.setObject(LiteralsUtils.objectToLiteralObjectProto(type, this.getLiteralObject()));
        if (!this.isQueryLiteral()) {
            Verify.verify(this.isNamedParameter() || this.isUnnamedParameter());
            if (this.isNamedParameter()) {
                argumentBuilder.setParameterName(Objects.requireNonNull(this.getParameterName()));
            } else {
                argumentBuilder.setUnnamedParameterIndex(Objects.requireNonNull(this.getUnnamedParameterIndex()));
            }
        }
        return argumentBuilder.build();
    }

    @Nonnull
    private static OrderedLiteral forQueryLiteral(@Nonnull Type type, @Nullable Object literalObject, int tokenIndex, @Nonnull Optional<String> scope) {
        return new OrderedLiteral(type, literalObject, null, null, tokenIndex, scope);
    }

    @Nonnull
    private static OrderedLiteral forUnnamedParameter(@Nonnull Type type, @Nullable Object literalObject, int unnamedParameterIndex, int tokenIndex, @Nonnull Optional<String> scope) {
        return new OrderedLiteral(type, literalObject, unnamedParameterIndex, null, tokenIndex, scope);
    }

    @Nonnull
    private static OrderedLiteral forNamedParameter(@Nonnull Type type, @Nullable Object literalObject, @Nonnull String parameterName, int tokenIndex, @Nonnull Optional<String> scope) {
        return new OrderedLiteral(type, literalObject, null, parameterName, tokenIndex, scope);
    }

    @Nonnull
    public static OrderedLiteral fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull TypeRepository typeRepository, @Nonnull TypedQueryArgument argumentProto) {
        Optional<String> scopeMaybe;
        Type argumentType = Type.fromTypeProto(serializationContext, argumentProto.getType());
        Optional<String> optional = scopeMaybe = argumentProto.hasScope() ? Optional.of(argumentProto.getScope()) : Optional.empty();
        if (argumentProto.hasUnnamedParameterIndex()) {
            return OrderedLiteral.forUnnamedParameter(argumentType, LiteralsUtils.objectFromLiteralObjectProto(typeRepository, argumentType, argumentProto.getObject()), argumentProto.getUnnamedParameterIndex(), argumentProto.getTokenIndex(), scopeMaybe);
        }
        if (argumentProto.hasParameterName()) {
            return OrderedLiteral.forNamedParameter(argumentType, LiteralsUtils.objectFromLiteralObjectProto(typeRepository, argumentType, argumentProto.getObject()), argumentProto.getParameterName(), argumentProto.getTokenIndex(), scopeMaybe);
        }
        return OrderedLiteral.forQueryLiteral(argumentType, LiteralsUtils.objectFromLiteralObjectProto(typeRepository, argumentType, argumentProto.getObject()), argumentProto.getTokenIndex(), scopeMaybe);
    }

    @Nonnull
    public static String constantId(int tokenIndex, @Nonnull Optional<String> scope) {
        return "c" + scope.orElse("") + tokenIndex;
    }

    @Nonnull
    @VisibleForTesting
    public static String constantId(int tokenIndex) {
        return OrderedLiteral.constantId(tokenIndex, Optional.empty());
    }
}

