/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.TreeLike;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.generated.RelationalParser;
import com.apple.foundationdb.relational.recordlayer.util.Hex;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.Base64;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

@API(value=API.Status.EXPERIMENTAL)
public final class ParseHelpers {
    @Nonnull
    public static final TypeRepository EMPTY_TYPE_REPOSITORY = TypeRepository.empty();

    private ParseHelpers() {
    }

    @Nonnull
    public static Object parseDecimal(@Nonnull String valueAsString) {
        int lastCharIdx = valueAsString.length() - 1;
        Assert.thatUnchecked(lastCharIdx >= 0);
        if (valueAsString.contains(".")) {
            char lastCharacter = valueAsString.charAt(lastCharIdx);
            switch (lastCharacter) {
                case 'F': 
                case 'f': {
                    return Float.valueOf(Float.parseFloat(valueAsString.substring(0, lastCharIdx)));
                }
                case 'D': 
                case 'd': {
                    return Double.parseDouble(valueAsString.substring(0, lastCharIdx));
                }
            }
            return Double.parseDouble(valueAsString);
        }
        char lastCharacter = valueAsString.charAt(lastCharIdx);
        switch (lastCharacter) {
            case 'L': 
            case 'l': {
                return Long.parseLong(valueAsString.substring(0, lastCharIdx));
            }
            case 'I': 
            case 'i': {
                return Integer.parseInt(valueAsString.substring(0, lastCharIdx));
            }
        }
        long result = Long.parseLong(valueAsString);
        if (Integer.MIN_VALUE <= result && result <= Integer.MAX_VALUE) {
            return Math.toIntExact(result);
        }
        return result;
    }

    @Nonnull
    public static String underlineParsingError(@Nonnull Recognizer<?, ?> recognizer, @Nonnull Token offendingToken, int line, int charPositionInLine) {
        StringBuilder stringBuilder = new StringBuilder();
        CommonTokenStream tokens = (CommonTokenStream)recognizer.getInputStream();
        String input = tokens.getTokenSource().getInputStream().toString();
        String[] lines = input.split("\n");
        String errorLine = lines[line - 1];
        stringBuilder.append(errorLine).append("\n");
        stringBuilder.append(" ".repeat(Math.max(0, charPositionInLine)));
        int start = offendingToken.getStartIndex();
        int stop = offendingToken.getStopIndex();
        if (stop < start) {
            stringBuilder.append("^^");
        } else if (start >= 0) {
            stringBuilder.append("^".repeat(Math.max(0, stop - start + 1)));
        }
        return stringBuilder.toString();
    }

    public static boolean isConstant(@Nonnull RelationalParser.ExpressionsContext expressionsContext) {
        for (RelationalParser.ExpressionContext exp : expressionsContext.expression()) {
            if (!(exp instanceof RelationalParser.PredicatedExpressionContext)) {
                return false;
            }
            RelationalParser.PredicatedExpressionContext predicate = (RelationalParser.PredicatedExpressionContext)exp;
            if (predicate.predicate() != null) {
                return false;
            }
            RelationalParser.ExpressionAtomContext expressionAtom = predicate.expressionAtom();
            if (expressionAtom instanceof RelationalParser.ConstantExpressionAtomContext) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public static byte[] parseBytes(String text) {
        try {
            if (text.toLowerCase(Locale.ROOT).startsWith("xstartswith_") && text.endsWith("'")) {
                String input = text.substring(text.indexOf("'") + 1, text.length() - 1);
                return input.length() % 2 == 0 ? Hex.decodeHex(input) : Hex.decodeHex(input + "0");
            }
            if (text.toLowerCase(Locale.ROOT).startsWith("x'") && text.endsWith("'")) {
                return Hex.decodeHex(text.substring(2, text.length() - 1));
            }
            if (text.toLowerCase(Locale.ROOT).startsWith("b64'") && text.endsWith("'")) {
                return Base64.getDecoder().decode(text.substring(4, text.length() - 1));
            }
            throw new RelationalException("Could not parse bytes literal", ErrorCode.INVALID_BINARY_REPRESENTATION).toUncheckedWrappedException();
        }
        catch (RelationalException e) {
            throw e.toUncheckedWrappedException();
        }
        catch (IllegalArgumentException e) {
            throw new RelationalException("Could not parse bytes literal", ErrorCode.INVALID_BINARY_REPRESENTATION, e).toUncheckedWrappedException();
        }
    }

    public static boolean isDescending(@Nonnull RelationalParser.OrderByExpressionContext orderByExpressionContext) {
        return orderByExpressionContext.ASC() == null && orderByExpressionContext.DESC() != null;
    }

    public static boolean isNullsLast(@Nonnull RelationalParser.OrderByExpressionContext orderByExpressionContext, boolean isDescending) {
        return orderByExpressionContext.nulls == null ? isDescending : orderByExpressionContext.FIRST() == null && orderByExpressionContext.LAST() != null;
    }

    public static class ParseTreeLikeAdapter
    implements TreeLike<ParseTreeLikeAdapter> {
        @Nonnull
        private final ParseTree parseTree;
        @Nonnull
        private final Supplier<Iterable<? extends ParseTreeLikeAdapter>> children;

        private ParseTreeLikeAdapter(@Nonnull ParseTree parseTree) {
            this.parseTree = parseTree;
            this.children = Suppliers.memoize(this::computeChildren);
        }

        @Override
        @Nonnull
        public ParseTreeLikeAdapter getThis() {
            return this;
        }

        @Nonnull
        public ParseTree getParseTree() {
            return this.parseTree;
        }

        @Nonnull
        public Iterable<? extends ParseTreeLikeAdapter> computeChildren() {
            ImmutableList.Builder result = ImmutableList.builder();
            for (int i = 0; i < this.parseTree.getChildCount(); ++i) {
                result.add(new ParseTreeLikeAdapter(this.parseTree.getChild(i)));
            }
            return result.build();
        }

        @Override
        @Nonnull
        public Iterable<? extends ParseTreeLikeAdapter> getChildren() {
            return this.children.get();
        }

        @Override
        @Nonnull
        public ParseTreeLikeAdapter withChildren(Iterable<? extends ParseTreeLikeAdapter> iterable) {
            throw new UnsupportedOperationException("adding children to parse tree is not supported");
        }

        @Nonnull
        public static ParseTreeLikeAdapter from(@Nonnull ParseTree parseTree) {
            return new ParseTreeLikeAdapter(parseTree);
        }
    }
}

