/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.ParseTreeInfo;
import com.apple.foundationdb.relational.generated.RelationalParser;
import com.apple.foundationdb.relational.generated.RelationalParserBaseVisitor;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class ParseTreeInfoImpl
implements ParseTreeInfo {
    @Nonnull
    private final RelationalParser.RootContext rootContext;
    @Nonnull
    private final Supplier<ParseTreeInfo.QueryType> queryTypeSupplier;

    private ParseTreeInfoImpl(@Nonnull RelationalParser.RootContext rootContext) {
        this.rootContext = rootContext;
        this.queryTypeSupplier = Suppliers.memoize(this::calculateQueryType);
    }

    @Nonnull
    private ParseTreeInfo.QueryType calculateQueryType() {
        QueryTypeVisitor queryTypeVisitor = new QueryTypeVisitor();
        return (ParseTreeInfo.QueryType)((Object)queryTypeVisitor.visit(this.rootContext));
    }

    @Override
    @Nonnull
    public ParseTreeInfo.QueryType getQueryType() {
        return this.queryTypeSupplier.get();
    }

    @Nonnull
    public RelationalParser.RootContext getRootContext() {
        return this.rootContext;
    }

    @Nonnull
    public static ParseTreeInfoImpl from(@Nonnull RelationalParser.RootContext root) {
        return new ParseTreeInfoImpl(root);
    }

    private static class QueryTypeVisitor
    extends RelationalParserBaseVisitor<ParseTreeInfo.QueryType> {
        private QueryTypeVisitor() {
        }

        @Override
        public ParseTreeInfo.QueryType visitUpdateStatement(RelationalParser.UpdateStatementContext ctx) {
            return ParseTreeInfo.QueryType.UPDATE;
        }

        @Override
        public ParseTreeInfo.QueryType visitInsertStatement(RelationalParser.InsertStatementContext ctx) {
            return ParseTreeInfo.QueryType.INSERT;
        }

        @Override
        public ParseTreeInfo.QueryType visitDeleteStatement(RelationalParser.DeleteStatementContext ctx) {
            return ParseTreeInfo.QueryType.DELETE;
        }

        @Override
        public ParseTreeInfo.QueryType visitQuery(RelationalParser.QueryContext ctx) {
            return ParseTreeInfo.QueryType.SELECT;
        }

        @Override
        public ParseTreeInfo.QueryType visitCreateDatabaseStatement(RelationalParser.CreateDatabaseStatementContext ctx) {
            return ParseTreeInfo.QueryType.CREATE;
        }

        @Override
        public ParseTreeInfo.QueryType visitCreateSchemaStatement(RelationalParser.CreateSchemaStatementContext ctx) {
            return ParseTreeInfo.QueryType.CREATE;
        }

        @Override
        public ParseTreeInfo.QueryType visitCreateSchemaTemplateStatement(RelationalParser.CreateSchemaTemplateStatementContext ctx) {
            return ParseTreeInfo.QueryType.CREATE;
        }

        @Override
        protected ParseTreeInfo.QueryType aggregateResult(ParseTreeInfo.QueryType aggregate, ParseTreeInfo.QueryType nextResult) {
            if (nextResult != null) {
                return nextResult;
            }
            return aggregate;
        }
    }
}

