/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.CascadesPlanner;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalConnection;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metrics.MetricCollector;
import com.apple.foundationdb.relational.api.metrics.RelationalMetric;
import com.apple.foundationdb.relational.recordlayer.query.PlanContext;
import com.apple.foundationdb.relational.recordlayer.query.QueryExecutionContext;
import javax.annotation.Nonnull;

public abstract class Plan<T> {
    @Nonnull
    protected final String query;

    protected Plan(@Nonnull String query) {
        this.query = query;
    }

    public abstract boolean isUpdatePlan();

    public abstract Plan<T> optimize(@Nonnull CascadesPlanner var1, @Nonnull PlanContext var2, @Nonnull PlanHashable.PlanHashMode var3) throws RelationalException;

    public final T execute(@Nonnull ExecutionContext c) throws RelationalException {
        return (T)c.metricCollector.clock(RelationalMetric.RelationalEvent.TOTAL_EXECUTE_QUERY, () -> this.executeInternal(c));
    }

    protected abstract T executeInternal(@Nonnull ExecutionContext var1) throws RelationalException;

    @Nonnull
    public abstract QueryPlanConstraint getConstraint();

    @Nonnull
    public abstract Plan<T> withExecutionContext(@Nonnull QueryExecutionContext var1);

    @Nonnull
    public abstract String explain();

    @Nonnull
    public String getQuery() {
        return this.query;
    }

    public static class ExecutionContext {
        @Nonnull
        final Transaction transaction;
        @Nonnull
        final Options options;
        @Nonnull
        final RelationalConnection connection;
        @Nonnull
        final MetricCollector metricCollector;

        ExecutionContext(@Nonnull Transaction transaction, @Nonnull Options options, @Nonnull RelationalConnection connection, @Nonnull MetricCollector metricCollector) {
            this.transaction = transaction;
            this.options = options;
            this.connection = connection;
            this.metricCollector = metricCollector;
        }

        @Nonnull
        public Options getOptions() {
            return this.options;
        }

        @Nonnull
        public static ExecutionContext of(@Nonnull Transaction transaction, @Nonnull Options options, @Nonnull RelationalConnection connection, @Nonnull MetricCollector metricCollector) {
            return new ExecutionContext(transaction, options, connection, metricCollector);
        }
    }
}

