/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordStoreState;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.ddl.DdlQueryFactory;
import com.apple.foundationdb.relational.api.ddl.MetadataOperationsFactory;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.api.metrics.MetricCollector;
import com.apple.foundationdb.relational.recordlayer.AbstractDatabase;
import com.apple.foundationdb.relational.recordlayer.query.PlannerConfiguration;
import com.apple.foundationdb.relational.recordlayer.query.PreparedParams;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class PlanContext {
    @Nonnull
    private final RecordMetaData metaData;
    @Nonnull
    private final MetricCollector metricCollector;
    @Nonnull
    private final PlannerConfiguration plannerConfiguration;
    @Nonnull
    private final MetadataOperationsFactory metadataOperationsFactory;
    @Nonnull
    private final DdlQueryFactory ddlQueryFactory;
    @Nonnull
    private final URI dbUri;
    @Nonnull
    private final PreparedParams preparedStatementParameters;
    @Nonnull
    private final SchemaTemplate schemaTemplate;
    private final int userVersion;
    private final boolean isCaseSensitive;

    private PlanContext(@Nonnull RecordMetaData metaData, @Nonnull MetricCollector metricCollector, @Nonnull SchemaTemplate schemaTemplate, @Nonnull PlannerConfiguration plannerConfiguration, @Nonnull MetadataOperationsFactory metadataOperationsFactory, @Nonnull DdlQueryFactory ddlQueryFactory, @Nonnull URI dbUri, @Nonnull PreparedParams preparedStatementParameters, int userVersion, boolean isCaseSensitive) {
        this.metaData = metaData;
        this.metricCollector = metricCollector;
        this.schemaTemplate = schemaTemplate;
        this.plannerConfiguration = plannerConfiguration;
        this.metadataOperationsFactory = metadataOperationsFactory;
        this.ddlQueryFactory = ddlQueryFactory;
        this.dbUri = dbUri;
        this.preparedStatementParameters = preparedStatementParameters;
        this.userVersion = userVersion;
        this.isCaseSensitive = isCaseSensitive;
    }

    @Nonnull
    public RecordMetaData getMetaData() {
        return this.metaData;
    }

    @Nonnull
    public MetricCollector getMetricsCollector() {
        return this.metricCollector;
    }

    @Nonnull
    public PlannerConfiguration getPlannerConfiguration() {
        return this.plannerConfiguration;
    }

    @Nonnull
    public Optional<Set<String>> getReadableIndexes() {
        return this.plannerConfiguration.getReadableIndexes();
    }

    @Nonnull
    public RecordQueryPlannerConfiguration getRecordQueryPlannerConfiguration() {
        return this.plannerConfiguration.getRecordQueryPlannerConfiguration();
    }

    @Nonnull
    public MetadataOperationsFactory getConstantActionFactory() {
        return this.metadataOperationsFactory;
    }

    @Nonnull
    public DdlQueryFactory getDdlQueryFactory() {
        return this.ddlQueryFactory;
    }

    @Nonnull
    public URI getDbUri() {
        return this.dbUri;
    }

    @Nonnull
    public PreparedParams getPreparedStatementParameters() {
        return this.preparedStatementParameters;
    }

    @Nonnull
    public SchemaTemplate getSchemaTemplate() {
        return this.schemaTemplate;
    }

    public int getUserVersion() {
        return this.userVersion;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private RecordMetaData metaData;
        private MetricCollector metricCollector;
        private PlannerConfiguration plannerConfiguration;
        private int userVersion;
        private SchemaTemplate schemaTemplate;
        private MetadataOperationsFactory metadataOperationsFactory;
        private DdlQueryFactory ddlQueryFactory;
        private URI dbUri;
        private PreparedParams preparedStatementParameters;
        private boolean isCaseSensitive;

        private Builder() {
        }

        @Nonnull
        @VisibleForTesting
        public Builder withMetadata(@Nonnull RecordMetaData metadata) {
            this.metaData = metadata;
            return this;
        }

        @Nonnull
        public Builder withMetricsCollector(@Nonnull MetricCollector metricCollector) {
            this.metricCollector = metricCollector;
            return this;
        }

        @Nonnull
        public Builder withSchemaTemplate(@Nonnull SchemaTemplate schemaTemplate) {
            this.schemaTemplate = schemaTemplate;
            return this;
        }

        @Nonnull
        @VisibleForTesting
        public Builder withPlannerConfiguration(@Nonnull PlannerConfiguration plannerConfiguration) {
            this.plannerConfiguration = plannerConfiguration;
            return this;
        }

        @Nonnull
        @VisibleForTesting
        public Builder withUserVersion(int userVersion) {
            this.userVersion = userVersion;
            return this;
        }

        @Nonnull
        private Builder isCaseSensitive(boolean isCaseSensitive) {
            this.isCaseSensitive = isCaseSensitive;
            return this;
        }

        @Nonnull
        @VisibleForTesting
        public Builder withConstantActionFactory(@Nonnull MetadataOperationsFactory metadataOperationsFactory) {
            this.metadataOperationsFactory = metadataOperationsFactory;
            return this;
        }

        @Nonnull
        public Builder withDdlQueryFactory(@Nonnull DdlQueryFactory ddlQueryFactory) {
            this.ddlQueryFactory = ddlQueryFactory;
            return this;
        }

        @Nonnull
        public Builder withDbUri(@Nonnull URI dbUri) {
            this.dbUri = dbUri;
            return this;
        }

        @Nonnull
        public Builder withPreparedParameters(@Nonnull PreparedParams parameters) {
            this.preparedStatementParameters = parameters;
            return this;
        }

        @Nonnull
        private static Optional<Set<String>> getReadableIndexes(@Nonnull RecordMetaData metaData, @Nonnull RecordStoreState storeState) {
            if (storeState.allIndexesReadable()) {
                return Optional.empty();
            }
            List<Index> universalIndexes = metaData.getUniversalIndexes();
            return Optional.of(metaData.getAllIndexes().stream().filter(storeState::isReadable).filter(index -> !universalIndexes.contains(index)).map(Index::getName).collect(Collectors.toUnmodifiableSet()));
        }

        @Nonnull
        public Builder fromRecordStore(@Nonnull FDBRecordStoreBase<?> recordStore, @Nonnull Options options) {
            PlannerConfiguration plannerConfig = recordStore.getRecordStoreState().allIndexesReadable() ? PlannerConfiguration.ofAllAvailableIndexes(options) : PlannerConfiguration.of(Builder.getReadableIndexes(recordStore.getRecordMetaData(), recordStore.getRecordStoreState()), options);
            return this.withPlannerConfiguration(plannerConfig).withMetadata(recordStore.getRecordMetaData()).withUserVersion(recordStore.getRecordStoreState().getStoreHeader().getUserVersion()).isCaseSensitive((Boolean)options.getOption(Options.Name.CASE_SENSITIVE_IDENTIFIERS));
        }

        @Nonnull
        public Builder fromDatabase(@Nonnull AbstractDatabase database) {
            return this.withDdlQueryFactory(database.getDdlQueryFactory()).withConstantActionFactory(database.getDdlFactory()).withDbUri(database.getURI());
        }

        private void verify() throws RelationalException {
            Assert.notNull(this.metaData);
            Assert.notNull(this.schemaTemplate);
            Assert.notNull(this.plannerConfiguration);
            Assert.notNull(this.metadataOperationsFactory);
            Assert.notNull(this.ddlQueryFactory);
            Assert.notNull(this.dbUri);
            if (this.preparedStatementParameters == null) {
                this.preparedStatementParameters = PreparedParams.empty();
            }
        }

        @Nonnull
        public PlanContext build() throws RelationalException {
            this.verify();
            return new PlanContext(this.metaData, this.metricCollector, this.schemaTemplate, this.plannerConfiguration, this.metadataOperationsFactory, this.ddlQueryFactory, this.dbUri, this.preparedStatementParameters, this.userVersion, this.isCaseSensitive);
        }

        @Nonnull
        public static Builder create() {
            return new Builder();
        }

        @Nonnull
        @VisibleForTesting
        public static Builder unapply(@Nonnull PlanContext planContext) {
            return Builder.create().withConstantActionFactory(planContext.metadataOperationsFactory).withDbUri(planContext.dbUri).withMetadata(planContext.metaData).withMetricsCollector(planContext.metricCollector).withSchemaTemplate(planContext.schemaTemplate).withDdlQueryFactory(planContext.ddlQueryFactory).withPlannerConfiguration(planContext.plannerConfiguration).withUserVersion(planContext.userVersion).withPreparedParameters(planContext.preparedStatementParameters).isCaseSensitive(planContext.isCaseSensitive);
        }
    }
}

