/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordStoreState;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexMatchCandidateRegistry;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.CascadesPlanner;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.StableSelectorCostModel;
import com.apple.foundationdb.record.query.plan.cascades.properties.UsedTypesProperty;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.serialization.DefaultPlanSerializationRegistry;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.exceptions.UncheckedRelationalException;
import com.apple.foundationdb.relational.api.metrics.RelationalMetric;
import com.apple.foundationdb.relational.continuation.CompiledStatement;
import com.apple.foundationdb.relational.continuation.TypedQueryArgument;
import com.apple.foundationdb.relational.recordlayer.ContinuationImpl;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.query.AstNormalizer;
import com.apple.foundationdb.relational.recordlayer.query.MutablePlanGenerationContext;
import com.apple.foundationdb.relational.recordlayer.query.OptionsUtils;
import com.apple.foundationdb.relational.recordlayer.query.OrderedLiteral;
import com.apple.foundationdb.relational.recordlayer.query.Plan;
import com.apple.foundationdb.relational.recordlayer.query.PlanContext;
import com.apple.foundationdb.relational.recordlayer.query.PlanValidator;
import com.apple.foundationdb.relational.recordlayer.query.PlannerConfiguration;
import com.apple.foundationdb.relational.recordlayer.query.PreparedParams;
import com.apple.foundationdb.relational.recordlayer.query.QueryExecutionContext;
import com.apple.foundationdb.relational.recordlayer.query.QueryPlan;
import com.apple.foundationdb.relational.recordlayer.query.cache.PhysicalPlanEquivalence;
import com.apple.foundationdb.relational.recordlayer.query.cache.RelationalPlanCache;
import com.apple.foundationdb.relational.recordlayer.query.visitors.BaseVisitor;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.relational.util.RelationalLoggingUtil;
import com.google.common.base.VerifyException;
import com.google.common.collect.Maps;
import com.google.protobuf.InvalidProtocolBufferException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@API(value=API.Status.EXPERIMENTAL)
public final class PlanGenerator {
    private static final Logger logger = LogManager.getLogger(PlanGenerator.class);
    @Nonnull
    private final Optional<RelationalPlanCache> cache;
    @Nonnull
    private final CascadesPlanner planner;
    @Nonnull
    private final PlanContext planContext;
    @Nonnull
    private Options options;
    private long beginTime;
    private long currentTime;

    private PlanGenerator(@Nonnull Optional<RelationalPlanCache> cache, @Nonnull PlanContext planContext, @Nonnull CascadesPlanner planner, @Nonnull Options options) {
        this.currentTime = this.beginTime = System.nanoTime();
        this.cache = cache;
        this.planContext = planContext;
        this.planner = planner;
        this.options = options;
    }

    @Nonnull
    public Plan<?> getPlan(@Nonnull String query) throws RelationalException {
        this.resetTimer();
        KeyValueLogMessage message = KeyValueLogMessage.build("PlanGenerator", new Object[0]);
        Plan plan = null;
        RelationalException exception = null;
        try {
            plan = this.planContext.getMetricsCollector().clock(RelationalMetric.RelationalEvent.TOTAL_GET_PLAN_QUERY, () -> this.getPlanInternal(query, message));
        }
        catch (RelationalException e) {
            exception = e;
            throw e;
        }
        finally {
            RelationalLoggingUtil.publishPlanGenerationLogs(logger, message, plan, exception, this.totalTimeMicros(), this.options);
        }
        return plan;
    }

    private boolean isCaseSensitive() {
        return (Boolean)this.options.getOption(Options.Name.CASE_SENSITIVE_IDENTIFIERS);
    }

    @Nonnull
    private Plan<?> getPlanInternal(@Nonnull String query, @Nonnull KeyValueLogMessage message) throws RelationalException {
        try {
            Set<PlanHashable.PlanHashMode> validPlanHashModes = OptionsUtils.getValidPlanHashModes(this.options);
            PlanHashable.PlanHashMode currentPlanHashMode = OptionsUtils.getCurrentPlanHashMode(this.options);
            AstNormalizer.NormalizationResult astHashResult = AstNormalizer.normalizeQuery(this.planContext, query, this.isCaseSensitive(), currentPlanHashMode);
            RelationalLoggingUtil.publishNormalizeQueryLogs(message, this.stepTimeMicros(), astHashResult.getQueryCacheKey().getHash(), astHashResult.getQueryCacheKey().getCanonicalQueryString());
            this.options = this.options.withChild(astHashResult.getQueryOptions());
            if (PlanGenerator.shouldNotCache(astHashResult.getQueryCachingFlags()) || this.cache.isEmpty()) {
                Plan<?> plan = this.generatePhysicalPlan(astHashResult, validPlanHashModes, currentPlanHashMode);
                RelationalLoggingUtil.publishPlanCacheLogs(message, RelationalLoggingUtil.PlanCacheEvent.SKIP, this.stepTimeMicros(), 0L);
                return plan;
            }
            RelationalLoggingUtil.publishPlanCacheLogs(message, RelationalLoggingUtil.PlanCacheEvent.HIT, -1L, this.cache.get().getStats().numEntries());
            PhysicalPlanEquivalence planEquivalence = PhysicalPlanEquivalence.of(astHashResult.getQueryExecutionContext().getEvaluationContext());
            return this.planContext.getMetricsCollector().clock(RelationalMetric.RelationalEvent.CACHE_LOOKUP, () -> this.cache.get().reduce(astHashResult.getSchemaTemplateName(), astHashResult.getQueryCacheKey(), planEquivalence, () -> {
                Plan<?> physicalPlan;
                try {
                    physicalPlan = this.generatePhysicalPlan(astHashResult, validPlanHashModes, currentPlanHashMode);
                }
                catch (RelationalException vE) {
                    throw vE.toUncheckedWrappedException();
                }
                RelationalLoggingUtil.publishPlanCacheLogs(message, RelationalLoggingUtil.PlanCacheEvent.MISS, this.stepTimeMicros(), this.cache.get().getStats().numEntries());
                return NonnullPair.of(planEquivalence.withConstraint(physicalPlan.getConstraint()), physicalPlan);
            }, value -> value.withExecutionContext(astHashResult.getQueryExecutionContext()), plans -> plans.reduce(null, (acc, candidate) -> {
                if (candidate instanceof QueryPlan.PhysicalQueryPlan) {
                    RecordQueryPlan bestQueryPlanSoFar;
                    QueryPlan.PhysicalQueryPlan candidatePhysicalPlan = Assert.castUnchecked(candidate, QueryPlan.PhysicalQueryPlan.class);
                    RecordQueryPlan candidateQueryPlan = candidatePhysicalPlan.getRecordQueryPlan();
                    RecordQueryPlan recordQueryPlan = bestQueryPlanSoFar = acc == null ? null : Assert.castUnchecked(acc, QueryPlan.PhysicalQueryPlan.class).getRecordQueryPlan();
                    if (bestQueryPlanSoFar == null || new StableSelectorCostModel().compare(candidateQueryPlan, bestQueryPlanSoFar) < 0) {
                        return candidate;
                    }
                    return acc;
                }
                return candidate;
            }), e -> this.planContext.getMetricsCollector().increment((RelationalMetric.RelationalCount)e)));
        }
        catch (UncheckedRelationalException uve) {
            throw uve.unwrap();
        }
        catch (MetaDataException mde) {
            throw new RelationalException(mde.getMessage(), ErrorCode.SYNTAX_OR_ACCESS_VIOLATION, mde);
        }
        catch (SemanticException | VerifyException ve) {
            throw new RelationalException(ve.getMessage(), ErrorCode.INTERNAL_ERROR, ve);
        }
        catch (SQLException e) {
            throw ExceptionUtil.toRelationalException(e);
        }
    }

    @Nonnull
    private Plan<?> generatePhysicalPlan(@Nonnull AstNormalizer.NormalizationResult ast, @Nonnull Set<PlanHashable.PlanHashMode> validPlanHashModes, @Nonnull PlanHashable.PlanHashMode currentPlanHashMode) throws RelationalException {
        if (ast.getQueryCachingFlags().contains((Object)AstNormalizer.NormalizationResult.QueryCachingFlags.IS_EXECUTE_CONTINUATION_STATEMENT)) {
            return this.planContext.getMetricsCollector().clock(RelationalMetric.RelationalEvent.GENERATE_CONTINUED_PLAN, () -> this.generatePhysicalPlanForExecuteContinuation(ast, validPlanHashModes, currentPlanHashMode));
        }
        return this.generatePhysicalPlanForCompilableStatement(ast, this.isCaseSensitive(), currentPlanHashMode);
    }

    @Nonnull
    public PlannerConfiguration getPlannerConfigurations() {
        return this.planContext.getPlannerConfiguration();
    }

    @Nonnull
    private Plan<?> generatePhysicalPlanForCompilableStatement(@Nonnull AstNormalizer.NormalizationResult ast, boolean caseSensitive, @Nonnull PlanHashable.PlanHashMode currentPlanHashMode) {
        int parameterHash = ast.getQueryExecutionContext().getParameterHash();
        MutablePlanGenerationContext planGenerationContext = new MutablePlanGenerationContext(this.planContext.getPreparedStatementParameters(), currentPlanHashMode, ast.getQuery(), ast.getQueryCacheKey().getCanonicalQueryString(), parameterHash);
        RecordLayerSchemaTemplate metadata = Assert.castUnchecked(this.planContext.getSchemaTemplate(), RecordLayerSchemaTemplate.class);
        try {
            Plan maybePlan = this.planContext.getMetricsCollector().clock(RelationalMetric.RelationalEvent.GENERATE_LOGICAL_PLAN, () -> new BaseVisitor(planGenerationContext, metadata, this.planContext.getDdlQueryFactory(), this.planContext.getConstantActionFactory(), this.planContext.getDbUri(), caseSensitive).generateLogicalPlan(ast.getParseTree()));
            return maybePlan.optimize(this.planner, this.planContext, currentPlanHashMode);
        }
        catch (MetaDataException mde) {
            throw new RelationalException(mde.getMessage(), ErrorCode.SYNTAX_OR_ACCESS_VIOLATION, mde).toUncheckedWrappedException();
        }
        catch (SemanticException | VerifyException ve) {
            throw ExceptionUtil.toRelationalException(ve).toUncheckedWrappedException();
        }
        catch (RelationalException e) {
            throw e.toUncheckedWrappedException();
        }
    }

    @Nonnull
    private QueryPlan.PhysicalQueryPlan generatePhysicalPlanForExecuteContinuation(@Nonnull AstNormalizer.NormalizationResult ast, @Nonnull Set<PlanHashable.PlanHashMode> validPlanHashModes, @Nonnull PlanHashable.PlanHashMode currentPlanHashMode) throws RelationalException {
        int i;
        ContinuationImpl continuation;
        QueryExecutionContext queryHasherContext = ast.getQueryExecutionContext();
        byte[] continuationProto = queryHasherContext.getContinuation();
        try {
            continuation = ContinuationImpl.parseContinuation(continuationProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RelationalException("unable to parse continuation", ErrorCode.INTERNAL_ERROR, e);
        }
        CompiledStatement compiledStatement = Assert.notNullUnchecked(continuation.getCompiledStatement());
        PlanHashable.PlanHashMode serializedPlanHashMode = PlanValidator.validateSerializedPlanSerializationMode(compiledStatement, validPlanHashModes);
        PlanSerializationContext serializationContext = new PlanSerializationContext(DefaultPlanSerializationRegistry.INSTANCE, PlanHashable.PlanHashMode.valueOf(Assert.notNullUnchecked(compiledStatement.getPlanSerializationMode())));
        RecordQueryPlan recordQueryPlan = RecordQueryPlan.fromRecordQueryPlanProto(serializationContext, Assert.notNullUnchecked(compiledStatement.getPlan()));
        if (!Objects.requireNonNull(continuation.getPlanHash()).equals(recordQueryPlan.planHash(serializedPlanHashMode))) {
            throw new PlanValidator.PlanValidationException("cannot continue query due to mismatch between serialized and actual plan hash");
        }
        Set<Type> planTypes = UsedTypesProperty.usedTypes().evaluate(recordQueryPlan);
        TypeRepository.Builder typeRepositoryBuilder = TypeRepository.newBuilder();
        planTypes.forEach(typeRepositoryBuilder::addTypeIfNeeded);
        TypeRepository typeRepository = typeRepositoryBuilder.build();
        OrderedLiteral[] orderedLiterals = new OrderedLiteral[compiledStatement.getArgumentsCount() + compiledStatement.getExtractedLiteralsCount()];
        TypedQueryArgument[] typedQueryArguments = new TypedQueryArgument[compiledStatement.getArgumentsCount() + compiledStatement.getExtractedLiteralsCount()];
        for (i = 0; i < compiledStatement.getArgumentsCount(); ++i) {
            TypedQueryArgument argument;
            typedQueryArguments[argument.getLiteralsTableIndex()] = argument = compiledStatement.getArguments(i);
        }
        for (i = 0; i < compiledStatement.getExtractedLiteralsCount(); ++i) {
            TypedQueryArgument extractedLiteral;
            typedQueryArguments[extractedLiteral.getLiteralsTableIndex()] = extractedLiteral = compiledStatement.getExtractedLiterals(i);
        }
        for (i = 0; i < typedQueryArguments.length; ++i) {
            TypedQueryArgument typedQueryArgument = typedQueryArguments[i];
            orderedLiterals[i] = OrderedLiteral.fromProto(serializationContext, typeRepository, typedQueryArgument);
        }
        PreparedParams preparedStatementParameters = PlanGenerator.deserializeArgumentsForParameters(compiledStatement, orderedLiterals);
        MutablePlanGenerationContext planGenerationContext = new MutablePlanGenerationContext(preparedStatementParameters, currentPlanHashMode, ast.getQuery(), ast.getQueryCacheKey().getCanonicalQueryString(), Objects.requireNonNull(continuation.getBindingHash()));
        planGenerationContext.setForExplain(ast.getQueryExecutionContext().isForExplain());
        Arrays.stream(orderedLiterals).forEach(literal -> planGenerationContext.getLiteralsBuilder().addLiteral((OrderedLiteral)literal));
        planGenerationContext.setContinuation(continuationProto);
        QueryPlanConstraint continuationPlanConstraint = QueryPlanConstraint.fromProto(serializationContext, compiledStatement.getPlanConstraint());
        return new QueryPlan.ContinuedPhysicalQueryPlan(recordQueryPlan, typeRepository, continuationPlanConstraint, planGenerationContext, "EXECUTE CONTINUATION " + ast.getQueryCacheKey().getCanonicalQueryString(), currentPlanHashMode, serializedPlanHashMode);
    }

    private void resetTimer() {
        this.beginTime = this.currentTime = System.nanoTime();
    }

    private long stepTimeMicros() {
        long time = System.nanoTime();
        long result = TimeUnit.NANOSECONDS.toMicros(time - this.currentTime);
        this.currentTime = time;
        return result;
    }

    private long totalTimeMicros() {
        return TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - this.beginTime);
    }

    @Nonnull
    private static PreparedParams deserializeArgumentsForParameters(@Nonnull CompiledStatement compiledStatement, @Nonnull OrderedLiteral[] orderedLiteralsTable) {
        HashMap<Integer, Object> unnamedParameterMap = Maps.newHashMap();
        HashMap<String, Object> namedParameterMap = Maps.newHashMap();
        for (int i = 0; i < compiledStatement.getArgumentsCount(); ++i) {
            TypedQueryArgument argument = compiledStatement.getArguments(i);
            OrderedLiteral literal = orderedLiteralsTable[argument.getLiteralsTableIndex()];
            if (argument.hasUnnamedParameterIndex()) {
                unnamedParameterMap.put(argument.getUnnamedParameterIndex(), literal.getLiteralObject());
                continue;
            }
            Assert.thatUnchecked(argument.hasParameterName());
            namedParameterMap.put(argument.getParameterName(), literal.getLiteralObject());
        }
        return PreparedParams.of(unnamedParameterMap, namedParameterMap);
    }

    @Nonnull
    public Options getOptions() {
        return this.options;
    }

    private static boolean shouldNotCache(@Nonnull Set<AstNormalizer.NormalizationResult.QueryCachingFlags> queryCachingFlags) {
        return queryCachingFlags.contains((Object)AstNormalizer.NormalizationResult.QueryCachingFlags.WITH_NO_CACHE_OPTION) || queryCachingFlags.contains((Object)AstNormalizer.NormalizationResult.QueryCachingFlags.IS_DDL_STATEMENT) || queryCachingFlags.contains((Object)AstNormalizer.NormalizationResult.QueryCachingFlags.IS_INSERT_STATEMENT);
    }

    @Nonnull
    public static PlanGenerator create(@Nonnull Optional<RelationalPlanCache> cache, @Nonnull PlanContext planContext, @Nonnull RecordMetaData metaData, @Nonnull RecordStoreState recordStoreState, @Nonnull IndexMatchCandidateRegistry matchCandidateRegistry, @Nonnull Options options) throws RelationalException {
        CascadesPlanner planner = new CascadesPlanner(metaData, recordStoreState, matchCandidateRegistry);
        planner.setConfiguration(planContext.getRecordQueryPlannerConfiguration());
        return new PlanGenerator(cache, planContext, planner, options);
    }

    @Nonnull
    public static PlanGenerator create(@Nonnull Optional<RelationalPlanCache> cache, @Nonnull PlanContext planContext, @Nonnull FDBRecordStoreBase<?> store, @Nonnull Options options) throws RelationalException {
        return PlanGenerator.create(cache, planContext, store.getRecordMetaData(), store.getRecordStoreState(), store.getIndexMaintainerRegistry(), options);
    }
}

