/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metrics.MetricCollector;
import com.apple.foundationdb.relational.api.metrics.RelationalMetric;
import com.apple.foundationdb.relational.continuation.CompiledStatement;
import com.apple.foundationdb.relational.recordlayer.ContinuationImpl;
import com.apple.foundationdb.relational.recordlayer.query.QueryExecutionContext;
import com.google.protobuf.Message;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class PlanValidator {
    private PlanValidator() {
    }

    public static PlanHashable.PlanHashMode validateSerializedPlanSerializationMode(@Nonnull CompiledStatement compiledStatement, @Nonnull Set<PlanHashable.PlanHashMode> validPlanHashModes) throws RelationalException {
        PlanHashable.PlanHashMode planSerializationMode = PlanHashable.PlanHashMode.valueOf(compiledStatement.getPlanSerializationMode());
        if (!validPlanHashModes.contains((Object)planSerializationMode)) {
            throw new PlanValidationException("Plan provided by continuation cannot be continued due to an incompatible environment");
        }
        return planSerializationMode;
    }

    public static <M extends Message> void validateContinuationConstraint(@Nonnull FDBRecordStoreBase<M> fdbRecordStore, @Nonnull QueryPlanConstraint continuationPlanConstraint) throws RelationalException {
        Boolean isValid = continuationPlanConstraint.getPredicate().eval(fdbRecordStore, EvaluationContext.EMPTY);
        if (isValid == null || !isValid.booleanValue()) {
            throw new PlanValidationException("Plan provided by continuation cannot be continued due to an incompatible environment");
        }
    }

    public static void validateHashes(@Nonnull ContinuationImpl parsedContinuation, @Nonnull MetricCollector metricCollector, @Nonnull RecordQueryPlan plan, @Nonnull QueryExecutionContext context, @Nonnull PlanHashable.PlanHashMode currentPlanHashMode, @Nonnull Set<PlanHashable.PlanHashMode> validPlanHashModes) throws RelationalException {
        if (!parsedContinuation.atBeginning()) {
            if (!PlanValidator.validateBindingHash(context, parsedContinuation)) {
                metricCollector.increment(RelationalMetric.RelationalCount.CONTINUATION_REJECTED);
                throw new PlanValidationException("Continuation binding does not match query");
            }
            PlanHashable.PlanHashMode resolvedPlanHashMode = PlanValidator.resolveValidPlanHashMode(plan, parsedContinuation, currentPlanHashMode, validPlanHashModes);
            if (resolvedPlanHashMode == null) {
                metricCollector.increment(RelationalMetric.RelationalCount.CONTINUATION_REJECTED);
                throw new PlanValidationException("Continuation plan does not match query");
            }
            if (resolvedPlanHashMode != currentPlanHashMode) {
                metricCollector.increment(RelationalMetric.RelationalCount.CONTINUATION_DOWN_LEVEL);
            }
            metricCollector.increment(RelationalMetric.RelationalCount.CONTINUATION_ACCEPTED);
        }
    }

    private static boolean validateBindingHash(QueryExecutionContext parameters, ContinuationImpl continuation) {
        return Objects.equals(parameters.getParameterHash(), continuation.getBindingHash());
    }

    @Nullable
    private static PlanHashable.PlanHashMode resolveValidPlanHashMode(@Nonnull RecordQueryPlan plan, @Nonnull ContinuationImpl continuation, @Nonnull PlanHashable.PlanHashMode currentPlanHashMode, @Nonnull Set<PlanHashable.PlanHashMode> validPlanHashModes) {
        if (Objects.equals(plan.planHash(currentPlanHashMode), continuation.getPlanHash())) {
            return currentPlanHashMode;
        }
        for (PlanHashable.PlanHashMode validPlanHashMode : validPlanHashModes) {
            if (validPlanHashMode == currentPlanHashMode || !Objects.equals(plan.planHash(validPlanHashMode), continuation.getPlanHash())) continue;
            return validPlanHashMode;
        }
        return null;
    }

    public static class PlanValidationException
    extends RelationalException {
        public PlanValidationException(String message) {
            super(message, ErrorCode.INVALID_CONTINUATION);
        }

        public PlanValidationException(String message, Throwable cause) {
            super(message, ErrorCode.INVALID_CONTINUATION, cause);
        }
    }
}

