/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexFetchMethod;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.PlanningRuleSet;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.recordlayer.query.OptionsUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class PlannerConfiguration {
    @Nonnull
    private final Optional<Set<String>> readableIndexes;
    @Nonnull
    private final IndexFetchMethod indexFetchMethod;
    private final boolean disabledAllPlannerRules;
    @Nonnull
    private final Set<String> disabledPlannerRewriteRules;
    @Nonnull
    private final RecordQueryPlannerConfiguration recordQueryPlannerConfiguration;
    private final int memoizedHash;

    private PlannerConfiguration(@Nonnull Optional<Set<String>> readableIndexes, @Nonnull IndexFetchMethod indexFetchMethod, @Nonnull Set<String> disabledPlannerRewriteRules, boolean disabledAllPlannerRules) {
        this.readableIndexes = readableIndexes;
        this.indexFetchMethod = indexFetchMethod;
        this.disabledAllPlannerRules = disabledAllPlannerRules;
        this.disabledPlannerRewriteRules = ImmutableSet.copyOf(disabledPlannerRewriteRules);
        this.memoizedHash = this.computeHash();
        this.recordQueryPlannerConfiguration = this.buildRecordQueryPlannerConfiguration();
    }

    @Nonnull
    public Optional<Set<String>> getReadableIndexes() {
        return this.readableIndexes;
    }

    @Nonnull
    public RecordQueryPlannerConfiguration getRecordQueryPlannerConfiguration() {
        return this.recordQueryPlannerConfiguration;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PlannerConfiguration that = (PlannerConfiguration)other;
        return Objects.equals(this.readableIndexes, that.readableIndexes) && this.indexFetchMethod.equals((Object)that.indexFetchMethod) && this.disabledAllPlannerRules == that.disabledAllPlannerRules && this.disabledPlannerRewriteRules.equals(that.disabledPlannerRewriteRules);
    }

    private int computeHash() {
        return Objects.hash(new Object[]{this.readableIndexes, this.indexFetchMethod, this.disabledAllPlannerRules, this.disabledPlannerRewriteRules});
    }

    public int hashCode() {
        return this.memoizedHash;
    }

    @Nonnull
    private RecordQueryPlannerConfiguration buildRecordQueryPlannerConfiguration() {
        RecordQueryPlannerConfiguration.Builder configurationBuilder = RecordQueryPlannerConfiguration.builder().setIndexScanPreference(QueryPlanner.IndexScanPreference.PREFER_INDEX).setAttemptFailedInJoinAsUnionMaxSize(24);
        configurationBuilder.setIndexFetchMethod(this.indexFetchMethod);
        configurationBuilder.setDisabledTransformationRuleNames(this.disabledPlannerRewriteRules, PlanningRuleSet.DEFAULT);
        if (this.disabledAllPlannerRules) {
            configurationBuilder.disableRewritingRules();
        }
        return configurationBuilder.build();
    }

    @Nonnull
    public static PlannerConfiguration of(@Nonnull Optional<Set<String>> readableIndexesMaybe, @Nonnull Options options) {
        ImmutableSet<String> disabledPlannerRules = ImmutableSet.copyOf((Collection)options.getOption(Options.Name.DISABLED_PLANNER_RULES));
        return new PlannerConfiguration(readableIndexesMaybe, OptionsUtils.getIndexFetchMethod(options), disabledPlannerRules, (Boolean)options.getOption(Options.Name.DISABLE_PLANNER_REWRITING));
    }

    @Nonnull
    public static PlannerConfiguration ofAllAvailableIndexes() {
        return PlannerConfiguration.of(Optional.empty(), Options.none());
    }

    @Nonnull
    public static PlannerConfiguration ofAllAvailableIndexes(@Nonnull Options options) {
        return PlannerConfiguration.of(Optional.empty(), options);
    }
}

