/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class PreparedParams {
    @Nonnull
    private static final PreparedParams EMPTY_PARAMETERS = new PreparedParams(Map.of(), Map.of());
    @Nonnull
    private final Map<Integer, Object> unnamedParams;
    @Nonnull
    private final Map<String, Object> namedParams;
    private int nextParam = 1;

    private PreparedParams(@Nonnull Map<Integer, Object> unnamedParams, @Nonnull Map<String, Object> namedParameters) {
        this.unnamedParams = unnamedParams;
        this.namedParams = namedParameters;
    }

    public int currentUnnamedParamIndex() {
        return this.nextParam;
    }

    @Nullable
    public Object nextUnnamedParamValue() {
        Assert.thatUnchecked(this.unnamedParams.containsKey(this.nextParam), ErrorCode.UNDEFINED_PARAMETER, "No value found for parameter " + this.nextParam);
        return this.unnamedParams.get(this.nextParam++);
    }

    @Nullable
    public Object namedParamValue(@Nonnull String name) {
        Assert.thatUnchecked(this.namedParams.containsKey(name), ErrorCode.UNDEFINED_PARAMETER, "No value found for parameter " + name);
        return this.namedParams.get(name);
    }

    public boolean isEmpty() {
        return this.namedParams.isEmpty() && this.unnamedParams.isEmpty();
    }

    @Nonnull
    public static PreparedParams empty() {
        return EMPTY_PARAMETERS;
    }

    @Nonnull
    public static PreparedParams of(@Nonnull Map<Integer, Object> parameters, @Nonnull Map<String, Object> namedParameters) {
        return new PreparedParams(parameters, namedParameters);
    }

    @Nonnull
    public static PreparedParams ofUnnamed(@Nonnull Map<Integer, Object> parameters) {
        return PreparedParams.of(parameters, ImmutableMap.of());
    }

    @Nonnull
    public static PreparedParams ofNamed(@Nonnull Map<String, Object> parameters) {
        return new PreparedParams(ImmutableMap.of(), parameters);
    }

    @Nonnull
    public static PreparedParams copyOf(@Nonnull PreparedParams other) {
        return new PreparedParams(other.unnamedParams, other.namedParams);
    }
}

