/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedRecordValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.VersionValue;
import com.apple.foundationdb.relational.recordlayer.query.Expression;
import com.apple.foundationdb.relational.recordlayer.query.Identifier;
import com.apple.foundationdb.relational.recordlayer.query.LogicalOperator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;

public enum PseudoColumn {
    ROW_VERSION(qun -> new VersionValue(QuantifiedRecordValue.of(qun)));

    private static final String PREFIX = "__";
    @Nonnull
    private final Function<Quantifier, Value> valueCreator;
    @Nonnull
    private final String columnName;

    private PseudoColumn(Function<Quantifier, Value> valueCreator) {
        this.valueCreator = valueCreator;
        this.columnName = PREFIX + this.name();
    }

    @Nonnull
    public Value getValue(@Nonnull Quantifier qun) {
        return Objects.requireNonNull(this.valueCreator.apply(qun));
    }

    @Nonnull
    public String getColumnName() {
        return this.columnName;
    }

    @Nonnull
    public static Optional<Expression> mapToExpressionMaybe(@Nonnull LogicalOperator logicalOperator, @Nonnull String pseudoColumnName) {
        if (!pseudoColumnName.startsWith(PREFIX)) {
            return Optional.empty();
        }
        for (PseudoColumn pseudo : PseudoColumn.values()) {
            if (!pseudo.columnName.equals(pseudoColumnName)) continue;
            return Optional.of(Expression.of(pseudo.getValue(logicalOperator.getQuantifier()), Identifier.of(pseudoColumnName)));
        }
        return Optional.empty();
    }
}

