/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.EvaluationContextBuilder;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.relational.recordlayer.query.Literals;
import com.apple.foundationdb.relational.recordlayer.query.ParseHelpers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface QueryExecutionContext {
    @Nonnull
    default public EvaluationContext getEvaluationContext(@Nonnull TypeRepository typeRepository) {
        Literals literals = this.getLiterals();
        if (literals.isEmpty()) {
            return EvaluationContext.forTypeRepository(typeRepository);
        }
        EvaluationContextBuilder builder = EvaluationContext.newBuilder();
        builder.setConstant(Quantifier.constant(), literals.asMap());
        return builder.build(typeRepository);
    }

    @Nonnull
    default public EvaluationContext getEvaluationContext() {
        return this.getEvaluationContext(ParseHelpers.EMPTY_TYPE_REPOSITORY);
    }

    @Nonnull
    public ExecuteProperties.Builder getExecutionPropertiesBuilder();

    @Nullable
    public byte[] getContinuation();

    public int getParameterHash();

    @Nonnull
    public Literals getLiterals();

    public boolean isForExplain();

    @Nonnull
    public PlanHashable.PlanHashMode getPlanHashMode();
}

