/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.generated.RelationalLexer;
import com.apple.foundationdb.relational.generated.RelationalParser;
import com.apple.foundationdb.relational.generated.RelationalParserBaseVisitor;
import com.apple.foundationdb.relational.recordlayer.query.CaseInsensitiveCharStream;
import com.apple.foundationdb.relational.recordlayer.query.ParseHelpers;
import com.apple.foundationdb.relational.recordlayer.query.ParseTreeInfoImpl;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.relational.util.Environment;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;

@API(value=API.Status.EXPERIMENTAL)
public class QueryParser {
    @Nonnull
    public static ParseTreeInfoImpl parse(@Nonnull String query) throws RelationalException {
        RelationalLexer tokenSource = new RelationalLexer(new CaseInsensitiveCharStream(query));
        RelationalParser parser = QueryParser.getParserInstance(new CommonTokenStream(tokenSource));
        RelationalParser.RootContext rootContext = ErrorStringifier.withParseErrorHandling(listener -> {
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)listener);
            return parser.root();
        });
        return ParseTreeInfoImpl.from(rootContext);
    }

    @Nonnull
    public static RelationalParser.SqlInvokedFunctionContext parseFunction(@Nonnull String functionString) throws RelationalException {
        RelationalLexer tokenSource = new RelationalLexer(new CaseInsensitiveCharStream(functionString));
        CommonTokenStream tokensStream = new CommonTokenStream(tokenSource);
        tokensStream.consume();
        RelationalParser parser = QueryParser.getParserInstance(tokensStream);
        return ErrorStringifier.withParseErrorHandling(listener -> {
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)listener);
            return parser.sqlInvokedFunction();
        });
    }

    @Nonnull
    public static RelationalParser.TempSqlInvokedFunctionContext parseTemporaryFunction(@Nonnull String functionString) throws RelationalException {
        RelationalLexer tokenSource = new RelationalLexer(new CaseInsensitiveCharStream(functionString));
        RelationalParser parser = QueryParser.getParserInstance(new CommonTokenStream(tokenSource));
        return ErrorStringifier.withParseErrorHandling(listener -> {
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)listener);
            return parser.createTempFunction().tempSqlInvokedFunction();
        });
    }

    public static void validateNoPreparedParams(@Nonnull ParseTree context) {
        PreparedParamsValidator validator = new PreparedParamsValidator();
        validator.visit(context);
    }

    @Nonnull
    private static RelationalParser getParserInstance(@Nonnull TokenStream tokenStream) {
        RelationalParser parser = new RelationalParser(tokenStream);
        if (Environment.isDebug()) {
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL_EXACT_AMBIG_DETECTION);
        } else {
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
        }
        return parser;
    }

    @VisibleForTesting
    public static class ErrorStringifier
    extends BaseErrorListener {
        @Nonnull
        private final List<String> syntaxErrors = new ArrayList<String>();
        @Nonnull
        private final List<String> ambiguityErrors = new ArrayList<String>();

        @VisibleForTesting
        public ErrorStringifier() {
        }

        @Nonnull
        List<String> getSyntaxErrors() {
            return this.syntaxErrors;
        }

        @Nonnull
        List<String> getAmbiguityErrors() {
            return this.ambiguityErrors;
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.syntaxErrors.add(ParseHelpers.underlineParsingError(recognizer, (Token)offendingSymbol, line, charPositionInLine));
        }

        @Override
        public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
            this.ambiguityErrors.add(String.format(Locale.ROOT, "Ambiguity: %s, Exact: %b", recognizer.getInputStream().getText(Interval.of(startIndex, recognizer.getInputStream().size() - 1)), exact));
        }

        static <T> T withParseErrorHandling(@Nonnull Function<ErrorStringifier, T> parsingRoutine) throws RelationalException {
            ErrorStringifier listener = new ErrorStringifier();
            T result = parsingRoutine.apply(listener);
            if (Environment.isDebug() && !listener.getAmbiguityErrors().isEmpty()) {
                String errorMessage = String.join((CharSequence)", ", listener.getAmbiguityErrors());
                if (!listener.getSyntaxErrors().isEmpty()) {
                    errorMessage = errorMessage.concat(listener.getAmbiguityErrors().get(0));
                }
                throw new RelationalException(errorMessage, ErrorCode.INTERNAL_ERROR);
            }
            if (!listener.getSyntaxErrors().isEmpty()) {
                throw new RelationalException("syntax error:\n" + listener.getSyntaxErrors().get(0), ErrorCode.SYNTAX_ERROR);
            }
            return result;
        }
    }

    private static final class PreparedParamsValidator
    extends RelationalParserBaseVisitor<Void> {
        private PreparedParamsValidator() {
        }

        @Override
        public Void visitPreparedStatementParameter(RelationalParser.PreparedStatementParameterContext ctx) {
            Assert.failUnchecked(ErrorCode.SYNTAX_ERROR, "found prepared parameter(s) in SQL statement");
            return null;
        }
    }
}

