/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.IndexQueryabilityFilter;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.QueryPlanInfoKeys;
import com.apple.foundationdb.record.query.plan.QueryPlanResult;
import com.apple.foundationdb.record.query.plan.cascades.CascadesPlanner;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.debug.Stats;
import com.apple.foundationdb.record.query.plan.cascades.debug.StatsMaps;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.CompatibleTypeEvolutionPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.DatabaseObjectDependenciesPredicate;
import com.apple.foundationdb.record.query.plan.cascades.properties.UsedTypesProperty;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDeletePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUpdatePlan;
import com.apple.foundationdb.record.query.plan.serialization.DefaultPlanSerializationRegistry;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.ImmutableRowStruct;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.RelationalStructMetaData;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.ddl.DdlQuery;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.api.metrics.MetricCollector;
import com.apple.foundationdb.relational.api.metrics.RelationalMetric;
import com.apple.foundationdb.relational.continuation.CompiledStatement;
import com.apple.foundationdb.relational.continuation.TypedQueryArgument;
import com.apple.foundationdb.relational.recordlayer.ArrayRow;
import com.apple.foundationdb.relational.recordlayer.ContinuationBuilder;
import com.apple.foundationdb.relational.recordlayer.ContinuationImpl;
import com.apple.foundationdb.relational.recordlayer.EmbeddedRelationalConnection;
import com.apple.foundationdb.relational.recordlayer.IteratorResultSet;
import com.apple.foundationdb.relational.recordlayer.MessageTuple;
import com.apple.foundationdb.relational.recordlayer.RecordLayerIterator;
import com.apple.foundationdb.relational.recordlayer.RecordLayerResultSet;
import com.apple.foundationdb.relational.recordlayer.RecordLayerSchema;
import com.apple.foundationdb.relational.recordlayer.metadata.DataTypeUtils;
import com.apple.foundationdb.relational.recordlayer.query.Literals;
import com.apple.foundationdb.relational.recordlayer.query.MutablePlanGenerationContext;
import com.apple.foundationdb.relational.recordlayer.query.OptionsUtils;
import com.apple.foundationdb.relational.recordlayer.query.OrderedLiteral;
import com.apple.foundationdb.relational.recordlayer.query.Plan;
import com.apple.foundationdb.relational.recordlayer.query.PlanContext;
import com.apple.foundationdb.relational.recordlayer.query.PlanValidator;
import com.apple.foundationdb.relational.recordlayer.query.QueryExecutionContext;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class QueryPlan
extends Plan<RelationalResultSet>
implements Typed {
    protected QueryPlan(@Nonnull String query) {
        super(query);
    }

    public static class MetadataQueryPlan
    extends QueryPlan {
        @Nonnull
        private final CheckedFunctional<Transaction, RelationalResultSet> query;
        @Nonnull
        private final Type rowType;

        private MetadataQueryPlan(@Nonnull CheckedFunctional<Transaction, RelationalResultSet> query, @Nonnull Type rowType) {
            super("MetadataQueryPlan");
            this.query = query;
            this.rowType = rowType;
        }

        @Override
        public boolean isUpdatePlan() {
            return false;
        }

        @Override
        public Plan<RelationalResultSet> optimize(@Nonnull CascadesPlanner planner, @Nonnull PlanContext planContext, @Nonnull PlanHashable.PlanHashMode currentPlanHashMode) {
            return this;
        }

        @Override
        public RelationalResultSet executeInternal(@Nonnull Plan.ExecutionContext context) throws RelationalException {
            return this.query.apply(context.transaction);
        }

        @Override
        @Nonnull
        public QueryPlanConstraint getConstraint() {
            return QueryPlanConstraint.noConstraint();
        }

        @Override
        @Nonnull
        public Plan<RelationalResultSet> withExecutionContext(@Nonnull QueryExecutionContext queryExecutionContext) {
            return this;
        }

        @Override
        @Nonnull
        public String explain() {
            return "MetadataQueryPlan";
        }

        @Override
        @Nonnull
        public Type getResultType() {
            return this.rowType;
        }

        @Nonnull
        public static MetadataQueryPlan of(DdlQuery ddlQuery) {
            return new MetadataQueryPlan(ddlQuery::executeAction, ddlQuery.getResultSetMetadata());
        }

        private static interface CheckedFunctional<T, R> {
            public R apply(T var1) throws RelationalException;
        }
    }

    public static class LogicalQueryPlan
    extends QueryPlan {
        @Nonnull
        private final RelationalExpression relationalExpression;
        @Nonnull
        private final MutablePlanGenerationContext context;
        @Nonnull
        private final String query;
        @Nonnull
        private Optional<PhysicalQueryPlan> optimizedPlan;

        private LogicalQueryPlan(@Nonnull RelationalExpression relationalExpression, @Nonnull MutablePlanGenerationContext context, @Nonnull String query) {
            super(query);
            this.relationalExpression = relationalExpression;
            this.context = context;
            this.optimizedPlan = Optional.empty();
            this.query = query;
        }

        @Override
        public boolean isUpdatePlan() {
            return false;
        }

        @Nonnull
        public PhysicalQueryPlan optimize(@Nonnull CascadesPlanner planner, @Nonnull PlanContext planContext, @Nonnull PlanHashable.PlanHashMode currentPlanHashMode) throws RelationalException {
            if (this.optimizedPlan.isPresent()) {
                return this.optimizedPlan.get();
            }
            return planContext.getMetricsCollector().clock(RelationalMetric.RelationalEvent.OPTIMIZE_PLAN, () -> {
                QueryPlanResult planResult;
                TypeRepository.Builder builder = TypeRepository.newBuilder();
                Set<Type> usedTypes = UsedTypesProperty.usedTypes().evaluate(this.relationalExpression);
                usedTypes.forEach(builder::addTypeIfNeeded);
                EvaluationContext evaluationContext = this.context.getEvaluationContext();
                EvaluationContext typedEvaluationContext = EvaluationContext.forBindingsAndTypeRepository(evaluationContext.getBindings(), builder.build());
                try {
                    planResult = planner.planGraph(() -> Reference.initialOf(this.relationalExpression), planContext.getReadableIndexes().map(s2 -> s2), IndexQueryabilityFilter.TRUE, typedEvaluationContext);
                }
                catch (RecordCoreException ex) {
                    throw ExceptionUtil.toRelationalException(ex);
                }
                StatsMaps statsMaps = planResult.getPlanInfo().get(QueryPlanInfoKeys.STATS_MAPS);
                RecordQueryPlan plannedPlan = planResult.getPlan();
                RecordQueryPlan minimizedPlan = plannedPlan.minimize();
                Set<Type> planTypes = UsedTypesProperty.usedTypes().evaluate(minimizedPlan);
                planTypes.forEach(builder::addTypeIfNeeded);
                QueryPlanConstraint constraint = QueryPlanConstraint.composeConstraints(List.of(Objects.requireNonNull(planResult.getPlanInfo().get(QueryPlanInfoKeys.CONSTRAINTS)), this.getConstraint()));
                QueryPlanConstraint continuationConstraint = LogicalQueryPlan.computeContinuationPlanConstraint(planContext.getMetaData(), plannedPlan);
                this.optimizedPlan = Optional.of(new PhysicalQueryPlan(minimizedPlan, statsMaps, builder.build(), constraint, continuationConstraint, this.context, this.query, currentPlanHashMode));
                return this.optimizedPlan.get();
            });
        }

        @Override
        @Nonnull
        public QueryPlanConstraint getConstraint() {
            return this.context.getPlanConstraintsForLiteralReferences();
        }

        @Override
        @Nonnull
        public Plan<RelationalResultSet> withExecutionContext(@Nonnull QueryExecutionContext queryExecutionContext) {
            return this;
        }

        @Override
        @Nonnull
        public String explain() {
            return this.optimizedPlan.map(PhysicalQueryPlan::explain).orElse("Logical Query Plan");
        }

        @Override
        public RelationalResultSet executeInternal(@Nonnull Plan.ExecutionContext executionContext) throws RelationalException {
            return (RelationalResultSet)this.optimizedPlan.get().execute(executionContext);
        }

        @Override
        @Nonnull
        public Type getResultType() {
            return this.relationalExpression.getResultType();
        }

        @Nonnull
        public RelationalExpression getRelationalExpression() {
            return this.relationalExpression;
        }

        public MutablePlanGenerationContext getGenerationContext() {
            return this.context;
        }

        @Nonnull
        public static LogicalQueryPlan of(@Nonnull RelationalExpression relationalExpression, @Nonnull MutablePlanGenerationContext context, @Nonnull String query) {
            return new LogicalQueryPlan(relationalExpression, context, query);
        }

        @Nonnull
        private static QueryPlanConstraint computeContinuationPlanConstraint(@Nonnull RecordMetaData recordMetaData, @Nonnull RecordQueryPlan plannedPlan) {
            CompatibleTypeEvolutionPredicate compatibleTypeEvolutionPredicate = CompatibleTypeEvolutionPredicate.fromPlan(plannedPlan);
            DatabaseObjectDependenciesPredicate databaseObjectDependenciesPredicate = DatabaseObjectDependenciesPredicate.fromPlan(recordMetaData, plannedPlan);
            return QueryPlanConstraint.ofPredicates(ImmutableList.of(compatibleTypeEvolutionPredicate, databaseObjectDependenciesPredicate));
        }
    }

    public static class ContinuedPhysicalQueryPlan
    extends PhysicalQueryPlan {
        @Nonnull
        private final PlanHashable.PlanHashMode serializedPlanHashMode;
        @Nonnull
        private final Supplier<Integer> serializedPlanHashSupplier;

        public ContinuedPhysicalQueryPlan(@Nonnull RecordQueryPlan recordQueryPlan, @Nonnull TypeRepository typeRepository, @Nonnull QueryPlanConstraint continuationConstraint, @Nonnull QueryExecutionContext queryExecutionParameters, @Nonnull String query, @Nonnull PlanHashable.PlanHashMode currentPlanHashMode, @Nonnull PlanHashable.PlanHashMode serializedPlanHashMode) {
            super(recordQueryPlan, null, typeRepository, QueryPlanConstraint.noConstraint(), continuationConstraint, queryExecutionParameters, query, currentPlanHashMode);
            this.serializedPlanHashMode = serializedPlanHashMode;
            this.serializedPlanHashSupplier = Suppliers.memoize(() -> recordQueryPlan.planHash(serializedPlanHashMode));
        }

        @Nonnull
        public PlanHashable.PlanHashMode getSerializedPlanHashMode() {
            return this.serializedPlanHashMode;
        }

        @Override
        @Nonnull
        public PhysicalQueryPlan withExecutionContext(@Nonnull QueryExecutionContext queryExecutionContext) {
            if (queryExecutionContext == this.getQueryExecutionContext()) {
                return this;
            }
            return new ContinuedPhysicalQueryPlan(this.getRecordQueryPlan(), this.getTypeRepository(), this.getContinuationConstraint(), queryExecutionContext, this.query, queryExecutionContext.getPlanHashMode(), this.getSerializedPlanHashMode());
        }

        @Override
        protected <M extends Message> void validatePlanAgainstEnvironment(@Nonnull ContinuationImpl parsedContinuation, @Nonnull FDBRecordStoreBase<M> fdbRecordStore, @Nonnull Plan.ExecutionContext executionContext, @Nonnull Set<PlanHashable.PlanHashMode> validPlanHashModes) throws RelationalException {
            Verify.verify(!parsedContinuation.atBeginning());
            MetricCollector metricCollector = executionContext.metricCollector;
            try {
                PlanValidator.validateContinuationConstraint(fdbRecordStore, this.getContinuationConstraint());
            }
            catch (PlanValidator.PlanValidationException pVE) {
                metricCollector.increment(RelationalMetric.RelationalCount.CONTINUATION_REJECTED);
            }
            if (this.serializedPlanHashMode != this.getCurrentPlanHashMode()) {
                metricCollector.increment(RelationalMetric.RelationalCount.CONTINUATION_DOWN_LEVEL);
            }
            metricCollector.increment(RelationalMetric.RelationalCount.CONTINUATION_ACCEPTED);
        }

        @Override
        @Nonnull
        protected Optional<RecordQueryPlan> getSerializedPlanFromContinuation(@Nonnull ContinuationImpl parsedContinuation, @Nonnull Plan.ExecutionContext executionContext) throws RelationalException {
            Assert.that(Objects.requireNonNull(parsedContinuation.getPlanHash()).equals(this.serializedPlanHashSupplier.get()), ErrorCode.INTERNAL_ERROR, "unexpected mismatch between deserialized plan hash and continuation plan hash");
            return Optional.of(this.getRecordQueryPlan());
        }
    }

    public static class PhysicalQueryPlan
    extends QueryPlan {
        @Nonnull
        private final RecordQueryPlan recordQueryPlan;
        @Nullable
        private final StatsMaps plannerStatsMaps;
        @Nonnull
        private final PlanHashable.PlanHashMode currentPlanHashMode;
        private final Supplier<Integer> planHashSupplier;
        @Nonnull
        private final TypeRepository typeRepository;
        @Nonnull
        private final QueryPlanConstraint constraint;
        @Nonnull
        private final QueryPlanConstraint continuationConstraint;
        @Nonnull
        private final QueryExecutionContext queryExecutionContext;

        public PhysicalQueryPlan(@Nonnull RecordQueryPlan recordQueryPlan, @Nullable StatsMaps plannerStatsMaps, @Nonnull TypeRepository typeRepository, @Nonnull QueryPlanConstraint constraint, @Nonnull QueryPlanConstraint continuationConstraint, @Nonnull QueryExecutionContext queryExecutionContext, @Nonnull String query, @Nonnull PlanHashable.PlanHashMode currentPlanHashMode) {
            super(query);
            this.recordQueryPlan = recordQueryPlan;
            this.plannerStatsMaps = plannerStatsMaps;
            this.typeRepository = typeRepository;
            this.constraint = constraint;
            this.continuationConstraint = continuationConstraint;
            this.queryExecutionContext = queryExecutionContext;
            this.currentPlanHashMode = currentPlanHashMode;
            this.planHashSupplier = Suppliers.memoize(() -> recordQueryPlan.planHash(currentPlanHashMode));
        }

        @Nonnull
        public RecordQueryPlan getRecordQueryPlan() {
            return this.recordQueryPlan;
        }

        @Nonnull
        public TypeRepository getTypeRepository() {
            return this.typeRepository;
        }

        @Override
        @Nonnull
        public QueryPlanConstraint getConstraint() {
            return this.constraint;
        }

        @Nonnull
        public QueryPlanConstraint getContinuationConstraint() {
            return this.continuationConstraint;
        }

        @Override
        @Nonnull
        public Type getResultType() {
            return Assert.notNullUnchecked(this.recordQueryPlan.getResultType().getInnerType());
        }

        @Nonnull
        public QueryExecutionContext getQueryExecutionContext() {
            return this.queryExecutionContext;
        }

        @Nonnull
        public PlanHashable.PlanHashMode getCurrentPlanHashMode() {
            return this.currentPlanHashMode;
        }

        @Nonnull
        public PhysicalQueryPlan withExecutionContext(@Nonnull QueryExecutionContext queryExecutionContext) {
            if (queryExecutionContext == this.queryExecutionContext) {
                return this;
            }
            return new PhysicalQueryPlan(this.recordQueryPlan, this.plannerStatsMaps, this.typeRepository, this.constraint, this.continuationConstraint, queryExecutionContext, this.query, queryExecutionContext.getPlanHashMode());
        }

        @Override
        @Nonnull
        public String explain() {
            ExecuteProperties.Builder executeProperties = this.queryExecutionContext.getExecutionPropertiesBuilder();
            ArrayList<Object> explainComponents = new ArrayList<Object>();
            explainComponents.add(ExplainPlanVisitor.toStringForExternalExplain(this.recordQueryPlan));
            if (executeProperties.getReturnedRowLimit() != 0) {
                explainComponents.add("(limit=" + executeProperties.getReturnedRowLimit() + ")");
            }
            if (executeProperties.getSkip() != 0) {
                explainComponents.add("(offset=" + executeProperties.getSkip() + ")");
            }
            return String.join((CharSequence)" ", explainComponents);
        }

        @Override
        public boolean isUpdatePlan() {
            if (this.queryExecutionContext.isForExplain()) {
                return false;
            }
            return this.recordQueryPlan instanceof RecordQueryInsertPlan || this.recordQueryPlan instanceof RecordQueryUpdatePlan || this.recordQueryPlan instanceof RecordQueryDeletePlan;
        }

        @Override
        public Plan<RelationalResultSet> optimize(@Nonnull CascadesPlanner planner, @Nonnull PlanContext planContext, @Nonnull PlanHashable.PlanHashMode currentPlanHashMode) {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public RelationalResultSet executeInternal(@Nonnull Plan.ExecutionContext executionContext) throws RelationalException {
            if (!(executionContext.connection instanceof EmbeddedRelationalConnection)) {
                throw new RelationalException("Cannot execute a QueryPlan without an EmbeddedRelationalConnection", ErrorCode.INTERNAL_ERROR);
            }
            EmbeddedRelationalConnection conn = (EmbeddedRelationalConnection)executionContext.connection;
            try {
                String schemaName = conn.getSchema();
                try (RecordLayerSchema recordLayerSchema = conn.getRecordLayerDatabase().loadSchema(schemaName);){
                    ContinuationImpl parsedContinuation;
                    EvaluationContext evaluationContext = this.queryExecutionContext.getEvaluationContext();
                    EvaluationContext typedEvaluationContext = EvaluationContext.forBindingsAndTypeRepository(evaluationContext.getBindings(), this.typeRepository);
                    try {
                        parsedContinuation = ContinuationImpl.parseContinuation(this.queryExecutionContext.getContinuation());
                    }
                    catch (InvalidProtocolBufferException ipbe) {
                        executionContext.metricCollector.increment(RelationalMetric.RelationalCount.CONTINUATION_REJECTED);
                        throw ExceptionUtil.toRelationalException(ipbe);
                    }
                    if (this.queryExecutionContext.isForExplain()) {
                        RelationalResultSet relationalResultSet2 = this.executeExplain(parsedContinuation, executionContext);
                        return relationalResultSet2;
                    }
                    RelationalResultSet relationalResultSet = this.executePhysicalPlan(recordLayerSchema, typedEvaluationContext, executionContext, parsedContinuation);
                    return relationalResultSet;
                }
            }
            catch (SQLException sqle) {
                throw new RelationalException(sqle);
            }
        }

        protected <M extends Message> void validatePlanAgainstEnvironment(@Nonnull ContinuationImpl parsedContinuation, @Nonnull FDBRecordStoreBase<M> fdbRecordStore, @Nonnull Plan.ExecutionContext executionContext, @Nonnull Set<PlanHashable.PlanHashMode> validPlanHashModes) throws RelationalException {
            PlanValidator.validateHashes(parsedContinuation, executionContext.metricCollector, this.recordQueryPlan, this.queryExecutionContext, this.currentPlanHashMode, validPlanHashModes);
            if (!parsedContinuation.atBeginning()) {
                executionContext.metricCollector.increment(RelationalMetric.RelationalCount.CONTINUATION_DOWN_LEVEL);
            }
        }

        @Nonnull
        protected Optional<RecordQueryPlan> getSerializedPlanFromContinuation(@Nonnull ContinuationImpl parsedContinuation, @Nonnull Plan.ExecutionContext executionContext) throws RelationalException {
            CompiledStatement compiledStatement = parsedContinuation.getCompiledStatement();
            if (compiledStatement == null || !compiledStatement.hasPlan() || !compiledStatement.hasPlanSerializationMode()) {
                return Optional.empty();
            }
            try {
                PlanHashable.PlanHashMode planSerializationMode = PlanValidator.validateSerializedPlanSerializationMode(compiledStatement, OptionsUtils.getValidPlanHashModes(executionContext.getOptions()));
                PlanSerializationContext serializationContext = new PlanSerializationContext(DefaultPlanSerializationRegistry.INSTANCE, planSerializationMode);
                return Optional.of(RecordQueryPlan.fromRecordQueryPlanProto(serializationContext, compiledStatement.getPlan()));
            }
            catch (RelationalException ex) {
                return Optional.empty();
            }
        }

        @Nonnull
        private RelationalResultSet executeExplain(@Nonnull ContinuationImpl parsedContinuation, Plan.ExecutionContext executionContext) throws RelationalException {
            ImmutableRowStruct plannerMetrics;
            ImmutableRowStruct continuationInfo;
            DataType.StructType continuationStructType = DataType.StructType.from("PLAN_CONTINUATION", List.of(DataType.StructType.Field.from("EXECUTION_STATE", DataType.Primitives.BYTES.type(), 0), DataType.StructType.Field.from("VERSION", DataType.Primitives.INTEGER.type(), 1), DataType.StructType.Field.from("PLAN_HASH_MODE", DataType.Primitives.STRING.type(), 2), DataType.StructType.Field.from("PLAN_HASH", DataType.Primitives.INTEGER.type(), 3), DataType.StructType.Field.from("SERIALIZED_PLAN_COMPLEXITY", DataType.Primitives.INTEGER.type(), 4)), true);
            DataType.StructType plannerMetricsStructType = DataType.StructType.from("PLANNER_METRICS", List.of(DataType.StructType.Field.from("TASK_COUNT", DataType.Primitives.LONG.type(), 0), DataType.StructType.Field.from("TASK_TOTAL_TIME_NS", DataType.Primitives.LONG.type(), 1), DataType.StructType.Field.from("TRANSFORM_COUNT", DataType.Primitives.LONG.type(), 2), DataType.StructType.Field.from("TRANSFORM_TIME_NS", DataType.Primitives.LONG.type(), 3), DataType.StructType.Field.from("TRANSFORM_YIELD_COUNT", DataType.Primitives.LONG.type(), 4), DataType.StructType.Field.from("INSERT_TIME_NS", DataType.Primitives.LONG.type(), 5), DataType.StructType.Field.from("INSERT_NEW_COUNT", DataType.Primitives.LONG.type(), 6), DataType.StructType.Field.from("INSERT_REUSED_COUNT", DataType.Primitives.LONG.type(), 7)), true);
            DataType.StructType explainStructType = DataType.StructType.from("EXPLAIN", List.of(DataType.StructType.Field.from("PLAN", DataType.Primitives.STRING.type(), 0), DataType.StructType.Field.from("PLAN_HASH", DataType.Primitives.INTEGER.type(), 1), DataType.StructType.Field.from("PLAN_DOT", DataType.Primitives.STRING.type(), 2), DataType.StructType.Field.from("PLAN_GML", DataType.Primitives.STRING.type(), 3), DataType.StructType.Field.from("PLAN_CONTINUATION", continuationStructType, 4), DataType.StructType.Field.from("PLANNER_METRICS", plannerMetricsStructType, 5)), true);
            ImmutableRowStruct immutableRowStruct = ContinuationImpl.BEGIN.equals(parsedContinuation) ? null : (continuationInfo = new ImmutableRowStruct(new ArrayRow(parsedContinuation.getExecutionState(), parsedContinuation.getVersion(), parsedContinuation.getCompiledStatement() == null ? null : parsedContinuation.getCompiledStatement().getPlanSerializationMode(), parsedContinuation.getPlanHash(), this.getSerializedPlanFromContinuation(parsedContinuation, executionContext).map(com.apple.foundationdb.record.query.plan.plans.QueryPlan::getComplexity).orElse(null)), RelationalStructMetaData.of(continuationStructType)));
            if (this.plannerStatsMaps == null) {
                plannerMetrics = null;
            } else {
                Map<Class<? extends Debugger.Event>, Stats> plannerEventClassStatsMap = this.plannerStatsMaps.getEventClassStatsMap();
                Optional<Stats> executingTasksStats = Optional.ofNullable(plannerEventClassStatsMap.get(Debugger.ExecutingTaskEvent.class));
                Optional<Stats> transformRuleCallStats = Optional.ofNullable(plannerEventClassStatsMap.get(Debugger.TransformRuleCallEvent.class));
                Optional<Stats> insertIntoMemoStats = Optional.ofNullable(plannerEventClassStatsMap.get(Debugger.InsertIntoMemoEvent.class));
                plannerMetrics = new ImmutableRowStruct(new ArrayRow(executingTasksStats.map(s2 -> s2.getCount(Debugger.Location.BEGIN)).orElse(0L), executingTasksStats.map(Stats::getTotalTimeInNs).orElse(0L), transformRuleCallStats.map(s2 -> s2.getCount(Debugger.Location.BEGIN)).orElse(0L), transformRuleCallStats.map(Stats::getOwnTimeInNs).orElse(0L), transformRuleCallStats.map(s2 -> s2.getCount(Debugger.Location.YIELD)).orElse(0L), insertIntoMemoStats.map(Stats::getOwnTimeInNs).orElse(0L), insertIntoMemoStats.map(s2 -> s2.getCount(Debugger.Location.NEW)).orElse(0L), insertIntoMemoStats.map(s2 -> s2.getCount(Debugger.Location.REUSED)).orElse(0L), parsedContinuation.getVersion(), parsedContinuation.getCompiledStatement() == null ? null : parsedContinuation.getCompiledStatement().getPlanSerializationMode()), RelationalStructMetaData.of(plannerMetricsStructType));
            }
            PlannerGraph plannerGraph = Objects.requireNonNull(this.recordQueryPlan.acceptVisitor(PlannerGraphVisitor.forExplain()));
            return new IteratorResultSet(RelationalStructMetaData.of(explainStructType), Collections.singleton(new ArrayRow(this.explain(), this.planHashSupplier.get(), PlannerGraphVisitor.exportToDot(plannerGraph), PlannerGraphVisitor.exportToGml(plannerGraph, Map.of()), continuationInfo, plannerMetrics)).iterator(), 0);
        }

        @Nonnull
        private RelationalResultSet executePhysicalPlan(@Nonnull RecordLayerSchema recordLayerSchema, @Nonnull EvaluationContext evaluationContext, @Nonnull Plan.ExecutionContext executionContext, @Nonnull ContinuationImpl parsedContinuation) throws RelationalException {
            EmbeddedRelationalConnection connection = (EmbeddedRelationalConnection)executionContext.connection;
            Type type = this.recordQueryPlan.getResultType().getInnerType();
            Assert.notNull(type);
            Assert.that(type instanceof Type.Record, ErrorCode.INTERNAL_ERROR, "unexpected plan returning top-level result of type %s", (Object)type.getTypeCode());
            FDBRecordStoreBase fdbRecordStore = recordLayerSchema.loadStore().unwrap(FDBRecordStoreBase.class);
            Options options = executionContext.getOptions();
            this.validatePlanAgainstEnvironment(parsedContinuation, fdbRecordStore, executionContext, OptionsUtils.getValidPlanHashModes(options));
            ExecuteProperties executeProperties = connection.getExecuteProperties().toBuilder().setReturnedRowLimit((Integer)options.getOption(Options.Name.MAX_ROWS)).setDryRun((Boolean)options.getOption(Options.Name.DRY_RUN)).build();
            RecordCursor cursor = executionContext.metricCollector.clock(RelationalMetric.RelationalEvent.EXECUTE_RECORD_QUERY_PLAN, () -> this.recordQueryPlan.executePlan(fdbRecordStore, evaluationContext, parsedContinuation.getExecutionState(), executeProperties));
            PlanHashable.PlanHashMode currentPlanHashMode = OptionsUtils.getCurrentPlanHashMode(options);
            DataType.StructType dataType = (DataType.StructType)DataTypeUtils.toRelationalType(type);
            return executionContext.metricCollector.clock(RelationalMetric.RelationalEvent.CREATE_RESULT_SET_ITERATOR, () -> {
                RecordLayerIterator<QueryResult> iterator = RecordLayerIterator.create(cursor, messageFDBQueriedRecord -> new MessageTuple((Message)messageFDBQueriedRecord.getMessage()));
                return new RecordLayerResultSet(RelationalStructMetaData.of(dataType), iterator, connection, (continuation, reason) -> this.enrichContinuation(continuation, currentPlanHashMode, reason));
            });
        }

        @Nonnull
        private Continuation enrichContinuation(@Nonnull Continuation continuation, @Nonnull PlanHashable.PlanHashMode currentPlanHashMode, @Nonnull Continuation.Reason reason) throws RelationalException {
            ContinuationBuilder continuationBuilder = ContinuationImpl.copyOf(continuation).asBuilder().withBindingHash(this.queryExecutionContext.getParameterHash()).withPlanHash(this.planHashSupplier.get()).withReason(reason);
            if (!continuation.atEnd()) {
                PlanSerializationContext serializationContext = new PlanSerializationContext(DefaultPlanSerializationRegistry.INSTANCE, currentPlanHashMode);
                Literals literals = this.queryExecutionContext.getLiterals();
                CompiledStatement.Builder compiledStatementBuilder = CompiledStatement.newBuilder().setPlanSerializationMode(this.queryExecutionContext.getPlanHashMode().name());
                compiledStatementBuilder.setPlan(this.recordQueryPlan.toRecordQueryPlanProto(serializationContext));
                int i = 0;
                for (OrderedLiteral orderedLiteral : literals.getOrderedLiterals()) {
                    TypedQueryArgument orderedLiteralProto = orderedLiteral.toProto(serializationContext, i);
                    if (orderedLiteral.isQueryLiteral()) {
                        compiledStatementBuilder.addExtractedLiterals(orderedLiteralProto);
                    } else {
                        compiledStatementBuilder.addArguments(orderedLiteralProto);
                    }
                    ++i;
                }
                compiledStatementBuilder.setPlanConstraint(this.getContinuationConstraint().toProto(serializationContext));
                continuationBuilder.withCompiledStatement(compiledStatementBuilder.build());
            }
            return continuationBuilder.build();
        }

        public int planHash(@Nonnull PlanHashable.PlanHashMode currentPlanHashMode) {
            return this.recordQueryPlan.planHash(currentPlanHashMode);
        }
    }
}

