/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AccessHint;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInTableFunction;
import com.apple.foundationdb.record.query.plan.cascades.CatalogedFunction;
import com.apple.foundationdb.record.query.plan.cascades.Correlated;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.IndexAccessHint;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TableFunctionExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.AndOrValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ArithmeticValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.InOpValue;
import com.apple.foundationdb.record.query.plan.cascades.values.IndexableAggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.NotValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RelOpValue;
import com.apple.foundationdb.record.query.plan.cascades.values.StreamableAggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.StreamingValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.api.metadata.Metadata;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.api.metadata.Table;
import com.apple.foundationdb.relational.generated.RelationalParser;
import com.apple.foundationdb.relational.recordlayer.metadata.DataTypeUtils;
import com.apple.foundationdb.relational.recordlayer.query.Expression;
import com.apple.foundationdb.relational.recordlayer.query.Expressions;
import com.apple.foundationdb.relational.recordlayer.query.Identifier;
import com.apple.foundationdb.relational.recordlayer.query.LogicalOperator;
import com.apple.foundationdb.relational.recordlayer.query.LogicalOperators;
import com.apple.foundationdb.relational.recordlayer.query.LogicalPlanFragment;
import com.apple.foundationdb.relational.recordlayer.query.MutablePlanGenerationContext;
import com.apple.foundationdb.relational.recordlayer.query.OrderByExpression;
import com.apple.foundationdb.relational.recordlayer.query.ParseHelpers;
import com.apple.foundationdb.relational.recordlayer.query.PseudoColumn;
import com.apple.foundationdb.relational.recordlayer.query.Star;
import com.apple.foundationdb.relational.recordlayer.query.functions.SqlFunctionCatalog;
import com.apple.foundationdb.relational.recordlayer.query.functions.WithPlanGenerationSideEffects;
import com.apple.foundationdb.relational.recordlayer.query.visitors.BaseVisitor;
import com.apple.foundationdb.relational.recordlayer.query.visitors.QueryVisitor;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.protobuf.ByteString;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

@API(value=API.Status.EXPERIMENTAL)
public class SemanticAnalyzer {
    private static final int BITMAP_DEFAULT_ENTRY_SIZE = 10000;
    private static final Set<String> BITMAP_SCALAR_FUNCTIONS = ImmutableSet.of("bitmap_bucket_offset", "bitmap_bit_position");
    @Nonnull
    private final SchemaTemplate metadataCatalog;
    @Nonnull
    private final SqlFunctionCatalog functionCatalog;
    @Nonnull
    private final MutablePlanGenerationContext mutablePlanGenerationContext;

    public SemanticAnalyzer(@Nonnull SchemaTemplate metadataCatalog, @Nonnull SqlFunctionCatalog functionCatalog, @Nonnull MutablePlanGenerationContext mutablePlanGenerationContext) {
        this.metadataCatalog = metadataCatalog;
        this.functionCatalog = functionCatalog;
        this.mutablePlanGenerationContext = mutablePlanGenerationContext;
    }

    @Nullable
    public static String normalizeString(@Nullable String string, boolean caseSensitive) {
        if (string == null) {
            return null;
        }
        if (SemanticAnalyzer.isQuoted(string, "'") || SemanticAnalyzer.isQuoted(string, "\"")) {
            return string.substring(1, string.length() - 1);
        }
        if (caseSensitive) {
            return string;
        }
        return string.toUpperCase(Locale.ROOT);
    }

    private static boolean isQuoted(@Nonnull String str, @Nonnull String quotationMark) {
        return str.startsWith(quotationMark) && str.endsWith(quotationMark);
    }

    @Nonnull
    public Optional<LogicalOperator> findCteMaybe(@Nonnull Identifier identifier, @Nonnull LogicalPlanFragment logicalPlanFragment) {
        Optional<LogicalPlanFragment> currentFragment = Optional.of(logicalPlanFragment);
        while (currentFragment.isPresent()) {
            LogicalOperators logicalOperators = currentFragment.get().getLogicalOperators();
            ImmutableList matches = logicalOperators.stream().filter(logicalOperator -> logicalOperator.getName().isPresent() && logicalOperator.getName().get().equals(identifier)).collect(ImmutableList.toImmutableList());
            Assert.thatUnchecked(matches.size() <= 1, ErrorCode.DUPLICATE_ALIAS, () -> String.format(Locale.ROOT, "found '%s' more than once", identifier.getName()));
            if (!matches.isEmpty()) {
                return Optional.of((LogicalOperator)matches.get(0));
            }
            currentFragment = currentFragment.get().getParentMaybe();
        }
        return Optional.empty();
    }

    public boolean tableExists(@Nonnull Identifier tableIdentifier) {
        if (tableIdentifier.getQualifier().size() > 1) {
            return false;
        }
        if (tableIdentifier.isQualified()) {
            String qualifier = tableIdentifier.getQualifier().get(0);
            if (!this.metadataCatalog.getName().equals(qualifier)) {
                return false;
            }
        }
        String tableName = tableIdentifier.getName();
        try {
            return this.metadataCatalog.findTableByName(tableName).isPresent();
        }
        catch (RelationalException e) {
            throw e.toUncheckedWrappedException();
        }
    }

    public boolean functionExists(@Nonnull Identifier functionIdentifier) {
        return this.functionCatalog.containsFunction(functionIdentifier.getName());
    }

    @Nonnull
    public Table getTable(@Nonnull Identifier tableIdentifier) {
        Assert.thatUnchecked(tableIdentifier.getQualifier().size() <= 1, ErrorCode.INTERNAL_ERROR, () -> String.format(Locale.ROOT, "Unknown table %s", tableIdentifier));
        if (tableIdentifier.isQualified()) {
            String qualifier = tableIdentifier.getQualifier().get(0);
            Assert.thatUnchecked(this.metadataCatalog.getName().equals(qualifier), ErrorCode.UNDEFINED_DATABASE, () -> String.format(Locale.ROOT, "Unknown schema template %s", qualifier));
        }
        String tableName = tableIdentifier.getName();
        try {
            Optional<Table> tableMaybe = this.metadataCatalog.findTableByName(tableName);
            Assert.thatUnchecked(tableMaybe.isPresent(), ErrorCode.UNDEFINED_TABLE, () -> String.format(Locale.ROOT, "Unknown table %s", tableName));
            return tableMaybe.get();
        }
        catch (RelationalException e) {
            throw e.toUncheckedWrappedException();
        }
    }

    public void validateIndexes(@Nonnull Identifier tableIdentifier, @Nonnull Set<AccessHint> requestedIndexes) {
        Table table = this.getTable(tableIdentifier);
        this.validateIndexes(table, requestedIndexes);
    }

    public void validateIndexes(@Nonnull Table table, @Nonnull Set<AccessHint> requestedIndexes) {
        if (requestedIndexes.isEmpty()) {
            return;
        }
        ImmutableSet nonIndexAccessHints = requestedIndexes.stream().filter(accessHint -> !(accessHint instanceof IndexAccessHint)).map(Object::getClass).map(Class::toString).collect(ImmutableSet.toImmutableSet());
        Assert.thatUnchecked(nonIndexAccessHints.isEmpty(), ErrorCode.UNDEFINED_INDEX, () -> String.format(Locale.ROOT, "Unknown index hint(s) %s", String.join((CharSequence)",", nonIndexAccessHints)));
        ImmutableSet tableIndexes = table.getIndexes().stream().map(Metadata::getName).collect(ImmutableSet.toImmutableSet());
        Sets.SetView unrecognizedIndexes = Sets.difference(requestedIndexes.stream().map(IndexAccessHint.class::cast).map(IndexAccessHint::getIndexName).collect(ImmutableSet.toImmutableSet()), tableIndexes);
        Assert.thatUnchecked(unrecognizedIndexes.isEmpty(), ErrorCode.UNDEFINED_INDEX, () -> String.format(Locale.ROOT, "Unknown index(es) %s", String.join((CharSequence)",", unrecognizedIndexes)));
    }

    public void validateOrderByColumns(@Nonnull Iterable<OrderByExpression> orderBys) {
        List duplicates = StreamSupport.stream(orderBys.spliterator(), false).map(OrderByExpression::getExpression).flatMap(expr -> expr.getName().stream()).collect(Collectors.groupingBy(Functions.identity(), Collectors.counting())).entrySet().stream().filter(p -> (Long)p.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        Assert.thatUnchecked(duplicates.isEmpty(), ErrorCode.COLUMN_ALREADY_EXISTS, () -> String.format(Locale.ROOT, "Order by column %s is duplicated in the order by clause", duplicates.stream().map(Identifier::toString).collect(Collectors.joining(","))));
    }

    @Nonnull
    public Set<String> getAllTableNames() {
        try {
            return this.metadataCatalog.getTables().stream().map(Metadata::getName).collect(ImmutableSet.toImmutableSet());
        }
        catch (RelationalException e) {
            throw e.toUncheckedWrappedException();
        }
    }

    @Nonnull
    public Expression resolveCorrelatedIdentifier(@Nonnull Identifier identifier, @Nonnull LogicalOperators operators) {
        Assert.thatUnchecked(identifier.isQualified(), ErrorCode.UNDEFINED_TABLE, () -> String.format(Locale.ROOT, "Unknown table %s", identifier));
        return this.resolveIdentifier(identifier, operators);
    }

    @Nonnull
    public Star expandStar(@Nonnull Optional<Identifier> optionalQualifier, @Nonnull LogicalOperators operators) {
        LogicalOperators forEachOperators = operators.forEachOnly();
        if (optionalQualifier.isEmpty()) {
            Expressions expansion = forEachOperators.getExpressions().nonEphemeral();
            return Star.overQuantifiers(Optional.empty(), Streams.stream(forEachOperators).map(LogicalOperator::getQuantifier).map(Quantifier::getFlowedObjectValue).collect(ImmutableList.toImmutableList()), "unknown", expansion);
        }
        Identifier qualifier = optionalQualifier.get();
        Optional<LogicalOperator> logicalTableMaybe = Streams.stream(forEachOperators).filter(table -> table.getName().isPresent() && table.getName().get().equals(qualifier)).findFirst();
        if (logicalTableMaybe.isPresent()) {
            return Star.overQuantifier(optionalQualifier, logicalTableMaybe.get().getQuantifier().getFlowedObjectValue(), qualifier.getName(), logicalTableMaybe.get().getOutput().nonEphemeral());
        }
        Expressions individualReferencedColumns = Expressions.of(forEachOperators.getExpressions().stream().filter(expr -> expr.getName().isPresent() && expr.getName().get().isQualified()).filter(expr -> expr.getName().get().qualifiedWith((Identifier)optionalQualifier.get())).collect(ImmutableList.toImmutableList()));
        if (!individualReferencedColumns.isEmpty()) {
            return Star.overIndividualExpressions(optionalQualifier, "unknown", individualReferencedColumns);
        }
        Expression expression = this.resolveIdentifier(qualifier, forEachOperators);
        Assert.thatUnchecked(expression.getDataType().getCode() == DataType.Code.STRUCT, ErrorCode.INVALID_COLUMN_REFERENCE, () -> String.format(Locale.ROOT, "attempt to expand non-struct column %s", qualifier));
        Expressions expressions = SemanticAnalyzer.expandStructExpression(expression).nonEphemeral();
        return Star.overQuantifier(optionalQualifier, expression.getUnderlying(), qualifier.getName(), expressions);
    }

    @Nonnull
    public Expression resolveIdentifier(@Nonnull Identifier identifier, @Nonnull LogicalPlanFragment planFragment) {
        LogicalPlanFragment currentPlanFragment = planFragment;
        Optional<Expression> resolvedMaybe = this.resolveIdentifierMaybe(identifier, currentPlanFragment.getLogicalOperators());
        if (resolvedMaybe.isPresent()) {
            return resolvedMaybe.get();
        }
        while (currentPlanFragment.hasParent()) {
            resolvedMaybe = this.resolveIdentifierMaybe(identifier, (currentPlanFragment = currentPlanFragment.getParent()).getLogicalOperators());
            if (!resolvedMaybe.isPresent()) continue;
            return resolvedMaybe.get();
        }
        Assert.failUnchecked(ErrorCode.UNDEFINED_COLUMN, String.format(Locale.ROOT, "Attempting to query non existing column '%s'", identifier));
        return null;
    }

    @Nonnull
    public Expression resolveIdentifier(@Nonnull Identifier identifier, @Nonnull LogicalOperators operators) {
        List<Expression> attributes = this.lookup(identifier, operators, true);
        Assert.thatUnchecked(attributes.size() <= 1, ErrorCode.AMBIGUOUS_COLUMN, () -> String.format(Locale.ROOT, "Ambiguous reference '%s'", identifier));
        if (attributes.isEmpty()) {
            attributes = this.lookup(identifier, operators, false);
        }
        Assert.thatUnchecked(!attributes.isEmpty(), ErrorCode.UNDEFINED_COLUMN, () -> String.format(Locale.ROOT, "Unknown reference %s", identifier));
        Assert.thatUnchecked(attributes.size() == 1, ErrorCode.AMBIGUOUS_COLUMN, () -> String.format(Locale.ROOT, "Ambiguous reference '%s'", identifier));
        return attributes.get(0);
    }

    @Nonnull
    private Optional<Expression> resolveIdentifierMaybe(@Nonnull Identifier identifier, @Nonnull LogicalOperators operators) {
        List<Expression> attributes = this.lookup(identifier, operators, true);
        Assert.thatUnchecked(attributes.size() <= 1, ErrorCode.AMBIGUOUS_COLUMN, () -> String.format(Locale.ROOT, "Ambiguous reference '%s'", identifier));
        if (attributes.isEmpty()) {
            attributes = this.lookup(identifier, operators, false);
        }
        if (attributes.isEmpty()) {
            return Optional.empty();
        }
        Assert.thatUnchecked(attributes.size() == 1, ErrorCode.AMBIGUOUS_COLUMN, () -> String.format(Locale.ROOT, "Ambiguous reference '%s'", identifier));
        return Optional.of(attributes.get(0));
    }

    private static Optional<Expression> lookupPseudoField(@Nonnull LogicalOperator logicalOperator, @Nonnull Identifier identifier, boolean matchQualifiedOnly) {
        if (matchQualifiedOnly && (!identifier.isQualified() || logicalOperator.getName().isEmpty())) {
            return Optional.empty();
        }
        if (matchQualifiedOnly && identifier.isQualified() && identifier.fullyQualifiedName().size() != 2) {
            return Optional.empty();
        }
        if (!identifier.isQualified()) {
            return PseudoColumn.mapToExpressionMaybe(logicalOperator, identifier.getName());
        }
        if (logicalOperator.getName().isEmpty()) {
            return Optional.empty();
        }
        if (!identifier.prefixedWith(logicalOperator.getName().get())) {
            return Optional.empty();
        }
        return PseudoColumn.mapToExpressionMaybe(logicalOperator, identifier.getName());
    }

    @Nonnull
    private List<Expression> lookup(@Nonnull Identifier referenceIdentifier, @Nonnull LogicalOperators operators, boolean matchQualifiedOnly) {
        if (matchQualifiedOnly && !referenceIdentifier.isQualified()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder matchedAttributes = ImmutableList.builder();
        for (LogicalOperator operator : operators) {
            if (operator.getQuantifier() instanceof Quantifier.Existential) continue;
            Optional<Identifier> operatorNameMaybe = operator.getName();
            boolean checkForPseudoColumns = true;
            for (Expression attribute : operator.getOutput()) {
                if (attribute.getName().isEmpty()) continue;
                Identifier attributeIdentifier = attribute.getName().get();
                if (attributeIdentifier.equals(referenceIdentifier)) {
                    matchedAttributes.add(attribute);
                    checkForPseudoColumns = false;
                    continue;
                }
                if (!matchQualifiedOnly && attributeIdentifier.withoutQualifier().equals(referenceIdentifier)) {
                    matchedAttributes.add(attribute);
                    checkForPseudoColumns = false;
                    continue;
                }
                if (matchQualifiedOnly && operatorNameMaybe.isPresent() && attributeIdentifier.withQualifier(operatorNameMaybe.get().getName()).equals(referenceIdentifier)) {
                    matchedAttributes.add(attribute);
                    checkForPseudoColumns = false;
                    continue;
                }
                Optional<Expression> nestedFieldMaybe = this.lookupNestedField(referenceIdentifier, attribute, operator, matchQualifiedOnly);
                if (!nestedFieldMaybe.isPresent()) continue;
                matchedAttributes.add(nestedFieldMaybe.get());
                checkForPseudoColumns = false;
            }
            if (!checkForPseudoColumns) continue;
            SemanticAnalyzer.lookupPseudoField(operator, referenceIdentifier, matchQualifiedOnly).ifPresent(matchedAttributes::add);
        }
        return matchedAttributes.build();
    }

    @Nonnull
    public Optional<Expression> lookupAlias(@Nonnull Identifier requestedAlias, @Nonnull Expressions existingExpressions) {
        if (requestedAlias.isQualified()) {
            return Optional.empty();
        }
        ImmutableList.Builder matchedAttributesBuilder = ImmutableList.builder();
        for (Expression expression : existingExpressions) {
            if (expression.getName().isEmpty() || expression.getName().get().isQualified() || !expression.getName().get().equals(requestedAlias)) continue;
            matchedAttributesBuilder.add(expression);
        }
        ImmutableCollection matchedAttributes = matchedAttributesBuilder.build();
        if (matchedAttributes.size() > 1) {
            Assert.failUnchecked(ErrorCode.AMBIGUOUS_COLUMN, String.format(Locale.ROOT, "Ambiguous alias %s", requestedAlias));
        }
        return matchedAttributes.isEmpty() ? Optional.empty() : Optional.of((Expression)matchedAttributes.get(0));
    }

    @Nonnull
    public Optional<Expression> lookupNestedField(@Nonnull Identifier requestedIdentifier, @Nonnull Expression existingExpression, @Nonnull LogicalOperator logicalOperator, boolean matchQualifiedOnly) {
        List<String> remainingPath;
        if (existingExpression.getName().isEmpty() || requestedIdentifier.fullyQualifiedName().size() <= 1) {
            return Optional.empty();
        }
        Expression effectiveExistingExpr = matchQualifiedOnly && logicalOperator.getName().isPresent() ? existingExpression.withQualifier(Optional.of(logicalOperator.getName().get())) : existingExpression.clearQualifier();
        Identifier effectiveExprName = effectiveExistingExpr.getName().orElseThrow();
        if (!requestedIdentifier.prefixedWith(effectiveExprName)) {
            if (existingExpression.getName().isPresent() && requestedIdentifier.prefixedWith(existingExpression.getName().get())) {
                effectiveExprName = existingExpression.getName().get();
            } else {
                return Optional.empty();
            }
        }
        if ((remainingPath = requestedIdentifier.fullyQualifiedName().subList(effectiveExprName.fullyQualifiedName().size(), requestedIdentifier.fullyQualifiedName().size())).isEmpty()) {
            return Optional.of(existingExpression.withName(requestedIdentifier));
        }
        ImmutableList.Builder accessors = ImmutableList.builder();
        DataType type = existingExpression.getDataType();
        for (String s2 : remainingPath) {
            if (type.getCode() != DataType.Code.STRUCT) {
                return Optional.empty();
            }
            List<DataType.StructType.Field> fields = ((DataType.StructType)type).getFields();
            boolean found = false;
            for (int j = 0; j < fields.size(); ++j) {
                if (!fields.get(j).getName().equals(s2)) continue;
                accessors.add(new FieldValue.Accessor(fields.get(j).getName(), j));
                type = fields.get(j).getType();
                found = true;
                break;
            }
            if (found) continue;
            return Optional.empty();
        }
        FieldValue.FieldPath fieldPath = FieldValue.resolveFieldPath(existingExpression.getUnderlying().getResultType(), (List<FieldValue.Accessor>)((Object)accessors.build()));
        FieldValue attributeExpression = FieldValue.ofFieldsAndFuseIfPossible(existingExpression.getUnderlying(), fieldPath);
        Expression nestedAttribute = new Expression(Optional.of(requestedIdentifier), type, attributeExpression);
        return Optional.of(nestedAttribute);
    }

    @Nonnull
    public DataType lookupType(@Nonnull Identifier typeIdentifier, boolean isNullable, boolean isRepeated, @Nonnull Function<String, Optional<DataType>> dataTypeProvider) {
        DataType type;
        String typeName = typeIdentifier.getName();
        switch (typeName.toUpperCase(Locale.ROOT)) {
            case "STRING": {
                type = isNullable ? DataType.Primitives.NULLABLE_STRING.type() : DataType.Primitives.STRING.type();
                break;
            }
            case "INTEGER": {
                type = isNullable ? DataType.Primitives.NULLABLE_INTEGER.type() : DataType.Primitives.INTEGER.type();
                break;
            }
            case "BIGINT": {
                type = isNullable ? DataType.Primitives.NULLABLE_LONG.type() : DataType.Primitives.LONG.type();
                break;
            }
            case "DOUBLE": {
                type = isNullable ? DataType.Primitives.NULLABLE_DOUBLE.type() : DataType.Primitives.DOUBLE.type();
                break;
            }
            case "BOOLEAN": {
                type = isNullable ? DataType.Primitives.NULLABLE_BOOLEAN.type() : DataType.Primitives.BOOLEAN.type();
                break;
            }
            case "BYTES": {
                type = isNullable ? DataType.Primitives.NULLABLE_BYTES.type() : DataType.Primitives.BYTES.type();
                break;
            }
            case "FLOAT": {
                type = isNullable ? DataType.Primitives.NULLABLE_FLOAT.type() : DataType.Primitives.FLOAT.type();
                break;
            }
            case "UUID": {
                type = isNullable ? DataType.Primitives.NULLABLE_UUID.type() : DataType.Primitives.UUID.type();
                break;
            }
            default: {
                Assert.notNullUnchecked(this.metadataCatalog);
                Optional<DataType> maybeFound = dataTypeProvider.apply(typeName);
                type = maybeFound.orElseGet(() -> DataType.UnresolvedType.of(typeName, isNullable));
            }
        }
        if (isRepeated) {
            return DataType.ArrayType.from(type.withNullable(false), isNullable);
        }
        return type;
    }

    @Nonnull
    private static Expressions expandStructExpression(@Nonnull Expression expression) {
        Assert.thatUnchecked(expression.getDataType().getCode() == DataType.Code.STRUCT, ErrorCode.INVALID_COLUMN_REFERENCE, () -> String.format(Locale.ROOT, "attempt to expand non-struct expression %s", expression));
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        Value underlying = expression.getUnderlying();
        DataType.StructType type = Assert.castUnchecked(expression.getDataType(), DataType.StructType.class);
        int colCount = 0;
        for (DataType.StructType.Field field : type.getFields()) {
            FieldValue expandedExpressionValue = FieldValue.ofOrdinalNumber(underlying, colCount);
            List expandedExpressionQuantifier = expression.getName().map(Identifier::fullyQualifiedName).orElse(ImmutableList.of());
            String expandedExpressionName = field.getName();
            DataType expandedExpressionType = DataTypeUtils.toRelationalType(expandedExpressionValue.getResultType());
            resultBuilder.add(new Expression(Optional.of(Identifier.of(expandedExpressionName, expandedExpressionQuantifier)), expandedExpressionType, expandedExpressionValue));
            ++colCount;
        }
        return Expressions.of(resultBuilder.build());
    }

    public void validateInListItems(@Nonnull Expressions inListItems) {
        for (Expression inListItem : inListItems) {
            Type resultType = inListItem.getUnderlying().getResultType();
            Assert.thatUnchecked(resultType != Type.NULL, ErrorCode.WRONG_OBJECT_TYPE, "NULL values are not allowed in the IN list");
            Assert.thatUnchecked(!resultType.isUnresolved(), ErrorCode.UNKNOWN_TYPE, String.format(Locale.ROOT, "Type cannot be determined for element `%s` in the IN list", inListItem));
        }
    }

    public static void validateGroupByAggregates(@Nonnull Expressions groupByExpressions) {
        ImmutableSet nestedAggregates = groupByExpressions.stream().filter(expression -> expression.getUnderlying() instanceof AggregateValue).filter(agg -> agg.getUnderlying().preOrderStream().skip(1L).anyMatch(c -> c instanceof StreamableAggregateValue || c instanceof IndexableAggregateValue)).collect(ImmutableSet.toImmutableSet());
        Assert.thatUnchecked(nestedAggregates.isEmpty(), ErrorCode.UNSUPPORTED_OPERATION, () -> String.format(Locale.ROOT, "unsupported nested aggregate(s) %s", nestedAggregates.stream().map(ex -> ex.getUnderlying().toString()).collect(Collectors.joining(","))));
    }

    @Nonnull
    public static Optional<Type.Record> validateUnionTypes(@Nonnull LogicalOperators unionLegs) {
        long distinctTypesCount = unionLegs.stream().map(exp -> exp.getOutput().expanded().size()).distinct().count();
        Assert.thatUnchecked(distinctTypesCount == 1L, ErrorCode.UNION_INCORRECT_COLUMN_COUNT, "UNION legs do not have the same number of columns");
        Type.Record result = null;
        boolean requiresPromotion = false;
        for (Type.Record unionLegType : unionLegs.stream().map(leg -> leg.getQuantifier().getFlowedObjectType()).map(type -> Assert.castUnchecked(type, Type.Record.class)).collect(ImmutableList.toImmutableList())) {
            if (result == null) {
                result = unionLegType;
                continue;
            }
            if (requiresPromotion) {
                result = Assert.castUnchecked(Type.maximumType(result, unionLegType), Type.Record.class);
                continue;
            }
            Type.Record oldType = result;
            if (oldType.equals(result = Assert.castUnchecked(Assert.notNullUnchecked(Type.maximumType(result, unionLegType), ErrorCode.UNION_INCOMPATIBLE_COLUMNS, "Incompatible column types in UNION legs"), Type.Record.class))) continue;
            requiresPromotion = true;
        }
        return requiresPromotion ? Optional.of(Assert.notNullUnchecked(result)) : Optional.empty();
    }

    @Nonnull
    public Type.Array resolveArrayTypeFromValues(@Nonnull Expressions arrayItems) {
        ImmutableList<Type> arrayItemsTypes = Streams.stream(arrayItems).map(Expression::getUnderlying).map(Value::getResultType).collect(ImmutableList.toImmutableList());
        return SemanticAnalyzer.resolveArrayTypeFromElementTypes(arrayItemsTypes);
    }

    public static boolean isComposableFrom(@Nonnull Expression expression, @Nonnull Expressions parts, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantCorrelations) {
        Correlated.BoundEquivalence<Value> boundEquivalence = new Correlated.BoundEquivalence<Value>(aliasMap);
        ImmutableSet<Equivalence.Wrapper<Value>> boundParts = Streams.stream(parts).map(Expression::getUnderlying).map(boundEquivalence::wrap).collect(ImmutableSet.toImmutableSet());
        return SemanticAnalyzer.isComposableFromInternal(expression.getUnderlying(), boundParts, boundEquivalence, constantCorrelations);
    }

    private static boolean isComposableFromInternal(@Nonnull Value value, @Nonnull Set<Equivalence.Wrapper<Value>> parts, @Nonnull Correlated.BoundEquivalence<Value> boundEquivalence, @Nonnull Set<CorrelationIdentifier> constantCorrelations) {
        Equivalence.Wrapper<Value> boundValue = boundEquivalence.wrap(value);
        if (parts.contains(boundValue)) {
            return true;
        }
        if (value.isConstant()) {
            return true;
        }
        if (constantCorrelations.containsAll(value.getCorrelatedTo())) {
            return true;
        }
        if (value instanceof ArithmeticValue || value instanceof RecordConstructorValue || value instanceof RelOpValue.BinaryRelOpValue || value instanceof AndOrValue || value instanceof NotValue || value instanceof InOpValue) {
            for (Value child : value.getChildren()) {
                if (SemanticAnalyzer.isComposableFromInternal(child, parts, boundEquivalence, constantCorrelations)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    private static Type.Array resolveArrayTypeFromElementTypes(@Nonnull List<Type> types) {
        Type elementType;
        if (types.isEmpty()) {
            elementType = Type.nullType();
        } else {
            List distinctTypes = types.stream().filter(type -> type != Type.nullType()).distinct().collect(Collectors.toList());
            Assert.thatUnchecked(distinctTypes.size() == 1, ErrorCode.DATATYPE_MISMATCH, "could not determine type of constant array");
            elementType = (Type)distinctTypes.get(0);
        }
        return new Type.Array(elementType);
    }

    public static void validateLimit(@Nonnull Expression expression) {
        long minInclusive = 1L;
        long maxInclusive = Integer.MAX_VALUE;
        Value underlying = expression.getUnderlying();
        Assert.thatUnchecked(underlying instanceof LiteralValue);
        Object value = ((LiteralValue)underlying).getLiteralValue();
        Assert.notNullUnchecked(value, ErrorCode.INVALID_ROW_COUNT_IN_LIMIT_CLAUSE, () -> String.format(Locale.ROOT, "limit value out of range [1, %d]", Integer.MAX_VALUE));
        if (value.getClass() == Integer.class) {
            Assert.thatUnchecked(1L <= (long)((Integer)value).intValue() && (long)((Integer)value).intValue() <= Integer.MAX_VALUE, ErrorCode.INVALID_ROW_COUNT_IN_LIMIT_CLAUSE, () -> String.format(Locale.ROOT, "limit value out of range [1, %d]", Integer.MAX_VALUE));
            return;
        }
        if (value.getClass() == Long.class) {
            Assert.thatUnchecked(1L <= (Long)value && (Long)value <= Integer.MAX_VALUE, ErrorCode.INVALID_ROW_COUNT_IN_LIMIT_CLAUSE, () -> String.format(Locale.ROOT, "limit value out of range [1, %d]", Integer.MAX_VALUE));
            return;
        }
        Assert.failUnchecked("unexpected limit type " + String.valueOf(value.getClass()));
    }

    public static void validateDatabaseUri(@Nonnull Identifier path) {
        Assert.thatUnchecked(Objects.requireNonNull(path.getName()).matches("/\\w[a-zA-Z0-9_/]*\\w"), ErrorCode.INVALID_PATH, () -> String.format(Locale.ROOT, "invalid database path '%s'", path));
    }

    public static void validateCteColumnAliases(@Nonnull LogicalOperator logicalOperator, @Nonnull List<Identifier> columnAliases) {
        Expressions expressions = logicalOperator.getOutput().expanded();
        Assert.thatUnchecked(expressions.size() == columnAliases.size(), ErrorCode.INVALID_COLUMN_REFERENCE, () -> String.format(Locale.ROOT, "cte query has %d column(s), however %d aliases defined", expressions.size(), columnAliases.size()));
    }

    @Nonnull
    public static NonnullPair<Optional<URI>, String> parseSchemaIdentifier(@Nonnull Identifier schemaIdentifier) {
        String id = schemaIdentifier.getName();
        Assert.notNullUnchecked(id);
        if (id.startsWith("/")) {
            SemanticAnalyzer.validateDatabaseUri(schemaIdentifier);
            int separatorIdx = id.lastIndexOf("/");
            Assert.thatUnchecked(separatorIdx < id.length() - 1);
            return NonnullPair.of(Optional.of(URI.create(id.substring(0, separatorIdx))), id.substring(separatorIdx + 1));
        }
        return NonnullPair.of(Optional.empty(), id);
    }

    public static void validateContinuation(@Nonnull Expression continuation) {
        Value underlying = continuation.getUnderlying();
        Assert.thatUnchecked(underlying instanceof LiteralValue, ErrorCode.INVALID_CONTINUATION, "Unexpected continuation parameter of type %s", underlying.getClass().getSimpleName());
        Object continuationBytes = Assert.castUnchecked(underlying, LiteralValue.class).getLiteralValue();
        Assert.notNullUnchecked(continuationBytes);
        Assert.thatUnchecked(continuationBytes instanceof ByteString, ErrorCode.INVALID_CONTINUATION, "Unexpected continuation parameter of type %s", continuationBytes.getClass().getSimpleName());
    }

    @Nonnull
    public Expression resolveScalarFunction(@Nonnull String functionName, @Nonnull Expressions arguments, boolean flattenSingleItemRecords) {
        Assert.thatUnchecked(this.functionCatalog.containsFunction(functionName), ErrorCode.UNSUPPORTED_QUERY, () -> String.format(Locale.ROOT, "Unsupported operator %s", functionName));
        CatalogedFunction builtInFunction = this.functionCatalog.lookupFunction(functionName, arguments);
        this.processFunctionSideEffects(builtInFunction);
        ImmutableCollection.Builder argumentList = ImmutableList.builderWithExpectedSize(arguments.size() + 1).addAll((Iterable)arguments);
        if (BITMAP_SCALAR_FUNCTIONS.contains(functionName.toLowerCase(Locale.ROOT))) {
            ((ImmutableList.Builder)argumentList).add(Expression.ofUnnamed(new LiteralValue<Integer>(10000)));
        }
        List valueArgs = ((ImmutableList.Builder)argumentList).build().stream().map(Expression::getUnderlying).map(v -> flattenSingleItemRecords ? SqlFunctionCatalog.flattenRecordWithOneField(v) : v).collect(ImmutableList.toImmutableList());
        Value resultingValue = Assert.castUnchecked(builtInFunction.encapsulate(valueArgs), Value.class);
        return Expression.ofUnnamed(DataTypeUtils.toRelationalType(resultingValue.getResultType()), resultingValue);
    }

    private void processFunctionSideEffects(@Nonnull CatalogedFunction builtInFunction) {
        if (!(builtInFunction instanceof WithPlanGenerationSideEffects)) {
            return;
        }
        this.mutablePlanGenerationContext.importAuxiliaryLiterals(Assert.castUnchecked(builtInFunction, WithPlanGenerationSideEffects.class).getAuxiliaryLiterals());
    }

    @Nonnull
    public LogicalOperator resolveTableFunction(@Nonnull Identifier functionName, @Nonnull Expressions arguments, boolean flattenSingleItemRecords) {
        Typed resultingValue;
        Assert.thatUnchecked(this.functionCatalog.containsFunction(functionName.getName()), ErrorCode.UNDEFINED_FUNCTION, () -> String.format(Locale.ROOT, "Unknown function %s", functionName));
        CatalogedFunction tableFunction = this.functionCatalog.lookupFunction(functionName.getName(), arguments);
        if (tableFunction instanceof BuiltInFunction) {
            Assert.thatUnchecked(tableFunction instanceof BuiltInTableFunction, String.valueOf(functionName) + " is not a table-valued function");
        }
        this.processFunctionSideEffects(tableFunction);
        List valueArgs = Streams.stream(arguments.underlying().iterator()).map(v -> flattenSingleItemRecords ? SqlFunctionCatalog.flattenRecordWithOneField(v) : v).collect(ImmutableList.toImmutableList());
        Assert.thatUnchecked(arguments.allNamedArguments() || arguments.noneNamedArguments(), ErrorCode.UNSUPPORTED_OPERATION, "mixing named and unnamed arguments is not supported");
        Typed typed = resultingValue = arguments.allNamedArguments() ? tableFunction.encapsulate(arguments.toNamedArgumentInvocation()) : tableFunction.encapsulate(valueArgs);
        if (resultingValue instanceof StreamingValue) {
            TableFunctionExpression tableFunctionExpression = new TableFunctionExpression(Assert.castUnchecked(resultingValue, StreamingValue.class));
            Quantifier.ForEach resultingQuantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)tableFunctionExpression));
            Expressions output = Expressions.of(LogicalOperator.convertToExpressions(resultingQuantifier));
            return LogicalOperator.newNamedOperator(functionName, output, resultingQuantifier);
        }
        RelationalExpression relationalExpression = Assert.castUnchecked(resultingValue, RelationalExpression.class);
        Quantifier.ForEach topQun = Quantifier.forEach(Reference.initialOf(relationalExpression));
        return LogicalOperator.newNamedOperator(functionName, Expressions.fromQuantifier(topQun), topQun);
    }

    public boolean isJavaCallFunction(@Nonnull String functionName) {
        return this.functionCatalog.isJavaCallFunction(functionName);
    }

    public boolean containsReferencesTo(@Nonnull ParseTree parseTree, @Nonnull Identifier identifier, @Nonnull Function<RelationalParser.FullIdContext, Identifier> idParser) {
        return ParseHelpers.ParseTreeLikeAdapter.from(parseTree).preOrderStream().map(ParseHelpers.ParseTreeLikeAdapter::getParseTree).anyMatch(child -> child instanceof RelationalParser.TableNameContext && ((Identifier)idParser.apply(((RelationalParser.TableNameContext)child).fullId())).equals(identifier));
    }

    @Nonnull
    public Optional<Type> getRecursiveCteType(@Nonnull RelationalParser.QueryContext namedQueryBody, @Nonnull Identifier queryName, @Nonnull Function<RelationalParser.FullIdContext, Identifier> idParser, @Nonnull Function<ParserRuleContext, LogicalOperators> memoizer, @Nonnull QueryVisitor queryVisitor) {
        AtomicReference result = new AtomicReference(Optional.empty());
        this.recursiveQueryTraversal(namedQueryBody, queryName, idParser, nonRecursiveBranch -> {
            if (((Optional)result.get()).isEmpty()) {
                LogicalOperator logicalOperator = SemanticAnalyzer.handleQueryFragment(nonRecursiveBranch, namedQueryBody, memoizer, queryVisitor);
                result.set(Optional.of(logicalOperator.getQuantifier().getFlowedObjectType()));
            }
        }, ignored -> {});
        return result.get();
    }

    @Nonnull
    public NonnullPair<List<LogicalOperator>, List<LogicalOperator>> partitionRecursiveQuery(@Nonnull RelationalParser.QueryContext namedQueryBody, @Nonnull Identifier queryName, @Nonnull Function<RelationalParser.FullIdContext, Identifier> idParser, @Nonnull Function<ParserRuleContext, LogicalOperators> memoizer, @Nonnull QueryVisitor queryVisitor) {
        ImmutableList.Builder nonRecursiveBranchesBuilder = ImmutableList.builder();
        ImmutableList.Builder recursiveBranchesBuilder = ImmutableList.builder();
        this.recursiveQueryTraversal(namedQueryBody, queryName, idParser, nonRecursiveBranch -> {
            LogicalOperator logicalOperator = SemanticAnalyzer.handleQueryFragment(nonRecursiveBranch, namedQueryBody, memoizer, queryVisitor);
            nonRecursiveBranchesBuilder.add(logicalOperator);
        }, recursiveBranch -> {
            LogicalOperator logicalOperator = SemanticAnalyzer.handleQueryFragment(recursiveBranch, namedQueryBody, memoizer, queryVisitor);
            recursiveBranchesBuilder.add(logicalOperator);
        });
        return NonnullPair.of(nonRecursiveBranchesBuilder.build(), recursiveBranchesBuilder.build());
    }

    private void recursiveQueryTraversal(@Nonnull RelationalParser.QueryContext namedQueryBody, @Nonnull Identifier queryName, @Nonnull Function<RelationalParser.FullIdContext, Identifier> idParser, @Nonnull Consumer<ParserRuleContext> nonRecursiveBranchConsumer, @Nonnull Consumer<ParserRuleContext> recursiveBranchConsumer) {
        RelationalParser.QueryExpressionBodyContext queryExpressionBody;
        boolean hasNestedCtes;
        boolean bl = hasNestedCtes = namedQueryBody.ctes() != null;
        if (hasNestedCtes) {
            for (RelationalParser.NamedQueryContext nestedNamedQuery : namedQueryBody.ctes().namedQuery()) {
                Identifier nestedQueryName = idParser.apply(nestedNamedQuery.name);
                Assert.thatUnchecked(!queryName.equals(nestedQueryName), ErrorCode.UNSUPPORTED_QUERY, "ambiguous nested recursive CTE name");
            }
        }
        if ((queryExpressionBody = namedQueryBody.queryExpressionBody()) instanceof RelationalParser.QueryTermDefaultContext) {
            RelationalParser.QueryTermContext queryTerm = ((RelationalParser.QueryTermDefaultContext)queryExpressionBody).queryTerm();
            if (queryTerm instanceof RelationalParser.ParenthesisQueryContext) {
                this.recursiveQueryTraversal(((RelationalParser.ParenthesisQueryContext)queryTerm).query(), queryName, idParser, nonRecursiveBranchConsumer, recursiveBranchConsumer);
                return;
            }
            boolean isRecursive = this.containsReferencesTo(queryTerm, queryName, idParser);
            if (isRecursive) {
                recursiveBranchConsumer.accept(queryTerm);
            } else {
                nonRecursiveBranchConsumer.accept(queryTerm);
            }
        } else {
            Assert.thatUnchecked(queryExpressionBody instanceof RelationalParser.SetQueryContext);
            final RelationalParser.SetQueryContext setQueryContext = (RelationalParser.SetQueryContext)queryExpressionBody;
            this.recursiveQueryTraversal(new RelationalParser.QueryContext((ParserRuleContext)namedQueryBody.parent, namedQueryBody.invokingState){

                @Override
                public RelationalParser.QueryExpressionBodyContext queryExpressionBody() {
                    return setQueryContext.left;
                }

                @Override
                public int getChildCount() {
                    return 1;
                }

                @Override
                public ParseTree getChild(int i) {
                    Assert.thatUnchecked(i == 0);
                    return setQueryContext.left;
                }
            }, queryName, idParser, nonRecursiveBranchConsumer, recursiveBranchConsumer);
            this.recursiveQueryTraversal(new RelationalParser.QueryContext((ParserRuleContext)namedQueryBody.parent, namedQueryBody.invokingState){

                @Override
                public RelationalParser.QueryExpressionBodyContext queryExpressionBody() {
                    return setQueryContext.right;
                }

                @Override
                public int getChildCount() {
                    return 1;
                }

                @Override
                public ParseTree getChild(int i) {
                    Assert.thatUnchecked(i == 0);
                    return setQueryContext.right;
                }
            }, queryName, idParser, nonRecursiveBranchConsumer, recursiveBranchConsumer);
        }
    }

    @Nonnull
    private static LogicalOperator handleQueryFragment(@Nonnull ParserRuleContext queryFragment, @Nonnull RelationalParser.QueryContext namedQueryBody, @Nonnull Function<ParserRuleContext, LogicalOperators> memoizer, @Nonnull QueryVisitor queryVisitor) {
        LogicalOperator logicalOperator;
        if (namedQueryBody.ctes() != null) {
            RelationalParser.CtesContext ctes = namedQueryBody.ctes();
            LogicalPlanFragment currentPlanFragment = ((BaseVisitor)queryVisitor.getDelegate()).pushPlanFragment();
            memoizer.apply(ctes).forEach(currentPlanFragment::addOperator);
            logicalOperator = memoizer.apply(queryFragment).first();
            ((BaseVisitor)queryVisitor.getDelegate()).popPlanFragment();
        } else {
            logicalOperator = memoizer.apply(queryFragment).first();
        }
        return logicalOperator;
    }
}

