/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.recordlayer.query.EphemeralExpression;
import com.apple.foundationdb.relational.recordlayer.query.Expression;
import com.apple.foundationdb.relational.recordlayer.query.Expressions;
import com.apple.foundationdb.relational.recordlayer.query.Identifier;
import com.apple.foundationdb.relational.recordlayer.query.Literals;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class Star
extends Expression {
    @Nonnull
    private final List<Expression> expansion;

    private Star(@Nonnull Optional<Identifier> qualifier, @Nonnull DataType dataType, @Nonnull Value expression, @Nonnull Iterable<Expression> expansion) {
        super(qualifier, dataType, expression);
        Assert.thatUnchecked(expression.getResultType().isRecord());
        Assert.thatUnchecked(dataType.getCode() == DataType.Code.STRUCT);
        Assert.thatUnchecked(Iterables.size(expansion) == ((DataType.StructType)dataType).getFields().size());
        this.expansion = ImmutableList.copyOf(expansion);
    }

    @Nonnull
    public List<Expression> getExpansion() {
        return this.expansion;
    }

    @Override
    @Nonnull
    public Expression withQualifier(@Nonnull Collection<String> qualifier) {
        if (this.getName().isEmpty()) {
            return this;
        }
        Identifier name = this.getName().get();
        Identifier newNameMaybe = name.withQualifier(qualifier);
        ImmutableList<Expression> newExpansionMaybe = this.expansion.stream().map(expression -> expression.withQualifier(qualifier)).collect(ImmutableList.toImmutableList());
        if (!newNameMaybe.equals(name) || !Objects.equals(newExpansionMaybe, this.expansion)) {
            return new Star(Optional.of(newNameMaybe), this.getDataType(), this.getUnderlying(), newExpansionMaybe);
        }
        return this;
    }

    @Override
    @Nonnull
    public Expression withName(@Nonnull Identifier name) {
        Assert.failUnchecked("attempt to name a star expression");
        return null;
    }

    @Override
    @Nonnull
    public Expression withUnderlying(@Nonnull Value underlying) {
        Assert.failUnchecked("attempt to replace underlying value of a star expression");
        return null;
    }

    @Override
    @Nonnull
    public Expressions dereferenced(@Nonnull Literals literals) {
        return Expressions.of(this.expansion).dereferenced(literals);
    }

    @Override
    @Nonnull
    public EphemeralExpression asEphemeral() {
        Assert.failUnchecked("attempt to create an ephermeral expression from a star");
        return null;
    }

    @Override
    public String toString() {
        return "* \u224d" + this.expansion.stream().flatMap(exp -> exp.getName().stream()).map(Identifier::toString).collect(Collectors.joining(",")) + "|" + String.valueOf(this.getDataType()) + "| \u21fe " + String.valueOf(this.getUnderlying());
    }

    @Nonnull
    public static Star overQuantifier(@Nonnull Optional<Identifier> qualifier, @Nonnull Value quantifier, @Nonnull String typeName, @Nonnull Expressions expansion) {
        DataType.StructType starType = Star.createStarType(typeName, expansion);
        return new Star(qualifier, starType, quantifier, expansion);
    }

    @Nonnull
    public static Star overQuantifiers(@Nonnull Optional<Identifier> qualifier, @Nonnull List<QuantifiedObjectValue> quantifiers, @Nonnull String typeName, @Nonnull Expressions expansion) {
        RecordConstructorValue underlyingStarType = quantifiers.size() == 1 ? (AbstractValue)quantifiers.get(0) : RecordConstructorValue.ofUnnamed(quantifiers);
        DataType.StructType starType = Star.createStarType(typeName, expansion);
        return new Star(qualifier, starType, underlyingStarType, expansion);
    }

    @Nonnull
    public static Star overIndividualExpressions(@Nonnull Optional<Identifier> qualifier, @Nonnull String typeName, @Nonnull Expressions expansion) {
        DataType.StructType starType = Star.createStarType(typeName, expansion);
        return new Star(qualifier, starType, RecordConstructorValue.ofColumns(expansion.underlyingAsColumns()), expansion);
    }

    @Nonnull
    private static DataType.StructType createStarType(@Nonnull String name, @Nonnull Expressions expansion) {
        ImmutableList.Builder fields = ImmutableList.builder();
        int i = 0;
        for (Expression expression : expansion) {
            fields.add(DataType.StructType.Field.from(expression.getName().map(Identifier::toString).orElseGet(() -> expression.getUnderlying().toString()), expression.getDataType(), i));
            ++i;
        }
        return DataType.StructType.from(name, (List<DataType.StructType.Field>)((Object)fields.build()), true);
    }
}

