/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query.cache;

import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.relational.api.metrics.RelationalMetric;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractCache<K, S, T, V> {
    @Nonnull
    public abstract V reduce(@Nonnull K var1, @Nonnull S var2, @Nonnull T var3, @Nonnull Supplier<NonnullPair<T, V>> var4, @Nonnull Function<V, V> var5, @Nonnull Function<Stream<V>, V> var6, Consumer<RelationalMetric.RelationalCount> var7);

    public abstract CacheStatistics getStats();

    public abstract class CacheStatistics {
        public abstract long numEntries();

        @VisibleForTesting
        public abstract long numEntriesSlow();

        @Nullable
        public abstract Long numSecondaryEntries(@Nonnull K var1);

        @Nullable
        public abstract Long numTertiaryEntries(@Nonnull K var1, @Nonnull S var2);

        @Nullable
        @VisibleForTesting
        public abstract Long numSecondaryEntriesSlow(@Nonnull K var1);

        @Nullable
        @VisibleForTesting
        public abstract Long numTertiaryEntriesSlow(@Nonnull K var1, @Nonnull S var2);

        @Nonnull
        public abstract Set<K> getAllKeys();

        @Nonnull
        public abstract Set<S> getAllSecondaryKeys(@Nonnull K var1);

        @Nonnull
        public abstract Set<T> getAllTertiaryKeys(@Nonnull K var1, @Nonnull S var2);

        @Nonnull
        public abstract Map<K, Set<S>> getAllMappings();

        @Nonnull
        public abstract Map<S, Set<T>> getAllSecondaryMappings(@Nonnull K var1);

        @Nonnull
        public abstract Map<T, V> getAllTertiaryMappings(@Nonnull K var1, @Nonnull S var2);

        public abstract long numHits();

        @Nonnull
        public abstract Long numSecondaryHits(@Nonnull K var1);

        @Nonnull
        public abstract Long numTertiaryHits(@Nonnull K var1, @Nonnull S var2);

        public abstract long numMisses();

        @Nonnull
        public abstract Long numSecondaryMisses(@Nonnull K var1);

        @Nonnull
        public abstract Long numTertiaryMisses(@Nonnull K var1, @Nonnull S var2);

        public abstract long numWrites();

        @Nonnull
        public abstract Long numSecondaryWrites(@Nonnull K var1);

        @Nonnull
        public abstract Long numTertiaryWrites(@Nonnull K var1, @Nonnull S var2);

        public abstract long numReads();

        @Nonnull
        public abstract Long numSecondaryReads(@Nonnull K var1);

        @Nonnull
        public abstract Long numTertiaryReads(@Nonnull K var1, @Nonnull S var2);
    }
}

