/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query.cache;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.metrics.RelationalMetric;
import com.apple.foundationdb.relational.recordlayer.query.cache.AbstractCache;
import com.apple.foundationdb.relational.util.Assert;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class MultiStageCache<K, S, T, V>
extends AbstractCache<K, S, T, V> {
    @Nonnull
    private final Cache<K, Cache<S, Cache<T, V>>> mainCache;
    private final int secondarySize;
    private final int tertiarySize;
    private final long secondaryTtl;
    private final long tertiaryTtl;
    private final TimeUnit secondaryTtlTimeUnit;
    private final TimeUnit tertiaryTtlTimeUnit;
    @Nullable
    private final Executor secondaryExecutor;
    private final Executor tertiaryExecutor;
    @Nullable
    private final Ticker ticker;

    protected MultiStageCache(int size, int secondarySize, int tertiarySize, long ttl, TimeUnit ttlTimeUnit, long secondaryTtl, TimeUnit secondaryTtlTimeUnit, long tertiaryTtl, TimeUnit tertiaryTtlTimeUnit, @Nullable Executor executor, @Nullable Executor secondaryExecutor, @Nullable Executor tertiaryExecutor, @Nullable Ticker ticker) {
        Assert.thatUnchecked(size > 0, ErrorCode.INTERNAL_ERROR, "Invalid cache size '%d'", size);
        Assert.thatUnchecked(secondarySize > 0, ErrorCode.INTERNAL_ERROR, "Invalid secondary cache size '%d'", secondarySize);
        Assert.thatUnchecked(tertiarySize > 0, ErrorCode.INTERNAL_ERROR, "Invalid tertiary cache size '%d'", tertiarySize);
        Assert.thatUnchecked(ttl > 0L, ErrorCode.INTERNAL_ERROR, "Invalid cache ttl '%d'", ttl);
        Assert.thatUnchecked(secondaryTtl > 0L, ErrorCode.INTERNAL_ERROR, "Invalid secondary cache ttl '%d'", secondaryTtl);
        Assert.thatUnchecked(tertiaryTtl > 0L, ErrorCode.INTERNAL_ERROR, "Invalid tertiary cache ttl '%d'", tertiaryTtl);
        Caffeine<Object, Object> mainCacheBuilder = Caffeine.newBuilder().recordStats().maximumSize(size);
        mainCacheBuilder.expireAfterAccess(ttl, ttlTimeUnit);
        if (executor != null) {
            mainCacheBuilder.executor(executor);
        }
        if (ticker != null) {
            mainCacheBuilder.ticker(ticker::read);
        }
        this.mainCache = mainCacheBuilder.build();
        this.secondarySize = secondarySize;
        this.secondaryTtl = secondaryTtl;
        this.secondaryTtlTimeUnit = secondaryTtlTimeUnit;
        this.secondaryExecutor = secondaryExecutor;
        this.tertiarySize = tertiarySize;
        this.tertiaryTtl = tertiaryTtl;
        this.tertiaryTtlTimeUnit = tertiaryTtlTimeUnit;
        this.tertiaryExecutor = tertiaryExecutor;
        this.ticker = ticker;
    }

    @Override
    @Nonnull
    public V reduce(@Nonnull K key, @Nonnull S secondaryKey, @Nonnull T tertiaryKey, @Nonnull Supplier<NonnullPair<T, V>> tertiaryKeyValueSupplier, @Nonnull Function<V, V> valueWithEnvironmentDecorator, @Nonnull Function<Stream<V>, V> reductionFunction, @Nonnull Consumer<RelationalMetric.RelationalCount> registerCacheEvent) {
        Cache secondaryCache = this.mainCache.get(key, newKey -> {
            registerCacheEvent.accept(RelationalMetric.RelationalCount.PLAN_CACHE_PRIMARY_MISS);
            Caffeine<Object, Cache> secondaryCacheBuilder = Caffeine.newBuilder().maximumSize(this.secondarySize).recordStats().removalListener((k, v, i) -> {
                Cache<S, Cache<T, V>> value = this.mainCache.getIfPresent(key);
                if (value != null && value.asMap().isEmpty()) {
                    this.mainCache.invalidate(key);
                }
            });
            if (this.secondaryTtl > 0L) {
                secondaryCacheBuilder.expireAfterWrite(this.secondaryTtl, this.secondaryTtlTimeUnit);
            }
            if (this.secondaryExecutor != null) {
                secondaryCacheBuilder.executor(this.secondaryExecutor);
            }
            if (this.ticker != null) {
                secondaryCacheBuilder.ticker(this.ticker::read);
            }
            return secondaryCacheBuilder.build();
        });
        Cache tertiaryCache = secondaryCache.get(secondaryKey, newKey -> {
            registerCacheEvent.accept(RelationalMetric.RelationalCount.PLAN_CACHE_SECONDARY_MISS);
            Caffeine<Object, Object> tertiaryCacheBuilder = Caffeine.newBuilder().maximumSize(this.tertiarySize).recordStats().removalListener((k, v, i) -> {
                Cache value = (Cache)secondaryCache.getIfPresent(secondaryKey);
                if (value != null && value.asMap().isEmpty()) {
                    secondaryCache.invalidate(secondaryKey);
                }
            });
            if (this.tertiaryTtl > 0L) {
                tertiaryCacheBuilder.expireAfterWrite(this.tertiaryTtl, this.tertiaryTtlTimeUnit);
            }
            if (this.tertiaryExecutor != null) {
                tertiaryCacheBuilder.executor(this.tertiaryExecutor);
            }
            if (this.ticker != null) {
                tertiaryCacheBuilder.ticker(this.ticker::read);
            }
            return tertiaryCacheBuilder.build();
        });
        V result = reductionFunction.apply(tertiaryCache.asMap().entrySet().stream().filter(kvPair -> kvPair.getKey().equals(tertiaryKey)).map(Map.Entry::getValue));
        if (result != null) {
            registerCacheEvent.accept(RelationalMetric.RelationalCount.PLAN_CACHE_TERTIARY_HIT);
            return valueWithEnvironmentDecorator.apply(result);
        }
        registerCacheEvent.accept(RelationalMetric.RelationalCount.PLAN_CACHE_TERTIARY_MISS);
        NonnullPair<T, V> keyValuePair = tertiaryKeyValueSupplier.get();
        tertiaryCache.put(keyValuePair.getKey(), keyValuePair.getValue());
        return (V)keyValuePair.getValue();
    }

    @VisibleForTesting
    public void cleanUp() {
        this.mainCache.asMap().values().forEach(secondaryCache -> secondaryCache.asMap().values().forEach(Cache::cleanUp));
        this.mainCache.asMap().values().forEach(Cache::cleanUp);
        this.mainCache.cleanUp();
    }

    @Override
    public AbstractCache.CacheStatistics getStats() {
        return new AbstractCache.CacheStatistics(){

            @Override
            public long numEntries() {
                return MultiStageCache.this.mainCache.estimatedSize();
            }

            @Override
            public long numEntriesSlow() {
                return MultiStageCache.this.mainCache.asMap().size();
            }

            @Override
            @Nullable
            public Long numSecondaryEntries(@Nonnull K key) {
                Cache secondary = MultiStageCache.this.mainCache.getIfPresent(key);
                if (secondary != null) {
                    return secondary.estimatedSize();
                }
                return null;
            }

            @Override
            @Nullable
            public Long numTertiaryEntries(@Nonnull K key, @Nonnull S secondaryKey) {
                Cache tertiary;
                Cache secondary = MultiStageCache.this.mainCache.getIfPresent(key);
                if (secondary != null && (tertiary = secondary.getIfPresent(secondaryKey)) != null) {
                    return tertiary.estimatedSize();
                }
                return null;
            }

            @Override
            @Nullable
            public Long numSecondaryEntriesSlow(@Nonnull K key) {
                Cache secondary = MultiStageCache.this.mainCache.getIfPresent(key);
                if (secondary != null) {
                    return secondary.asMap().size();
                }
                return null;
            }

            @Override
            @Nullable
            public Long numTertiaryEntriesSlow(@Nonnull K key, @Nonnull S secondaryKey) {
                Cache tertiary;
                Cache secondary = MultiStageCache.this.mainCache.getIfPresent(key);
                if (secondary != null && (tertiary = secondary.getIfPresent(secondaryKey)) != null) {
                    return tertiary.asMap().size();
                }
                return null;
            }

            @Override
            @Nonnull
            public Set<K> getAllKeys() {
                return MultiStageCache.this.mainCache.asMap().keySet();
            }

            @Override
            @Nonnull
            public Set<S> getAllSecondaryKeys(@Nonnull K key) {
                Cache secondary = MultiStageCache.this.mainCache.getIfPresent(key);
                if (secondary != null) {
                    return secondary.asMap().keySet();
                }
                return Set.of();
            }

            @Override
            @Nonnull
            public Set<T> getAllTertiaryKeys(@Nonnull K key, @Nonnull S secondaryKey) {
                Cache tertiary;
                Cache secondary = MultiStageCache.this.mainCache.getIfPresent(key);
                if (secondary != null && (tertiary = secondary.getIfPresent(secondaryKey)) != null) {
                    return tertiary.asMap().keySet();
                }
                return Set.of();
            }

            @Override
            @Nonnull
            public Map<K, Set<S>> getAllMappings() {
                return MultiStageCache.this.mainCache.asMap().entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), ((Cache)e.getValue()).asMap().keySet())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }

            @Override
            @Nonnull
            public Map<S, Set<T>> getAllSecondaryMappings(@Nonnull K key) {
                Cache secondary = MultiStageCache.this.mainCache.getIfPresent(key);
                if (secondary != null) {
                    return secondary.asMap().entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), ((Cache)e.getValue()).asMap().keySet())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                }
                return Map.of();
            }

            @Override
            @Nonnull
            public Map<T, V> getAllTertiaryMappings(@Nonnull K key, @Nonnull S secondaryKey) {
                Cache tertiary;
                Cache secondary = MultiStageCache.this.mainCache.getIfPresent(key);
                if (secondary != null && (tertiary = secondary.getIfPresent(secondaryKey)) != null) {
                    return tertiary.asMap();
                }
                return Map.of();
            }

            @Override
            public long numHits() {
                return MultiStageCache.this.mainCache.stats().hitCount();
            }

            @Override
            @Nonnull
            public Long numSecondaryHits(@Nonnull K key) {
                Cache secondary = MultiStageCache.this.mainCache.getIfPresent(key);
                if (secondary != null) {
                    return secondary.stats().hitCount();
                }
                return 0L;
            }

            @Override
            @Nonnull
            public Long numTertiaryHits(@Nonnull K key, @Nonnull S secondaryKey) {
                Cache tertiary;
                Cache secondary = MultiStageCache.this.mainCache.getIfPresent(key);
                if (secondary != null && (tertiary = secondary.getIfPresent(secondaryKey)) != null) {
                    return tertiary.stats().hitCount();
                }
                return 0L;
            }

            @Override
            public long numMisses() {
                return MultiStageCache.this.mainCache.stats().missCount();
            }

            @Override
            @Nonnull
            public Long numSecondaryMisses(@Nonnull K key) {
                Cache secondary = MultiStageCache.this.mainCache.getIfPresent(key);
                if (secondary != null) {
                    return secondary.stats().missCount();
                }
                return 0L;
            }

            @Override
            @Nonnull
            public Long numTertiaryMisses(@Nonnull K key, @Nonnull S secondaryKey) {
                Cache tertiary;
                Cache secondary = MultiStageCache.this.mainCache.getIfPresent(key);
                if (secondary != null && (tertiary = secondary.getIfPresent(secondaryKey)) != null) {
                    return tertiary.stats().missCount();
                }
                return 0L;
            }

            @Override
            public long numWrites() {
                return MultiStageCache.this.mainCache.stats().loadCount();
            }

            @Override
            @Nonnull
            public Long numSecondaryWrites(@Nonnull K key) {
                Cache secondary = MultiStageCache.this.mainCache.getIfPresent(key);
                if (secondary != null) {
                    return secondary.stats().loadCount();
                }
                return 0L;
            }

            @Override
            @Nonnull
            public Long numTertiaryWrites(@Nonnull K key, @Nonnull S secondaryKey) {
                Cache tertiary;
                Cache secondary = MultiStageCache.this.mainCache.getIfPresent(key);
                if (secondary != null && (tertiary = secondary.getIfPresent(secondaryKey)) != null) {
                    return tertiary.stats().loadCount();
                }
                return 0L;
            }

            @Override
            public long numReads() {
                return MultiStageCache.this.mainCache.stats().requestCount();
            }

            @Override
            @Nonnull
            public Long numSecondaryReads(@Nonnull K key) {
                Cache secondary = MultiStageCache.this.mainCache.getIfPresent(key);
                if (secondary != null) {
                    return secondary.stats().requestCount();
                }
                return 0L;
            }

            @Override
            @Nonnull
            public Long numTertiaryReads(@Nonnull K key, @Nonnull S secondaryKey) {
                Cache tertiary;
                Cache secondary = MultiStageCache.this.mainCache.getIfPresent(key);
                if (secondary != null && (tertiary = secondary.getIfPresent(secondaryKey)) != null) {
                    return tertiary.stats().requestCount();
                }
                return 0L;
            }
        };
    }

    @Nonnull
    public static <K, S, T, V> MultiStageCacheBuilder<K, S, T, V> newMultiStageCacheBuilder() {
        return new MultiStageCacheBuilder();
    }

    public static class MultiStageCacheBuilder<K, S, T, V>
    extends Builder<K, S, T, V, MultiStageCacheBuilder<K, S, T, V>> {
        @Override
        @Nonnull
        protected MultiStageCacheBuilder<K, S, T, V> self() {
            return this;
        }
    }

    public static abstract class Builder<K, S, T, V, B extends Builder<K, S, T, V, B>> {
        private static final int DEFAULT_SIZE = 256;
        private static final int DEFAULT_SECONDARY_SIZE = 256;
        private static final int DEFAULT_TERTIARY_SIZE = 8;
        private static final int DEFAULT_TTL_MS = 5000;
        private static final int DEFAULT_SECONDARY_TTL_MS = 5000;
        private static final int DEFAULT_TERTIARY_TTL_MS = 2000;
        @Nonnull
        private static final TimeUnit DEFAULT_TTL_TIME_UNIT = TimeUnit.MILLISECONDS;
        @Nonnull
        private static final TimeUnit DEFAULT_SECONDARY_TTL_TIME_UNIT = TimeUnit.MILLISECONDS;
        @Nonnull
        private static final TimeUnit DEFAULT_TERTIARY_TTL_TIME_UNIT = TimeUnit.MILLISECONDS;
        protected int size = 256;
        protected int secondarySize = 256;
        protected int tertiarySize = 8;
        protected long ttl = 5000L;
        protected long secondaryTtl = 5000L;
        protected long tertiaryTtl = 2000L;
        @Nonnull
        protected TimeUnit ttlTimeUnit = DEFAULT_TTL_TIME_UNIT;
        @Nonnull
        protected TimeUnit secondaryTtlTimeUnit = DEFAULT_SECONDARY_TTL_TIME_UNIT;
        @Nonnull
        protected TimeUnit tertiaryTtlTimeUnit = DEFAULT_TERTIARY_TTL_TIME_UNIT;
        @Nullable
        protected Executor executor = null;
        @Nullable
        protected Executor secondaryExecutor = null;
        @Nullable
        protected Executor tertiaryExecutor = null;
        @Nullable
        protected Ticker ticker = null;

        @Nonnull
        protected abstract B self();

        @Nonnull
        public B setSize(int size) {
            Assert.thatUnchecked(size > 0, ErrorCode.INTERNAL_ERROR, "Invalid cache size '%d'", size);
            this.size = size;
            return this.self();
        }

        @Nonnull
        public B setSecondarySize(int secondarySize) {
            Assert.thatUnchecked(secondarySize > 0, ErrorCode.INTERNAL_ERROR, "Invalid secondary cache size '%d'", secondarySize);
            this.secondarySize = secondarySize;
            return this.self();
        }

        @Nonnull
        public B setTertiarySize(int tertiarySize) {
            Assert.thatUnchecked(tertiarySize > 0, ErrorCode.INTERNAL_ERROR, "Invalid tertiary cache size '%d'", tertiarySize);
            this.tertiarySize = tertiarySize;
            return this.self();
        }

        @Nonnull
        public B setTtl(long ttlMillis) {
            return this.setTtl(ttlMillis, TimeUnit.MILLISECONDS);
        }

        @Nonnull
        public B setTtl(long ttl, @Nonnull TimeUnit timeUnit) {
            Assert.thatUnchecked(ttl > 0L, ErrorCode.INTERNAL_ERROR, "Invalid cache ttl '%d'", ttl);
            this.ttl = ttl;
            this.ttlTimeUnit = timeUnit;
            return this.self();
        }

        @Nonnull
        public B setSecondaryTtl(long secondaryTtlMillis) {
            return this.setSecondaryTtl(secondaryTtlMillis, TimeUnit.MILLISECONDS);
        }

        @Nonnull
        public B setSecondaryTtl(long secondaryTtl, @Nonnull TimeUnit timeUnit) {
            Assert.thatUnchecked(secondaryTtl > 0L, ErrorCode.INTERNAL_ERROR, "Invalid cache secondaryTtl '%d'", secondaryTtl);
            this.secondaryTtl = secondaryTtl;
            this.secondaryTtlTimeUnit = timeUnit;
            return this.self();
        }

        @Nonnull
        public B setTertiaryTtl(long tertiaryTtlMillis) {
            return this.setTertiaryTtl(tertiaryTtlMillis, TimeUnit.MILLISECONDS);
        }

        @Nonnull
        public B setTertiaryTtl(long tertiaryTtl, @Nonnull TimeUnit timeUnit) {
            Assert.thatUnchecked(tertiaryTtl > 0L, ErrorCode.INTERNAL_ERROR, "Invalid cache tertiaryTtl '%d'", tertiaryTtl);
            this.tertiaryTtl = tertiaryTtl;
            this.tertiaryTtlTimeUnit = timeUnit;
            return this.self();
        }

        @Nonnull
        public B setTicker(@Nonnull Ticker ticker) {
            this.ticker = ticker;
            return this.self();
        }

        @Nonnull
        public B setExecutor(@Nonnull Executor executor) {
            this.executor = executor;
            return this.self();
        }

        @Nonnull
        public B setSecondaryExecutor(@Nonnull Executor secondaryExecutor) {
            this.secondaryExecutor = secondaryExecutor;
            return this.self();
        }

        @Nonnull
        public B setTertiaryExecutor(@Nonnull Executor tertiaryExecutor) {
            this.tertiaryExecutor = tertiaryExecutor;
            return this.self();
        }

        @Nonnull
        public MultiStageCache<K, S, T, V> build() {
            return new MultiStageCache(this.size, this.secondarySize, this.tertiarySize, this.ttl, this.ttlTimeUnit, this.secondaryTtl, this.secondaryTtlTimeUnit, this.tertiaryTtl, this.tertiaryTtlTimeUnit, this.executor, this.secondaryExecutor, this.tertiaryExecutor, this.ticker);
        }
    }
}

