/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query.cache;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class PhysicalPlanEquivalence {
    @Nonnull
    private final Optional<QueryPlanConstraint> constraint;
    @Nonnull
    private final Optional<EvaluationContext> evaluationContext;

    @VisibleForTesting
    PhysicalPlanEquivalence(@Nonnull Optional<QueryPlanConstraint> constraint, @Nonnull Optional<EvaluationContext> evaluationContext) {
        Assert.thatUnchecked(constraint.isPresent() ^ evaluationContext.isPresent(), ErrorCode.INTERNAL_ERROR, "Either constraint or evaluation context must be set (but not both)");
        this.constraint = constraint;
        this.evaluationContext = evaluationContext;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof PhysicalPlanEquivalence)) {
            return false;
        }
        PhysicalPlanEquivalence other = (PhysicalPlanEquivalence)object;
        if (other.constraint.isEmpty()) {
            if (this.constraint.isPresent()) {
                return this.constraint.get().compileTimeEval(other.evaluationContext.get());
            }
            if (this.evaluationContext.isEmpty() && other.evaluationContext.isEmpty()) {
                return true;
            }
            if (this.evaluationContext.isEmpty() || other.evaluationContext.isEmpty()) {
                return false;
            }
            Object constantBindings1 = this.evaluationContext.get().getBindings().get(Bindings.Internal.CONSTANT.bindingName(Quantifier.constant().getId()));
            Object constantBindings2 = other.evaluationContext.get().getBindings().get(Bindings.Internal.CONSTANT.bindingName(Quantifier.constant().getId()));
            return Objects.equals(constantBindings1, constantBindings2);
        }
        return this.evaluationContext.map(context -> other.constraint.get().compileTimeEval((EvaluationContext)context)).orElseGet(() -> other.constraint.equals(this.constraint));
    }

    public int hashCode() {
        return 0;
    }

    @Nonnull
    public PhysicalPlanEquivalence withConstraint(@Nonnull QueryPlanConstraint constraint) {
        return new PhysicalPlanEquivalence(Optional.of(constraint), Optional.empty());
    }

    @Nonnull
    public static PhysicalPlanEquivalence of(@Nonnull EvaluationContext evaluationContext) {
        return new PhysicalPlanEquivalence(Optional.empty(), Optional.of(evaluationContext));
    }

    @Nonnull
    public static PhysicalPlanEquivalence of(@Nonnull QueryPlanConstraint constraint) {
        return new PhysicalPlanEquivalence(Optional.of(constraint), Optional.empty());
    }

    public String toString() {
        return this.constraint.map(queryPlanConstraint -> "constraint " + String.valueOf(queryPlanConstraint)).orElseGet(() -> "environment " + String.valueOf(this.evaluationContext.get()));
    }
}

