/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query.cache;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.recordlayer.query.PlannerConfiguration;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class QueryCacheKey {
    @Nonnull
    private final String canonicalQueryString;
    @Nonnull
    private final PlannerConfiguration plannerConfiguration;
    @Nonnull
    private final String auxiliaryMetadata;
    private final int hash;
    private final int schemaTemplateVersion;
    private final int userVersion;
    private final int memoizedHashCode;

    private QueryCacheKey(@Nonnull String canonicalQueryString, @Nonnull PlannerConfiguration plannerConfiguration, @Nonnull String auxiliaryMetadata, int hash, int schemaTemplateVersion, int userVersion) {
        this.canonicalQueryString = canonicalQueryString;
        this.hash = hash;
        this.schemaTemplateVersion = schemaTemplateVersion;
        this.userVersion = userVersion;
        this.auxiliaryMetadata = auxiliaryMetadata;
        this.plannerConfiguration = plannerConfiguration;
        this.memoizedHashCode = Objects.hash(hash, schemaTemplateVersion, plannerConfiguration, userVersion, auxiliaryMetadata);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        QueryCacheKey that = (QueryCacheKey)other;
        return this.hash == that.hash && this.schemaTemplateVersion == that.schemaTemplateVersion && this.userVersion == that.userVersion && Objects.equals(this.canonicalQueryString, that.canonicalQueryString) && Objects.equals(this.auxiliaryMetadata, that.auxiliaryMetadata) && Objects.equals(this.plannerConfiguration, that.plannerConfiguration);
    }

    public int hashCode() {
        return this.memoizedHashCode;
    }

    public int getHash() {
        return this.hash;
    }

    @Nonnull
    public String getCanonicalQueryString() {
        return this.canonicalQueryString;
    }

    public int getSchemaTemplateVersion() {
        return this.schemaTemplateVersion;
    }

    @Nonnull
    public PlannerConfiguration getPlannerConfiguration() {
        return this.plannerConfiguration;
    }

    public int getUserVersion() {
        return this.userVersion;
    }

    @Nonnull
    public String getAuxiliaryMetadata() {
        return this.auxiliaryMetadata;
    }

    public String toString() {
        return "(" + this.schemaTemplateVersion + " || " + this.auxiliaryMetadata + ")||" + this.canonicalQueryString + "||" + this.hash;
    }

    @Nonnull
    public static QueryCacheKey of(@Nonnull String query, @Nonnull PlannerConfiguration plannerConfiguration, @Nonnull String auxiliaryMetadata, int queryHash, int schemaTemplateVersion, int userVersion) {
        return new QueryCacheKey(query, plannerConfiguration, auxiliaryMetadata, queryHash, schemaTemplateVersion, userVersion);
    }
}

