/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query.cache;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.recordlayer.query.Plan;
import com.apple.foundationdb.relational.recordlayer.query.cache.MultiStageCache;
import com.apple.foundationdb.relational.recordlayer.query.cache.PhysicalPlanEquivalence;
import com.apple.foundationdb.relational.recordlayer.query.cache.QueryCacheKey;
import com.google.common.base.Ticker;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class RelationalPlanCache
extends MultiStageCache<String, QueryCacheKey, PhysicalPlanEquivalence, Plan<?>> {
    @Nonnull
    private static final TimeUnit DEFAULT_TTL_TIME_UNIT = TimeUnit.MILLISECONDS;
    @Nonnull
    private static final TimeUnit DEFAULT_SECONDARY_TTL_TIME_UNIT = TimeUnit.MILLISECONDS;
    @Nonnull
    private static final TimeUnit DEFAULT_TERTIARY_TTL_TIME_UNIT = TimeUnit.MILLISECONDS;

    private RelationalPlanCache(int size, int secondarySize, int tertiarySize, long ttl, @Nonnull TimeUnit ttlTimeUnit, long secondaryTtl, @Nonnull TimeUnit secondaryTtlTimeUnit, long tertiaryTtl, @Nonnull TimeUnit tertiaryTtlTimeUnit, @Nullable Executor executor, @Nullable Executor secondaryExecutor, @Nullable Executor tertiaryExecutor, @Nullable Ticker ticker) {
        super(size, secondarySize, tertiarySize, ttl, ttlTimeUnit, secondaryTtl, secondaryTtlTimeUnit, tertiaryTtl, tertiaryTtlTimeUnit, executor, secondaryExecutor, tertiaryExecutor, ticker);
    }

    @Nonnull
    public static RelationalCacheBuilder newRelationalCacheBuilder() {
        return new RelationalCacheBuilder();
    }

    @Nonnull
    public static RelationalPlanCache buildWithDefaults() {
        return RelationalPlanCache.newRelationalCacheBuilder().build();
    }

    public static final class RelationalCacheBuilder
    extends MultiStageCache.Builder<String, QueryCacheKey, PhysicalPlanEquivalence, Plan<?>, RelationalCacheBuilder> {
        public RelationalCacheBuilder() {
            this.size = (Integer)Options.defaultOptions().get((Object)Options.Name.PLAN_CACHE_PRIMARY_MAX_ENTRIES);
            this.secondarySize = (Integer)Options.defaultOptions().get((Object)Options.Name.PLAN_CACHE_SECONDARY_MAX_ENTRIES);
            this.tertiarySize = (Integer)Options.defaultOptions().get((Object)Options.Name.PLAN_CACHE_TERTIARY_MAX_ENTRIES);
            this.ttl = (Long)Options.defaultOptions().get((Object)Options.Name.PLAN_CACHE_PRIMARY_TIME_TO_LIVE_MILLIS);
            this.ttlTimeUnit = DEFAULT_TTL_TIME_UNIT;
            this.secondaryTtl = (Long)Options.defaultOptions().get((Object)Options.Name.PLAN_CACHE_SECONDARY_TIME_TO_LIVE_MILLIS);
            this.secondaryTtlTimeUnit = DEFAULT_SECONDARY_TTL_TIME_UNIT;
            this.tertiaryTtl = (Long)Options.defaultOptions().get((Object)Options.Name.PLAN_CACHE_TERTIARY_TIME_TO_LIVE_MILLIS);
            this.tertiaryTtlTimeUnit = DEFAULT_TERTIARY_TTL_TIME_UNIT;
            this.executor = null;
            this.secondaryExecutor = null;
            this.tertiaryExecutor = null;
            this.ticker = null;
        }

        @Nonnull
        public RelationalPlanCache build() {
            return new RelationalPlanCache(this.size, this.secondarySize, this.tertiarySize, this.ttl, this.ttlTimeUnit, this.secondaryTtl, this.secondaryTtlTimeUnit, this.tertiaryTtl, this.tertiaryTtlTimeUnit, this.executor, this.secondaryExecutor, this.tertiaryExecutor, this.ticker);
        }

        @Override
        @Nonnull
        protected RelationalCacheBuilder self() {
            return this;
        }
    }
}

