/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query.functions;

import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.UserDefinedFunction;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TableFunctionExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RangeValue;
import com.apple.foundationdb.record.query.plan.cascades.values.StreamingValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ThrowsValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.recordlayer.query.Expression;
import com.apple.foundationdb.relational.recordlayer.query.Expressions;
import com.apple.foundationdb.relational.recordlayer.query.Literals;
import com.apple.foundationdb.relational.recordlayer.query.functions.WithPlanGenerationSideEffects;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

public class CompiledSqlFunction
extends UserDefinedFunction
implements WithPlanGenerationSideEffects {
    @Nonnull
    private final RelationalExpression body;
    @Nonnull
    private final Optional<CorrelationIdentifier> parametersCorrelation;
    @Nonnull
    private final Literals literals;

    protected CompiledSqlFunction(@Nonnull String functionName, @Nonnull List<String> parameterNames, @Nonnull List<Type> parameterTypes, @Nonnull List<Optional<? extends Typed>> parameterDefaults, @Nonnull Optional<CorrelationIdentifier> parametersCorrelation, @Nonnull RelationalExpression body, @Nonnull Literals literals) {
        super(functionName, parameterNames, parameterTypes, parameterDefaults);
        this.parametersCorrelation = parametersCorrelation;
        this.body = body;
        this.literals = literals;
    }

    @Override
    @Nonnull
    public RecordMetaDataProto.PUserDefinedFunction toProto(@Nonnull PlanSerializationContext serializationContext) {
        throw new RecordCoreException("attempt to serialize compiled SQL function", new Object[0]);
    }

    @Override
    @Nonnull
    public RelationalExpression encapsulate(@Nonnull List<? extends Typed> arguments) {
        if (this.parametersCorrelation.isEmpty()) {
            Assert.thatUnchecked(arguments.isEmpty(), ErrorCode.INTERNAL_ERROR, "unexpected parameterless function invocation with non-zero arguments");
            return this.body;
        }
        int parametersCount = this.getParameterNames().size();
        Assert.thatUnchecked(arguments.size() <= parametersCount, ErrorCode.UNDEFINED_FUNCTION, () -> "could not find function matching the provided arguments");
        for (int missingArgIndex = arguments.size(); missingArgIndex < parametersCount; ++missingArgIndex) {
            Assert.thatUnchecked(this.hasDefaultValue(missingArgIndex), ErrorCode.UNDEFINED_FUNCTION, () -> "could not find function matching the provided arguments");
        }
        GraphExpansion.Builder resultBuilder = GraphExpansion.builder();
        for (int paramIdx = 0; paramIdx < parametersCount; ++paramIdx) {
            Value argumentValue;
            if (paramIdx >= arguments.size()) {
                argumentValue = Assert.castUnchecked(Assert.optionalUnchecked(this.getDefaultValue(paramIdx)), Value.class);
            } else {
                Value providedArgValue = Assert.castUnchecked(arguments.get(paramIdx), Value.class);
                boolean isPromotionNeeded = PromoteValue.isPromotionNeeded(providedArgValue.getResultType(), this.computeParameterType(paramIdx));
                Assert.thatUnchecked(!isPromotionNeeded || PromoteValue.isPromotable(providedArgValue.getResultType(), this.computeParameterType(paramIdx)), ErrorCode.UNDEFINED_FUNCTION, () -> "could not find function matching the provided arguments");
                argumentValue = PromoteValue.inject(providedArgValue, this.computeParameterType(paramIdx));
            }
            resultBuilder.addResultColumn(Column.of(Optional.of(this.getParameterName(paramIdx)), argumentValue));
        }
        Quantifier.ForEach qun = Quantifier.forEach(Reference.initialOf((RelationalExpression)resultBuilder.addQuantifier(CompiledSqlFunction.rangeOfOnePlan()).build().buildSelect()), this.parametersCorrelation.get());
        Quantifier.ForEach bodyQun = Quantifier.forEach(Reference.initialOf(this.body));
        GraphExpansion.Builder selectBuilder = GraphExpansion.builder().addQuantifier(bodyQun).addQuantifier(qun);
        bodyQun.computeFlowedColumns().forEach(selectBuilder::addResultColumn);
        return selectBuilder.build().buildSelect();
    }

    @Override
    @Nonnull
    public RelationalExpression encapsulate(@Nonnull Map<String, ? extends Typed> namedArguments) {
        if (this.parametersCorrelation.isEmpty()) {
            Assert.thatUnchecked(namedArguments.isEmpty(), ErrorCode.INTERNAL_ERROR, "unexpected parameterless function invocation with non-zero arguments");
            return this.body;
        }
        Assert.thatUnchecked(this.hasNamedParameters(), ErrorCode.INTERNAL_ERROR, "unexpected invocation of function with named arguments");
        GraphExpansion.Builder resultBuilder = GraphExpansion.builder();
        for (String name : this.getParameterNames()) {
            Value argumentValue = namedArguments.containsKey(name) ? Assert.castUnchecked(namedArguments.get(name), Value.class) : Assert.castUnchecked(Assert.optionalUnchecked(this.getDefaultValue(name), ErrorCode.UNDEFINED_FUNCTION, () -> "could not find function matching the provided arguments"), Value.class);
            boolean isPromotionNeeded = PromoteValue.isPromotionNeeded(argumentValue.getResultType(), this.computeParameterType(name));
            Assert.thatUnchecked(!isPromotionNeeded || PromoteValue.isPromotable(argumentValue.getResultType(), this.computeParameterType(name)), ErrorCode.UNDEFINED_FUNCTION, () -> "could not find function matching the provided arguments");
            Value maybePromotedArgument = PromoteValue.inject(argumentValue, this.computeParameterType(name));
            resultBuilder.addResultColumn(Column.of(Optional.of(name), maybePromotedArgument));
        }
        Quantifier.ForEach qun = Quantifier.forEach(Reference.initialOf((RelationalExpression)resultBuilder.addQuantifier(CompiledSqlFunction.rangeOfOnePlan()).build().buildSelect()), this.parametersCorrelation.get());
        Quantifier.ForEach bodyQun = Quantifier.forEach(Reference.initialOf(this.body));
        GraphExpansion.Builder selectBuilder = GraphExpansion.builder().addQuantifier(bodyQun).addQuantifier(qun);
        bodyQun.computeFlowedColumns().forEach(selectBuilder::addResultColumn);
        return selectBuilder.build().buildSelect();
    }

    @Override
    @Nonnull
    public Literals getAuxiliaryLiterals() {
        return this.literals;
    }

    @Nonnull
    private static Quantifier rangeOfOnePlan() {
        RangeValue.RangeFn rangeFunction = new RangeValue.RangeFn();
        StreamingValue rangeValue = Assert.castUnchecked(rangeFunction.encapsulate(ImmutableList.of(LiteralValue.ofScalar(1L))), StreamingValue.class);
        TableFunctionExpression tableFunctionExpression = new TableFunctionExpression(rangeValue);
        return Quantifier.forEach(Reference.initialOf((RelationalExpression)tableFunctionExpression));
    }

    @Nonnull
    public static StepBuilder newBuilder() {
        return new StepBuilder();
    }

    public static final class StepBuilder {
        private final ImmutableList.Builder<Expression> parametersBuilder = ImmutableList.builder();
        private String name;

        private StepBuilder() {
        }

        @Nonnull
        public StepBuilder setReturnType(@Nonnull Type returnType) {
            throw new UnsupportedOperationException("unsupported explicit return type");
        }

        @Nonnull
        public StepBuilder addParameter(@Nonnull Expression expression) {
            this.parametersBuilder.add((Object)expression);
            return this;
        }

        @Nonnull
        public StepBuilder addAllParameters(@Nonnull Expressions expressions) {
            this.parametersBuilder.addAll((Iterable)expressions);
            return this;
        }

        @Nonnull
        public StepBuilder setName(@Nonnull String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public FinalBuilder seal() {
            Assert.notNullUnchecked(this.name);
            Expressions parameters = Expressions.of(this.parametersBuilder.build());
            Assert.thatUnchecked(parameters.allNamedArguments(), ErrorCode.UNSUPPORTED_OPERATION, "unnamed arguments is not supported");
            return new FinalBuilder(this, parameters);
        }

        public static final class FinalBuilder {
            @Nonnull
            private final StepBuilder outerBuilder;
            private RelationalExpression body;
            private Quantifier.ForEach qun;
            private final Expressions parameters;
            private Literals literals;

            private FinalBuilder(@Nonnull StepBuilder outerBuilder, @Nonnull Expressions parameters) {
                this.outerBuilder = outerBuilder;
                this.parameters = parameters;
                this.literals = Literals.empty();
            }

            @Nonnull
            public Optional<Quantifier> getParametersCorrelation() {
                if (this.parameters.isEmpty()) {
                    return Optional.empty();
                }
                if (this.qun == null) {
                    SelectExpression select = GraphExpansion.builder().addAllResultColumns(this.parameters.underlyingAsColumns()).build().buildSelect();
                    this.qun = Quantifier.forEach(Reference.initialOf((RelationalExpression)select));
                }
                return Optional.of(this.qun);
            }

            @Nonnull
            public FinalBuilder setBody(@Nonnull RelationalExpression body) {
                this.body = body;
                return this;
            }

            @Nonnull
            public FinalBuilder setLiterals(@Nonnull Literals literals) {
                this.literals = literals;
                return this;
            }

            @Nonnull
            public CompiledSqlFunction build() {
                List defaultsValuesList = Streams.stream(this.parameters.underlying()).map(v -> v instanceof ThrowsValue ? Optional.empty() : Optional.of(v)).collect(ImmutableList.toImmutableList());
                return new CompiledSqlFunction(this.outerBuilder.name, this.parameters.argumentNames(), this.parameters.underlyingTypes(), defaultsValuesList, this.getParametersCorrelation().map(Quantifier::getAlias), this.body, this.literals);
            }
        }
    }
}

