/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query.functions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.CatalogedFunction;
import com.apple.foundationdb.record.query.plan.cascades.UserDefinedFunction;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.BuiltInFunctionCatalog;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.query.Expressions;
import com.apple.foundationdb.relational.recordlayer.query.functions.SqlFunctionCatalog;
import com.apple.foundationdb.relational.recordlayer.query.functions.UserDefinedFunctionCatalog;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
final class SqlFunctionCatalogImpl
implements SqlFunctionCatalog {
    @Nonnull
    private static final ImmutableMap<String, Function<Integer, Optional<BuiltInFunction<? extends Typed>>>> builtInSynonyms = SqlFunctionCatalogImpl.createSynonyms();
    @Nonnull
    private final UserDefinedFunctionCatalog userDefinedFunctionCatalog;

    private SqlFunctionCatalogImpl(boolean isCaseSensitive) {
        this.userDefinedFunctionCatalog = new UserDefinedFunctionCatalog(isCaseSensitive);
    }

    @Override
    @Nonnull
    public CatalogedFunction lookupFunction(@Nonnull String name, @Nonnull Expressions arguments) {
        Optional<? extends CatalogedFunction> builtInFunctionMaybe = this.lookupBuiltInFunction(name, arguments);
        Optional<? extends CatalogedFunction> userDefinedFunctionMaybe = this.lookupUserDefinedFunction(name, arguments);
        if (builtInFunctionMaybe.isPresent() && userDefinedFunctionMaybe.isPresent()) {
            Assert.failUnchecked(ErrorCode.INTERNAL_ERROR, "multiple definition of '" + name + "' found in the catalog");
        }
        if (builtInFunctionMaybe.isEmpty() && userDefinedFunctionMaybe.isEmpty()) {
            Assert.failUnchecked(ErrorCode.UNDEFINED_FUNCTION, "could not find function '" + name + "'");
        }
        if (builtInFunctionMaybe.isPresent()) {
            return builtInFunctionMaybe.get();
        }
        return userDefinedFunctionMaybe.get();
    }

    @Nonnull
    private Optional<? extends CatalogedFunction> lookupBuiltInFunction(@Nonnull String name, @Nonnull Expressions expressions) {
        Function<Integer, Optional<BuiltInFunction<? extends Typed>>> functionValidator = builtInSynonyms.get(name.toLowerCase(Locale.ROOT));
        if (functionValidator == null) {
            return Optional.empty();
        }
        return functionValidator.apply(expressions.size());
    }

    @Nonnull
    private Optional<? extends CatalogedFunction> lookupUserDefinedFunction(@Nonnull String name, @Nonnull Expressions expressions) {
        return this.userDefinedFunctionCatalog.lookup(name, expressions);
    }

    @Override
    public boolean containsFunction(@Nonnull String name) {
        return builtInSynonyms.containsKey(name.toLowerCase(Locale.ROOT)) || this.userDefinedFunctionCatalog.containsFunction(name);
    }

    @Override
    public boolean isJavaCallFunction(@Nonnull String name) {
        return "java_call".equals(name.trim().toLowerCase(Locale.ROOT));
    }

    public void registerUserDefinedFunction(@Nonnull String functionName, @Nonnull Function<Boolean, ? extends UserDefinedFunction> functionSupplier) {
        this.userDefinedFunctionCatalog.registerFunction(functionName, functionSupplier);
    }

    @Nonnull
    private static ImmutableMap<String, Function<Integer, Optional<BuiltInFunction<? extends Typed>>>> createSynonyms() {
        return ImmutableMap.builder().put("+", argumentsCount -> BuiltInFunctionCatalog.resolve("add", argumentsCount)).put("-", argumentsCount -> BuiltInFunctionCatalog.resolve("sub", argumentsCount)).put("*", argumentsCount -> BuiltInFunctionCatalog.resolve("mul", argumentsCount)).put("/", argumentsCount -> BuiltInFunctionCatalog.resolve("div", argumentsCount)).put("%", argumentsCount -> BuiltInFunctionCatalog.resolve("mod", argumentsCount)).put(">", argumentsCount -> BuiltInFunctionCatalog.resolve("gt", argumentsCount)).put(">=", argumentsCount -> BuiltInFunctionCatalog.resolve("gte", argumentsCount)).put("<", argumentsCount -> BuiltInFunctionCatalog.resolve("lt", argumentsCount)).put("<=", argumentsCount -> BuiltInFunctionCatalog.resolve("lte", argumentsCount)).put("=", argumentsCount -> BuiltInFunctionCatalog.resolve("equals", argumentsCount)).put("<>", argumentsCount -> BuiltInFunctionCatalog.resolve("notEquals", argumentsCount)).put("!=", argumentsCount -> BuiltInFunctionCatalog.resolve("notEquals", argumentsCount)).put("&", argumentsCount -> BuiltInFunctionCatalog.resolve("bitand", argumentsCount)).put("|", argumentsCount -> BuiltInFunctionCatalog.resolve("bitor", argumentsCount)).put("^", argumentsCount -> BuiltInFunctionCatalog.resolve("bitxor", argumentsCount)).put("[]", argumentsCount -> BuiltInFunctionCatalog.resolve("subscript", argumentsCount)).put("bitmap_bit_position", argumentsCount -> BuiltInFunctionCatalog.resolve("bitmap_bit_position", 1 + argumentsCount)).put("bitmap_bucket_offset", argumentsCount -> BuiltInFunctionCatalog.resolve("bitmap_bucket_offset", 1 + argumentsCount)).put("bitmap_construct_agg", argumentsCount -> BuiltInFunctionCatalog.resolve("BITMAP_CONSTRUCT_AGG", argumentsCount)).put("not", argumentsCount -> BuiltInFunctionCatalog.resolve("not", argumentsCount)).put("and", argumentsCount -> BuiltInFunctionCatalog.resolve("and", argumentsCount)).put("or", argumentsCount -> BuiltInFunctionCatalog.resolve("or", argumentsCount)).put("count", argumentsCount -> BuiltInFunctionCatalog.resolve("COUNT", argumentsCount)).put("max", argumentsCount -> BuiltInFunctionCatalog.resolve("MAX", argumentsCount)).put("min", argumentsCount -> BuiltInFunctionCatalog.resolve("MIN", argumentsCount)).put("avg", argumentsCount -> BuiltInFunctionCatalog.resolve("AVG", argumentsCount)).put("sum", argumentsCount -> BuiltInFunctionCatalog.resolve("SUM", argumentsCount)).put("max_ever", argumentsCount -> BuiltInFunctionCatalog.resolve("MAX_EVER", argumentsCount)).put("min_ever", argumentsCount -> BuiltInFunctionCatalog.resolve("MIN_EVER", argumentsCount)).put("java_call", argumentsCount -> BuiltInFunctionCatalog.resolve("java_call", argumentsCount)).put("greatest", argumentsCount -> BuiltInFunctionCatalog.resolve("greatest", argumentsCount)).put("least", argumentsCount -> BuiltInFunctionCatalog.resolve("least", argumentsCount)).put("like", argumentsCount -> BuiltInFunctionCatalog.resolve("like", argumentsCount)).put("in", argumentsCount -> BuiltInFunctionCatalog.resolve("in", argumentsCount)).put("coalesce", argumentsCount -> BuiltInFunctionCatalog.resolve("coalesce", argumentsCount)).put("is null", argumentsCount -> BuiltInFunctionCatalog.resolve("isNull", argumentsCount)).put("is not null", argumentsCount -> BuiltInFunctionCatalog.resolve("notNull", argumentsCount)).put("isdistinctfrom", argumentsCount -> BuiltInFunctionCatalog.resolve("isDistinctFrom", argumentsCount)).put("isnotdistinctfrom", argumentsCount -> BuiltInFunctionCatalog.resolve("notDistinctFrom", argumentsCount)).put("range", argumentsCount -> BuiltInFunctionCatalog.resolve("range", argumentsCount)).put("__pattern_for_like", argumentsCount -> BuiltInFunctionCatalog.resolve("patternForLike", argumentsCount)).put("__internal_array", argumentsCount -> BuiltInFunctionCatalog.resolve("array", argumentsCount)).put("__pick_value", argumentsCount -> BuiltInFunctionCatalog.resolve("pick", argumentsCount)).build();
    }

    @Nonnull
    public static SqlFunctionCatalogImpl newInstance(@Nonnull RecordLayerSchemaTemplate metadata, boolean isCaseSensitive) {
        SqlFunctionCatalogImpl functionCatalog = new SqlFunctionCatalogImpl(isCaseSensitive);
        metadata.getInvokedRoutines().forEach(func -> functionCatalog.registerUserDefinedFunction(Assert.notNullUnchecked(func.getName()), func.getCompilableSqlFunctionSupplier()));
        return functionCatalog;
    }
}

