/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query.functions;

import com.apple.foundationdb.record.query.plan.cascades.CatalogedFunction;
import com.apple.foundationdb.record.query.plan.cascades.UserDefinedFunction;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.recordlayer.query.Expression;
import com.apple.foundationdb.relational.recordlayer.query.Expressions;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;

final class UserDefinedFunctionCatalog {
    @Nonnull
    private final Map<String, Function<Boolean, ? extends UserDefinedFunction>> functionsMap;
    private final boolean isCaseSensitive;

    UserDefinedFunctionCatalog(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
        this.functionsMap = new LinkedHashMap<String, Function<Boolean, ? extends UserDefinedFunction>>();
    }

    void registerFunction(@Nonnull String functionName, @Nonnull Function<Boolean, ? extends UserDefinedFunction> function) {
        this.functionsMap.put(functionName, function);
    }

    public boolean containsFunction(@Nonnull String name) {
        return this.functionsMap.containsKey(name);
    }

    @Nonnull
    public Optional<? extends CatalogedFunction> lookup(@Nonnull String functionName, Expressions arguments) {
        Function<Boolean, ? extends UserDefinedFunction> functionSupplier = this.functionsMap.get(functionName);
        if (functionSupplier == null) {
            return Optional.empty();
        }
        UserDefinedFunction function = functionSupplier.apply(this.isCaseSensitive);
        int countNamed = 0;
        int countUnnamed = 0;
        ImmutableMap.Builder<String, Value> namedArgumentsBuilder = ImmutableMap.builder();
        ImmutableList.Builder unnamedArgumentsBuilder = ImmutableList.builder();
        for (Expression argument : arguments) {
            if (argument.isNamedArgument()) {
                Assert.thatUnchecked(countUnnamed == 0, ErrorCode.UNSUPPORTED_OPERATION, "mixing named and unnamed arguments is not supported");
                ++countNamed;
                namedArgumentsBuilder.put(argument.getName().get().toString(), argument.getUnderlying());
                continue;
            }
            Assert.thatUnchecked(countNamed == 0, ErrorCode.UNSUPPORTED_OPERATION, "mixing named and unnamed arguments is not supported");
            ++countUnnamed;
            unnamedArgumentsBuilder.add(argument.getUnderlying());
        }
        ImmutableMap namedArguments = namedArgumentsBuilder.build();
        if (!namedArguments.isEmpty()) {
            return function.validateCall(arguments.toNamedArgumentInvocation());
        }
        return Optional.of(function);
    }
}

