/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query.visitors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.predicates.CompatibleTypeEvolutionPredicate;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.relational.api.ddl.DdlQueryFactory;
import com.apple.foundationdb.relational.api.ddl.MetadataOperationsFactory;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.generated.RelationalParser;
import com.apple.foundationdb.relational.generated.RelationalParserBaseVisitor;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerIndex;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerInvokedRoutine;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerTable;
import com.apple.foundationdb.relational.recordlayer.query.Expression;
import com.apple.foundationdb.relational.recordlayer.query.Expressions;
import com.apple.foundationdb.relational.recordlayer.query.Identifier;
import com.apple.foundationdb.relational.recordlayer.query.LogicalOperator;
import com.apple.foundationdb.relational.recordlayer.query.LogicalOperatorCatalog;
import com.apple.foundationdb.relational.recordlayer.query.LogicalOperators;
import com.apple.foundationdb.relational.recordlayer.query.LogicalPlanFragment;
import com.apple.foundationdb.relational.recordlayer.query.MutablePlanGenerationContext;
import com.apple.foundationdb.relational.recordlayer.query.OrderByExpression;
import com.apple.foundationdb.relational.recordlayer.query.Plan;
import com.apple.foundationdb.relational.recordlayer.query.ProceduralPlan;
import com.apple.foundationdb.relational.recordlayer.query.QueryPlan;
import com.apple.foundationdb.relational.recordlayer.query.SemanticAnalyzer;
import com.apple.foundationdb.relational.recordlayer.query.functions.CompiledSqlFunction;
import com.apple.foundationdb.relational.recordlayer.query.functions.SqlFunctionCatalog;
import com.apple.foundationdb.relational.recordlayer.query.visitors.DdlVisitor;
import com.apple.foundationdb.relational.recordlayer.query.visitors.ExpressionVisitor;
import com.apple.foundationdb.relational.recordlayer.query.visitors.IdentifierVisitor;
import com.apple.foundationdb.relational.recordlayer.query.visitors.MetadataPlanVisitor;
import com.apple.foundationdb.relational.recordlayer.query.visitors.QueryVisitor;
import com.apple.foundationdb.relational.recordlayer.query.visitors.TypedVisitor;
import com.apple.foundationdb.relational.util.Assert;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.tree.ParseTree;

@API(value=API.Status.EXPERIMENTAL)
public class BaseVisitor
extends RelationalParserBaseVisitor<Object>
implements TypedVisitor {
    private final boolean caseSensitive;
    @Nonnull
    protected final MutablePlanGenerationContext mutablePlanGenerationContext;
    @Nonnull
    private final DdlQueryFactory ddlQueryFactory;
    @Nonnull
    private final URI dbUri;
    @Nonnull
    protected Optional<LogicalPlanFragment> currentPlanFragment;
    @Nonnull
    private final ExpressionVisitor expressionVisitor;
    @Nonnull
    private final IdentifierVisitor identifierVisitor;
    @Nonnull
    private final QueryVisitor queryVisitor;
    @Nonnull
    private final MetadataPlanVisitor metadataPlanVisitor;
    @Nonnull
    private final DdlVisitor ddlVisitor;
    @Nonnull
    private RecordLayerSchemaTemplate metadata;
    @Nonnull
    private SemanticAnalyzer semanticAnalyzer;
    @Nonnull
    private final LogicalOperatorCatalog logicalOperatorCatalog;

    public BaseVisitor(@Nonnull MutablePlanGenerationContext mutablePlanGenerationContext, @Nonnull RecordLayerSchemaTemplate metadata, @Nonnull DdlQueryFactory ddlQueryFactory, @Nonnull MetadataOperationsFactory metadataOperationsFactory, @Nonnull URI dbUri, boolean caseSensitive) {
        this.mutablePlanGenerationContext = mutablePlanGenerationContext;
        this.metadata = metadata;
        this.ddlQueryFactory = ddlQueryFactory;
        this.dbUri = dbUri;
        this.currentPlanFragment = Optional.empty();
        this.caseSensitive = caseSensitive;
        this.expressionVisitor = ExpressionVisitor.of(this);
        this.identifierVisitor = IdentifierVisitor.of(this);
        this.queryVisitor = QueryVisitor.of(this);
        this.metadataPlanVisitor = MetadataPlanVisitor.of(this);
        this.ddlVisitor = DdlVisitor.of(this, metadataOperationsFactory, dbUri);
        this.semanticAnalyzer = new SemanticAnalyzer(this.getSchemaTemplate(), this.createFunctionCatalog(this.getSchemaTemplate()), mutablePlanGenerationContext);
        this.logicalOperatorCatalog = LogicalOperatorCatalog.newInstance();
    }

    @Nonnull
    public MutablePlanGenerationContext getPlanGenerationContext() {
        return this.mutablePlanGenerationContext;
    }

    @Nonnull
    public Plan<?> generateLogicalPlan(@Nonnull ParseTree parseTree) {
        Object result = this.visit(parseTree);
        return Assert.castUnchecked(result, Plan.class, ErrorCode.INTERNAL_ERROR, () -> "Could not generate a logical plan");
    }

    @Nonnull
    public RecordLayerSchemaTemplate getSchemaTemplate() {
        return this.metadata;
    }

    @Nonnull
    public RecordLayerSchemaTemplate replaceSchemaTemplate(@Nonnull RecordLayerSchemaTemplate newCatalog) {
        RecordLayerSchemaTemplate oldMetadata = this.metadata;
        this.metadata = newCatalog;
        this.semanticAnalyzer = new SemanticAnalyzer(this.metadata, this.createFunctionCatalog(this.metadata), this.mutablePlanGenerationContext);
        return oldMetadata;
    }

    @Nonnull
    public SemanticAnalyzer getSemanticAnalyzer() {
        return this.semanticAnalyzer;
    }

    @Nonnull
    public LogicalOperatorCatalog getLogicalOperatorCatalog() {
        return this.logicalOperatorCatalog;
    }

    @Nonnull
    public SqlFunctionCatalog createFunctionCatalog(@Nonnull RecordLayerSchemaTemplate metadata) {
        return SqlFunctionCatalog.newInstance(metadata, this.isCaseSensitive());
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Nonnull
    LogicalOperators getLogicalOperators() {
        return this.currentPlanFragment.orElseThrow().getLogicalOperators();
    }

    @Nonnull
    LogicalOperators getLogicalOperatorsIncludingOuter() {
        return this.currentPlanFragment.orElseThrow().getLogicalOperatorsIncludingOuter();
    }

    public boolean isTopLevel() {
        return !this.currentPlanFragment.isPresent() || !this.currentPlanFragment.get().hasParent();
    }

    @Nonnull
    public LogicalPlanFragment pushPlanFragment() {
        this.currentPlanFragment = Optional.of(this.currentPlanFragment.map(LogicalPlanFragment::addChild).orElse(LogicalPlanFragment.ofRoot()));
        return this.currentPlanFragment.get();
    }

    public void popPlanFragment() {
        this.currentPlanFragment = this.currentPlanFragment.flatMap(LogicalPlanFragment::getParentMaybe);
    }

    @Nonnull
    LogicalPlanFragment getCurrentPlanFragment() {
        Assert.thatUnchecked(this.currentPlanFragment.isPresent());
        return this.currentPlanFragment.get();
    }

    @Nonnull
    Optional<LogicalPlanFragment> getCurrentPlanFragmentMaybe() {
        return this.currentPlanFragment;
    }

    boolean isForDdl() {
        return this.getPlanGenerationContext().isForDdl();
    }

    @Nonnull
    protected String normalizeString(@Nonnull String value) {
        return Assert.notNullUnchecked(SemanticAnalyzer.normalizeString(value, this.caseSensitive));
    }

    @Nonnull
    public Expression resolveFunction(@Nonnull String functionName, Expression ... arguments) {
        return this.getSemanticAnalyzer().resolveScalarFunction(functionName, Expressions.of(arguments), true);
    }

    @Nonnull
    public Expression resolveFunction(@Nonnull String functionName, boolean flattenSingleItemRecords, Expression ... arguments) {
        return this.getSemanticAnalyzer().resolveScalarFunction(functionName, Expressions.of(arguments), flattenSingleItemRecords);
    }

    @Nonnull
    public LogicalOperator resolveTableValuedFunction(@Nonnull Identifier functionName, @Nonnull Expressions arguments) {
        return this.getSemanticAnalyzer().resolveTableFunction(functionName, arguments, true);
    }

    @Override
    protected Object aggregateResult(Object aggregate, Object nextResult) {
        return nextResult != null ? nextResult : aggregate;
    }

    @Override
    @Nonnull
    public Object visitRoot(@Nonnull RelationalParser.RootContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitStatements(@Nonnull RelationalParser.StatementsContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitStatement(@Nonnull RelationalParser.StatementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public QueryPlan.LogicalQueryPlan visitDmlStatement(@Nonnull RelationalParser.DmlStatementContext ctx) {
        return this.queryVisitor.visitDmlStatement(ctx);
    }

    @Override
    @Nonnull
    public Object visitDdlStatement(RelationalParser.DdlStatementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitTransactionStatement(@Nonnull RelationalParser.TransactionStatementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitPreparedStatement(@Nonnull RelationalParser.PreparedStatementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitAdministrationStatement(@Nonnull RelationalParser.AdministrationStatementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitUtilityStatement(@Nonnull RelationalParser.UtilityStatementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitTemplateClause(@Nonnull RelationalParser.TemplateClauseContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public ProceduralPlan visitCreateSchemaStatement(@Nonnull RelationalParser.CreateSchemaStatementContext ctx) {
        return this.ddlVisitor.visitCreateSchemaStatement(ctx);
    }

    @Override
    @Nonnull
    public ProceduralPlan visitCreateSchemaTemplateStatement(@Nonnull RelationalParser.CreateSchemaTemplateStatementContext ctx) {
        return this.ddlVisitor.visitCreateSchemaTemplateStatement(ctx);
    }

    @Override
    @Nonnull
    public ProceduralPlan visitCreateDatabaseStatement(@Nonnull RelationalParser.CreateDatabaseStatementContext ctx) {
        return this.ddlVisitor.visitCreateDatabaseStatement(ctx);
    }

    @Override
    @Nonnull
    public Object visitOptionsClause(@Nonnull RelationalParser.OptionsClauseContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitOption(@Nonnull RelationalParser.OptionContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public ProceduralPlan visitDropDatabaseStatement(@Nonnull RelationalParser.DropDatabaseStatementContext ctx) {
        return this.ddlVisitor.visitDropDatabaseStatement(ctx);
    }

    @Override
    @Nonnull
    public ProceduralPlan visitDropSchemaTemplateStatement(@Nonnull RelationalParser.DropSchemaTemplateStatementContext ctx) {
        return this.ddlVisitor.visitDropSchemaTemplateStatement(ctx);
    }

    @Override
    @Nonnull
    public ProceduralPlan visitDropSchemaStatement(@Nonnull RelationalParser.DropSchemaStatementContext ctx) {
        return this.ddlVisitor.visitDropSchemaStatement(ctx);
    }

    @Override
    @Nonnull
    public RecordLayerTable visitStructDefinition(@Nonnull RelationalParser.StructDefinitionContext ctx) {
        return this.ddlVisitor.visitStructDefinition(ctx);
    }

    @Override
    @Nonnull
    public RecordLayerTable visitTableDefinition(@Nonnull RelationalParser.TableDefinitionContext ctx) {
        return this.ddlVisitor.visitTableDefinition(ctx);
    }

    @Override
    @Nonnull
    public Object visitColumnDefinition(@Nonnull RelationalParser.ColumnDefinitionContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public DataType visitFunctionColumnType(@Nonnull RelationalParser.FunctionColumnTypeContext ctx) {
        return this.ddlVisitor.visitFunctionColumnType(ctx);
    }

    @Override
    @Nonnull
    public DataType visitColumnType(@Nonnull RelationalParser.ColumnTypeContext ctx) {
        return this.ddlVisitor.visitColumnType(ctx);
    }

    @Override
    @Nonnull
    public DataType visitPrimitiveType(@Nonnull RelationalParser.PrimitiveTypeContext ctx) {
        return this.ddlVisitor.visitPrimitiveType(ctx);
    }

    @Override
    @Nonnull
    public Boolean visitNullColumnConstraint(@Nonnull RelationalParser.NullColumnConstraintContext ctx) {
        return this.ddlVisitor.visitNullColumnConstraint(ctx);
    }

    @Override
    @Nonnull
    public Object visitPrimaryKeyDefinition(@Nonnull RelationalParser.PrimaryKeyDefinitionContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public List<Identifier> visitFullIdList(RelationalParser.FullIdListContext ctx) {
        return this.identifierVisitor.visitFullIdList(ctx);
    }

    @Override
    @Nonnull
    public DataType.Named visitEnumDefinition(@Nonnull RelationalParser.EnumDefinitionContext ctx) {
        return this.ddlVisitor.visitEnumDefinition(ctx);
    }

    @Override
    @Nonnull
    public RecordLayerIndex visitIndexDefinition(@Nonnull RelationalParser.IndexDefinitionContext ctx) {
        return this.ddlVisitor.visitIndexDefinition(ctx);
    }

    @Override
    public Object visitIndexAttributes(RelationalParser.IndexAttributesContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    public Object visitIndexAttribute(RelationalParser.IndexAttributeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    public ProceduralPlan visitCreateTempFunction(RelationalParser.CreateTempFunctionContext ctx) {
        return this.ddlVisitor.visitCreateTempFunction(ctx);
    }

    @Override
    public ProceduralPlan visitDropTempFunction(RelationalParser.DropTempFunctionContext ctx) {
        return this.ddlVisitor.visitDropTempFunction(ctx);
    }

    @Override
    public CompiledSqlFunction visitCreateFunction(RelationalParser.CreateFunctionContext ctx) {
        return this.ddlVisitor.visitCreateFunction(ctx);
    }

    @Override
    public CompiledSqlFunction visitTempSqlInvokedFunction(RelationalParser.TempSqlInvokedFunctionContext ctx) {
        return this.ddlVisitor.visitTempSqlInvokedFunction(ctx);
    }

    @Override
    public CompiledSqlFunction visitSqlInvokedFunction(RelationalParser.SqlInvokedFunctionContext ctx) {
        return this.ddlVisitor.visitSqlInvokedFunction(ctx);
    }

    @Override
    public LogicalOperator visitStatementBody(RelationalParser.StatementBodyContext ctx) {
        return this.ddlVisitor.visitStatementBody(ctx);
    }

    @Override
    public Object visitExpressionBody(RelationalParser.ExpressionBodyContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    public Expressions visitSqlParameterDeclarationList(RelationalParser.SqlParameterDeclarationListContext ctx) {
        return this.ddlVisitor.visitSqlParameterDeclarationList(ctx);
    }

    @Override
    public Expressions visitSqlParameterDeclarations(RelationalParser.SqlParameterDeclarationsContext ctx) {
        return this.ddlVisitor.visitSqlParameterDeclarations(ctx);
    }

    @Override
    public Expression visitSqlParameterDeclaration(RelationalParser.SqlParameterDeclarationContext ctx) {
        return this.ddlVisitor.visitSqlParameterDeclaration(ctx);
    }

    @Override
    public DataType visitReturnsType(RelationalParser.ReturnsTypeContext ctx) {
        return this.ddlVisitor.visitReturnsType(ctx);
    }

    @Override
    public RecordLayerInvokedRoutine visitFunctionSpecification(RelationalParser.FunctionSpecificationContext ctx) {
        return this.ddlVisitor.visitFunctionSpecification(ctx);
    }

    @Override
    public Object visitParameterMode(RelationalParser.ParameterModeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    public Object visitReturnsClause(RelationalParser.ReturnsClauseContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    public Object visitReturnsTableType(RelationalParser.ReturnsTableTypeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    public Object visitTableFunctionColumnList(RelationalParser.TableFunctionColumnListContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    public Object visitTableFunctionColumnListElement(RelationalParser.TableFunctionColumnListElementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    public Object visitRoutineCharacteristics(RelationalParser.RoutineCharacteristicsContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    public Object visitLanguageClause(RelationalParser.LanguageClauseContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    public Object visitLanguageName(RelationalParser.LanguageNameContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    public Object visitParameterStyle(RelationalParser.ParameterStyleContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    public Object visitDeterministicCharacteristic(RelationalParser.DeterministicCharacteristicContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    public Object visitNullCallClause(RelationalParser.NullCallClauseContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    public Object visitDispatchClause(RelationalParser.DispatchClauseContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    public LogicalOperator visitSqlReturnStatement(RelationalParser.SqlReturnStatementContext ctx) {
        return this.ddlVisitor.visitSqlReturnStatement(ctx);
    }

    @Override
    public LogicalOperator visitReturnValue(RelationalParser.ReturnValueContext ctx) {
        return this.ddlVisitor.visitReturnValue(ctx);
    }

    @Override
    @Nonnull
    public Object visitCharSet(@Nonnull RelationalParser.CharSetContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitIntervalType(@Nonnull RelationalParser.IntervalTypeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitSchemaId(@Nonnull RelationalParser.SchemaIdContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitPath(@Nonnull RelationalParser.PathContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitSchemaTemplateId(@Nonnull RelationalParser.SchemaTemplateIdContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public LogicalOperator visitDeleteStatement(@Nonnull RelationalParser.DeleteStatementContext ctx) {
        return this.queryVisitor.visitDeleteStatement(ctx);
    }

    @Override
    @Nonnull
    public LogicalOperator visitInsertStatement(@Nonnull RelationalParser.InsertStatementContext ctx) {
        return this.queryVisitor.visitInsertStatement(ctx);
    }

    @Override
    @Nonnull
    public QueryPlan.LogicalQueryPlan visitSelectStatement(RelationalParser.SelectStatementContext ctx) {
        return this.queryVisitor.visitSelectStatement(ctx);
    }

    @Override
    @Nonnull
    public LogicalOperator visitQuery(@Nonnull RelationalParser.QueryContext ctx) {
        return this.queryVisitor.visitQuery(ctx);
    }

    @Override
    @Nonnull
    public LogicalOperators visitCtes(RelationalParser.CtesContext ctx) {
        return this.queryVisitor.visitCtes(ctx);
    }

    @Override
    @Nonnull
    public LogicalOperator visitNamedQuery(RelationalParser.NamedQueryContext ctx) {
        return this.queryVisitor.visitNamedQuery(ctx);
    }

    @Override
    public LogicalOperator visitTableFunction(@Nonnull RelationalParser.TableFunctionContext ctx) {
        return this.expressionVisitor.visitTableFunction(ctx);
    }

    @Override
    public Expressions visitTableFunctionArgs(RelationalParser.TableFunctionArgsContext ctx) {
        return this.expressionVisitor.visitTableFunctionArgs(ctx);
    }

    @Override
    public Identifier visitTableFunctionName(RelationalParser.TableFunctionNameContext ctx) {
        return this.identifierVisitor.visitTableFunctionName(ctx);
    }

    @Override
    @Nonnull
    public Expression visitContinuation(RelationalParser.ContinuationContext ctx) {
        return this.expressionVisitor.visitContinuation(ctx);
    }

    @Override
    @Nonnull
    public Expression visitContinuationAtom(@Nonnull RelationalParser.ContinuationAtomContext ctx) {
        return this.expressionVisitor.visitContinuationAtom(ctx);
    }

    @Override
    @Nonnull
    public LogicalOperator visitQueryTermDefault(@Nonnull RelationalParser.QueryTermDefaultContext ctx) {
        return Assert.castUnchecked(this.visitChildren(ctx), LogicalOperator.class);
    }

    @Override
    @Nonnull
    public LogicalOperator visitSetQuery(RelationalParser.SetQueryContext ctx) {
        return this.queryVisitor.visitSetQuery(ctx);
    }

    @Override
    @Nonnull
    public LogicalOperator visitInsertStatementValueSelect(@Nonnull RelationalParser.InsertStatementValueSelectContext ctx) {
        return this.queryVisitor.visitInsertStatementValueSelect(ctx);
    }

    @Override
    @Nonnull
    public LogicalOperator visitInsertStatementValueValues(@Nonnull RelationalParser.InsertStatementValueValuesContext ctx) {
        return this.queryVisitor.visitInsertStatementValueValues(ctx);
    }

    @Override
    @Nonnull
    public Expressions visitUpdatedElement(@Nonnull RelationalParser.UpdatedElementContext ctx) {
        return this.expressionVisitor.visitUpdatedElement(ctx);
    }

    @Override
    @Nonnull
    public Object visitAssignmentField(@Nonnull RelationalParser.AssignmentFieldContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public LogicalOperator visitUpdateStatement(@Nonnull RelationalParser.UpdateStatementContext ctx) {
        return this.queryVisitor.visitUpdateStatement(ctx);
    }

    @Override
    @Nonnull
    public List<OrderByExpression> visitOrderByClause(@Nonnull RelationalParser.OrderByClauseContext ctx) {
        return this.expressionVisitor.visitOrderByClause(ctx);
    }

    @Override
    @Nonnull
    public OrderByExpression visitOrderByExpression(@Nonnull RelationalParser.OrderByExpressionContext ctx) {
        return this.expressionVisitor.visitOrderByExpression(ctx);
    }

    @Override
    @Nullable
    public Void visitTableSources(@Nonnull RelationalParser.TableSourcesContext ctx) {
        return this.queryVisitor.visitTableSources(ctx);
    }

    @Override
    @Nonnull
    public LogicalOperator visitTableSourceBase(@Nonnull RelationalParser.TableSourceBaseContext ctx) {
        return this.queryVisitor.visitTableSourceBase(ctx);
    }

    @Override
    @Nonnull
    public LogicalOperator visitAtomTableItem(@Nonnull RelationalParser.AtomTableItemContext ctx) {
        return this.queryVisitor.visitAtomTableItem(ctx);
    }

    @Override
    @Nonnull
    public LogicalOperator visitSubqueryTableItem(@Nonnull RelationalParser.SubqueryTableItemContext ctx) {
        return this.queryVisitor.visitSubqueryTableItem(ctx);
    }

    @Override
    @Nonnull
    public LogicalOperator visitInlineTableItem(@Nonnull RelationalParser.InlineTableItemContext ctx) {
        return this.queryVisitor.visitInlineTableItem(ctx);
    }

    @Override
    public LogicalOperator visitTableValuedFunction(@Nonnull RelationalParser.TableValuedFunctionContext ctx) {
        return this.queryVisitor.visitTableValuedFunction(ctx);
    }

    @Override
    @Nonnull
    public Set<String> visitIndexHint(@Nonnull RelationalParser.IndexHintContext ctx) {
        return this.queryVisitor.visitIndexHint(ctx);
    }

    @Override
    @Nonnull
    public Object visitIndexHintType(@Nonnull RelationalParser.IndexHintTypeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public NonnullPair<String, CompatibleTypeEvolutionPredicate.FieldAccessTrieNode> visitInlineTableDefinition(RelationalParser.InlineTableDefinitionContext ctx) {
        return this.expressionVisitor.visitInlineTableDefinition(ctx);
    }

    @Override
    @Nonnull
    public Object visitInnerJoin(@Nonnull RelationalParser.InnerJoinContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitStraightJoin(@Nonnull RelationalParser.StraightJoinContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitOuterJoin(@Nonnull RelationalParser.OuterJoinContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitNaturalJoin(@Nonnull RelationalParser.NaturalJoinContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public LogicalOperator visitSimpleTable(@Nonnull RelationalParser.SimpleTableContext ctx) {
        return this.queryVisitor.visitSimpleTable(ctx);
    }

    @Override
    @Nonnull
    public LogicalOperator visitParenthesisQuery(RelationalParser.ParenthesisQueryContext ctx) {
        return this.queryVisitor.visitParenthesisQuery(ctx);
    }

    @Override
    @Nonnull
    public Expressions visitSelectElements(@Nonnull RelationalParser.SelectElementsContext ctx) {
        return this.expressionVisitor.visitSelectElements(ctx);
    }

    @Override
    @Nonnull
    public Expression visitSelectStarElement(@Nonnull RelationalParser.SelectStarElementContext ctx) {
        return this.expressionVisitor.visitSelectStarElement(ctx);
    }

    @Override
    @Nonnull
    public Object visitSelectQualifierStarElement(@Nonnull RelationalParser.SelectQualifierStarElementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Expression visitSelectExpressionElement(@Nonnull RelationalParser.SelectExpressionElementContext ctx) {
        return this.expressionVisitor.visitSelectExpressionElement(ctx);
    }

    @Override
    @Nullable
    public Void visitFromClause(@Nonnull RelationalParser.FromClauseContext ctx) {
        return this.queryVisitor.visitFromClause(ctx);
    }

    @Override
    @Nonnull
    public Expressions visitGroupByClause(@Nonnull RelationalParser.GroupByClauseContext ctx) {
        return this.expressionVisitor.visitGroupByClause(ctx);
    }

    @Override
    @Nonnull
    public Expression visitWhereExpr(@Nonnull RelationalParser.WhereExprContext ctx) {
        return this.expressionVisitor.visitWhereExpr(ctx);
    }

    @Override
    @Nonnull
    public Expression visitHavingClause(@Nonnull RelationalParser.HavingClauseContext ctx) {
        return this.expressionVisitor.visitHavingClause(ctx);
    }

    @Override
    @Nonnull
    public Expression visitGroupByItem(@Nonnull RelationalParser.GroupByItemContext ctx) {
        return this.expressionVisitor.visitGroupByItem(ctx);
    }

    @Override
    @Nonnull
    public Expression visitLimitClause(@Nonnull RelationalParser.LimitClauseContext ctx) {
        return this.expressionVisitor.visitLimitClause(ctx);
    }

    @Override
    @Nonnull
    public Expression visitLimitClauseAtom(@Nonnull RelationalParser.LimitClauseAtomContext ctx) {
        return this.expressionVisitor.visitLimitClauseAtom(ctx);
    }

    @Override
    @Nonnull
    public Object visitQueryOptions(@Nonnull RelationalParser.QueryOptionsContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitQueryOption(@Nonnull RelationalParser.QueryOptionContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitStartTransaction(@Nonnull RelationalParser.StartTransactionContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitCommitStatement(@Nonnull RelationalParser.CommitStatementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitRollbackStatement(@Nonnull RelationalParser.RollbackStatementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitSetAutocommitStatement(@Nonnull RelationalParser.SetAutocommitStatementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitSetTransactionStatement(@Nonnull RelationalParser.SetTransactionStatementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitTransactionOption(@Nonnull RelationalParser.TransactionOptionContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitTransactionLevel(@Nonnull RelationalParser.TransactionLevelContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitPrepareStatement(@Nonnull RelationalParser.PrepareStatementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitExecuteStatement(@Nonnull RelationalParser.ExecuteStatementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public QueryPlan.MetadataQueryPlan visitShowDatabasesStatement(@Nonnull RelationalParser.ShowDatabasesStatementContext ctx) {
        return this.metadataPlanVisitor.visitShowDatabasesStatement(ctx);
    }

    @Override
    @Nonnull
    public QueryPlan.MetadataQueryPlan visitShowSchemaTemplatesStatement(@Nonnull RelationalParser.ShowSchemaTemplatesStatementContext ctx) {
        return this.metadataPlanVisitor.visitShowSchemaTemplatesStatement(ctx);
    }

    @Override
    @Nonnull
    public Object visitSetVariable(@Nonnull RelationalParser.SetVariableContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitSetCharset(@Nonnull RelationalParser.SetCharsetContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitSetNames(@Nonnull RelationalParser.SetNamesContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitSetTransaction(@Nonnull RelationalParser.SetTransactionContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitSetAutocommit(@Nonnull RelationalParser.SetAutocommitContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitSetNewValueInsideTrigger(@Nonnull RelationalParser.SetNewValueInsideTriggerContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitVariableClause(@Nonnull RelationalParser.VariableClauseContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitKillStatement(@Nonnull RelationalParser.KillStatementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitResetStatement(@Nonnull RelationalParser.ResetStatementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitTableIndexes(@Nonnull RelationalParser.TableIndexesContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitLoadedTableIndexes(@Nonnull RelationalParser.LoadedTableIndexesContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public QueryPlan.MetadataQueryPlan visitSimpleDescribeSchemaStatement(@Nonnull RelationalParser.SimpleDescribeSchemaStatementContext ctx) {
        return this.metadataPlanVisitor.visitSimpleDescribeSchemaStatement(ctx);
    }

    @Override
    @Nonnull
    public QueryPlan.MetadataQueryPlan visitSimpleDescribeSchemaTemplateStatement(@Nonnull RelationalParser.SimpleDescribeSchemaTemplateStatementContext ctx) {
        return this.metadataPlanVisitor.visitSimpleDescribeSchemaTemplateStatement(ctx);
    }

    @Override
    @Nonnull
    public QueryPlan.LogicalQueryPlan visitFullDescribeStatement(@Nonnull RelationalParser.FullDescribeStatementContext ctx) {
        return this.queryVisitor.visitFullDescribeStatement(ctx);
    }

    @Override
    @Nonnull
    public Object visitHelpStatement(@Nonnull RelationalParser.HelpStatementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitDescribeStatements(@Nonnull RelationalParser.DescribeStatementsContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitDescribeConnection(@Nonnull RelationalParser.DescribeConnectionContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Identifier visitFullId(@Nonnull RelationalParser.FullIdContext ctx) {
        return this.identifierVisitor.visitFullId(ctx);
    }

    @Override
    @Nonnull
    public Identifier visitTableName(@Nonnull RelationalParser.TableNameContext ctx) {
        return this.identifierVisitor.visitTableName(ctx);
    }

    @Override
    @Nonnull
    public Expression visitFullColumnName(@Nonnull RelationalParser.FullColumnNameContext ctx) {
        return this.expressionVisitor.visitFullColumnName(ctx);
    }

    @Override
    @Nonnull
    public Identifier visitIndexColumnName(@Nonnull RelationalParser.IndexColumnNameContext ctx) {
        return this.identifierVisitor.visitIndexColumnName(ctx);
    }

    @Override
    @Nonnull
    public Identifier visitCharsetName(@Nonnull RelationalParser.CharsetNameContext ctx) {
        return this.identifierVisitor.visitCharsetName(ctx);
    }

    @Override
    @Nonnull
    public Identifier visitCollationName(@Nonnull RelationalParser.CollationNameContext ctx) {
        return this.identifierVisitor.visitCollationName(ctx);
    }

    @Override
    @Nonnull
    public Identifier visitUid(@Nonnull RelationalParser.UidContext ctx) {
        return this.identifierVisitor.visitUid(ctx);
    }

    @Override
    @Nonnull
    public Identifier visitSimpleId(@Nonnull RelationalParser.SimpleIdContext ctx) {
        return this.identifierVisitor.visitSimpleId(ctx);
    }

    @Override
    @Nonnull
    public Object visitNullNotnull(@Nonnull RelationalParser.NullNotnullContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Expression visitDecimalLiteral(@Nonnull RelationalParser.DecimalLiteralContext ctx) {
        return this.expressionVisitor.visitDecimalLiteral(ctx);
    }

    @Override
    @Nonnull
    public Expression visitStringLiteral(@Nonnull RelationalParser.StringLiteralContext ctx) {
        return this.expressionVisitor.visitStringLiteral(ctx);
    }

    @Override
    @Nonnull
    public Expression visitBooleanLiteral(@Nonnull RelationalParser.BooleanLiteralContext ctx) {
        return this.expressionVisitor.visitBooleanLiteral(ctx);
    }

    @Override
    @Nonnull
    public Expression visitBytesLiteral(@Nonnull RelationalParser.BytesLiteralContext ctx) {
        return this.expressionVisitor.visitBytesLiteral(ctx);
    }

    @Override
    @Nonnull
    public Expression visitNullLiteral(@Nonnull RelationalParser.NullLiteralContext ctx) {
        return this.expressionVisitor.visitNullLiteral(ctx);
    }

    @Override
    @Nonnull
    public Expression visitStringConstant(@Nonnull RelationalParser.StringConstantContext ctx) {
        return this.expressionVisitor.visitStringConstant(ctx);
    }

    @Override
    @Nonnull
    public Expression visitDecimalConstant(@Nonnull RelationalParser.DecimalConstantContext ctx) {
        return this.expressionVisitor.visitDecimalConstant(ctx);
    }

    @Override
    @Nonnull
    public Expression visitNegativeDecimalConstant(@Nonnull RelationalParser.NegativeDecimalConstantContext ctx) {
        return this.expressionVisitor.visitNegativeDecimalConstant(ctx);
    }

    @Override
    @Nonnull
    public Expression visitBytesConstant(@Nonnull RelationalParser.BytesConstantContext ctx) {
        return this.expressionVisitor.visitBytesConstant(ctx);
    }

    @Override
    @Nonnull
    public Expression visitBooleanConstant(@Nonnull RelationalParser.BooleanConstantContext ctx) {
        return this.expressionVisitor.visitBooleanConstant(ctx);
    }

    @Override
    @Nonnull
    public Expression visitBitStringConstant(@Nonnull RelationalParser.BitStringConstantContext ctx) {
        return this.expressionVisitor.visitBitStringConstant(ctx);
    }

    @Override
    @Nonnull
    public Expression visitNullConstant(@Nonnull RelationalParser.NullConstantContext ctx) {
        return this.expressionVisitor.visitNullConstant(ctx);
    }

    @Override
    @Nonnull
    public Object visitStringDataType(@Nonnull RelationalParser.StringDataTypeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitNationalStringDataType(@Nonnull RelationalParser.NationalStringDataTypeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitNationalVaryingStringDataType(@Nonnull RelationalParser.NationalVaryingStringDataTypeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitDimensionDataType(@Nonnull RelationalParser.DimensionDataTypeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitSimpleDataType(@Nonnull RelationalParser.SimpleDataTypeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitCollectionDataType(@Nonnull RelationalParser.CollectionDataTypeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitSpatialDataType(@Nonnull RelationalParser.SpatialDataTypeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitLongVarcharDataType(@Nonnull RelationalParser.LongVarcharDataTypeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitLongVarbinaryDataType(@Nonnull RelationalParser.LongVarbinaryDataTypeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitCollectionOptions(@Nonnull RelationalParser.CollectionOptionsContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitConvertedDataType(@Nonnull RelationalParser.ConvertedDataTypeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitLengthOneDimension(@Nonnull RelationalParser.LengthOneDimensionContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitLengthTwoDimension(@Nonnull RelationalParser.LengthTwoDimensionContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitLengthTwoOptionalDimension(@Nonnull RelationalParser.LengthTwoOptionalDimensionContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public List<Identifier> visitUidList(@Nonnull RelationalParser.UidListContext ctx) {
        return this.identifierVisitor.visitUidList(ctx);
    }

    @Override
    @Nonnull
    public Object visitUidWithNestings(@Nonnull RelationalParser.UidWithNestingsContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public CompatibleTypeEvolutionPredicate.FieldAccessTrieNode visitUidListWithNestingsInParens(@Nonnull RelationalParser.UidListWithNestingsInParensContext ctx) {
        return this.expressionVisitor.visitUidListWithNestingsInParens(ctx);
    }

    @Override
    @Nonnull
    public CompatibleTypeEvolutionPredicate.FieldAccessTrieNode visitUidListWithNestings(@Nonnull RelationalParser.UidListWithNestingsContext ctx) {
        return this.expressionVisitor.visitUidListWithNestings(ctx);
    }

    @Override
    @Nonnull
    public Object visitTables(@Nonnull RelationalParser.TablesContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitIndexColumnNames(@Nonnull RelationalParser.IndexColumnNamesContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Expressions visitExpressions(@Nonnull RelationalParser.ExpressionsContext ctx) {
        return this.expressionVisitor.visitExpressions(ctx);
    }

    @Override
    @Nonnull
    public Object visitExpressionsWithDefaults(@Nonnull RelationalParser.ExpressionsWithDefaultsContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Expression visitRecordConstructorForInsert(@Nonnull RelationalParser.RecordConstructorForInsertContext ctx) {
        return this.expressionVisitor.visitRecordConstructorForInsert(ctx);
    }

    @Override
    @Nonnull
    public Expression visitRecordConstructorForInlineTable(RelationalParser.RecordConstructorForInlineTableContext ctx) {
        return this.expressionVisitor.visitRecordConstructorForInlineTable(ctx);
    }

    @Override
    @Nonnull
    public Expression visitRecordConstructor(@Nonnull RelationalParser.RecordConstructorContext ctx) {
        return this.expressionVisitor.visitRecordConstructor(ctx);
    }

    @Override
    @Nonnull
    public Object visitOfTypeClause(@Nonnull RelationalParser.OfTypeClauseContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Expression visitArrayConstructor(@Nonnull RelationalParser.ArrayConstructorContext ctx) {
        return this.expressionVisitor.visitArrayConstructor(ctx);
    }

    @Override
    @Nonnull
    public Object visitUserVariables(@Nonnull RelationalParser.UserVariablesContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitDefaultValue(@Nonnull RelationalParser.DefaultValueContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitCurrentTimestamp(@Nonnull RelationalParser.CurrentTimestampContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitExpressionOrDefault(@Nonnull RelationalParser.ExpressionOrDefaultContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Expression visitExpressionWithName(@Nonnull RelationalParser.ExpressionWithNameContext ctx) {
        return this.expressionVisitor.visitExpressionWithName(ctx);
    }

    @Override
    @Nonnull
    public Expression visitExpressionWithOptionalName(@Nonnull RelationalParser.ExpressionWithOptionalNameContext ctx) {
        return this.expressionVisitor.visitExpressionWithOptionalName(ctx);
    }

    @Override
    @Nonnull
    public Object visitIfExists(@Nonnull RelationalParser.IfExistsContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitIfNotExists(@Nonnull RelationalParser.IfNotExistsContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Expression visitAggregateFunctionCall(@Nonnull RelationalParser.AggregateFunctionCallContext ctx) {
        return this.expressionVisitor.visitAggregateFunctionCall(ctx);
    }

    @Override
    @Nonnull
    public Object visitSpecificFunctionCall(@Nonnull RelationalParser.SpecificFunctionCallContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Expression visitScalarFunctionCall(@Nonnull RelationalParser.ScalarFunctionCallContext ctx) {
        return this.expressionVisitor.visitScalarFunctionCall(ctx);
    }

    @Override
    @Nonnull
    public Object visitSimpleFunctionCall(@Nonnull RelationalParser.SimpleFunctionCallContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitDataTypeFunctionCall(@Nonnull RelationalParser.DataTypeFunctionCallContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitValuesFunctionCall(@Nonnull RelationalParser.ValuesFunctionCallContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitCaseExpressionFunctionCall(@Nonnull RelationalParser.CaseExpressionFunctionCallContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Expression visitCaseFunctionCall(@Nonnull RelationalParser.CaseFunctionCallContext ctx) {
        return this.expressionVisitor.visitCaseFunctionCall(ctx);
    }

    @Override
    @Nonnull
    public Object visitCharFunctionCall(@Nonnull RelationalParser.CharFunctionCallContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitPositionFunctionCall(@Nonnull RelationalParser.PositionFunctionCallContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitSubstrFunctionCall(@Nonnull RelationalParser.SubstrFunctionCallContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitTrimFunctionCall(@Nonnull RelationalParser.TrimFunctionCallContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitWeightFunctionCall(@Nonnull RelationalParser.WeightFunctionCallContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitExtractFunctionCall(@Nonnull RelationalParser.ExtractFunctionCallContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitGetFormatFunctionCall(@Nonnull RelationalParser.GetFormatFunctionCallContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitCaseFuncAlternative(@Nonnull RelationalParser.CaseFuncAlternativeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitLevelWeightList(@Nonnull RelationalParser.LevelWeightListContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitLevelWeightRange(@Nonnull RelationalParser.LevelWeightRangeContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitLevelInWeightListElement(@Nonnull RelationalParser.LevelInWeightListElementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Expression visitAggregateWindowedFunction(@Nonnull RelationalParser.AggregateWindowedFunctionContext ctx) {
        return this.expressionVisitor.visitAggregateWindowedFunction(ctx);
    }

    @Override
    @Nonnull
    public Object visitNonAggregateWindowedFunction(@Nonnull RelationalParser.NonAggregateWindowedFunctionContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitOverClause(@Nonnull RelationalParser.OverClauseContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitWindowName(@Nonnull RelationalParser.WindowNameContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitScalarFunctionName(@Nonnull RelationalParser.ScalarFunctionNameContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Expressions visitFunctionArgs(@Nonnull RelationalParser.FunctionArgsContext ctx) {
        return this.expressionVisitor.visitFunctionArgs(ctx);
    }

    @Override
    @Nonnull
    public Object visitFunctionArg(@Nonnull RelationalParser.FunctionArgContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    public Expression visitNamedFunctionArg(RelationalParser.NamedFunctionArgContext ctx) {
        return this.expressionVisitor.visitNamedFunctionArg(ctx);
    }

    @Override
    @Nonnull
    public Expression visitNotExpression(@Nonnull RelationalParser.NotExpressionContext ctx) {
        return this.expressionVisitor.visitNotExpression(ctx);
    }

    @Override
    @Nonnull
    public Expression visitLogicalExpression(@Nonnull RelationalParser.LogicalExpressionContext ctx) {
        return this.expressionVisitor.visitLogicalExpression(ctx);
    }

    @Override
    @Nonnull
    public Expression visitPredicatedExpression(@Nonnull RelationalParser.PredicatedExpressionContext ctx) {
        return this.expressionVisitor.visitPredicatedExpression(ctx);
    }

    @Override
    @Nonnull
    public Expression visitBinaryComparisonPredicate(@Nonnull RelationalParser.BinaryComparisonPredicateContext ctx) {
        return this.expressionVisitor.visitBinaryComparisonPredicate(ctx);
    }

    @Override
    public Expression visitSubscriptExpression(@Nonnull RelationalParser.SubscriptExpressionContext ctx) {
        return this.expressionVisitor.visitSubscriptExpression(ctx);
    }

    @Override
    @Nonnull
    public Expression visitInList(@Nonnull RelationalParser.InListContext ctx) {
        return this.expressionVisitor.visitInList(ctx);
    }

    @Override
    @Nonnull
    public Object visitConstantExpressionAtom(@Nonnull RelationalParser.ConstantExpressionAtomContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Expression visitFunctionCallExpressionAtom(@Nonnull RelationalParser.FunctionCallExpressionAtomContext ctx) {
        return this.expressionVisitor.visitFunctionCallExpressionAtom(ctx);
    }

    @Override
    @Nonnull
    public Object visitFullColumnNameExpressionAtom(@Nonnull RelationalParser.FullColumnNameExpressionAtomContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Expression visitBitExpressionAtom(@Nonnull RelationalParser.BitExpressionAtomContext ctx) {
        return this.expressionVisitor.visitBitExpressionAtom(ctx);
    }

    @Override
    @Nonnull
    public Expression visitPreparedStatementParameterAtom(@Nonnull RelationalParser.PreparedStatementParameterAtomContext ctx) {
        return this.expressionVisitor.visitPreparedStatementParameterAtom(ctx);
    }

    @Override
    @Nonnull
    public Object visitRecordConstructorExpressionAtom(@Nonnull RelationalParser.RecordConstructorExpressionAtomContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitArrayConstructorExpressionAtom(@Nonnull RelationalParser.ArrayConstructorExpressionAtomContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Expression visitMathExpressionAtom(@Nonnull RelationalParser.MathExpressionAtomContext ctx) {
        return this.expressionVisitor.visitMathExpressionAtom(ctx);
    }

    @Override
    @Nonnull
    public Expression visitExistsExpressionAtom(@Nonnull RelationalParser.ExistsExpressionAtomContext ctx) {
        return this.expressionVisitor.visitExistsExpressionAtom(ctx);
    }

    @Override
    @Nonnull
    public Expression visitPreparedStatementParameter(@Nonnull RelationalParser.PreparedStatementParameterContext ctx) {
        return this.expressionVisitor.visitPreparedStatementParameter(ctx);
    }

    @Override
    @Nonnull
    public Object visitUnaryOperator(@Nonnull RelationalParser.UnaryOperatorContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitComparisonOperator(@Nonnull RelationalParser.ComparisonOperatorContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitLogicalOperator(@Nonnull RelationalParser.LogicalOperatorContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitBitOperator(@Nonnull RelationalParser.BitOperatorContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitMathOperator(@Nonnull RelationalParser.MathOperatorContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitJsonOperator(@Nonnull RelationalParser.JsonOperatorContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitCharsetNameBase(@Nonnull RelationalParser.CharsetNameBaseContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitIntervalTypeBase(@Nonnull RelationalParser.IntervalTypeBaseContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitKeywordsCanBeId(@Nonnull RelationalParser.KeywordsCanBeIdContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitFunctionNameBase(@Nonnull RelationalParser.FunctionNameBaseContext ctx) {
        return this.visitChildren(ctx);
    }

    @Override
    @Nonnull
    public Object visitExecuteContinuationStatement(@Nonnull RelationalParser.ExecuteContinuationStatementContext ctx) {
        return this.visitChildren(ctx);
    }

    @Nonnull
    public DdlQueryFactory getDdlQueryFactory() {
        return this.ddlQueryFactory;
    }

    @Nonnull
    public URI getDbUri() {
        return this.dbUri;
    }
}

