/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query.visitors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalSortExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ThrowsValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.ddl.MetadataOperationsFactory;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.api.metadata.InvokedRoutine;
import com.apple.foundationdb.relational.generated.RelationalParser;
import com.apple.foundationdb.relational.recordlayer.metadata.DataTypeUtils;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerColumn;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerIndex;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerInvokedRoutine;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerTable;
import com.apple.foundationdb.relational.recordlayer.query.Expression;
import com.apple.foundationdb.relational.recordlayer.query.Expressions;
import com.apple.foundationdb.relational.recordlayer.query.Identifier;
import com.apple.foundationdb.relational.recordlayer.query.IndexGenerator;
import com.apple.foundationdb.relational.recordlayer.query.LogicalOperator;
import com.apple.foundationdb.relational.recordlayer.query.LogicalPlanFragment;
import com.apple.foundationdb.relational.recordlayer.query.PreparedParams;
import com.apple.foundationdb.relational.recordlayer.query.ProceduralPlan;
import com.apple.foundationdb.relational.recordlayer.query.QueryParser;
import com.apple.foundationdb.relational.recordlayer.query.SemanticAnalyzer;
import com.apple.foundationdb.relational.recordlayer.query.functions.CompiledSqlFunction;
import com.apple.foundationdb.relational.recordlayer.query.visitors.BaseVisitor;
import com.apple.foundationdb.relational.recordlayer.query.visitors.DelegatingVisitor;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;

@API(value=API.Status.EXPERIMENTAL)
public final class DdlVisitor
extends DelegatingVisitor<BaseVisitor> {
    @Nonnull
    private final RecordLayerSchemaTemplate.Builder metadataBuilder = RecordLayerSchemaTemplate.newBuilder();
    private boolean containsNullableArray;
    @Nonnull
    private final MetadataOperationsFactory metadataOperationsFactory;
    @Nonnull
    private final URI dbUri;

    private DdlVisitor(@Nonnull BaseVisitor delegate, @Nonnull MetadataOperationsFactory metadataOperationsFactory, @Nonnull URI dbUri) {
        super(delegate);
        this.metadataOperationsFactory = metadataOperationsFactory;
        this.dbUri = dbUri;
    }

    @Nonnull
    public static DdlVisitor of(@Nonnull BaseVisitor delegate, @Nonnull MetadataOperationsFactory metadataOperationsFactory, @Nonnull URI dbUri) {
        return new DdlVisitor(delegate, metadataOperationsFactory, dbUri);
    }

    @Override
    @Nonnull
    public DataType visitFunctionColumnType(@Nonnull RelationalParser.FunctionColumnTypeContext ctx) {
        SemanticAnalyzer semanticAnalyzer = ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer();
        if (ctx.customType != null) {
            Identifier columnType = this.visitUid(ctx.customType);
            return semanticAnalyzer.lookupType(columnType, true, false, this.metadataBuilder::findType);
        }
        return this.visitPrimitiveType(ctx.primitiveType()).withNullable(true);
    }

    @Override
    @Nonnull
    public DataType visitColumnType(@Nonnull RelationalParser.ColumnTypeContext ctx) {
        SemanticAnalyzer semanticAnalyzer = ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer();
        if (ctx.customType != null) {
            Identifier columnType = this.visitUid(ctx.customType);
            return semanticAnalyzer.lookupType(columnType, false, false, this.metadataBuilder::findType);
        }
        return this.visitPrimitiveType(ctx.primitiveType());
    }

    @Override
    @Nonnull
    public DataType visitPrimitiveType(@Nonnull RelationalParser.PrimitiveTypeContext ctx) {
        SemanticAnalyzer semanticAnalyzer = ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer();
        Identifier primitiveType = Identifier.of(ctx.getText());
        return semanticAnalyzer.lookupType(primitiveType, false, false, ignored -> Optional.empty());
    }

    @Override
    @Nonnull
    public RecordLayerColumn visitColumnDefinition(@Nonnull RelationalParser.ColumnDefinitionContext ctx) {
        Identifier columnId = this.visitUid(ctx.colName);
        boolean isRepeated = ctx.ARRAY() != null;
        boolean isNullable = ctx.columnConstraint() != null ? (Boolean)ctx.columnConstraint().accept(this) : true;
        Assert.thatUnchecked(isRepeated || isNullable, ErrorCode.UNSUPPORTED_OPERATION, "NOT NULL is only allowed for ARRAY column type");
        this.containsNullableArray = this.containsNullableArray || isRepeated && isNullable;
        Identifier columnTypeId = ctx.columnType().customType != null ? this.visitUid(ctx.columnType().customType) : Identifier.of(ctx.columnType().getText());
        SemanticAnalyzer semanticAnalyzer = ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer();
        DataType columnType = semanticAnalyzer.lookupType(columnTypeId, isNullable, isRepeated, this.metadataBuilder::findType);
        return RecordLayerColumn.newBuilder().setName(columnId.getName()).setDataType(columnType).build();
    }

    @Override
    @Nonnull
    public RecordLayerTable visitTableDefinition(@Nonnull RelationalParser.TableDefinitionContext ctx) {
        Identifier tableId = this.visitUid(ctx.uid());
        ImmutableList<RecordLayerColumn> columns = ctx.columnDefinition().stream().map(this::visitColumnDefinition).collect(ImmutableList.toImmutableList());
        RecordLayerTable.Builder tableBuilder = RecordLayerTable.newBuilder(this.metadataBuilder.isIntermingleTables()).setName(tableId.getName()).addColumns(columns);
        if (ctx.primaryKeyDefinition().fullIdList() != null) {
            this.visitFullIdList(ctx.primaryKeyDefinition().fullIdList()).stream().map(Identifier::fullyQualifiedName).forEach(tableBuilder::addPrimaryKeyPart);
        }
        return tableBuilder.build();
    }

    @Override
    @Nonnull
    public RecordLayerTable visitStructDefinition(@Nonnull RelationalParser.StructDefinitionContext ctx) {
        Identifier structId = this.visitUid(ctx.uid());
        ImmutableList<RecordLayerColumn> columns = ctx.columnDefinition().stream().map(this::visitColumnDefinition).collect(ImmutableList.toImmutableList());
        RecordLayerTable.Builder structBuilder = RecordLayerTable.newBuilder(this.metadataBuilder.isIntermingleTables()).setName(structId.getName()).addColumns(columns);
        return structBuilder.build();
    }

    @Override
    @Nonnull
    public RecordLayerIndex visitIndexDefinition(@Nonnull RelationalParser.IndexDefinitionContext ctx) {
        Identifier indexId = this.visitUid(ctx.indexName);
        RecordLayerSchemaTemplate ddlCatalog = this.metadataBuilder.build();
        ((BaseVisitor)this.getDelegate()).replaceSchemaTemplate(ddlCatalog);
        RelationalExpression viewPlan = ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().withDisabledLiteralProcessing(() -> Assert.castUnchecked(ctx.queryTerm().accept(this), LogicalOperator.class).getQuantifier().getRangesOver().get());
        boolean useLegacyBasedExtremumEver = ctx.indexAttributes() != null && ctx.indexAttributes().indexAttribute().stream().anyMatch(attribute -> attribute.LEGACY_EXTREMUM_EVER() != null);
        boolean isUnique = ctx.UNIQUE() != null;
        IndexGenerator generator = IndexGenerator.from(viewPlan, useLegacyBasedExtremumEver);
        RecordLayerTable table = this.metadataBuilder.findTable(generator.getRecordTypeName());
        Assert.thatUnchecked(viewPlan instanceof LogicalSortExpression, ErrorCode.INVALID_COLUMN_REFERENCE, "Cannot create index and order by an expression that is not present in the projection list");
        return generator.generate(indexId.getName(), isUnique, table.getType(), this.containsNullableArray);
    }

    @Override
    @Nonnull
    public DataType.Named visitEnumDefinition(@Nonnull RelationalParser.EnumDefinitionContext ctx) {
        Identifier enumId = this.visitUid(ctx.uid());
        ArrayList<DataType.EnumType.EnumValue> enumValues = new ArrayList<DataType.EnumType.EnumValue>(ctx.STRING_LITERAL().size());
        for (int i = 0; i < ctx.STRING_LITERAL().size(); ++i) {
            enumValues.add(DataType.EnumType.EnumValue.of(Assert.notNullUnchecked(((BaseVisitor)this.getDelegate()).normalizeString(ctx.STRING_LITERAL(i).getText())), i));
        }
        return DataType.EnumType.from(enumId.getName(), enumValues, false);
    }

    @Override
    @Nonnull
    public ProceduralPlan visitCreateSchemaTemplateStatement(@Nonnull RelationalParser.CreateSchemaTemplateStatementContext ctx) {
        Identifier schemaTemplateId = this.visitUid(ctx.schemaTemplateId().uid());
        this.metadataBuilder.setName(schemaTemplateId.getName()).setVersion(1);
        if (ctx.optionsClause() != null) {
            for (RelationalParser.OptionContext option : ctx.optionsClause().option()) {
                if (option.ENABLE_LONG_ROWS() != null) {
                    this.metadataBuilder.setEnableLongRows(option.booleanLiteral().TRUE() != null);
                    continue;
                }
                if (option.INTERMINGLE_TABLES() != null) {
                    this.metadataBuilder.setIntermingleTables(option.booleanLiteral().TRUE() != null);
                    continue;
                }
                if (option.STORE_ROW_VERSIONS() != null) {
                    this.metadataBuilder.setStoreRowVersions(option.booleanLiteral().TRUE() != null);
                    continue;
                }
                Assert.failUnchecked(ErrorCode.SYNTAX_ERROR, "Encountered unknown options in schema template creation");
            }
        }
        ImmutableSet.Builder structClauses = ImmutableSet.builder();
        ImmutableSet.Builder tableClauses = ImmutableSet.builder();
        ImmutableSet.Builder indexClauses = ImmutableSet.builder();
        ImmutableSet.Builder functionClauses = ImmutableSet.builder();
        for (RelationalParser.TemplateClauseContext templateClause : ctx.templateClause()) {
            if (templateClause.enumDefinition() != null) {
                this.metadataBuilder.addAuxiliaryType(this.visitEnumDefinition(templateClause.enumDefinition()));
                continue;
            }
            if (templateClause.structDefinition() != null) {
                structClauses.add(templateClause.structDefinition());
                continue;
            }
            if (templateClause.tableDefinition() != null) {
                tableClauses.add(templateClause.tableDefinition());
                continue;
            }
            if (templateClause.sqlInvokedFunction() != null) {
                functionClauses.add(templateClause.sqlInvokedFunction());
                continue;
            }
            Assert.thatUnchecked(templateClause.indexDefinition() != null);
            indexClauses.add(templateClause.indexDefinition());
        }
        structClauses.build().stream().map(this::visitStructDefinition).map(RecordLayerTable::getDatatype).forEach(this.metadataBuilder::addAuxiliaryType);
        tableClauses.build().stream().map(this::visitTableDefinition).forEach(this.metadataBuilder::addTable);
        ImmutableList indexes = indexClauses.build().stream().map(this::visitIndexDefinition).collect(ImmutableList.toImmutableList());
        functionClauses.build().forEach(functionClause -> {
            RecordLayerInvokedRoutine invokedRoutine = this.getInvokedRoutineMetadata((ParserRuleContext)functionClause, functionClause.functionSpecification(), functionClause.routineBody(), this.metadataBuilder.build());
            this.metadataBuilder.addInvokedRoutine(invokedRoutine);
        });
        for (RecordLayerIndex index : indexes) {
            RecordLayerTable table = this.metadataBuilder.extractTable(index.getTableName());
            RecordLayerTable tableWithIndex = RecordLayerTable.Builder.from(table).addIndex(index).build();
            this.metadataBuilder.addTable(tableWithIndex);
        }
        return ProceduralPlan.of(this.metadataOperationsFactory.getSaveSchemaTemplateConstantAction(this.metadataBuilder.build(), Options.NONE));
    }

    @Override
    @Nonnull
    public ProceduralPlan visitCreateSchemaStatement(@Nonnull RelationalParser.CreateSchemaStatementContext ctx) {
        Identifier schemaId = this.visitUid(ctx.schemaId().path().uid());
        NonnullPair<Optional<URI>, String> dbAndSchema = SemanticAnalyzer.parseSchemaIdentifier(schemaId);
        Identifier templateId = this.visitUid(ctx.schemaTemplateId().uid());
        return ProceduralPlan.of(this.metadataOperationsFactory.getCreateSchemaConstantAction(dbAndSchema.getLeft().orElse(this.dbUri), dbAndSchema.getRight(), templateId.getName(), Options.NONE));
    }

    @Override
    @Nonnull
    public ProceduralPlan visitCreateDatabaseStatement(@Nonnull RelationalParser.CreateDatabaseStatementContext ctx) {
        Identifier databaseId = this.visitUid(ctx.path().uid());
        SemanticAnalyzer.validateDatabaseUri(databaseId);
        return ProceduralPlan.of(this.metadataOperationsFactory.getCreateDatabaseConstantAction(URI.create(databaseId.getName()), Options.NONE));
    }

    @Override
    @Nonnull
    public ProceduralPlan visitDropDatabaseStatement(@Nonnull RelationalParser.DropDatabaseStatementContext ctx) {
        Identifier databaseId = this.visitUid(ctx.path().uid());
        SemanticAnalyzer.validateDatabaseUri(databaseId);
        boolean throwIfDoesNotExist = ctx.ifExists() == null;
        return ProceduralPlan.of(this.metadataOperationsFactory.getDropDatabaseConstantAction(URI.create(databaseId.getName()), throwIfDoesNotExist, Options.NONE));
    }

    @Override
    @Nonnull
    public ProceduralPlan visitDropSchemaStatement(@Nonnull RelationalParser.DropSchemaStatementContext ctx) {
        Identifier schemaId = this.visitUid(ctx.uid());
        NonnullPair<Optional<URI>, String> dbAndSchema = SemanticAnalyzer.parseSchemaIdentifier(schemaId);
        Assert.thatUnchecked(dbAndSchema.getLeft().isPresent(), ErrorCode.UNKNOWN_DATABASE, () -> String.format(Locale.ROOT, "invalid database identifier in '%s'", ctx.uid().getText()));
        return ProceduralPlan.of(this.metadataOperationsFactory.getDropSchemaConstantAction(dbAndSchema.getLeft().get(), dbAndSchema.getRight(), Options.NONE));
    }

    @Override
    @Nonnull
    public ProceduralPlan visitDropSchemaTemplateStatement(@Nonnull RelationalParser.DropSchemaTemplateStatementContext ctx) {
        Identifier schemaTemplateId = this.visitUid(ctx.uid());
        boolean throwIfDoesNotExist = ctx.ifExists() == null;
        return ProceduralPlan.of(this.metadataOperationsFactory.getDropSchemaTemplateConstantAction(schemaTemplateId.getName(), throwIfDoesNotExist, Options.NONE));
    }

    @Nonnull
    private RecordLayerInvokedRoutine getInvokedRoutineMetadata(@Nonnull ParserRuleContext functionCtx, @Nonnull RelationalParser.FunctionSpecificationContext functionSpecCtx, @Nonnull RelationalParser.RoutineBodyContext bodyCtx, @Nonnull RecordLayerSchemaTemplate ddlCatalog) {
        ((BaseVisitor)this.getDelegate()).replaceSchemaTemplate(ddlCatalog);
        boolean isTemporary = functionCtx instanceof RelationalParser.CreateTempFunctionContext;
        String functionName = this.visitFullId(functionSpecCtx.schemaQualifiedRoutineName).toString();
        String queryString = ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().getQuery();
        int start = functionCtx.start.getStartIndex();
        int stop = functionCtx.stop.getStopIndex() + 1;
        String functionDefinition = (isTemporary ? "" : "CREATE ") + queryString.substring(start, stop);
        if (isTemporary) {
            ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().getLiteralsBuilder().setScope(functionName);
        } else {
            QueryParser.validateNoPreparedParams(functionCtx);
        }
        CompiledSqlFunction compiledSqlFunction = this.visitSqlInvokedFunction(functionSpecCtx, bodyCtx, isTemporary);
        return RecordLayerInvokedRoutine.newBuilder().setName(functionName).setDescription(functionDefinition).withCompilableRoutine(ignored -> compiledSqlFunction).setNormalizedDescription(((BaseVisitor)this.getDelegate()).getPlanGenerationContext().getCanonicalQueryString()).setTemporary(isTemporary).build();
    }

    @Override
    public ProceduralPlan visitCreateTempFunction(@Nonnull RelationalParser.CreateTempFunctionContext ctx) {
        RecordLayerInvokedRoutine invokedRoutine = this.getInvokedRoutineMetadata(ctx, ctx.tempSqlInvokedFunction().functionSpecification(), ctx.tempSqlInvokedFunction().routineBody(), ((BaseVisitor)this.getDelegate()).getSchemaTemplate());
        boolean throwIfExists = ctx.REPLACE() == null;
        return ProceduralPlan.of(this.metadataOperationsFactory.getCreateTemporaryFunctionConstantAction(((BaseVisitor)this.getDelegate()).getSchemaTemplate(), throwIfExists, invokedRoutine, PreparedParams.copyOf(((BaseVisitor)this.getDelegate()).getPlanGenerationContext().getPreparedParams())));
    }

    @Override
    public ProceduralPlan visitDropTempFunction(@Nonnull RelationalParser.DropTempFunctionContext ctx) {
        String functionName = this.visitFullId(ctx.schemaQualifiedRoutineName).toString();
        boolean throwIfNotExists = ctx.IF() == null && ctx.EXISTS() == null;
        return ProceduralPlan.of(this.metadataOperationsFactory.getDropTemporaryFunctionConstantAction(throwIfNotExists, functionName));
    }

    @Override
    public CompiledSqlFunction visitCreateFunction(@Nonnull RelationalParser.CreateFunctionContext ctx) {
        return this.visitSqlInvokedFunction(ctx.sqlInvokedFunction());
    }

    @Override
    public CompiledSqlFunction visitTempSqlInvokedFunction(@Nonnull RelationalParser.TempSqlInvokedFunctionContext ctx) {
        return this.visitSqlInvokedFunction(ctx.functionSpecification(), ctx.routineBody(), true);
    }

    @Override
    public CompiledSqlFunction visitSqlInvokedFunction(@Nonnull RelationalParser.SqlInvokedFunctionContext ctx) {
        return this.visitSqlInvokedFunction(ctx.functionSpecification(), ctx.routineBody(), false);
    }

    private CompiledSqlFunction visitSqlInvokedFunction(@Nonnull RelationalParser.FunctionSpecificationContext functionSpecCtx, @Nonnull RelationalParser.RoutineBodyContext bodyCtx, boolean isTemporary) {
        String functionName = this.visitFullId(functionSpecCtx.schemaQualifiedRoutineName).toString();
        RelationalParser.RoutineCharacteristicsContext props = functionSpecCtx.routineCharacteristics();
        InvokedRoutine.Language language = props.languageClause() != null && props.languageClause().languageName().JAVA() != null ? InvokedRoutine.Language.JAVA : InvokedRoutine.Language.SQL;
        boolean isNullReturnOnNull = props.nullCallClause() != null && props.nullCallClause().RETURNS() != null;
        Assert.thatUnchecked(!isNullReturnOnNull, "only CALLED ON NULL INPUT clause is supported");
        boolean isSqlParameterStyle = props.parameterStyle() == null || props.parameterStyle().SQL() != null;
        boolean isScalar = functionSpecCtx.returnsClause() != null && functionSpecCtx.returnsClause().returnsType().returnsTableType() == null;
        Assert.thatUnchecked(!isScalar, "only table functions are supported");
        Assert.thatUnchecked(isSqlParameterStyle, ErrorCode.UNSUPPORTED_OPERATION, "only sql-style parameters are supported");
        Assert.thatUnchecked(language == InvokedRoutine.Language.SQL, ErrorCode.UNSUPPORTED_OPERATION, "only sql-language functions are supported");
        Expressions parameters = ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().withDisabledLiteralProcessing(() -> this.visitSqlParameterDeclarationList(functionSpecCtx.sqlParameterDeclarationList()).asNamedArguments());
        CompiledSqlFunction.StepBuilder.FinalBuilder sqlFunctionBuilder = CompiledSqlFunction.newBuilder().setName(functionName).addAllParameters(parameters).seal();
        Optional<Quantifier> parametersCorrelation = sqlFunctionBuilder.getParametersCorrelation();
        LogicalPlanFragment fragment = ((BaseVisitor)this.getDelegate()).pushPlanFragment();
        parametersCorrelation.ifPresent(quantifier -> fragment.addOperator(LogicalOperator.newUnnamedOperator(Expressions.fromQuantifier(quantifier), quantifier)));
        LogicalOperator body = isTemporary ? Assert.castUnchecked(this.visit(bodyCtx), LogicalOperator.class) : ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().withDisabledLiteralProcessing(() -> Assert.castUnchecked(this.visit(bodyCtx), LogicalOperator.class));
        ((BaseVisitor)this.getDelegate()).popPlanFragment();
        sqlFunctionBuilder.setBody(body.getQuantifier().getRangesOver().get()).setLiterals(((BaseVisitor)this.getDelegate()).getPlanGenerationContext().getLiterals());
        return sqlFunctionBuilder.build();
    }

    @Override
    public LogicalOperator visitStatementBody(RelationalParser.StatementBodyContext ctx) {
        return Assert.castUnchecked(this.visit(ctx.queryTerm()), LogicalOperator.class);
    }

    @Override
    public LogicalOperator visitSqlReturnStatement(RelationalParser.SqlReturnStatementContext ctx) {
        return this.visitReturnValue(ctx.returnValue());
    }

    @Override
    public LogicalOperator visitReturnValue(RelationalParser.ReturnValueContext ctx) {
        Assert.failUnchecked("scalar functions are not implemented");
        return null;
    }

    @Override
    public Expressions visitSqlParameterDeclarationList(@Nonnull RelationalParser.SqlParameterDeclarationListContext ctx) {
        if (ctx.sqlParameterDeclarations() == null) {
            return Expressions.empty();
        }
        return this.visitSqlParameterDeclarations(ctx.sqlParameterDeclarations());
    }

    @Override
    public Expressions visitSqlParameterDeclarations(RelationalParser.SqlParameterDeclarationsContext ctx) {
        Expressions parameters = Expressions.of(ctx.sqlParameterDeclaration().stream().map(this::visitSqlParameterDeclaration).collect(ImmutableList.toImmutableList()));
        ImmutableList duplicateParameters = parameters.asList().stream().flatMap(p -> p.getName().stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(p -> (Long)p.getValue() > 1L).collect(ImmutableList.toImmutableList());
        Assert.thatUnchecked(duplicateParameters.isEmpty(), ErrorCode.INVALID_FUNCTION_DEFINITION, () -> "unexpected duplicate parameter(s) " + duplicateParameters.stream().map(Object::toString).collect(Collectors.joining(",")));
        return Expressions.of(ctx.sqlParameterDeclaration().stream().map(this::visitSqlParameterDeclaration).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public Expression visitSqlParameterDeclaration(@Nonnull RelationalParser.SqlParameterDeclarationContext ctx) {
        Assert.thatUnchecked(ctx.sqlParameterName != null, "unnamed parameters not supported");
        Identifier parameterName = this.visitUid(ctx.sqlParameterName);
        DataType parameterType = this.visitFunctionColumnType(ctx.parameterType);
        Type underlyingType = DataTypeUtils.toRecordLayerType(parameterType);
        Assert.thatUnchecked(parameterType.isResolved());
        Assert.thatUnchecked(ctx.parameterMode() == null || ctx.parameterMode().IN() != null, "only IN parameters are supported");
        if (ctx.DEFAULT() != null) {
            Expression defaultExpression = Assert.castUnchecked(this.visit(ctx.parameterDefault), Expression.class);
            Value defaultValue = PromoteValue.inject(defaultExpression.getUnderlying(), underlyingType);
            return Expression.of(defaultValue, parameterName);
        }
        return Expression.of(new ThrowsValue(underlyingType), parameterName);
    }

    @Override
    public DataType visitReturnsType(@Nonnull RelationalParser.ReturnsTypeContext ctx) {
        if (ctx.returnsDataType != null) {
            return this.visitColumnType(ctx.returnsDataType);
        }
        throw new UnsupportedOperationException("table type is not supported");
    }

    @Override
    @Nonnull
    public Boolean visitNullColumnConstraint(@Nonnull RelationalParser.NullColumnConstraintContext ctx) {
        return ctx.nullNotnull().NOT() == null;
    }
}

