/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query.visitors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.predicates.CompatibleTypeEvolutionPredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractArrayConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ConditionSelectorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ExistsValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.NullValue;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.util.TrieNode;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.generated.RelationalParser;
import com.apple.foundationdb.relational.recordlayer.metadata.DataTypeUtils;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerColumn;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerTable;
import com.apple.foundationdb.relational.recordlayer.query.Expression;
import com.apple.foundationdb.relational.recordlayer.query.Expressions;
import com.apple.foundationdb.relational.recordlayer.query.Identifier;
import com.apple.foundationdb.relational.recordlayer.query.LogicalOperator;
import com.apple.foundationdb.relational.recordlayer.query.LogicalPlanFragment;
import com.apple.foundationdb.relational.recordlayer.query.OrderByExpression;
import com.apple.foundationdb.relational.recordlayer.query.ParseHelpers;
import com.apple.foundationdb.relational.recordlayer.query.SemanticAnalyzer;
import com.apple.foundationdb.relational.recordlayer.query.Star;
import com.apple.foundationdb.relational.recordlayer.query.StringTrieNode;
import com.apple.foundationdb.relational.recordlayer.query.TautologicalValue;
import com.apple.foundationdb.relational.recordlayer.query.visitors.BaseVisitor;
import com.apple.foundationdb.relational.recordlayer.query.visitors.DelegatingVisitor;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.protobuf.ZeroCopyByteString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;

@API(value=API.Status.EXPERIMENTAL)
public final class ExpressionVisitor
extends DelegatingVisitor<BaseVisitor> {
    private ExpressionVisitor(@Nonnull BaseVisitor baseVisitor) {
        super(baseVisitor);
    }

    @Nonnull
    public static ExpressionVisitor of(@Nonnull BaseVisitor baseVisitor) {
        return new ExpressionVisitor(baseVisitor);
    }

    @Override
    public LogicalOperator visitTableFunction(@Nonnull RelationalParser.TableFunctionContext ctx) {
        Identifier functionName = this.visitTableFunctionName(ctx.tableFunctionName());
        return ctx.tableFunctionArgs() == null ? ((BaseVisitor)this.getDelegate()).resolveTableValuedFunction(functionName, Expressions.empty()) : ((BaseVisitor)this.getDelegate()).resolveTableValuedFunction(functionName, this.visitTableFunctionArgs(ctx.tableFunctionArgs()));
    }

    @Override
    public Expressions visitTableFunctionArgs(@Nonnull RelationalParser.TableFunctionArgsContext ctx) {
        if (!ctx.namedFunctionArg().isEmpty()) {
            Expressions namedArguments = Expressions.of(ctx.namedFunctionArg().stream().map(this::visitNamedFunctionArg).collect(ImmutableList.toImmutableList()));
            ImmutableList duplicateArguments = namedArguments.asList().stream().flatMap(p -> p.getName().stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(p -> (Long)p.getValue() > 1L).collect(ImmutableList.toImmutableList());
            Assert.thatUnchecked(duplicateArguments.isEmpty(), ErrorCode.SYNTAX_ERROR, () -> "argument name(s) used more than once" + duplicateArguments.stream().map(Object::toString).collect(Collectors.joining(",")));
            return namedArguments;
        }
        return Expressions.of(ctx.functionArg().stream().map(this::visitFunctionArg).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public Expression visitNamedFunctionArg(@Nonnull RelationalParser.NamedFunctionArgContext ctx) {
        Identifier name = this.visitUid(ctx.key);
        Expression expression = Assert.castUnchecked(this.visit(ctx.value), Expression.class);
        return expression.toNamedArgument(name);
    }

    @Override
    @Nonnull
    public Expression visitContinuation(@Nonnull RelationalParser.ContinuationContext ctx) {
        return this.visitContinuationAtom(ctx.continuationAtom());
    }

    @Override
    @Nonnull
    public Expression visitContinuationAtom(@Nonnull RelationalParser.ContinuationAtomContext ctx) {
        return ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().withDisabledLiteralProcessing(() -> {
            Expression continuationExpression = this.parseChild(ctx);
            SemanticAnalyzer.validateContinuation(continuationExpression);
            return continuationExpression;
        });
    }

    @Override
    @Nonnull
    public Expression visitSelectStarElement(@Nonnull RelationalParser.SelectStarElementContext ignored) {
        return ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer().expandStar(Optional.empty(), ((BaseVisitor)this.getDelegate()).getLogicalOperators());
    }

    @Override
    @Nonnull
    public Expression visitSelectQualifierStarElement(@Nonnull RelationalParser.SelectQualifierStarElementContext ctx) {
        Identifier identifier = this.visitUid(ctx.uid());
        return ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer().expandStar(Optional.of(identifier), ((BaseVisitor)this.getDelegate()).getLogicalOperatorsIncludingOuter());
    }

    @Override
    @Nonnull
    public Expression visitFullColumnNameExpressionAtom(@Nonnull RelationalParser.FullColumnNameExpressionAtomContext fullColumnNameExpressionAtomContext) {
        return Assert.castUnchecked(fullColumnNameExpressionAtomContext.fullColumnName().accept(this), Expression.class);
    }

    @Override
    @Nonnull
    public Expressions visitSelectElements(@Nonnull RelationalParser.SelectElementsContext selectElementsContext) {
        return Expressions.of(selectElementsContext.selectElement().stream().map(selectElement -> Assert.castUnchecked(selectElement.accept(this), Expression.class)).collect(ImmutableList.toImmutableList()));
    }

    @Override
    @Nonnull
    public Expression visitSelectExpressionElement(@Nonnull RelationalParser.SelectExpressionElementContext selectExpressionElementContext) {
        Expression expression = Assert.castUnchecked(selectExpressionElementContext.expression().accept(this), Expression.class);
        if (selectExpressionElementContext.AS() != null) {
            Identifier expressionName = this.visitUid(selectExpressionElementContext.uid());
            return expression.withName(expressionName);
        }
        return expression;
    }

    @Override
    @Nonnull
    public Expression visitFullColumnName(@Nonnull RelationalParser.FullColumnNameContext fullColumnNameContext) {
        Identifier id = this.visitFullId(fullColumnNameContext.fullId());
        return ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer().resolveIdentifier(id, ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment());
    }

    @Override
    @Nonnull
    public List<OrderByExpression> visitOrderByClause(@Nonnull RelationalParser.OrderByClauseContext orderByClauseContextContext) {
        if (!((BaseVisitor)this.getDelegate()).isTopLevel()) {
            Assert.failUnchecked(ErrorCode.UNSUPPORTED_OPERATION, "order by is not supported in subquery");
        }
        ImmutableList<OrderByExpression> orderByExpressions = orderByClauseContextContext.orderByExpression().stream().map(this::visitOrderByExpression).collect(ImmutableList.toImmutableList());
        ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer().validateOrderByColumns(orderByExpressions);
        return orderByExpressions;
    }

    @Override
    @Nonnull
    public OrderByExpression visitOrderByExpression(@Nonnull RelationalParser.OrderByExpressionContext orderByExpressionContext) {
        Expression expression = Assert.castUnchecked(orderByExpressionContext.expression().accept(this), Expression.class);
        boolean descending = ParseHelpers.isDescending(orderByExpressionContext);
        boolean nullsLast = ParseHelpers.isNullsLast(orderByExpressionContext, descending);
        return OrderByExpression.of(expression, descending, nullsLast);
    }

    @Override
    @Nonnull
    public NonnullPair<String, CompatibleTypeEvolutionPredicate.FieldAccessTrieNode> visitInlineTableDefinition(@Nonnull RelationalParser.InlineTableDefinitionContext ctx) {
        Identifier tableId = this.visitTableName(ctx.tableName());
        CompatibleTypeEvolutionPredicate.FieldAccessTrieNode columnIdTrie = this.visitUidListWithNestingsInParens(ctx.uidListWithNestingsInParens());
        int columnCount = Objects.requireNonNull(columnIdTrie.getThis().getChildrenMap()).size();
        ArrayList<RecordLayerColumn> columnsList = new ArrayList<RecordLayerColumn>(Collections.nCopies(columnCount, null));
        for (Map.Entry entry : columnIdTrie.getThis().getChildrenMap().entrySet()) {
            RecordLayerColumn column = ExpressionVisitor.toColumn((FieldValue.ResolvedAccessor)entry.getKey(), (CompatibleTypeEvolutionPredicate.FieldAccessTrieNode)entry.getValue());
            columnsList.set(column.getIndex(), column);
        }
        RecordLayerTable.Builder tableBuilder = RecordLayerTable.newBuilder(false).setName(tableId.getName());
        columnsList.forEach(tableBuilder::addColumn);
        return NonnullPair.of(tableId.getName(), columnIdTrie);
    }

    private static RecordLayerColumn toColumn(@Nonnull FieldValue.ResolvedAccessor field, @Nonnull CompatibleTypeEvolutionPredicate.FieldAccessTrieNode columnIdTrie) {
        String columnName = field.getName();
        RecordLayerColumn.Builder builder = RecordLayerColumn.newBuilder().setName(columnName).setIndex(field.getOrdinal());
        if (columnIdTrie.getChildrenMap() == null) {
            return builder.setDataType(DataTypeUtils.toRelationalType(field.getType())).build();
        }
        int columnCount = columnIdTrie.getChildrenMap().size();
        ArrayList<DataType.StructType.Field> fields = new ArrayList<DataType.StructType.Field>(Collections.nCopies(columnCount, null));
        for (Map.Entry child : columnIdTrie.getChildrenMap().entrySet()) {
            RecordLayerColumn column = ExpressionVisitor.toColumn((FieldValue.ResolvedAccessor)child.getKey(), (CompatibleTypeEvolutionPredicate.FieldAccessTrieNode)child.getValue());
            fields.set(column.getIndex(), DataType.StructType.Field.from(column.getName(), column.getDataType(), column.getIndex()));
        }
        builder.setDataType(DataType.StructType.from(columnName, fields, true));
        return builder.build();
    }

    @Override
    @Nonnull
    public Expressions visitGroupByClause(@Nonnull RelationalParser.GroupByClauseContext groupByClauseContext) {
        return Expressions.of(groupByClauseContext.groupByItem().stream().map(this::visitGroupByItem).collect(ImmutableList.toImmutableList()));
    }

    @Override
    @Nonnull
    public Expression visitGroupByItem(@Nonnull RelationalParser.GroupByItemContext groupByItemContext) {
        Assert.isNullUnchecked((Object)groupByItemContext.order, ErrorCode.UNSUPPORTED_QUERY, "ordering grouping column is not supported");
        Expression expression = Assert.castUnchecked(groupByItemContext.expression().accept(this), Expression.class);
        if (groupByItemContext.uid() != null) {
            Identifier name = this.visitUid(groupByItemContext.uid());
            return expression.withName(name).asEphemeral();
        }
        return expression;
    }

    @Override
    @Nonnull
    public Expression visitAggregateFunctionCall(@Nonnull RelationalParser.AggregateFunctionCallContext functionCon) {
        return this.visitAggregateWindowedFunction(functionCon.aggregateWindowedFunction());
    }

    @Override
    @Nonnull
    public Expression visitAggregateWindowedFunction(@Nonnull RelationalParser.AggregateWindowedFunctionContext functionContext) {
        Assert.thatUnchecked(functionContext.aggregator == null || functionContext.aggregator.getText().equals(functionContext.ALL().getText()), ErrorCode.UNSUPPORTED_QUERY, () -> String.format(Locale.ROOT, "Unsupported aggregator %s", functionContext.aggregator.getText()));
        String functionName = functionContext.functionName.getText();
        Optional<Expression> argumentMaybe = Optional.empty();
        if (functionContext.starArg != null) {
            argumentMaybe = Optional.of(Expression.ofUnnamed(RecordConstructorValue.ofColumns(List.of())));
        } else if (functionContext.functionArg() != null) {
            argumentMaybe = Optional.of(this.visitFunctionArg(functionContext.functionArg()));
        }
        return argumentMaybe.map(expression -> ((BaseVisitor)this.getDelegate()).resolveFunction(functionName, (Expression)expression)).orElseGet(() -> ((BaseVisitor)this.getDelegate()).resolveFunction(functionName, new Expression[0]));
    }

    @Override
    @Nonnull
    public Expression visitScalarFunctionCall(@Nonnull RelationalParser.ScalarFunctionCallContext ctx) {
        Expressions arguments;
        String functionName = ctx.scalarFunctionName().getText();
        boolean isUdf = ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer().isJavaCallFunction(functionName);
        if (isUdf) {
            List argumentNodes = ctx.functionArgs().children.stream().filter(arg -> arg instanceof RelationalParser.FunctionArgContext).map(RelationalParser.FunctionArgContext.class::cast).collect(Collectors.toUnmodifiableList());
            Assert.thatUnchecked(!argumentNodes.isEmpty());
            Expression classNameExpression = ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().withDisabledLiteralProcessing(() -> {
                Expression result = this.visitFunctionArg((RelationalParser.FunctionArgContext)argumentNodes.get(0));
                Assert.thatUnchecked(result.getUnderlying() instanceof LiteralValue, ErrorCode.INVALID_ARGUMENT_FOR_FUNCTION, () -> String.format(Locale.ROOT, "attempt to invoke java_call with incorrect UDF '%s'", result.getUnderlying()));
                return result;
            });
            arguments = Expressions.of(Streams.concat(Stream.of(classNameExpression), argumentNodes.stream().skip(1L).map(this::visitFunctionArg)).collect(Collectors.toUnmodifiableList()));
        } else {
            arguments = this.visitFunctionArgs(ctx.functionArgs());
        }
        return ((BaseVisitor)this.getDelegate()).resolveFunction(functionName, arguments.asList().toArray(new Expression[0]));
    }

    @Override
    @Nonnull
    public Expression visitCaseFunctionCall(@Nonnull RelationalParser.CaseFunctionCallContext ctx) {
        ImmutableList.Builder implications = ImmutableList.builder();
        ImmutableList.Builder pickerValues = ImmutableList.builder();
        for (RelationalParser.CaseFuncAlternativeContext caseAlternative : ctx.caseFuncAlternative()) {
            Expression condition = this.visitFunctionArg(caseAlternative.condition);
            Assert.thatUnchecked(condition.getDataType().getCode().equals((Object)DataType.Code.BOOLEAN), ErrorCode.DATATYPE_MISMATCH, "argument of case when must be of boolean type");
            Expression consequent = this.visitFunctionArg(caseAlternative.consequent);
            implications.add(condition.getUnderlying());
            pickerValues.add(consequent);
        }
        if (ctx.ELSE() != null) {
            implications.add(TautologicalValue.getInstance());
            Expression defaultConsequent = this.visitFunctionArg(ctx.functionArg());
            pickerValues.add(defaultConsequent);
        }
        ImmutableList.Builder arguments = ImmutableList.builder();
        arguments.add(Expression.ofUnnamed(new ConditionSelectorValue(implications.build())));
        arguments.addAll((Iterable)pickerValues.build());
        return ((BaseVisitor)this.getDelegate()).resolveFunction("__pick_value", arguments.build().toArray(new Expression[0]));
    }

    @Override
    @Nonnull
    public Expression visitFunctionCallExpressionAtom(@Nonnull RelationalParser.FunctionCallExpressionAtomContext ctx) {
        return this.parseChild(ctx);
    }

    @Override
    @Nonnull
    public Expression visitFunctionArg(@Nonnull RelationalParser.FunctionArgContext functionArgContext) {
        return Assert.castUnchecked(functionArgContext.expression().accept(this), Expression.class);
    }

    @Override
    @Nonnull
    public Expressions visitFunctionArgs(@Nonnull RelationalParser.FunctionArgsContext ctx) {
        return Expressions.of(ctx.functionArg().stream().map(this::visitFunctionArg).collect(ImmutableList.toImmutableList()));
    }

    @Override
    @Nonnull
    public Expression visitHavingClause(@Nonnull RelationalParser.HavingClauseContext havingClauseContext) {
        return Assert.castUnchecked(havingClauseContext.expression().accept(this), Expression.class);
    }

    @Override
    @Nonnull
    public Expression visitPreparedStatementParameterAtom(@Nonnull RelationalParser.PreparedStatementParameterAtomContext ctx) {
        return this.visitPreparedStatementParameter(ctx.preparedStatementParameter());
    }

    @Override
    @Nonnull
    public Expression visitPreparedStatementParameter(@Nonnull RelationalParser.PreparedStatementParameterContext ctx) {
        Value value;
        int tokenIndex = ctx.getStart().getTokenIndex();
        if (ctx.QUESTION() != null) {
            value = ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().processUnnamedPreparedParam(tokenIndex);
        } else {
            String parameterName = ctx.NAMED_PARAMETER().getText().substring(1);
            value = ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().processNamedPreparedParam(parameterName, tokenIndex);
        }
        DataType type = DataTypeUtils.toRelationalType(value.getResultType());
        return Expression.ofUnnamed(type, value);
    }

    @Override
    @Nonnull
    public Expression visitNotExpression(@Nonnull RelationalParser.NotExpressionContext ctx) {
        Expression argument = Assert.castUnchecked(ctx.expression().accept(this), Expression.class);
        return ((BaseVisitor)this.getDelegate()).resolveFunction(ctx.NOT().getText(), argument);
    }

    @Override
    @Nonnull
    public Expression visitLogicalExpression(@Nonnull RelationalParser.LogicalExpressionContext ctx) {
        Expression left = Assert.castUnchecked(ctx.expression(0).accept(this), Expression.class);
        Expression right = Assert.castUnchecked(ctx.expression(1).accept(this), Expression.class);
        return ((BaseVisitor)this.getDelegate()).resolveFunction(ctx.logicalOperator().getText(), left, right);
    }

    @Override
    @Nonnull
    public Expression visitPredicatedExpression(@Nonnull RelationalParser.PredicatedExpressionContext ctx) {
        Expression operand = Assert.castUnchecked(this.visit(ctx.expressionAtom()), Expression.class);
        RelationalParser.PredicateContext predicate = ctx.predicate();
        if (predicate == null) {
            return operand;
        }
        if (predicate instanceof RelationalParser.BetweenComparisonPredicateContext) {
            return this.visitBetweenComparisonPredicate(operand, (RelationalParser.BetweenComparisonPredicateContext)predicate);
        }
        if (predicate instanceof RelationalParser.InPredicateContext) {
            return this.visitInPredicate(operand, (RelationalParser.InPredicateContext)predicate);
        }
        if (predicate instanceof RelationalParser.LikePredicateContext) {
            return this.visitLikePredicate(operand, (RelationalParser.LikePredicateContext)predicate);
        }
        if (predicate instanceof RelationalParser.IsExpressionContext) {
            return this.visitIsExpression(operand, (RelationalParser.IsExpressionContext)predicate);
        }
        Assert.failUnchecked(ErrorCode.UNSUPPORTED_QUERY, "unsupported predicate " + ctx.predicate().getText());
        return null;
    }

    @Override
    @Nonnull
    public Expression visitLimitClause(@Nonnull RelationalParser.LimitClauseContext ctx) {
        Assert.isNullUnchecked(ctx.offset, "OFFSET clause is not supported");
        return ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().withDisabledLiteralProcessing(() -> {
            Expression limitExpression = this.parseChild(ctx);
            SemanticAnalyzer.validateLimit(limitExpression);
            return limitExpression;
        });
    }

    @Override
    @Nonnull
    public Expression visitLimitClauseAtom(@Nonnull RelationalParser.LimitClauseAtomContext ctx) {
        return this.parseChild(ctx);
    }

    @Override
    @Nonnull
    public Expression visitExistsExpressionAtom(@Nonnull RelationalParser.ExistsExpressionAtomContext ctx) {
        LogicalOperator selectOperator = this.visitQuery(ctx.query());
        LogicalOperator asExistential = selectOperator.withQuantifier(Quantifier.existential(selectOperator.getQuantifier().getRangesOver()));
        ExistsValue underlyingValue = new ExistsValue(asExistential.getQuantifier().getAlias());
        ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().addOperator(asExistential);
        return Expression.ofUnnamed(underlyingValue);
    }

    @Nonnull
    private Expression visitIsExpression(@Nonnull Expression operand, @Nonnull RelationalParser.IsExpressionContext ctx) {
        String combineFunc;
        Expression nullClause;
        boolean right;
        if (ctx.NULL_LITERAL() != null) {
            if (ctx.NOT() != null) {
                return ((BaseVisitor)this.getDelegate()).resolveFunction("is not null", operand);
            }
            return ((BaseVisitor)this.getDelegate()).resolveFunction("is null", operand);
        }
        boolean bl = right = ctx.TRUE() != null;
        if (ctx.NOT() != null) {
            right = !right;
            nullClause = ((BaseVisitor)this.getDelegate()).resolveFunction("is null", operand);
            combineFunc = "or";
        } else {
            nullClause = ((BaseVisitor)this.getDelegate()).resolveFunction("is not null", operand);
            combineFunc = "and";
        }
        Expression equals = ((BaseVisitor)this.getDelegate()).resolveFunction("=", operand, Expression.ofUnnamed(new LiteralValue<Boolean>(right)));
        return ((BaseVisitor)this.getDelegate()).resolveFunction(combineFunc, nullClause, equals);
    }

    @Nonnull
    private Expression visitLikePredicate(@Nonnull Expression operand, @Nonnull RelationalParser.LikePredicateContext ctx) {
        LiteralValue<Object> escapeValue;
        if (ctx.escape != null) {
            String escapeChar = ((BaseVisitor)this.getDelegate()).normalizeString(ctx.escape.getText());
            Assert.thatUnchecked(escapeChar.length() == 1);
            escapeValue = new LiteralValue<String>(escapeChar);
        } else {
            escapeValue = new LiteralValue<Object>(null);
        }
        String pattern = Assert.notNullUnchecked(((BaseVisitor)this.getDelegate()).normalizeString(ctx.pattern.getText()));
        Value patternValueBinding = ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().processQueryLiteral(Type.primitiveType(Type.TypeCode.STRING), pattern, ctx.pattern.getTokenIndex());
        Expression patternFunction = ((BaseVisitor)this.getDelegate()).resolveFunction("__pattern_for_like", Expression.ofUnnamed(patternValueBinding), Expression.ofUnnamed(escapeValue));
        Expression likeFunction = ((BaseVisitor)this.getDelegate()).resolveFunction(ctx.LIKE().getText(), operand, patternFunction);
        if (ctx.NOT() != null) {
            return ((BaseVisitor)this.getDelegate()).resolveFunction(ctx.NOT().getText(), likeFunction);
        }
        return likeFunction;
    }

    @Nonnull
    private Expression visitInPredicate(@Nonnull Expression operand, @Nonnull RelationalParser.InPredicateContext ctx) {
        Assert.thatUnchecked(ctx.inList().queryExpressionBody() == null, ErrorCode.UNSUPPORTED_QUERY, "IN predicate does not support nested SELECT");
        Expression right = this.visitInList(ctx.inList());
        Expression in = ((BaseVisitor)this.getDelegate()).resolveFunction(ctx.IN().getText(), operand, right);
        if (ctx.NOT() != null) {
            in = ((BaseVisitor)this.getDelegate()).resolveFunction(ctx.NOT().getText(), in);
        }
        return in;
    }

    @Override
    @Nonnull
    public Expression visitInList(@Nonnull RelationalParser.InListContext ctx) {
        Expression result;
        if (ctx.preparedStatementParameter() != null) {
            result = this.visitPreparedStatementParameter(ctx.preparedStatementParameter());
        } else if (((BaseVisitor)this.getDelegate()).getPlanGenerationContext().shouldProcessLiteral() && ParseHelpers.isConstant(ctx.expressions())) {
            ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().startArrayLiteral();
            Expressions inListItems = this.visitExpressions(ctx.expressions());
            int tokenIndex = ctx.getStart().getTokenIndex();
            ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().finishArrayLiteral(null, null, tokenIndex);
            SemanticAnalyzer semanticAnalyzer = ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer();
            semanticAnalyzer.validateInListItems(inListItems);
            Type.Array arrayType = semanticAnalyzer.resolveArrayTypeFromValues(inListItems);
            result = Expression.ofUnnamed(((BaseVisitor)this.getDelegate()).getPlanGenerationContext().processComplexLiteral(tokenIndex, arrayType));
        } else {
            Expressions inListItems = this.visitExpressions(ctx.expressions());
            result = ((BaseVisitor)this.getDelegate()).resolveFunction("__internal_array", inListItems.asList().toArray(new Expression[0]));
        }
        return result;
    }

    @Override
    @Nonnull
    public Expression visitWhereExpr(@Nonnull RelationalParser.WhereExprContext ctx) {
        return this.parseChild(ctx);
    }

    @Override
    @Nonnull
    public Expressions visitExpressions(@Nonnull RelationalParser.ExpressionsContext ctx) {
        return Expressions.of(ctx.expression().stream().map(expression -> Assert.castUnchecked(expression.accept(this), Expression.class)).collect(ImmutableList.toImmutableList()));
    }

    @Override
    @Nonnull
    public Expression visitBitExpressionAtom(@Nonnull RelationalParser.BitExpressionAtomContext ctx) {
        Expression left = Assert.castUnchecked(ctx.left.accept(this), Expression.class);
        Expression right = Assert.castUnchecked(ctx.right.accept(this), Expression.class);
        return ((BaseVisitor)this.getDelegate()).resolveFunction(ctx.bitOperator().getText(), left, right);
    }

    @Override
    @Nonnull
    public Expression visitBinaryComparisonPredicate(@Nonnull RelationalParser.BinaryComparisonPredicateContext ctx) {
        Expression left = Assert.castUnchecked(ctx.left.accept(this), Expression.class);
        Expression right = Assert.castUnchecked(ctx.right.accept(this), Expression.class);
        return ((BaseVisitor)this.getDelegate()).resolveFunction(ctx.comparisonOperator().getText(), left, right);
    }

    @Override
    public Expression visitSubscriptExpression(@Nonnull RelationalParser.SubscriptExpressionContext ctx) {
        Expression index = Assert.castUnchecked(ctx.index.accept(this), Expression.class);
        Expression base = Assert.castUnchecked(ctx.base.accept(this), Expression.class);
        return ((BaseVisitor)this.getDelegate()).resolveFunction(ctx.LEFT_SQUARE_BRACKET().getText().concat(ctx.RIGHT_SQUARE_BRACKET().getText()), index, base);
    }

    @Nonnull
    private Expression visitBetweenComparisonPredicate(@Nonnull Expression operand, @Nonnull RelationalParser.BetweenComparisonPredicateContext ctx) {
        Expression left = Assert.castUnchecked(ctx.left.accept(this), Expression.class);
        Expression right = Assert.castUnchecked(ctx.right.accept(this), Expression.class);
        if (ctx.NOT() == null) {
            return ((BaseVisitor)this.getDelegate()).resolveFunction("and", ((BaseVisitor)this.getDelegate()).resolveFunction("<=", left, operand), ((BaseVisitor)this.getDelegate()).resolveFunction("<=", operand, right));
        }
        return ((BaseVisitor)this.getDelegate()).resolveFunction("or", ((BaseVisitor)this.getDelegate()).resolveFunction("<", operand, left), ((BaseVisitor)this.getDelegate()).resolveFunction(">", operand, right));
    }

    @Override
    @Nonnull
    public Expression visitMathExpressionAtom(@Nonnull RelationalParser.MathExpressionAtomContext ctx) {
        Expression left = Assert.castUnchecked(ctx.left.accept(this), Expression.class);
        Expression right = Assert.castUnchecked(ctx.right.accept(this), Expression.class);
        return ((BaseVisitor)this.getDelegate()).resolveFunction(ctx.mathOperator().getText(), left, right);
    }

    @Override
    @Nonnull
    public Expression visitExpressionWithName(@Nonnull RelationalParser.ExpressionWithNameContext ctx) {
        Expression expression = Assert.castUnchecked(ctx.expression().accept(this), Expression.class);
        Identifier name = this.visitUid(ctx.uid());
        return expression.withName(name);
    }

    @Override
    @Nonnull
    public Expression visitExpressionWithOptionalName(@Nonnull RelationalParser.ExpressionWithOptionalNameContext ctx) {
        Expression expression = Assert.castUnchecked(ctx.expression().accept(this), Expression.class);
        if (ctx.AS() != null) {
            Identifier name = this.visitUid(ctx.uid());
            return expression.withName(name);
        }
        return expression;
    }

    @Override
    @Nonnull
    public Expression visitDecimalLiteral(@Nonnull RelationalParser.DecimalLiteralContext ctx) {
        return this.resolveDecimal(ctx.getText(), ctx.getStart().getTokenIndex());
    }

    @Override
    @Nonnull
    public Expression visitStringLiteral(@Nonnull RelationalParser.StringLiteralContext ctx) {
        Assert.isNullUnchecked((Object)ctx.STRING_CHARSET_NAME(), ErrorCode.UNSUPPORTED_QUERY, "charset not is supported");
        Assert.isNullUnchecked((Object)ctx.START_NATIONAL_STRING_LITERAL(), ErrorCode.UNSUPPORTED_QUERY, "national string literal is not supported");
        Assert.isNullUnchecked((Object)ctx.COLLATE(), ErrorCode.UNSUPPORTED_QUERY, "collation is not supported");
        Value value = ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().processQueryLiteral(Type.primitiveType(Type.TypeCode.STRING), ((BaseVisitor)this.getDelegate()).normalizeString(ctx.getText()), ctx.getStart().getTokenIndex());
        return Expression.ofUnnamed(value);
    }

    @Override
    @Nonnull
    public Expression visitBooleanLiteral(@Nonnull RelationalParser.BooleanLiteralContext ctx) {
        Value booleanValue;
        if (ctx.FALSE() != null) {
            booleanValue = ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().processQueryLiteral(Type.primitiveType(Type.TypeCode.BOOLEAN), Boolean.FALSE, ctx.FALSE().getSymbol().getTokenIndex());
        } else {
            Assert.notNullUnchecked(ctx.TRUE());
            booleanValue = ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().processQueryLiteral(Type.primitiveType(Type.TypeCode.BOOLEAN), Boolean.TRUE, ctx.TRUE().getSymbol().getTokenIndex());
        }
        return Expression.ofUnnamed(booleanValue);
    }

    @Override
    @Nonnull
    public Expression visitBytesLiteral(@Nonnull RelationalParser.BytesLiteralContext ctx) {
        String literal = ctx.HEXADECIMAL_LITERAL() != null ? ctx.HEXADECIMAL_LITERAL().getText() : ctx.BASE64_LITERAL().getText();
        byte[] byteArray = ParseHelpers.parseBytes(literal);
        Value value = ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().processQueryLiteral(Type.primitiveType(Type.TypeCode.BYTES), ZeroCopyByteString.wrap(byteArray), ctx.getStart().getTokenIndex());
        return Expression.ofUnnamed(value);
    }

    @Override
    @Nonnull
    public Expression visitNullLiteral(@Nonnull RelationalParser.NullLiteralContext ctx) {
        return Expression.ofUnnamed(new NullValue(Type.nullType()));
    }

    @Override
    @Nonnull
    public Expression visitStringConstant(@Nonnull RelationalParser.StringConstantContext ctx) {
        return this.parseChild(ctx);
    }

    @Override
    @Nonnull
    public Expression visitDecimalConstant(@Nonnull RelationalParser.DecimalConstantContext ctx) {
        return this.parseChild(ctx);
    }

    @Override
    @Nonnull
    public Expression visitNegativeDecimalConstant(@Nonnull RelationalParser.NegativeDecimalConstantContext ctx) {
        return this.resolveDecimal(ctx.getText(), ctx.getStart().getTokenIndex());
    }

    @Override
    @Nonnull
    public Expression visitBytesConstant(@Nonnull RelationalParser.BytesConstantContext ctx) {
        return this.parseChild(ctx);
    }

    @Override
    @Nonnull
    public Expression visitBooleanConstant(@Nonnull RelationalParser.BooleanConstantContext ctx) {
        return this.parseChild(ctx);
    }

    @Override
    @Nonnull
    public Expression visitBitStringConstant(@Nonnull RelationalParser.BitStringConstantContext ctx) {
        Assert.failUnchecked(ErrorCode.UNSUPPORTED_QUERY, "bit strings not supported");
        return null;
    }

    @Override
    @Nonnull
    public Expression visitNullConstant(@Nonnull RelationalParser.NullConstantContext ctx) {
        Assert.isNullUnchecked((Object)ctx.NOT(), ErrorCode.UNSUPPORTED_QUERY, "not null is not supported");
        return this.visitNullLiteral(ctx.nullLiteral());
    }

    @Override
    @Nonnull
    public CompatibleTypeEvolutionPredicate.FieldAccessTrieNode visitUidListWithNestingsInParens(@Nonnull RelationalParser.UidListWithNestingsInParensContext ctx) {
        return this.visitUidListWithNestings(ctx.uidListWithNestings());
    }

    @Override
    @Nonnull
    public CompatibleTypeEvolutionPredicate.FieldAccessTrieNode visitUidListWithNestings(@Nonnull RelationalParser.UidListWithNestingsContext ctx) {
        ImmutableMap<FieldValue.ResolvedAccessor, CompatibleTypeEvolutionPredicate.FieldAccessTrieNode> uidMap = Streams.mapWithIndex(ctx.uidWithNestings().stream(), (ctxWithNesting, index) -> {
            Identifier uid = this.visitUid(ctxWithNesting.uid());
            FieldValue.ResolvedAccessor accessor = FieldValue.ResolvedAccessor.of(uid.getName(), (int)index, Type.any());
            if (ctxWithNesting.uidListWithNestingsInParens() == null) {
                return NonnullPair.of(accessor, CompatibleTypeEvolutionPredicate.FieldAccessTrieNode.of(Type.any(), null));
            }
            return NonnullPair.of(accessor, this.visitUidListWithNestingsInParens(ctxWithNesting.uidListWithNestingsInParens()));
        }).collect(ImmutableMap.toImmutableMap(NonnullPair::getLeft, NonnullPair::getRight, (l, r) -> {
            throw Assert.failUnchecked(ErrorCode.AMBIGUOUS_COLUMN, "duplicate column '" + String.valueOf(l) + "'");
        }));
        return CompatibleTypeEvolutionPredicate.FieldAccessTrieNode.of(Type.any(), uidMap);
    }

    @Override
    @Nonnull
    public Expression visitRecordConstructorForInsert(@Nonnull RelationalParser.RecordConstructorForInsertContext ctx) {
        Expressions expressions = this.parseRecordFieldsUnderReorderings(ctx.expressionWithOptionalName());
        return Expression.ofUnnamed(RecordConstructorValue.ofColumns(expressions.underlyingAsColumns()));
    }

    @Override
    @Nonnull
    public Expression visitRecordConstructorForInlineTable(@Nonnull RelationalParser.RecordConstructorForInlineTableContext ctx) {
        Expressions expressions = this.parseRecordFieldsUnderReorderings(ctx.expressionWithOptionalName());
        return Expression.ofUnnamed(RecordConstructorValue.ofColumns(expressions.underlyingAsColumns()));
    }

    @Override
    @Nonnull
    public Expression visitRecordConstructor(@Nonnull RelationalParser.RecordConstructorContext ctx) {
        Expressions expressions;
        if (ctx.uid() != null) {
            Identifier id = this.visitUid(ctx.uid());
            if (ctx.STAR() == null) {
                Expression expression = ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer().resolveIdentifier(id, ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment());
                RecordConstructorValue resultValue = RecordConstructorValue.ofUnnamed(List.of(expression.getUnderlying()));
                return expression.withUnderlying(resultValue);
            }
            Star star = ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer().expandStar(Optional.of(id), ((BaseVisitor)this.getDelegate()).getLogicalOperators());
            Value resultValue = star.getUnderlying();
            return Expression.ofUnnamed(resultValue);
        }
        if (ctx.STAR() != null) {
            Star star = ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer().expandStar(Optional.empty(), ((BaseVisitor)this.getDelegate()).getLogicalOperators());
            Value resultValue = star.getUnderlying();
            return Expression.ofUnnamed(resultValue);
        }
        Expressions expressions2 = expressions = ctx.expressionWithName() != null ? this.parseRecordFieldsUnderReorderings(ImmutableList.of(ctx.expressionWithName())) : this.parseRecordFieldsUnderReorderings(ctx.expressionWithOptionalName());
        if (ctx.ofTypeClause() != null) {
            Identifier recordId = this.visitUid(ctx.ofTypeClause().uid());
            RecordConstructorValue resultValue = RecordConstructorValue.ofColumnsAndName(expressions.underlyingAsColumns(), recordId.getName());
            return Expression.ofUnnamed(resultValue);
        }
        RecordConstructorValue resultValue = RecordConstructorValue.ofColumns(expressions.underlyingAsColumns());
        return Expression.ofUnnamed(resultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Expression visitArrayConstructor(@Nonnull RelationalParser.ArrayConstructorContext ctx) {
        Optional<LogicalPlanFragment.State> maybeState = this.getStateMaybe();
        Optional<Type> targetTypeMaybe = maybeState.flatMap(LogicalPlanFragment.State::getTargetType);
        if (ctx.expressions() == null) {
            Type elementType = targetTypeMaybe.map(type -> Assert.castUnchecked(type, Type.Array.class).getElementType()).orElse(Type.any());
            return Expression.ofUnnamed(AbstractArrayConstructorValue.LightArrayConstructorValue.emptyArray(elementType));
        }
        if (targetTypeMaybe.isEmpty()) {
            return this.handleArray(ctx);
        }
        Type.Array arrayTargetType = Assert.castUnchecked((Type)targetTypeMaybe.get(), Type.Array.class);
        LogicalPlanFragment.State.Builder newStateBuilder = LogicalPlanFragment.State.newBuilder().withTargetType(Assert.notNullUnchecked(arrayTargetType.getElementType()));
        try {
            ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().setState(newStateBuilder.build());
            Expression expression = this.handleArray(ctx);
            return expression;
        }
        finally {
            ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().setStateMaybe(maybeState);
        }
    }

    @Nonnull
    private Expressions parseRecordFields(@Nonnull List<? extends ParserRuleContext> parserRuleContexts, @Nullable List<Type.Record.Field> targetFields) {
        Assert.thatUnchecked(targetFields == null || targetFields.size() == parserRuleContexts.size());
        ImmutableList.Builder resultsBuilder = ImmutableList.builder();
        for (int i = 0; i < parserRuleContexts.size(); ++i) {
            ParserRuleContext parserRuleContext = parserRuleContexts.get(i);
            Type.Record.Field targetField = targetFields == null ? null : targetFields.get(i);
            resultsBuilder.add(this.parseRecordField(parserRuleContext, targetField));
        }
        return Expressions.of(resultsBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Expression parseRecordField(@Nonnull ParserRuleContext parserRuleContext, @Nullable Type.Record.Field targetField) {
        Expression expression;
        Type fieldType = targetField == null ? null : targetField.getFieldType();
        TrieNode.AbstractTrieNode reorderings = null;
        Optional<LogicalPlanFragment.State> maybeState = this.getStateMaybe();
        if (targetField != null && maybeState.isPresent() && maybeState.get().getTargetTypeReorderings().isPresent()) {
            reorderings = maybeState.get().getTargetTypeReorderings().get();
        }
        StringTrieNode targetFieldReorderings = reorderings == null || reorderings.getChildrenMap() == null ? null : (StringTrieNode)reorderings.getChildrenMap().get(targetField.getFieldName());
        LogicalPlanFragment.State.Builder newStateBuilder = LogicalPlanFragment.State.newBuilder();
        try {
            if (fieldType != null) {
                newStateBuilder.withTargetType(fieldType);
            }
            if (targetFieldReorderings != null && targetFieldReorderings.getChildrenMap() != null) {
                newStateBuilder.withTargetTypeReorderings(targetFieldReorderings);
            }
            ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().setState(newStateBuilder.build());
            expression = Assert.castUnchecked(parserRuleContext.accept(this), Expression.class);
        }
        finally {
            ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().setStateMaybe(maybeState);
        }
        Assert.notNullUnchecked(expression);
        if (fieldType == null) {
            return expression;
        }
        Expression coercedExpression = ExpressionVisitor.coerceIfNecessary(expression, fieldType);
        if (expression.getName().isPresent() && targetField.getFieldNameOptional().isPresent()) {
            Assert.thatUnchecked(expression.getName().get().equals(Identifier.of(targetField.getFieldNameOptional().get())));
        }
        if (expression.getName().isEmpty() && targetField.getFieldNameOptional().isPresent()) {
            return coercedExpression.withName(Identifier.of(targetField.getFieldName()));
        }
        return coercedExpression;
    }

    @Nonnull
    private static Expression coerceIfNecessary(@Nonnull Expression expression, @Nonnull Type targetType) {
        Value maybeCoercedValue;
        Value value = expression.getUnderlying();
        if (value != (maybeCoercedValue = ExpressionVisitor.coerceValueIfNecessary(expression.getUnderlying(), targetType))) {
            return new Expression(expression.getName(), DataTypeUtils.toRelationalType(maybeCoercedValue.getResultType()), maybeCoercedValue);
        }
        return expression;
    }

    @Nonnull
    private static Value coerceValueIfNecessary(@Nonnull Value value, @Nonnull Type targetType) {
        Type resultType = value.getResultType();
        if (resultType.isUnresolved() || resultType.isPrimitive() && PromoteValue.isPromotionNeeded(resultType, targetType)) {
            return PromoteValue.inject(value, targetType);
        }
        if (resultType.isArray() && PromoteValue.isPromotionNeeded(resultType, targetType) && value instanceof AbstractArrayConstructorValue) {
            Assert.thatUnchecked(targetType.isArray(), "Cannot convert array type to non-array type");
            Type targetElementType = ((Type.Array)targetType).getElementType();
            return AbstractArrayConstructorValue.LightArrayConstructorValue.of(Streams.stream(value.getChildren()).map(c -> ExpressionVisitor.coerceValueIfNecessary(c, targetElementType)).collect(Collectors.toList()));
        }
        return value;
    }

    @Nonnull
    private Expressions parseRecordFieldsUnderReorderings(@Nonnull List<? extends ParserRuleContext> providedColumnContexts) {
        Optional<LogicalPlanFragment.State> maybeState = this.getStateMaybe();
        if (maybeState.isEmpty() || maybeState.get().getTargetType().isEmpty()) {
            return this.parseRecordFields(providedColumnContexts, null);
        }
        LogicalPlanFragment.State state = maybeState.get();
        Type.Record targetType = Assert.castUnchecked(state.getTargetType().get(), Type.Record.class);
        List<Type.Record.Field> elementFields = Assert.notNullUnchecked(targetType.getFields());
        if (state.getTargetTypeReorderings().isPresent()) {
            ImmutableList targetTypeReorderings = ImmutableList.copyOf(Assert.notNullUnchecked(state.getTargetTypeReorderings().get().getChildrenMap()).keySet());
            ImmutableList.Builder resultColumnsBuilder = ImmutableList.builder();
            Assert.thatUnchecked(targetTypeReorderings.size() >= providedColumnContexts.size(), ErrorCode.SYNTAX_ERROR, "Too many parameters");
            for (Type.Record.Field elementField : elementFields) {
                int index = targetTypeReorderings.indexOf(elementField.getFieldName());
                Type fieldType = elementField.getFieldType();
                Expression currentFieldColumns = null;
                if (index >= 0 && index < providedColumnContexts.size()) {
                    currentFieldColumns = this.parseRecordField(providedColumnContexts.get(index), elementField);
                } else if (index >= providedColumnContexts.size()) {
                    Assert.failUnchecked(ErrorCode.SYNTAX_ERROR, "Value of column \"" + elementField.getFieldName() + "\" is not provided");
                } else {
                    Assert.thatUnchecked(fieldType.isNullable(), ErrorCode.NOT_NULL_VIOLATION, "null value in column \"" + elementField.getFieldName() + "\" violates not-null constraint");
                    currentFieldColumns = Expression.fromUnderlying(new NullValue(fieldType));
                }
                resultColumnsBuilder.add(currentFieldColumns);
            }
            return Expressions.of(resultColumnsBuilder.build());
        }
        Assert.thatUnchecked(elementFields.size() == providedColumnContexts.size(), ErrorCode.CANNOT_CONVERT_TYPE, "provided record cannot be assigned as its type is incompatible with the target type");
        return this.parseRecordFields(providedColumnContexts, elementFields);
    }

    @Override
    @Nonnull
    public Expressions visitUpdatedElement(@Nonnull RelationalParser.UpdatedElementContext ctx) {
        Expression targetExpression = this.visitFullColumnName(ctx.fullColumnName());
        Expression updateExpression = Assert.castUnchecked(ctx.expression().accept(this), Expression.class);
        return Expressions.of(ImmutableList.of(targetExpression, updateExpression));
    }

    @Nonnull
    private Expression handleArray(@Nonnull RelationalParser.ArrayConstructorContext ctx) {
        Iterable<Value> elements = this.visitExpressions(ctx.expressions()).underlying();
        return Expression.ofUnnamed(AbstractArrayConstructorValue.LightArrayConstructorValue.of(Streams.stream(elements).collect(ImmutableList.toImmutableList())));
    }

    @Nonnull
    Optional<LogicalPlanFragment.State> getStateMaybe() {
        return ((BaseVisitor)this.getDelegate()).getCurrentPlanFragmentMaybe().flatMap(LogicalPlanFragment::getStateMaybe);
    }

    @Nonnull
    private Expression parseChild(@Nonnull ParserRuleContext context) {
        return Assert.castUnchecked(this.visitChildren(context), Expression.class);
    }

    @Nonnull
    private Expression resolveDecimal(@Nonnull String decimalText, int tokenIndex) {
        Object literal = ParseHelpers.parseDecimal(decimalText);
        Type type = Type.fromObject(literal);
        Value value = ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().processQueryLiteral(type, literal, tokenIndex);
        return Expression.ofUnnamed(value);
    }
}

