/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query.visitors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.generated.RelationalParser;
import com.apple.foundationdb.relational.recordlayer.query.Identifier;
import com.apple.foundationdb.relational.recordlayer.query.visitors.BaseVisitor;
import com.apple.foundationdb.relational.recordlayer.query.visitors.DelegatingVisitor;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.relational.util.ExcludeFromJacocoGeneratedReport;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class IdentifierVisitor
extends DelegatingVisitor<BaseVisitor> {
    private IdentifierVisitor(BaseVisitor baseVisitor) {
        super(baseVisitor);
    }

    @Nonnull
    public static IdentifierVisitor of(@Nonnull BaseVisitor baseVisitor) {
        return new IdentifierVisitor(baseVisitor);
    }

    @Override
    @Nonnull
    public Identifier visitTableName(@Nonnull RelationalParser.TableNameContext tableNameContext) {
        return this.visitFullId(tableNameContext.fullId());
    }

    @Override
    @Nonnull
    public Identifier visitFullId(@Nonnull RelationalParser.FullIdContext fullIdContext) {
        Assert.thatUnchecked(!fullIdContext.uid().isEmpty());
        ImmutableList.Builder qualifierBuilder = ImmutableList.builder();
        for (int i = 0; i < fullIdContext.uid().size() - 1; ++i) {
            String qualifierPart = this.visitUid(fullIdContext.uid().get(i)).getName();
            qualifierBuilder.add(qualifierPart);
        }
        String name = this.visitUid(fullIdContext.uid().get(fullIdContext.uid().size() - 1)).getName();
        return Identifier.of(name, qualifierBuilder.build());
    }

    @Override
    @Nonnull
    public List<Identifier> visitFullIdList(@Nonnull RelationalParser.FullIdListContext fullIdListContext) {
        return fullIdListContext.fullId().stream().map(this::visitFullId).collect(ImmutableList.toImmutableList());
    }

    @Override
    @Nonnull
    public Identifier visitUid(@Nonnull RelationalParser.UidContext uidContext) {
        if (uidContext.simpleId() != null) {
            return this.visitSimpleId(uidContext.simpleId());
        }
        return Identifier.of(((BaseVisitor)this.getDelegate()).normalizeString(uidContext.getText()));
    }

    @Override
    @Nonnull
    public List<Identifier> visitUidList(@Nonnull RelationalParser.UidListContext uidListContext) {
        return uidListContext.uid().stream().map(this::visitUid).collect(ImmutableList.toImmutableList());
    }

    @Override
    @Nonnull
    public Identifier visitSimpleId(@Nonnull RelationalParser.SimpleIdContext simpleIdContext) {
        return Identifier.of(((BaseVisitor)this.getDelegate()).normalizeString(simpleIdContext.getText()));
    }

    @Override
    @Nonnull
    @ExcludeFromJacocoGeneratedReport
    public Identifier visitIndexColumnName(@Nonnull RelationalParser.IndexColumnNameContext ctx) {
        Assert.failUnchecked(ErrorCode.UNSUPPORTED_QUERY, "setting index column is not supported");
        return null;
    }

    @Override
    @Nonnull
    @ExcludeFromJacocoGeneratedReport
    public Identifier visitCharsetName(@Nonnull RelationalParser.CharsetNameContext ctx) {
        Assert.failUnchecked(ErrorCode.UNSUPPORTED_QUERY, "setting charset is not supported");
        return null;
    }

    @Override
    @Nonnull
    @ExcludeFromJacocoGeneratedReport
    public Identifier visitCollationName(@Nonnull RelationalParser.CollationNameContext ctx) {
        Assert.failUnchecked(ErrorCode.UNSUPPORTED_QUERY, "setting collation is not supported");
        return null;
    }

    @Override
    public Identifier visitTableFunctionName(RelationalParser.TableFunctionNameContext ctx) {
        return this.visitFullId(ctx.fullId());
    }
}

