/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query.visitors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.relational.api.ddl.DdlQueryFactory;
import com.apple.foundationdb.relational.generated.RelationalParser;
import com.apple.foundationdb.relational.recordlayer.query.Identifier;
import com.apple.foundationdb.relational.recordlayer.query.QueryPlan;
import com.apple.foundationdb.relational.recordlayer.query.SemanticAnalyzer;
import com.apple.foundationdb.relational.recordlayer.query.visitors.BaseVisitor;
import com.apple.foundationdb.relational.recordlayer.query.visitors.DelegatingVisitor;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class MetadataPlanVisitor
extends DelegatingVisitor<BaseVisitor> {
    private MetadataPlanVisitor(@Nonnull BaseVisitor baseVisitor) {
        super(baseVisitor);
    }

    @Nonnull
    public static MetadataPlanVisitor of(@Nonnull BaseVisitor baseVisitor) {
        return new MetadataPlanVisitor(baseVisitor);
    }

    @Override
    @Nonnull
    public QueryPlan.MetadataQueryPlan visitShowDatabasesStatement(@Nonnull RelationalParser.ShowDatabasesStatementContext ctx) {
        DdlQueryFactory ddlFactory = ((BaseVisitor)this.getDelegate()).getDdlQueryFactory();
        if (ctx.path() != null) {
            Identifier databaseName = this.visitUid(ctx.path().uid());
            SemanticAnalyzer.validateDatabaseUri(databaseName);
            return QueryPlan.MetadataQueryPlan.of(ddlFactory.getListDatabasesQueryAction(URI.create(databaseName.getName())));
        }
        return QueryPlan.MetadataQueryPlan.of(ddlFactory.getListDatabasesQueryAction(((BaseVisitor)this.getDelegate()).getDbUri()));
    }

    @Override
    @Nonnull
    public QueryPlan.MetadataQueryPlan visitShowSchemaTemplatesStatement(@Nonnull RelationalParser.ShowSchemaTemplatesStatementContext ctx) {
        DdlQueryFactory ddlFactory = ((BaseVisitor)this.getDelegate()).getDdlQueryFactory();
        return QueryPlan.MetadataQueryPlan.of(ddlFactory.getListSchemaTemplatesQueryAction());
    }

    @Override
    @Nonnull
    public QueryPlan.MetadataQueryPlan visitSimpleDescribeSchemaStatement(@Nonnull RelationalParser.SimpleDescribeSchemaStatementContext ctx) {
        DdlQueryFactory ddlFactory = ((BaseVisitor)this.getDelegate()).getDdlQueryFactory();
        Identifier schemaId = this.visitUid(ctx.schemaId().path().uid());
        NonnullPair<Optional<URI>, String> dbAndSchema = SemanticAnalyzer.parseSchemaIdentifier(schemaId);
        URI database = dbAndSchema.getLeft().orElse(((BaseVisitor)this.getDelegate()).getDbUri());
        String schema = dbAndSchema.getRight();
        return QueryPlan.MetadataQueryPlan.of(ddlFactory.getDescribeSchemaQueryAction(database, schema));
    }

    @Override
    @Nonnull
    public QueryPlan.MetadataQueryPlan visitSimpleDescribeSchemaTemplateStatement(@Nonnull RelationalParser.SimpleDescribeSchemaTemplateStatementContext ctx) {
        DdlQueryFactory ddlFactory = ((BaseVisitor)this.getDelegate()).getDdlQueryFactory();
        Identifier schemaTemplateId = this.visitUid(ctx.uid());
        return QueryPlan.MetadataQueryPlan.of(ddlFactory.getDescribeSchemaTemplateQueryAction(schemaTemplateId.getName()));
    }
}

