/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.query.visitors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.DeleteExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.ExplodeExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RecursiveUnionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.UpdateExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.CompatibleTypeEvolutionPredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.metadata.Table;
import com.apple.foundationdb.relational.generated.RelationalParser;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerTable;
import com.apple.foundationdb.relational.recordlayer.query.EphemeralExpression;
import com.apple.foundationdb.relational.recordlayer.query.Expression;
import com.apple.foundationdb.relational.recordlayer.query.Expressions;
import com.apple.foundationdb.relational.recordlayer.query.Identifier;
import com.apple.foundationdb.relational.recordlayer.query.Literals;
import com.apple.foundationdb.relational.recordlayer.query.LogicalOperator;
import com.apple.foundationdb.relational.recordlayer.query.LogicalOperators;
import com.apple.foundationdb.relational.recordlayer.query.LogicalPlanFragment;
import com.apple.foundationdb.relational.recordlayer.query.OrderByExpression;
import com.apple.foundationdb.relational.recordlayer.query.ParseHelpers;
import com.apple.foundationdb.relational.recordlayer.query.QueryPlan;
import com.apple.foundationdb.relational.recordlayer.query.SemanticAnalyzer;
import com.apple.foundationdb.relational.recordlayer.query.StringTrieNode;
import com.apple.foundationdb.relational.recordlayer.query.visitors.BaseVisitor;
import com.apple.foundationdb.relational.recordlayer.query.visitors.DelegatingVisitor;
import com.apple.foundationdb.relational.recordlayer.util.MemoizedFunction;
import com.apple.foundationdb.relational.recordlayer.util.TypeUtils;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;

@API(value=API.Status.EXPERIMENTAL)
public final class QueryVisitor
extends DelegatingVisitor<BaseVisitor> {
    private QueryVisitor(@Nonnull BaseVisitor baseVisitor) {
        super(baseVisitor);
    }

    @Nonnull
    public static QueryVisitor of(@Nonnull BaseVisitor baseVisitor) {
        return new QueryVisitor(baseVisitor);
    }

    @Override
    @Nonnull
    public QueryPlan.LogicalQueryPlan visitSelectStatement(@Nonnull RelationalParser.SelectStatementContext ctx) {
        LogicalOperator logicalOperator = this.parseChild(ctx);
        return QueryPlan.LogicalQueryPlan.of(logicalOperator.getQuantifier().getRangesOver().get(), ((BaseVisitor)this.getDelegate()).getPlanGenerationContext(), "TODO");
    }

    @Override
    @Nonnull
    public QueryPlan.LogicalQueryPlan visitDmlStatement(@Nonnull RelationalParser.DmlStatementContext ctx) {
        LogicalOperator logicalOperator = this.parseChild(ctx);
        return QueryPlan.LogicalQueryPlan.of(logicalOperator.getQuantifier().getRangesOver().get(), ((BaseVisitor)this.getDelegate()).getPlanGenerationContext(), "TODO");
    }

    @Override
    @Nonnull
    public LogicalOperator visitQuery(@Nonnull RelationalParser.QueryContext ctx) {
        if (ctx.continuation() != null) {
            Expression continuationExpression = this.visitContinuation(ctx.continuation());
            LiteralValue continuationValue = Assert.castUnchecked(continuationExpression.getUnderlying(), LiteralValue.class);
            ByteString continuationBytes = Assert.castUnchecked(continuationValue.getLiteralValue(), ByteString.class);
            ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().setContinuation(continuationBytes.toByteArray());
        }
        if (ctx.ctes() != null) {
            LogicalPlanFragment currentPlanFragment = ((BaseVisitor)this.getDelegate()).pushPlanFragment();
            this.visitCtes(ctx.ctes()).forEach(currentPlanFragment::addOperator);
            LogicalOperator result = Assert.castUnchecked(ctx.queryExpressionBody().accept(this), LogicalOperator.class);
            ((BaseVisitor)this.getDelegate()).popPlanFragment();
            return ((BaseVisitor)this.getDelegate()).isTopLevel() ? LogicalOperator.generateSort(result, ImmutableList.of(), ImmutableSet.of(), Optional.empty()) : result;
        }
        return Assert.castUnchecked(ctx.queryExpressionBody().accept(this), LogicalOperator.class);
    }

    @Override
    @Nonnull
    public LogicalOperators visitCtes(@Nonnull RelationalParser.CtesContext ctx) {
        if (ctx.RECURSIVE() != null) {
            RecursiveUnionExpression.TraversalStrategy traversalStrategy;
            if (ctx.traversalOrderClause() != null) {
                RelationalParser.TraversalOrderClauseContext order = ctx.traversalOrderClause();
                if (order.LEVEL_ORDER() != null) {
                    traversalStrategy = RecursiveUnionExpression.TraversalStrategy.LEVEL;
                } else if (order.PRE_ORDER() != null) {
                    traversalStrategy = RecursiveUnionExpression.TraversalStrategy.PREORDER;
                } else {
                    traversalStrategy = RecursiveUnionExpression.TraversalStrategy.ANY;
                    Assert.failUnchecked(ErrorCode.INTERNAL_ERROR, "Unsupported traversal " + order.getText());
                }
            } else {
                traversalStrategy = RecursiveUnionExpression.TraversalStrategy.ANY;
            }
            return LogicalOperators.of(ctx.namedQuery().stream().map(namedQuery -> this.handleRecursiveNamedQuery((RelationalParser.NamedQueryContext)namedQuery, traversalStrategy)).collect(ImmutableList.toImmutableList()));
        }
        Assert.thatUnchecked(ctx.traversalOrderClause() == null, ErrorCode.SYNTAX_ERROR, "traversal order claude can only be defined with recursive CTE");
        return LogicalOperators.of(ctx.namedQuery().stream().map(this::visitNamedQuery).collect(ImmutableList.toImmutableList()));
    }

    @Override
    @Nonnull
    public LogicalOperator visitNamedQuery(@Nonnull RelationalParser.NamedQueryContext ctx) {
        Identifier queryName = this.visitFullId(ctx.name);
        LogicalOperator logicalOperator = this.visitQuery(ctx.query());
        if (ctx.columnAliases != null) {
            Object columnAliases = this.visitFullIdList(ctx.columnAliases);
            SemanticAnalyzer.validateCteColumnAliases(logicalOperator, (List<Identifier>)columnAliases);
            Expressions expressions = logicalOperator.getOutput().expanded();
            Expressions expressionsWithNewNames = Expressions.of(Streams.zip(expressions.stream(), columnAliases.stream(), Expression::withName).collect(ImmutableList.toImmutableList()));
            logicalOperator = logicalOperator.withOutput(expressionsWithNewNames);
        }
        return logicalOperator.withName(queryName);
    }

    @Nonnull
    public LogicalOperator handleRecursiveNamedQuery(@Nonnull RelationalParser.NamedQueryContext recursiveQueryContext, @Nonnull RecursiveUnionExpression.TraversalStrategy traversalStrategy) {
        Identifier queryName = this.visitFullId(recursiveQueryContext.name);
        Function<ParserRuleContext, LogicalOperators> memoized = MemoizedFunction.memoize(parserRuleContext -> {
            Object result = parserRuleContext.accept(this);
            if (result instanceof LogicalOperator) {
                return LogicalOperators.ofSingle((LogicalOperator)result);
            }
            return Assert.castUnchecked(result, LogicalOperators.class);
        });
        ((BaseVisitor)this.getDelegate()).pushPlanFragment();
        Optional<Type> recursiveQueryType = ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer().getRecursiveCteType(recursiveQueryContext.query(), queryName, ((BaseVisitor)this.getDelegate())::visitFullId, memoized, this);
        ((BaseVisitor)this.getDelegate()).popPlanFragment();
        Assert.thatUnchecked(recursiveQueryType.isPresent(), ErrorCode.INVALID_RECURSION, "recursive CTE does not contain non-recursive term");
        Type type = recursiveQueryType.get();
        LogicalPlanFragment currentPlanFragment = ((BaseVisitor)this.getDelegate()).pushPlanFragment();
        Identifier scanId = Identifier.of(String.valueOf(queryName) + "forScan");
        currentPlanFragment.addOperator(LogicalOperator.newTemporaryTableScan(queryName, scanId, type));
        NonnullPair<List<LogicalOperator>, List<LogicalOperator>> partitions = ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer().partitionRecursiveQuery(recursiveQueryContext.query(), queryName, ((BaseVisitor)this.getDelegate())::visitFullId, memoized, this);
        List<LogicalOperator> nonRecursiveBranches = partitions.getLeft();
        List<LogicalOperator> recursiveBranches = partitions.getRight();
        ((BaseVisitor)this.getDelegate()).popPlanFragment();
        if (recursiveBranches.isEmpty()) {
            return this.visitNamedQuery(recursiveQueryContext);
        }
        Set outerCorrelations = ((BaseVisitor)this.getDelegate()).getCurrentPlanFragmentMaybe().map(LogicalPlanFragment::getOuterCorrelations).orElse(ImmutableSet.of());
        LogicalOperator initialLeg = LogicalOperator.generateUnionAll(LogicalOperators.of(nonRecursiveBranches), outerCorrelations);
        LogicalOperator recursiveLeg = LogicalOperator.generateUnionAll(LogicalOperators.of(recursiveBranches), outerCorrelations);
        Identifier insertTempTableId = Identifier.of(queryName.getName() + "forInsert");
        LogicalOperator initialLegInsert = LogicalOperator.newTemporaryTableInsert(initialLeg, insertTempTableId, type);
        LogicalOperator recursiveLegInsert = LogicalOperator.newTemporaryTableInsert(recursiveLeg, insertTempTableId, type);
        RecursiveUnionExpression recursiveUnion = new RecursiveUnionExpression(initialLegInsert.getQuantifier(), recursiveLegInsert.getQuantifier(), CorrelationIdentifier.of(scanId.getName()), CorrelationIdentifier.of(insertTempTableId.getName()), traversalStrategy);
        Quantifier.ForEach quantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)recursiveUnion));
        LogicalOperator logicalOperator = LogicalOperator.newNamedOperator(queryName, Expressions.fromQuantifier(quantifier), quantifier);
        if (recursiveQueryContext.columnAliases != null) {
            Object columnAliases = this.visitFullIdList(recursiveQueryContext.columnAliases);
            SemanticAnalyzer.validateCteColumnAliases(logicalOperator, (List<Identifier>)columnAliases);
            Expressions expressions = logicalOperator.getOutput().expanded();
            Expressions expressionsWithNewNames = Expressions.of(Streams.zip(expressions.stream(), columnAliases.stream(), Expression::withName).collect(ImmutableList.toImmutableList()));
            logicalOperator = logicalOperator.withOutput(expressionsWithNewNames);
        }
        return logicalOperator;
    }

    @Override
    @Nonnull
    public LogicalOperator visitSimpleTable(@Nonnull RelationalParser.SimpleTableContext simpleTableContext) {
        Expressions selectExpressions;
        Set<CorrelationIdentifier> outerCorrelations;
        Assert.notNullUnchecked(simpleTableContext.fromClause(), ErrorCode.UNSUPPORTED_QUERY, "query is not supported");
        ((BaseVisitor)this.getDelegate()).pushPlanFragment();
        simpleTableContext.fromClause().accept(this);
        Optional<Object> where = Optional.ofNullable(simpleTableContext.fromClause().whereExpr() == null ? null : this.visitWhereExpr(simpleTableContext.fromClause().whereExpr()));
        List<OrderByExpression> orderBys = List.of();
        if (simpleTableContext.groupByClause() != null || this.hasAggregations(simpleTableContext.selectElements())) {
            outerCorrelations = ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().getOuterCorrelations();
            LogicalOperator selectWhere = LogicalOperator.generateSelectWhere(((BaseVisitor)this.getDelegate()).getLogicalOperators(), outerCorrelations, where, ((BaseVisitor)this.getDelegate()).isForDdl());
            ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().setOperator(selectWhere);
            Expressions groupByExpressions = simpleTableContext.groupByClause() == null ? Expressions.empty() : this.visitGroupByClause(simpleTableContext.groupByClause());
            List aliasedGroupByColumns = groupByExpressions.stream().filter(expression -> expression instanceof EphemeralExpression).collect(ImmutableList.toImmutableList());
            if (!aliasedGroupByColumns.isEmpty()) {
                LogicalOperator selectWhereWithExtraColumns = selectWhere.withAdditionalOutput(Expressions.of(aliasedGroupByColumns));
                ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().setOperator(selectWhereWithExtraColumns);
                selectExpressions = this.visitSelectElements(simpleTableContext.selectElements());
                where = Optional.ofNullable(simpleTableContext.havingClause() == null ? null : this.visitHavingClause(simpleTableContext.havingClause()));
                ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().setOperator(selectWhere);
            } else {
                selectExpressions = this.visitSelectElements(simpleTableContext.selectElements());
                where = Optional.ofNullable(simpleTableContext.havingClause() == null ? null : this.visitHavingClause(simpleTableContext.havingClause()));
            }
            outerCorrelations = ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().getOuterCorrelations();
            Literals literals = ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().getLiterals();
            LogicalOperator groupBy = LogicalOperator.generateGroupBy(((BaseVisitor)this.getDelegate()).getLogicalOperators(), groupByExpressions, selectExpressions, where, outerCorrelations, literals);
            if (groupByExpressions.isEmpty() && !((BaseVisitor)this.getDelegate()).isForDdl()) {
                selectExpressions = LogicalOperator.adjustCountOnEmpty(selectExpressions);
            }
            selectExpressions = selectExpressions.dereferenced(literals).expanded().pullUp(Expression.ofUnnamed(groupBy.getQuantifier().getRangesOver().get().getResultValue()).dereferenced(literals).getSingleItem().getUnderlying(), groupBy.getQuantifier().getAlias(), outerCorrelations).clearQualifier();
            Set<CorrelationIdentifier> finalOuterCorrelation = outerCorrelations;
            where = where.map(predicate -> predicate.pullUp(groupBy.getQuantifier().getRangesOver().get().getResultValue(), groupBy.getQuantifier().getAlias(), finalOuterCorrelation));
            if (simpleTableContext.orderByClause() != null) {
                List<OrderByExpression> resolvedOrderBys = this.visitOrderByClauseForSelect(simpleTableContext.orderByClause(), selectExpressions);
                orderBys = OrderByExpression.pullUp(resolvedOrderBys.stream(), groupBy.getQuantifier().getRangesOver().get().getResultValue(), groupBy.getQuantifier().getAlias(), outerCorrelations, Optional.empty()).collect(ImmutableList.toImmutableList());
            }
            ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().setOperator(groupBy);
        } else {
            selectExpressions = this.visitSelectElements(simpleTableContext.selectElements());
            if (simpleTableContext.orderByClause() != null) {
                orderBys = this.visitOrderByClauseForSelect(simpleTableContext.orderByClause(), selectExpressions);
            }
        }
        outerCorrelations = ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().getOuterCorrelations();
        LogicalOperator result = LogicalOperator.generateSelect(selectExpressions, ((BaseVisitor)this.getDelegate()).getLogicalOperators(), where, orderBys, Optional.empty(), outerCorrelations, ((BaseVisitor)this.getDelegate()).isTopLevel(), ((BaseVisitor)this.getDelegate()).isForDdl());
        ((BaseVisitor)this.getDelegate()).popPlanFragment();
        Assert.isNullUnchecked((Object)simpleTableContext.limitClause(), ErrorCode.UNSUPPORTED_QUERY, "limit not yet supported in SQL");
        return result;
    }

    @Override
    @Nonnull
    public LogicalOperator visitParenthesisQuery(@Nonnull RelationalParser.ParenthesisQueryContext ctx) {
        return this.visitQuery(ctx.query());
    }

    @Override
    @Nonnull
    public LogicalOperator visitQueryTermDefault(@Nonnull RelationalParser.QueryTermDefaultContext queryTermDefaultContext) {
        return this.parseChild(queryTermDefaultContext);
    }

    @Override
    @Nonnull
    public LogicalOperator visitSetQuery(@Nonnull RelationalParser.SetQueryContext setQueryContext) {
        Assert.thatUnchecked(setQueryContext.quantifier != null && setQueryContext.quantifier.getType() == 6, ErrorCode.UNSUPPORTED_QUERY, "only UNION ALL is supported");
        ImmutableList<LogicalOperator> unionLegs = ImmutableList.of(Assert.castUnchecked(this.visit(setQueryContext.left), LogicalOperator.class), Assert.castUnchecked(this.visit(setQueryContext.right), LogicalOperator.class));
        return LogicalOperator.generateUnionAll(LogicalOperators.of(unionLegs), ((BaseVisitor)this.getDelegate()).getCurrentPlanFragmentMaybe().map(LogicalPlanFragment::getOuterCorrelations).orElse(ImmutableSet.of()));
    }

    @Override
    @Nullable
    public Void visitFromClause(@Nonnull RelationalParser.FromClauseContext fromClauseContext) {
        fromClauseContext.tableSources().accept(this);
        return null;
    }

    @Override
    @Nullable
    public Void visitTableSources(@Nonnull RelationalParser.TableSourcesContext ctx) {
        for (RelationalParser.TableSourceContext tableSource : ctx.tableSource()) {
            LogicalOperator logicalOperator = Assert.castUnchecked(tableSource.accept(this), LogicalOperator.class);
            ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().addOperator(logicalOperator);
        }
        return null;
    }

    @Override
    @Nonnull
    public LogicalOperator visitTableSourceBase(@Nonnull RelationalParser.TableSourceBaseContext ctx) {
        Assert.thatUnchecked(ctx.joinPart().isEmpty(), "explicit join types are not supported");
        return Assert.castUnchecked(ctx.tableSourceItem().accept(this), LogicalOperator.class);
    }

    @Override
    @Nonnull
    public LogicalOperator visitAtomTableItem(@Nonnull RelationalParser.AtomTableItemContext atomTableItemContext) {
        Identifier tableIdentifier = Assert.castUnchecked(atomTableItemContext.tableName().accept(this), Identifier.class);
        Optional<Identifier> tableAlias = Optional.of(atomTableItemContext.alias == null ? this.visitTableName(atomTableItemContext.tableName()) : this.visitUid(atomTableItemContext.alias));
        ImmutableSet<String> requestedIndexes = atomTableItemContext.indexHint().stream().flatMap(indexHint -> this.visitIndexHint((RelationalParser.IndexHintContext)indexHint).stream()).collect(ImmutableSet.toImmutableSet());
        return LogicalOperator.generateAccess(tableIdentifier, tableAlias, requestedIndexes, ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer(), ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment(), ((BaseVisitor)this.getDelegate()).getLogicalOperatorCatalog());
    }

    @Override
    @Nonnull
    public LogicalOperator visitSubqueryTableItem(@Nonnull RelationalParser.SubqueryTableItemContext subqueryTableItemContext) {
        Identifier alias = Assert.castUnchecked(subqueryTableItemContext.alias.accept(this), Identifier.class);
        LogicalOperator selectOperator = this.visitQuery(subqueryTableItemContext.query());
        return selectOperator.withName(alias);
    }

    @Override
    @Nonnull
    public LogicalOperator visitInlineTableItem(@Nonnull RelationalParser.InlineTableItemContext inlineTableItemContext) {
        Expression rowExpression;
        Object typeMaybe = null;
        if (inlineTableItemContext.inlineTableDefinition() != null) {
            typeMaybe = this.visitInlineTableDefinition(inlineTableItemContext.inlineTableDefinition());
            Assert.thatUnchecked(!inlineTableItemContext.recordConstructorForInlineTable().isEmpty());
            Type type = null;
            for (RelationalParser.RecordConstructorForInlineTableContext inlineTableContext : inlineTableItemContext.recordConstructorForInlineTable()) {
                rowExpression = ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().withDisabledLiteralProcessing(() -> this.visitRecordConstructorForInlineTable(inlineTableContext));
                type = type == null ? rowExpression.getUnderlying().getResultType() : Type.maximumType(type, rowExpression.getUnderlying().getResultType());
            }
            Iterator<RelationalParser.RecordConstructorForInlineTableContext> actualInlineTableType = type;
            Type inlineTypedWithNames = TypeUtils.setFieldNames(actualInlineTableType, (CompatibleTypeEvolutionPredicate.FieldAccessTrieNode)((NonnullPair)typeMaybe).getRight());
            Assert.thatUnchecked(inlineTypedWithNames.isRecord());
            LogicalPlanFragment.State.Builder stateBuilder = LogicalPlanFragment.State.newBuilder().withTargetType(inlineTypedWithNames);
            ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().setState(stateBuilder.build());
        }
        ImmutableList.Builder rowExpressionBuilder = ImmutableList.builder();
        for (RelationalParser.RecordConstructorForInlineTableContext inlineTableContext : inlineTableItemContext.recordConstructorForInlineTable()) {
            rowExpression = this.visitRecordConstructorForInlineTable(inlineTableContext);
            rowExpressionBuilder.add(rowExpression);
        }
        Expression[] arguments = Expressions.of(rowExpressionBuilder.build()).asList().toArray(new Expression[0]);
        Expression arrayOfTuples = ((BaseVisitor)this.getDelegate()).resolveFunction("__internal_array", false, arguments);
        ExplodeExpression explodeExpression = new ExplodeExpression(arrayOfTuples.getUnderlying());
        Quantifier.ForEach resultingQuantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)explodeExpression));
        Expressions output = Expressions.of(LogicalOperator.convertToExpressions(resultingQuantifier));
        return typeMaybe == null ? LogicalOperator.newUnnamedOperator(output, resultingQuantifier) : LogicalOperator.newNamedOperator(Identifier.of((String)((NonnullPair)typeMaybe).getLeft()), output, resultingQuantifier);
    }

    @Override
    public LogicalOperator visitTableValuedFunction(@Nonnull RelationalParser.TableValuedFunctionContext tableValuedFunctionContext) {
        LogicalOperator logicalOperator = this.visitTableFunction(tableValuedFunctionContext.tableFunction());
        Optional<Object> aliasMaybe = Optional.ofNullable(tableValuedFunctionContext.uid() == null ? null : this.visitUid(tableValuedFunctionContext.uid()));
        return aliasMaybe.map(logicalOperator::withName).orElse(logicalOperator);
    }

    @Override
    @Nonnull
    public Set<String> visitIndexHint(@Nonnull RelationalParser.IndexHintContext indexHintContext) {
        Assert.isNullUnchecked(indexHintContext.IGNORE(), "index hint 'ignore' semantics not supported");
        Assert.isNullUnchecked(indexHintContext.FORCE(), "index hint 'force' semantics not supported");
        Assert.isNullUnchecked(indexHintContext.KEY(), "index hint 'key' not supported");
        Assert.isNullUnchecked(indexHintContext.FOR(), "index hint 'for' not supported");
        return indexHintContext.uidList().uid().stream().map(this::visitUid).map(Identifier::getName).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Nonnull
    public LogicalOperator visitInsertStatement(@Nonnull RelationalParser.InsertStatementContext ctx) {
        LogicalOperator insertSource;
        Identifier table = this.visitTableName(ctx.tableName());
        Table tableType = ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer().getTable(table);
        Type.Record targetType = Assert.castUnchecked(tableType, RecordLayerTable.class).getType();
        ((BaseVisitor)this.getDelegate()).pushPlanFragment();
        int lookahead = ctx.insertStatementValue().start.getType();
        boolean isInsertFromSelect = lookahead == 151;
        Assert.thatUnchecked(!isInsertFromSelect || ctx.columns == null, ErrorCode.UNSUPPORTED_QUERY, "setting column ordering for insert with select is not supported");
        if (isInsertFromSelect) {
            insertSource = Assert.castUnchecked(ctx.insertStatementValue().accept(this), LogicalOperator.class);
        } else {
            LogicalPlanFragment.State.Builder stateBuilder = LogicalPlanFragment.State.newBuilder().withTargetType(targetType);
            if (ctx.columns != null) {
                stateBuilder.withTargetTypeReorderings(QueryVisitor.toString(this.visitUidListWithNestingsInParens(ctx.columns)));
            }
            ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().setState(stateBuilder.build());
            insertSource = Assert.castUnchecked(ctx.insertStatementValue().accept(this), LogicalOperator.class);
        }
        LogicalOperator resultingInsert = LogicalOperator.generateInsert(insertSource, tableType);
        ((BaseVisitor)this.getDelegate()).popPlanFragment();
        return resultingInsert;
    }

    @Nonnull
    private static StringTrieNode toString(@Nonnull CompatibleTypeEvolutionPredicate.FieldAccessTrieNode fieldAccessTrieNode) {
        if (fieldAccessTrieNode.getChildrenMap() == null) {
            return StringTrieNode.leafNode();
        }
        ImmutableMap<String, StringTrieNode> map = fieldAccessTrieNode.getChildrenMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(pair -> ((FieldValue.ResolvedAccessor)pair.getKey()).getName(), pair -> QueryVisitor.toString((CompatibleTypeEvolutionPredicate.FieldAccessTrieNode)pair.getValue())));
        return new StringTrieNode(map);
    }

    @Override
    @Nonnull
    public LogicalOperator visitInsertStatementValueSelect(@Nonnull RelationalParser.InsertStatementValueSelectContext ctx) {
        return Assert.castUnchecked(ctx.queryExpressionBody().accept(this), LogicalOperator.class);
    }

    @Override
    @Nonnull
    public LogicalOperator visitInsertStatementValueValues(@Nonnull RelationalParser.InsertStatementValueValuesContext ctx) {
        ImmutableList.Builder insertTuples = ImmutableList.builder();
        for (RelationalParser.RecordConstructorForInsertContext tupleContext : ctx.recordConstructorForInsert()) {
            insertTuples.add(this.visitRecordConstructorForInsert(tupleContext));
        }
        Expression[] arguments = Expressions.of(insertTuples.build()).asList().toArray(new Expression[0]);
        Expression arrayOfTuples = ((BaseVisitor)this.getDelegate()).resolveFunction("__internal_array", false, arguments);
        ExplodeExpression explodeExpression = new ExplodeExpression(arrayOfTuples.getUnderlying());
        Quantifier.ForEach resultingQuantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)explodeExpression));
        return LogicalOperator.newUnnamedOperator(Expressions.ofSingle(arrayOfTuples), resultingQuantifier);
    }

    @Override
    @Nonnull
    public LogicalOperator visitUpdateStatement(@Nonnull RelationalParser.UpdateStatementContext ctx) {
        Identifier tableId = this.visitFullId(ctx.tableName().fullId());
        SemanticAnalyzer semanticAnalyzer = ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer();
        Table table = semanticAnalyzer.getTable(tableId);
        Type.Record tableType = Assert.castUnchecked(table, RecordLayerTable.class).getType();
        LogicalOperator tableAccess = ((BaseVisitor)this.getDelegate()).getLogicalOperatorCatalog().lookupTableAccess(tableId, semanticAnalyzer);
        ((BaseVisitor)this.getDelegate()).pushPlanFragment().setOperator(tableAccess);
        Expressions output = Expressions.ofSingle(semanticAnalyzer.expandStar(Optional.empty(), ((BaseVisitor)this.getDelegate()).getLogicalOperators()));
        Optional<Expression> whereMaybe = ctx.whereExpr() == null ? Optional.empty() : Optional.of(this.visitWhereExpr(ctx.whereExpr()));
        LogicalOperator updateSource = LogicalOperator.generateSimpleSelect(output, ((BaseVisitor)this.getDelegate()).getLogicalOperators(), whereMaybe, Optional.of(tableId), ImmutableSet.of(), false);
        ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().setOperator(updateSource);
        ImmutableMap.Builder<FieldValue.FieldPath, Value> transformMapBuilder = ImmutableMap.builder();
        for (RelationalParser.UpdatedElementContext updatedElementCtx : ctx.updatedElement()) {
            List<Expression> targetAndUpdateExpressions = this.visitUpdatedElement(updatedElementCtx).asList();
            FieldValue.FieldPath target = Assert.castUnchecked(targetAndUpdateExpressions.get(0).getUnderlying(), FieldValue.class).getFieldPath();
            Value update = targetAndUpdateExpressions.get(1).getUnderlying();
            transformMapBuilder.put(target, update);
        }
        UpdateExpression updateExpression = new UpdateExpression(Assert.castUnchecked(updateSource.getQuantifier(), Quantifier.ForEach.class), table.getName(), tableType, transformMapBuilder.build());
        Quantifier.ForEach updateQuantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)updateExpression));
        LogicalOperator resultingUpdate = LogicalOperator.newUnnamedOperator(Expressions.fromQuantifier(updateQuantifier), updateQuantifier);
        ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().setOperator(resultingUpdate);
        if (ctx.RETURNING() != null) {
            Expressions selectExpressions = this.visitSelectElements(ctx.selectElements());
            LogicalOperator result = LogicalOperator.generateSelect(selectExpressions, ((BaseVisitor)this.getDelegate()).getLogicalOperators(), Optional.empty(), List.of(), Optional.empty(), ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().getOuterCorrelations(), ((BaseVisitor)this.getDelegate()).isTopLevel(), false);
            ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().setOperator(result);
            return result;
        }
        LogicalOperator result = LogicalOperator.generateSort(resultingUpdate, List.of(), Set.of(), Optional.empty());
        ((BaseVisitor)this.getDelegate()).popPlanFragment();
        return result;
    }

    @Override
    @Nonnull
    public LogicalOperator visitDeleteStatement(@Nonnull RelationalParser.DeleteStatementContext ctx) {
        Assert.thatUnchecked(ctx.limitClause() == null, "limit is not supported");
        Identifier tableId = this.visitFullId(ctx.tableName().fullId());
        SemanticAnalyzer semanticAnalyzer = ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer();
        Table table = semanticAnalyzer.getTable(tableId);
        LogicalOperator tableAccess = ((BaseVisitor)this.getDelegate()).getLogicalOperatorCatalog().lookupTableAccess(tableId, semanticAnalyzer);
        ((BaseVisitor)this.getDelegate()).pushPlanFragment().setOperator(tableAccess);
        Expressions output = Expressions.ofSingle(semanticAnalyzer.expandStar(Optional.empty(), ((BaseVisitor)this.getDelegate()).getLogicalOperators()));
        Optional<Expression> whereMaybe = ctx.whereExpr() == null ? Optional.empty() : Optional.of(this.visitWhereExpr(ctx.whereExpr()));
        LogicalOperator deleteSource = LogicalOperator.generateSimpleSelect(output, ((BaseVisitor)this.getDelegate()).getLogicalOperators(), whereMaybe, Optional.of(tableId), ImmutableSet.of(), false);
        DeleteExpression deleteExpression = new DeleteExpression(Assert.castUnchecked(deleteSource.getQuantifier(), Quantifier.ForEach.class), table.getName());
        Quantifier.ForEach deleteQuantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)deleteExpression));
        LogicalOperator resultingDelete = LogicalOperator.newUnnamedOperator(Expressions.fromQuantifier(deleteQuantifier), deleteQuantifier);
        ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().setOperator(resultingDelete);
        if (ctx.RETURNING() != null) {
            Expressions selectExpressions = this.visitSelectElements(ctx.selectElements());
            LogicalOperator result = LogicalOperator.generateSelect(selectExpressions, ((BaseVisitor)this.getDelegate()).getLogicalOperators(), Optional.empty(), List.of(), Optional.empty(), ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().getOuterCorrelations(), ((BaseVisitor)this.getDelegate()).isTopLevel(), false);
            ((BaseVisitor)this.getDelegate()).getCurrentPlanFragment().setOperator(result);
            return result;
        }
        LogicalOperator result = LogicalOperator.generateSort(resultingDelete, List.of(), Set.of(), Optional.empty());
        ((BaseVisitor)this.getDelegate()).popPlanFragment();
        return result;
    }

    @Override
    @Nonnull
    public Object visitExecuteContinuationStatement(@Nonnull RelationalParser.ExecuteContinuationStatementContext ctx) {
        throw Assert.failUnchecked("execute package should not be handled here");
    }

    @Override
    @Nonnull
    public QueryPlan.LogicalQueryPlan visitFullDescribeStatement(@Nonnull RelationalParser.FullDescribeStatementContext ctx) {
        ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().setForExplain(ctx.EXPLAIN() != null);
        LogicalOperator logicalOperator = Assert.castUnchecked(ctx.describeObjectClause().accept(this), LogicalOperator.class);
        return QueryPlan.LogicalQueryPlan.of(logicalOperator.getQuantifier().getRangesOver().get(), ((BaseVisitor)this.getDelegate()).getPlanGenerationContext(), "TODO");
    }

    @Override
    @Nonnull
    public LogicalOperator visitDescribeStatements(@Nonnull RelationalParser.DescribeStatementsContext ctx) {
        return this.parseChild(ctx);
    }

    @Override
    @Nonnull
    public Object visitDescribeConnection(@Nonnull RelationalParser.DescribeConnectionContext ctx) {
        throw Assert.failUnchecked(ErrorCode.UNSUPPORTED_QUERY, "query is not supported");
    }

    @Nonnull
    private LogicalOperator parseChild(ParserRuleContext context) {
        return Assert.castUnchecked(this.visitChildren(context), LogicalOperator.class);
    }

    @Nonnull
    public List<OrderByExpression> visitOrderByClauseForSelect(@Nonnull RelationalParser.OrderByClauseContext orderByClauseContext, @Nonnull Expressions visibleSelectAliases) {
        Expressions validSelectAliases = Expressions.of(visibleSelectAliases.stream().filter(expr -> expr.getName().isPresent() && !expr.getName().get().isQualified()).collect(ImmutableList.toImmutableList()));
        if (validSelectAliases.isEmpty()) {
            return this.visitOrderByClause(orderByClauseContext);
        }
        if (!((BaseVisitor)this.getDelegate()).isTopLevel()) {
            Assert.failUnchecked(ErrorCode.UNSUPPORTED_OPERATION, "order by is not supported in subquery");
        }
        ImmutableList.Builder orderBysBuilder = ImmutableList.builder();
        SemanticAnalyzer semanticAnalyzer = ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer();
        for (RelationalParser.OrderByExpressionContext orderByExpression : orderByClauseContext.orderByExpression()) {
            Optional<RelationalParser.FullIdContext> isAliasMaybe = QueryVisitor.isAliasMaybe(orderByExpression);
            Optional matchingExpressionMaybe = isAliasMaybe.flatMap(alias -> semanticAnalyzer.lookupAlias(this.visitFullId((RelationalParser.FullIdContext)alias), validSelectAliases));
            matchingExpressionMaybe.ifPresentOrElse(matchingExpression -> {
                boolean descending = ParseHelpers.isDescending(orderByExpression);
                boolean nullsLast = ParseHelpers.isNullsLast(orderByExpression, descending);
                orderBysBuilder.add(OrderByExpression.of(matchingExpression, descending, nullsLast));
            }, () -> orderBysBuilder.add(this.visitOrderByExpression(orderByExpression)));
        }
        ImmutableCollection orderBys = orderBysBuilder.build();
        ((BaseVisitor)this.getDelegate()).getSemanticAnalyzer().validateOrderByColumns(orderBys);
        return orderBys;
    }

    private boolean hasAggregations(@Nonnull RelationalParser.SelectElementsContext selectElementsContext) {
        return ((BaseVisitor)this.getDelegate()).getPlanGenerationContext().withDisabledLiteralProcessing(() -> Streams.stream(this.visitSelectElements(selectElementsContext)).anyMatch(expression -> !Iterables.isEmpty(Expression.Utils.filterUnderlyingAggregates(expression))));
    }

    @Nonnull
    private static Optional<RelationalParser.FullIdContext> isAliasMaybe(@Nonnull RelationalParser.OrderByExpressionContext orderByExpressionContext) {
        if (!(orderByExpressionContext.expression() instanceof RelationalParser.PredicatedExpressionContext)) {
            return Optional.empty();
        }
        RelationalParser.PredicatedExpressionContext predicatedExpression = (RelationalParser.PredicatedExpressionContext)orderByExpressionContext.expression();
        if (predicatedExpression.predicate() != null) {
            return Optional.empty();
        }
        RelationalParser.ExpressionAtomContext atomExpression = predicatedExpression.expressionAtom();
        if (!(atomExpression instanceof RelationalParser.FullColumnNameExpressionAtomContext)) {
            return Optional.empty();
        }
        RelationalParser.FullColumnNameExpressionAtomContext fullColumnNameContext = (RelationalParser.FullColumnNameExpressionAtomContext)atomExpression;
        return Optional.of(fullColumnNameContext.fullColumnName().fullId());
    }
}

