/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.storage;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.ResolverStateProto;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.LocatableResolver;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverCreateHooks;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverResult;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.InternalErrorException;
import com.apple.foundationdb.relational.api.exceptions.OperationUnsupportedException;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.MessageTuple;
import com.apple.foundationdb.relational.recordlayer.QueryPropertiesUtils;
import com.apple.foundationdb.relational.recordlayer.storage.BackingStore;
import com.apple.foundationdb.relational.recordlayer.storage.LocatableResolverMetaDataProvider;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class BackingLocatableResolverStore
implements BackingStore {
    private final LocatableResolver locatableResolver;
    private final Transaction txn;
    private final LocatableResolverMetaDataProvider metaDataProvider;

    private BackingLocatableResolverStore(LocatableResolver locatableResolver, Transaction txn, LocatableResolverMetaDataProvider metaDataProvider) {
        this.locatableResolver = locatableResolver;
        this.txn = txn;
        this.metaDataProvider = metaDataProvider;
    }

    @Override
    @Nullable
    public Row get(Row key, Options options) throws RelationalException {
        try {
            FDBRecordContext context = this.txn.unwrap(FDBRecordContext.class);
            Object typeKey = key.getObject(0);
            if (this.metaDataProvider.getInterningTypeKey().equals(typeKey)) {
                String name = key.getString(1);
                CompletableFuture<ResolverResult> resultFuture = this.locatableResolver.readInTransaction(context, name);
                ResolverResult result = context.asyncToSync(FDBStoreTimer.Waits.WAIT_DIRECTORY_RESOLVE, resultFuture);
                return result == null ? null : new MessageTuple(this.metaDataProvider.wrapResolverResult(name, result));
            }
            if (this.metaDataProvider.getResolverStateTypeKey().equals(typeKey)) {
                ResolverStateProto.State state = context.asyncToSync(FDBStoreTimer.Waits.WAIT_DIRECTORY_RESOLVE, this.locatableResolver.loadResolverState(context));
                return state == null ? null : new MessageTuple(this.metaDataProvider.wrapResolverState(state));
            }
            throw new TypeNotPresentException(String.valueOf(typeKey), null);
        }
        catch (RecordCoreException rce) {
            throw ExceptionUtil.toRelationalException(rce);
        }
    }

    @Override
    @Nullable
    public Row getFromIndex(Index index, Row key, Options options) throws RelationalException {
        if (!"reverse_interning".equals(index.getName())) {
            throw new InternalErrorException("invalid index for resolver store");
        }
        FDBRecordContext context = this.txn.unwrap(FDBRecordContext.class);
        long value = key.getLong(0);
        try {
            String name = context.asyncToSync(FDBStoreTimer.Waits.WAIT_REVERSE_DIRECTORY_LOOKUP, this.locatableResolver.reverseLookupInTransaction(context, value));
            if (name == null) {
                return null;
            }
            return new MessageTuple(this.metaDataProvider.wrapInterning(name, value, null));
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    @Override
    public boolean delete(Row key) throws RelationalException {
        throw new OperationUnsupportedException("Cannot delete entry from interning layer store");
    }

    @Override
    public void deleteRange(Map<String, Object> prefix, @Nullable String tableName) throws RelationalException {
        throw new OperationUnsupportedException("Cannot delete range from interning layer store");
    }

    @Override
    public boolean insert(String tableName, Message message, boolean replaceOnDuplicate) throws RelationalException {
        if ("Interning".equals(tableName)) {
            Descriptors.Descriptor interningDescriptor = message.getDescriptorForType();
            String name = (String)message.getField(interningDescriptor.findFieldByName("key"));
            long value = (Long)message.getField(interningDescriptor.findFieldByName("value"));
            ByteString metaDataByteString = (ByteString)message.getField(interningDescriptor.findFieldByName("meta_data"));
            byte[] metaData = metaDataByteString.isEmpty() ? null : metaDataByteString.toByteArray();
            FDBRecordContext context = this.txn.unwrap(FDBRecordContext.class);
            ResolverResult result = context.asyncToSync(FDBStoreTimer.Waits.WAIT_DIRECTORY_RESOLVE, this.locatableResolver.readInTransaction(context, name));
            if (result != null) {
                if (replaceOnDuplicate) {
                    throw new RelationalException("Cannot update table <" + tableName + "> as entry with key " + name + " already exists", ErrorCode.UNSUPPORTED_OPERATION);
                }
                throw new RelationalException("Duplicate primary key for message (" + String.valueOf(message) + ") on table <" + tableName + ">", ErrorCode.UNIQUE_CONSTRAINT_VIOLATION);
            }
            if (value != 0L) {
                throw new RelationalException("Must use automatically allocated value for " + tableName + " rows", ErrorCode.UNSUPPORTED_OPERATION);
            }
            ResolverCreateHooks.MetadataHook metadataHook = ignore -> metaData;
            ResolverCreateHooks createHooks = new ResolverCreateHooks(ResolverCreateHooks.DEFAULT_CHECK, metadataHook);
            context.asyncToSync(FDBStoreTimer.Waits.WAIT_DIRECTORY_RESOLVE, this.locatableResolver.createInTransaction(context, name, createHooks));
            return true;
        }
        if ("ResolverState".equals(tableName)) {
            if (!replaceOnDuplicate) {
                throw new RelationalException("Duplicate primary key for message (" + String.valueOf(message) + ") on table <" + tableName + ">", ErrorCode.UNIQUE_CONSTRAINT_VIOLATION);
            }
            Descriptors.Descriptor stateDescriptor = message.getDescriptorForType();
            int version = (Integer)message.getField(stateDescriptor.findFieldByName("version"));
            Descriptors.EnumValueDescriptor lockEnum = (Descriptors.EnumValueDescriptor)message.getField(stateDescriptor.findFieldByName("lock"));
            String lock = lockEnum == null ? null : lockEnum.getName();
            ResolverStateProto.State.Builder builder = ResolverStateProto.State.newBuilder().setVersion(version);
            if (lock != null) {
                builder.setLock(ResolverStateProto.WriteLock.valueOf(lock));
            }
            ResolverStateProto.State protoState = builder.build();
            FDBRecordContext context = this.txn.unwrap(FDBRecordContext.class);
            context.asyncToSync(FDBStoreTimer.Waits.WAIT_LOCATABLE_RESOLVER_MAPPING_COPY, this.locatableResolver.saveResolverState(context, protoState));
            return true;
        }
        throw new TypeNotPresentException(tableName, null);
    }

    @Override
    public RecordCursor<FDBStoredRecord<Message>> scanType(RecordType type, TupleRange range, @Nullable Continuation continuation, Options options) throws RelationalException {
        if (continuation != null && continuation.atEnd()) {
            return RecordCursor.empty();
        }
        FDBRecordContext context = this.txn.unwrap(FDBRecordContext.class);
        if (!range.equals(TupleRange.allOf(Tuple.from(type.getRecordTypeKey())))) {
            throw new InternalErrorException("unsupported range");
        }
        byte[] continuationBytes = continuation == null ? null : continuation.getExecutionState();
        ScanProperties scanProperties = QueryPropertiesUtils.getScanProperties(options);
        if (type.getName().equals("ResolverState")) {
            ExecuteProperties executeProperties = scanProperties.getExecuteProperties();
            return RecordCursor.fromFuture(context.getExecutor(), () -> this.locatableResolver.loadResolverState(context).thenApply(state -> {
                Message msg = this.metaDataProvider.wrapResolverState((ResolverStateProto.State)state);
                return FDBStoredRecord.newBuilder(msg).setRecordType(type).setPrimaryKey(TupleHelpers.EMPTY).build();
            }), continuationBytes).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
        }
        if (type.getName().equals("Interning")) {
            return this.locatableResolver.scan(context, continuationBytes, scanProperties).map(resolverKeyValue -> {
                Message msg = this.metaDataProvider.wrapResolverResult(resolverKeyValue.getKey(), resolverKeyValue.getValue());
                return FDBStoredRecord.newBuilder(msg).setRecordType(type).setPrimaryKey(Tuple.from(resolverKeyValue.getKey())).build();
            });
        }
        throw new TypeNotPresentException(type.getName(), null);
    }

    @Override
    public RecordCursor<IndexEntry> scanIndex(Index index, TupleRange range, @Nullable Continuation continuation, Options options) throws RelationalException {
        throw new OperationUnsupportedException("Cannot scan indexes in interning layer store");
    }

    @Override
    @Nonnull
    public RecordMetaData getRecordMetaData() {
        return this.metaDataProvider.getRecordMetaData();
    }

    @Override
    public <T> T unwrap(Class<T> type) throws InternalErrorException {
        if (LocatableResolver.class.isAssignableFrom(type)) {
            return type.cast(this.locatableResolver);
        }
        return BackingStore.super.unwrap(type);
    }

    public static BackingStore create(LocatableResolver resolver, Transaction txn) throws RelationalException {
        return new BackingLocatableResolverStore(resolver, txn, LocatableResolverMetaDataProvider.instance());
    }
}

