/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.storage;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorIterator;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexOrphanBehavior;
import com.apple.foundationdb.record.provider.foundationdb.RecordAlreadyExistsException;
import com.apple.foundationdb.record.provider.foundationdb.RecordStoreDoesNotExistException;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.expressions.RecordTypeKeyComparison;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.InternalErrorException;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.ContinuationImpl;
import com.apple.foundationdb.relational.recordlayer.MessageTuple;
import com.apple.foundationdb.relational.recordlayer.QueryPropertiesUtils;
import com.apple.foundationdb.relational.recordlayer.RecordStoreAndRecordContextTransaction;
import com.apple.foundationdb.relational.recordlayer.TupleUtils;
import com.apple.foundationdb.relational.recordlayer.storage.BackingStore;
import com.apple.foundationdb.relational.recordlayer.storage.StoreConfig;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import com.google.common.base.Throwables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class BackingRecordStore
implements BackingStore {
    private final Transaction transaction;
    private final FDBRecordStoreBase<Message> recordStore;

    private BackingRecordStore(Transaction transaction, FDBRecordStoreBase<Message> recordStore) {
        this.transaction = transaction;
        this.recordStore = recordStore;
    }

    @Override
    public <T> T unwrap(Class<T> type) throws InternalErrorException {
        if (FDBRecordStoreBase.class.isAssignableFrom(type)) {
            return type.cast(this.recordStore);
        }
        return BackingStore.super.unwrap(type);
    }

    @Override
    @Nullable
    public Row get(Row key, Options options) throws RelationalException {
        try {
            FDBStoredRecord<Message> storedRecord = this.recordStore.loadRecord(TupleUtils.toFDBTuple(key));
            if (storedRecord == null) {
                return null;
            }
            return new MessageTuple(storedRecord.getRecord());
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Row getFromIndex(Index index, Row key, Options options) throws RelationalException {
        ScanProperties scanProperties = QueryPropertiesUtils.getScanProperties(options);
        scanProperties = new ScanProperties(scanProperties.getExecuteProperties().setReturnedRowLimit(1), scanProperties.isReverse());
        try {
            IndexEntry entry;
            try (RecordCursorIterator<IndexEntry> indexEntryRecordCursor = this.recordStore.scanIndex(index, IndexScanType.BY_VALUE, TupleRange.allOf(TupleUtils.toFDBTuple(key)), null, scanProperties).asIterator();){
                if (!indexEntryRecordCursor.hasNext()) {
                    Row row = null;
                    return row;
                }
                entry = Objects.requireNonNull(indexEntryRecordCursor.next());
            }
            CompletableFuture<FDBIndexedRecord<Message>> indexRecord = this.recordStore.loadIndexEntryRecord(entry, IndexOrphanBehavior.ERROR);
            FDBIndexedRecord<Message> storedRecord = this.transaction.unwrap(FDBRecordContext.class).asyncToSync(FDBStoreTimer.Waits.WAIT_LOAD_RECORD, indexRecord);
            if (storedRecord != null) return new MessageTuple(storedRecord.getRecord());
            return null;
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
    }

    @Override
    public boolean delete(Row key) throws RelationalException {
        try {
            return this.recordStore.deleteRecord(TupleUtils.toFDBTuple(key));
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
    }

    @Override
    public void deleteRange(Map<String, Object> prefix, @Nullable String tableName) throws RelationalException {
        QueryComponent query;
        List queryFields = prefix.entrySet().stream().map(entry -> Query.field((String)entry.getKey()).equalsValue(entry.getValue())).collect(Collectors.toList());
        if (tableName != null) {
            queryFields.add(new RecordTypeKeyComparison(tableName));
        }
        switch (queryFields.size()) {
            case 0: {
                throw new RelationalException("Delete range with empty key range is only supported on tables with RecordTypeKeys", ErrorCode.INVALID_PARAMETER);
            }
            case 1: {
                query = (QueryComponent)queryFields.get(0);
                break;
            }
            default: {
                query = Query.and(queryFields);
            }
        }
        try {
            this.recordStore.deleteRecordsWhere(query);
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
    }

    @Override
    public boolean insert(String tableName, Message message, boolean replaceOnDuplicate) throws RelationalException {
        try {
            if (!this.recordStore.getRecordMetaData().getRecordType(tableName).getDescriptor().equals(message.getDescriptorForType())) {
                throw new RelationalException("type of message <" + String.valueOf(message.getClass()) + "> does not match the required type for table <" + tableName + ">", ErrorCode.INVALID_PARAMETER);
            }
            if (replaceOnDuplicate) {
                this.recordStore.saveRecord(message);
            } else {
                this.recordStore.insertRecord(message);
            }
        }
        catch (MetaDataException mde) {
            throw new RelationalException("type of message <" + String.valueOf(message.getClass()) + "> does not match the required type for table <" + tableName + ">", ErrorCode.INVALID_PARAMETER, mde);
        }
        catch (RecordAlreadyExistsException raee) {
            throw new RelationalException("Duplicate primary key for message (" + String.valueOf(message) + ") on table <" + tableName + ">", ErrorCode.UNIQUE_CONSTRAINT_VIOLATION);
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
        return true;
    }

    @Override
    public RecordCursor<FDBStoredRecord<Message>> scanType(RecordType type, TupleRange range, @Nullable Continuation continuation, Options options) throws RelationalException {
        try {
            ScanProperties scanProps = QueryPropertiesUtils.getScanProperties(options);
            return this.recordStore.scanRecords(range, continuation == null ? null : continuation.getExecutionState(), scanProps).filter(record -> type.equals(record.getRecordType()));
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
    }

    @Override
    public RecordCursor<IndexEntry> scanIndex(Index index, TupleRange range, @Nullable Continuation continuation, Options options) throws RelationalException {
        assert (continuation == null || continuation instanceof ContinuationImpl);
        try {
            return this.recordStore.scanIndex(index, IndexScanType.BY_VALUE, range, continuation == null ? null : continuation.getExecutionState(), QueryPropertiesUtils.getScanProperties(options));
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
    }

    @Override
    @Nonnull
    public RecordMetaData getRecordMetaData() {
        return this.recordStore.getRecordMetaData();
    }

    public static BackingRecordStore fromTransactionWithStore(@Nonnull RecordStoreAndRecordContextTransaction txn) {
        return new BackingRecordStore(txn, txn.getRecordStore());
    }

    public static BackingRecordStore load(@Nonnull Transaction txn, @Nonnull StoreConfig config, @Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck) throws RelationalException {
        try {
            Object recordStore = ((FDBRecordStore.Builder)FDBRecordStore.newBuilder().setKeySpacePath(config.getStorePath()).setSerializer((RecordSerializer)config.getSerializer())).setMetaDataProvider(config.getMetaDataProvider()).setUserVersionChecker(config.getUserVersionChecker()).setFormatVersion(config.getFormatVersion()).setContext(txn.unwrap(FDBRecordContext.class)).createOrOpen(existenceCheck);
            return new BackingRecordStore(txn, (FDBRecordStoreBase<Message>)recordStore);
        }
        catch (RecordCoreException rce) {
            Throwable cause = Throwables.getRootCause(rce);
            if (cause instanceof RecordStoreDoesNotExistException) {
                throw new RelationalException("Schema does not exist. Schema: <" + config.getSchemaName() + ">", ErrorCode.UNDEFINED_SCHEMA, cause);
            }
            throw ExceptionUtil.toRelationalException(rce);
        }
    }
}

