/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.storage;

import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.ResolverStateProto;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverResult;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerColumn;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerIndex;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerTable;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class LocatableResolverMetaDataProvider
implements RecordMetaDataProvider {
    private static volatile LocatableResolverMetaDataProvider memoizedInstance;
    static final String INTERNING_TYPE_NAME = "Interning";
    static final String RESOLVER_STATE_TYPE_NAME = "ResolverState";
    static final String KEY_FIELD_NAME = "key";
    static final String VALUE_FIELD_NAME = "value";
    static final String META_DATA_FIELD_NAME = "meta_data";
    static final String VERSION_FIELD_NAME = "version";
    static final String LOCK_FIELD_NAME = "lock";
    static final String REVERSE_INDEX_NAME = "reverse_interning";
    private static final DataType.EnumType WRITE_LOCK_ENUM;
    private static final RecordLayerSchemaTemplate SCHEMA_TEMPLATE;
    @Nonnull
    private final RecordMetaData metaData;
    @Nonnull
    private final Object interningTypeKey;
    @Nonnull
    private final Object resolverStateTypeKey;

    private LocatableResolverMetaDataProvider(@Nonnull RecordMetaData metaData) {
        this.metaData = metaData;
        this.interningTypeKey = metaData.getRecordType(INTERNING_TYPE_NAME).getRecordTypeKey();
        this.resolverStateTypeKey = metaData.getRecordType(RESOLVER_STATE_TYPE_NAME).getRecordTypeKey();
    }

    Message wrapInterning(@Nonnull String key, long value, @Nullable byte[] metaData) {
        Descriptors.Descriptor descriptor = this.metaData.getRecordType(INTERNING_TYPE_NAME).getDescriptor();
        DynamicMessage.Builder builder = DynamicMessage.newBuilder(descriptor).setField(descriptor.findFieldByName(KEY_FIELD_NAME), key).setField(descriptor.findFieldByName(VALUE_FIELD_NAME), value);
        if (metaData != null) {
            builder.setField(descriptor.findFieldByName(META_DATA_FIELD_NAME), ByteString.copyFrom(metaData));
        }
        return builder.build();
    }

    @Nullable
    Message wrapResolverResult(@Nonnull String key, @Nullable ResolverResult result) {
        if (result == null) {
            return null;
        }
        return this.wrapInterning(key, result.getValue(), result.getMetadata());
    }

    @Nonnull
    Message wrapResolverState(ResolverStateProto.State state) {
        Descriptors.Descriptor descriptor = this.metaData.getRecordType(RESOLVER_STATE_TYPE_NAME).getDescriptor();
        return DynamicMessage.newBuilder(descriptor).setField(descriptor.findFieldByName(VERSION_FIELD_NAME), state.getVersion()).setField(descriptor.findFieldByName(LOCK_FIELD_NAME), descriptor.getFile().findEnumTypeByName(WRITE_LOCK_ENUM.getName()).findValueByName(state.getLock().name())).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static LocatableResolverMetaDataProvider instance() throws RelationalException {
        if (memoizedInstance != null) return memoizedInstance;
        Class<LocatableResolverMetaDataProvider> clazz = LocatableResolverMetaDataProvider.class;
        synchronized (LocatableResolverMetaDataProvider.class) {
            if (memoizedInstance != null) return memoizedInstance;
            RecordMetaData metaData = SCHEMA_TEMPLATE.toRecordMetadata();
            memoizedInstance = new LocatableResolverMetaDataProvider(metaData);
            // ** MonitorExit[var0] (shouldn't be in output)
            return memoizedInstance;
        }
    }

    public static SchemaTemplate getSchemaTemplate() {
        return SCHEMA_TEMPLATE;
    }

    @Override
    @Nonnull
    public RecordMetaData getRecordMetaData() {
        return this.metaData;
    }

    @Nonnull
    public Object getInterningTypeKey() {
        return this.interningTypeKey;
    }

    @Nonnull
    public Object getResolverStateTypeKey() {
        return this.resolverStateTypeKey;
    }

    static {
        WRITE_LOCK_ENUM = DataType.EnumType.from("WriteLock", List.of(DataType.EnumType.EnumValue.of("UNLOCKED", 1), DataType.EnumType.EnumValue.of("WRITE_LOCKED", 2), DataType.EnumType.EnumValue.of("RETIRED", 3)), true);
        SCHEMA_TEMPLATE = RecordLayerSchemaTemplate.newBuilder().setName("locatable_resolver").setVersion(1).addTable(RecordLayerTable.newBuilder(false).setName(INTERNING_TYPE_NAME).addColumn(RecordLayerColumn.newBuilder().setDataType(DataType.Primitives.STRING.type()).setName(KEY_FIELD_NAME).build()).addColumn(RecordLayerColumn.newBuilder().setDataType(DataType.Primitives.LONG.type()).setName(VALUE_FIELD_NAME).build()).addColumn(RecordLayerColumn.newBuilder().setDataType(DataType.Primitives.NULLABLE_BYTES.type()).setName(META_DATA_FIELD_NAME).build()).addPrimaryKeyPart(List.of(KEY_FIELD_NAME)).addIndex(RecordLayerIndex.newBuilder().setName(REVERSE_INDEX_NAME).setTableName(INTERNING_TYPE_NAME).setIndexType(VALUE_FIELD_NAME).setKeyExpression(Key.Expressions.field(VALUE_FIELD_NAME)).setUnique(true).build()).build()).addAuxiliaryType(WRITE_LOCK_ENUM).addTable(RecordLayerTable.newBuilder(false).setName(RESOLVER_STATE_TYPE_NAME).addColumn(RecordLayerColumn.newBuilder().setDataType(WRITE_LOCK_ENUM).setName(LOCK_FIELD_NAME).build()).addColumn(RecordLayerColumn.newBuilder().setDataType(DataType.Primitives.INTEGER.type()).setName(VERSION_FIELD_NAME).build()).build()).build();
    }
}

