/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.storage;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.provider.common.KeyStoreSerializationKeyManager;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.common.SerializationKeyManager;
import com.apple.foundationdb.record.provider.common.TransformedRecordSerializer;
import com.apple.foundationdb.record.provider.common.TransformedRecordSerializerJCE;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FormatVersion;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.NoSuchDirectoryException;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.RecordLayerConfig;
import com.apple.foundationdb.relational.recordlayer.RelationalKeyspaceProvider;
import com.apple.foundationdb.relational.recordlayer.catalog.RecordMetaDataStore;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import com.google.protobuf.Message;
import java.net.URI;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class StoreConfig {
    public static final RecordSerializer<Message> DEFAULT_RELATIONAL_SERIALIZER = TransformedRecordSerializer.newDefaultBuilder().setEncryptWhenSerializing(false).setCompressWhenSerializing(true).setCompressionLevel(-1).setWriteValidationRatio(0.0).build();
    private final RecordLayerConfig recordLayerConfig;
    private final String schemaName;
    private final KeySpacePath storePath;
    private final RecordMetaDataProvider metaDataProvider;
    private final RecordSerializer<Message> serializer;

    private StoreConfig(RecordLayerConfig recordLayerConfig, String schemaName, KeySpacePath storePath, RecordMetaDataProvider metaDataProvider, RecordSerializer<Message> serializer) {
        this.recordLayerConfig = recordLayerConfig;
        this.schemaName = schemaName;
        this.storePath = storePath;
        this.metaDataProvider = metaDataProvider;
        this.serializer = serializer;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public KeySpacePath getStorePath() {
        return this.storePath;
    }

    public RecordMetaDataProvider getMetaDataProvider() {
        return this.metaDataProvider;
    }

    public RecordSerializer<Message> getSerializer() {
        return this.serializer;
    }

    public FDBRecordStoreBase.UserVersionChecker getUserVersionChecker() {
        return this.recordLayerConfig.getUserVersionChecker();
    }

    public FormatVersion getFormatVersion() {
        return this.recordLayerConfig.getFormatVersion();
    }

    public static StoreConfig create(RecordLayerConfig recordLayerConfig, String schemaName, RelationalKeyspaceProvider.RelationalDatabasePath databasePath, RecordMetaDataStore metaDataStore, Transaction transaction, Options options) throws RelationalException {
        RelationalKeyspaceProvider.RelationalSchemaPath schemaPath;
        try {
            schemaPath = databasePath.schemaPath(schemaName);
        }
        catch (NoSuchDirectoryException nsde) {
            throw new RelationalException("Uninitialized Catalog", ErrorCode.INTERNAL_ERROR, nsde);
        }
        catch (MetaDataException mde) {
            throw new RelationalException(mde.getMessage(), ErrorCode.UNDEFINED_SCHEMA, mde);
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
        URI dbUri = databasePath.toUri();
        RecordMetaDataProvider metaDataProvider = metaDataStore.loadMetaData(transaction, dbUri, schemaName);
        RecordSerializer<Message> serializer = StoreConfig.serializerFromOptions(options);
        return new StoreConfig(recordLayerConfig, schemaName, schemaPath, metaDataProvider, serializer);
    }

    @Nonnull
    static RecordSerializer<Message> serializerFromOptions(@Nonnull Options options) throws RelationalException {
        boolean encrypted = (Boolean)options.getOption(Options.Name.ENCRYPT_WHEN_SERIALIZING);
        boolean compressed = (Boolean)options.getOption(Options.Name.COMPRESS_WHEN_SERIALIZING);
        SerializationKeyManager keyManager = StoreConfig.keyManagerFromOptions(options);
        if (!encrypted && compressed && keyManager == null) {
            return DEFAULT_RELATIONAL_SERIALIZER;
        }
        TransformedRecordSerializer.Builder serializerBuilder = ((TransformedRecordSerializerJCE.Builder)((TransformedRecordSerializerJCE.Builder)((TransformedRecordSerializerJCE.Builder)TransformedRecordSerializerJCE.newDefaultBuilder().setEncryptWhenSerializing(encrypted)).setCompressWhenSerializing(compressed)).setCompressionLevel(-1)).setWriteValidationRatio(0.0);
        if (keyManager != null) {
            ((TransformedRecordSerializerJCE.Builder)serializerBuilder).setKeyManager(keyManager);
        } else if (encrypted) {
            throw new RelationalException("Key store not specified", ErrorCode.UNSUPPORTED_OPERATION);
        }
        return ((TransformedRecordSerializerJCE.Builder)serializerBuilder).build();
    }

    @Nullable
    static SerializationKeyManager keyManagerFromOptions(@Nonnull Options options) throws RelationalException {
        String keyStorePassword;
        List keyEntryAliases;
        String keyStoreFileName = (String)options.getOption(Options.Name.ENCRYPTION_KEY_STORE);
        if (keyStoreFileName == null) {
            return null;
        }
        KeyStoreSerializationKeyManager.Builder builder = KeyStoreSerializationKeyManager.newBuilder();
        builder.setKeyStoreFileName(keyStoreFileName);
        String defaultKeyEntryAlias = (String)options.getOption(Options.Name.ENCRYPTION_KEY_ENTRY);
        if (defaultKeyEntryAlias != null) {
            builder.setDefaultKeyEntryAlias(defaultKeyEntryAlias);
        }
        if ((keyEntryAliases = (List)options.getOption(Options.Name.ENCRYPTION_KEY_ENTRY_LIST)) != null) {
            builder.setKeyEntryAliases(keyEntryAliases);
        }
        if ((keyStorePassword = (String)options.getOption(Options.Name.ENCRYPTION_KEY_PASSWORD)) != null) {
            builder.setKeyStorePassword(keyStorePassword);
        }
        try {
            return builder.build();
        }
        catch (RecordCoreException ex) {
            throw new RelationalException("problem with encryption options", ErrorCode.UNSUPPORTED_OPERATION, ex);
        }
    }
}

