/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.structuredsql.expression;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.fluentsql.expression.ExpressionFactory;
import com.apple.foundationdb.relational.api.fluentsql.expression.Field;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.api.metadata.Table;
import com.apple.foundationdb.relational.recordlayer.query.SemanticAnalyzer;
import com.apple.foundationdb.relational.recordlayer.structuredsql.expression.FieldImpl;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@API(value=API.Status.EXPERIMENTAL)
public class ExpressionFactoryImpl
implements ExpressionFactory {
    @Nonnull
    private final SchemaTemplate schemaTemplate;
    @Nonnull
    private final Options options;

    public ExpressionFactoryImpl(@Nonnull SchemaTemplate schemaTemplate, @Nonnull Options options) {
        this.schemaTemplate = schemaTemplate;
        this.options = options;
    }

    @Nonnull
    Field<?> resolve(@Nonnull DataType type, @Nonnull Iterable<String> fieldParts) {
        boolean caseSensitive = (Boolean)this.options.getOption(Options.Name.CASE_SENSITIVE_IDENTIFIERS);
        DataType current = type;
        ImmutableList.Builder normalizedFieldParts = ImmutableList.builder();
        for (String fieldPart : fieldParts) {
            Assert.thatUnchecked(current instanceof DataType.StructType, ErrorCode.INVALID_COLUMN_REFERENCE, "invalid field reference %s", fieldParts);
            String normalizedFieldPart = Assert.notNullUnchecked(SemanticAnalyzer.normalizeString(fieldPart, caseSensitive));
            normalizedFieldParts.add(normalizedFieldPart);
            Optional<DataType.StructType.Field> result = ((DataType.StructType)current).getFields().stream().filter(f -> Assert.notNullUnchecked(f.getName()).equals(normalizedFieldPart)).findAny();
            Assert.thatUnchecked(result.isPresent(), ErrorCode.INVALID_COLUMN_REFERENCE, "invalid field reference '%s'", StreamSupport.stream(fieldParts.spliterator(), false).collect(Collectors.joining(".")));
            current = result.get().getType();
        }
        return new FieldImpl<DataType>(normalizedFieldParts.build(), this, current);
    }

    @Override
    @Nonnull
    public Field<?> field(@Nonnull String tableName, @Nonnull Iterable<String> parts) {
        Optional<Table> maybeTable;
        boolean caseSensitive = (Boolean)this.options.getOption(Options.Name.CASE_SENSITIVE_IDENTIFIERS);
        String normalizedName = Assert.notNullUnchecked(SemanticAnalyzer.normalizeString(tableName, caseSensitive));
        try {
            maybeTable = this.schemaTemplate.findTableByName(normalizedName);
        }
        catch (RelationalException e) {
            throw e.toUncheckedWrappedException();
        }
        Assert.thatUnchecked(maybeTable.isPresent(), ErrorCode.UNDEFINED_TABLE, "Could not find table '%s'", normalizedName);
        return this.resolve(maybeTable.get().getDatatype(), parts);
    }
}

