/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.structuredsql.expression;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.fluentsql.FluentVisitor;
import com.apple.foundationdb.relational.api.fluentsql.expression.Field;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.recordlayer.structuredsql.expression.ExpressionFactoryImpl;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class FieldImpl<T extends DataType>
implements Field<T> {
    @Nonnull
    private final Iterable<String> parts;
    @Nonnull
    private final String name;
    @Nonnull
    private final ExpressionFactoryImpl expressionFactory;
    @Nonnull
    private final T dataType;
    @Nonnull
    private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

    FieldImpl(@Nonnull Iterable<String> parts, @Nonnull ExpressionFactoryImpl expressionFactory, @Nonnull T dataType) {
        this.name = Iterables.getLast(parts);
        this.parts = parts;
        this.expressionFactory = expressionFactory;
        this.dataType = dataType;
    }

    @Override
    @Nonnull
    public Iterable<String> getParts() {
        return this.parts;
    }

    @Override
    @Nonnull
    public Field<?> subField(@Nonnull String part) {
        return ((FieldImpl)this.expressionFactory.resolve((DataType)this.dataType, (Iterable<String>)List.of(part))).withPrefix(this.parts);
    }

    @Nonnull
    private Field<T> withPrefix(@Nonnull Iterable<String> prefix) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ((ImmutableList.Builder)builder.addAll(prefix)).addAll(this.parts);
        return new FieldImpl<T>(builder.build(), this.expressionFactory, this.dataType);
    }

    @Override
    @Nullable
    public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
        return visitor.visit(this, context);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public T getType() {
        return this.dataType;
    }

    private int computeHashCode() {
        return Objects.hash(this.parts, this.dataType);
    }

    public int hashCode() {
        return this.hashCodeSupplier.get();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Field)) {
            return false;
        }
        Field otherField = (Field)other;
        return this.getParts().equals(otherField.getParts()) && this.getType().equals(otherField.getType());
    }

    public String toString() {
        return String.join((CharSequence)".", this.parts) + " : " + String.valueOf(this.getType());
    }
}

