/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.structuredsql.statement;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.ParseTreeInfo;
import com.apple.foundationdb.relational.api.RelationalConnection;
import com.apple.foundationdb.relational.api.fluentsql.statement.StatementBuilderFactory;
import com.apple.foundationdb.relational.api.fluentsql.statement.UpdateStatement;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.query.ParseTreeInfoImpl;
import com.apple.foundationdb.relational.recordlayer.structuredsql.statement.UpdateStatementImpl;
import com.apple.foundationdb.relational.util.Assert;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class StatementBuilderFactoryImpl
implements StatementBuilderFactory {
    @Nonnull
    private final SchemaTemplate schemaTemplate;
    @Nonnull
    private final RelationalConnection relationalConnection;

    public StatementBuilderFactoryImpl(@Nonnull SchemaTemplate schemaTemplate, @Nonnull RelationalConnection relationalConnection) {
        this.schemaTemplate = schemaTemplate;
        this.relationalConnection = relationalConnection;
    }

    @Override
    @Nonnull
    public UpdateStatement.Builder updateStatementBuilder() {
        return new UpdateStatementImpl.BuilderImpl(this.relationalConnection, this.schemaTemplate);
    }

    @Override
    @Nonnull
    public UpdateStatement.Builder updateStatementBuilder(@Nonnull String updateQuery) {
        return UpdateStatementImpl.BuilderImpl.fromQuery(this.relationalConnection, this.schemaTemplate, updateQuery, Map.of());
    }

    @Override
    @Nonnull
    public UpdateStatement.Builder updateStatementBuilder(@Nonnull String updateQuery, @Nonnull Map<String, List<String>> columnSynonyms) {
        return UpdateStatementImpl.BuilderImpl.fromQuery(this.relationalConnection, this.schemaTemplate, updateQuery, columnSynonyms);
    }

    @Override
    @Nonnull
    public UpdateStatement.Builder updateStatementBuilder(@Nonnull ParseTreeInfo parseTree) {
        Assert.thatUnchecked(parseTree instanceof ParseTreeInfoImpl);
        return UpdateStatementImpl.BuilderImpl.fromParseTreeInfoImpl(this.relationalConnection, this.schemaTemplate, (ParseTreeInfoImpl)parseTree, Map.of());
    }

    @Override
    @Nonnull
    public UpdateStatement.Builder updateStatementBuilder(@Nonnull ParseTreeInfo parseTree, @Nonnull Map<String, List<String>> columnSynonyms) {
        Assert.thatUnchecked(parseTree instanceof ParseTreeInfoImpl);
        return UpdateStatementImpl.BuilderImpl.fromParseTreeInfoImpl(this.relationalConnection, this.schemaTemplate, (ParseTreeInfoImpl)parseTree, columnSynonyms);
    }
}

