/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.structuredsql.statement;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.ParseTreeInfo;
import com.apple.foundationdb.relational.api.RelationalConnection;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.fluentsql.SqlVisitor;
import com.apple.foundationdb.relational.api.fluentsql.expression.BooleanExpressionTrait;
import com.apple.foundationdb.relational.api.fluentsql.expression.Expression;
import com.apple.foundationdb.relational.api.fluentsql.expression.ExpressionFactory;
import com.apple.foundationdb.relational.api.fluentsql.expression.Field;
import com.apple.foundationdb.relational.api.fluentsql.statement.StructuredQuery;
import com.apple.foundationdb.relational.api.fluentsql.statement.UpdateStatement;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.api.metadata.Table;
import com.apple.foundationdb.relational.generated.RelationalLexer;
import com.apple.foundationdb.relational.generated.RelationalParser;
import com.apple.foundationdb.relational.generated.RelationalParserBaseVisitor;
import com.apple.foundationdb.relational.recordlayer.query.CaseInsensitiveCharStream;
import com.apple.foundationdb.relational.recordlayer.query.ParseTreeInfoImpl;
import com.apple.foundationdb.relational.recordlayer.query.SemanticAnalyzer;
import com.apple.foundationdb.relational.recordlayer.structuredsql.expression.FieldImpl;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;

@API(value=API.Status.EXPERIMENTAL)
public class UpdateStatementImpl
implements UpdateStatement {
    @Nonnull
    private final Table table;
    @Nonnull
    private final String originalTableName;
    @Nonnull
    private final Map<Field<?>, Expression<?>> setClauses;
    @Nullable
    private final BooleanExpressionTrait whereClause;
    @Nonnull
    private final List<Expression<?>> returning;
    @Nonnull
    private final Set<StructuredQuery.QueryOptions> queryOptions;
    @Nonnull
    private final Supplier<String> sqlGenerationMemoizer;
    @Nonnull
    private final RelationalConnection connection;
    private final boolean caseSensitive;

    public UpdateStatementImpl(@Nonnull Table table, @Nonnull String originalTableName, @Nonnull Map<Field<?>, Expression<?>> setClauses, @Nullable BooleanExpressionTrait whereClause, @Nonnull List<Expression<?>> returning, @Nonnull Set<StructuredQuery.QueryOptions> queryOptions, @Nonnull RelationalConnection connection) {
        this.table = table;
        this.originalTableName = originalTableName;
        this.setClauses = ImmutableMap.copyOf(setClauses);
        this.whereClause = whereClause;
        this.returning = ImmutableList.copyOf(returning);
        this.queryOptions = ImmutableSet.copyOf(queryOptions);
        this.connection = connection;
        this.sqlGenerationMemoizer = Suppliers.memoize(this::generateQuery);
        this.caseSensitive = (Boolean)connection.getOptions().getOption(Options.Name.CASE_SENSITIVE_IDENTIFIERS);
    }

    @Override
    @Nonnull
    public PreparedStatement getPreparedStatement() throws SQLException {
        return this.connection.prepareStatement(this.getSqlQuery());
    }

    @Override
    @Nonnull
    public String getSqlQuery() {
        return this.sqlGenerationMemoizer.get();
    }

    @Override
    @Nonnull
    public Map<Field<?>, Expression<?>> getSetClauses() {
        return ImmutableMap.copyOf(this.setClauses);
    }

    @Override
    @Nonnull
    public List<Expression<?>> getReturning() {
        return ImmutableList.copyOf(this.returning);
    }

    @Override
    @Nullable
    public BooleanExpressionTrait getWhereClause() {
        return this.whereClause;
    }

    @Override
    @Nonnull
    public Set<StructuredQuery.QueryOptions> getOptions() {
        return ImmutableSet.copyOf(this.queryOptions);
    }

    @Override
    @Nonnull
    public String getTable() {
        return this.table.getName();
    }

    @Nonnull
    private String generateQuery() {
        StringBuilder sb = new StringBuilder();
        SqlVisitor sqlVisitor = new SqlVisitor();
        sb.append("UPDATE ").append("\"").append(SemanticAnalyzer.normalizeString(this.originalTableName, this.caseSensitive)).append("\"").append(" SET ");
        Set<Map.Entry<Field<?>, Expression<?>>> setClauses = this.getSetClauses().entrySet();
        int size = setClauses.size();
        int counter = 0;
        for (Map.Entry<Field<?>, Expression<?>> setClause : this.getSetClauses().entrySet()) {
            setClause.getKey().accept(sqlVisitor, sb);
            sb.append(" = ");
            setClause.getValue().accept(sqlVisitor, sb);
            if (counter < size - 1) {
                sb.append(",");
            }
            ++counter;
        }
        if (this.whereClause != null) {
            sb.append(" WHERE ");
            this.whereClause.accept(sqlVisitor, sb);
        }
        if (!this.returning.isEmpty()) {
            sb.append(" RETURNING ");
            this.returning.get(0).accept(sqlVisitor, sb);
            for (int i = 1; i < this.returning.size(); ++i) {
                sb.append(", ");
                this.returning.get(i).accept(sqlVisitor, sb);
            }
        }
        if (!this.queryOptions.isEmpty()) {
            sb.append(" OPTIONS (");
            sb.append(this.queryOptions.stream().map(StructuredQuery.QueryOptions::getName).collect(Collectors.joining(", ")));
            sb.append(")");
        }
        return sb.toString();
    }

    public static class BuilderImpl
    implements UpdateStatement.Builder {
        @Nonnull
        private final RelationalConnection connection;
        @Nonnull
        private final SchemaTemplate schemaTemplate;
        private Table table;
        private String originalTableName;
        @Nonnull
        private Map<Field<?>, Expression<?>> setClauses;
        @Nullable
        private BooleanExpressionTrait whereClause;
        @Nonnull
        private final List<Expression<?>> returning;
        @Nonnull
        private final ImmutableSet.Builder<StructuredQuery.QueryOptions> queryOptionsBuilder;
        private final boolean isCaseSensitive;

        public BuilderImpl(@Nonnull RelationalConnection connection, @Nonnull SchemaTemplate schemaTemplate) {
            this.connection = connection;
            this.schemaTemplate = schemaTemplate;
            this.setClauses = new LinkedHashMap();
            this.returning = new ArrayList();
            this.queryOptionsBuilder = ImmutableSet.builder();
            this.isCaseSensitive = (Boolean)connection.getOptions().getOption(Options.Name.CASE_SENSITIVE_IDENTIFIERS);
        }

        @Override
        @Nonnull
        public Map<Field<?>, Expression<?>> getSetClauses() {
            return this.setClauses;
        }

        @Override
        @Nonnull
        public UpdateStatement.Builder addSetClause(@Nonnull Field<?> field, @Nonnull Expression<?> newValue) {
            this.setClauses.put(field, newValue);
            return this;
        }

        @Override
        @Nonnull
        public UpdateStatement.Builder clearSetClauses() {
            this.setClauses.clear();
            return this;
        }

        @Override
        @Nonnull
        public UpdateStatement.Builder removeSetClause(@Nonnull Field<?> field) {
            this.setClauses = this.setClauses.entrySet().stream().filter(pair -> !((Field)pair.getKey()).equals(field)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return this;
        }

        @Override
        @Nonnull
        public List<Expression<?>> getReturning() {
            return this.returning;
        }

        @Override
        @Nonnull
        public UpdateStatement.Builder addReturning(@Nonnull Expression<?> expression) {
            this.returning.add(expression);
            return this;
        }

        @Override
        @Nonnull
        public UpdateStatement.Builder clearReturning() {
            this.returning.clear();
            return this;
        }

        @Override
        @Nullable
        public BooleanExpressionTrait getWhereClause() {
            return this.whereClause;
        }

        @Override
        @Nonnull
        public UpdateStatement.Builder addWhereClause(@Nonnull BooleanExpressionTrait expression) {
            this.whereClause = this.whereClause != null ? this.whereClause.and(expression) : expression;
            return this;
        }

        @Override
        @Nonnull
        public UpdateStatement.Builder clearWhereClause() {
            this.whereClause = null;
            return this;
        }

        @Override
        @Nonnull
        public String getTable() {
            return this.originalTableName;
        }

        @Override
        @Nonnull
        public UpdateStatement.Builder setTable(@Nonnull String table) {
            Optional<Table> maybeTable;
            String normalizedTableName = Assert.notNullUnchecked(SemanticAnalyzer.normalizeString(table, this.isCaseSensitive));
            try {
                maybeTable = this.schemaTemplate.findTableByName(normalizedTableName);
            }
            catch (RelationalException e) {
                throw e.toUncheckedWrappedException();
            }
            Assert.thatUnchecked(maybeTable.isPresent(), ErrorCode.UNDEFINED_TABLE, "table '%s' is not found", table);
            this.originalTableName = table;
            this.table = maybeTable.get();
            return this;
        }

        @Override
        @Nonnull
        public UpdateStatement.Builder resolveSetFields(@Nonnull ExpressionFactory expressionFactory) {
            if (this.setClauses.entrySet().stream().allMatch(entry -> entry.getKey() instanceof FieldImpl)) {
                return this;
            }
            this.setClauses = this.setClauses.entrySet().stream().map(entry -> {
                if (entry.getKey() instanceof FieldImpl) {
                    return entry;
                }
                return Map.entry(expressionFactory.field(this.originalTableName, ((Field)entry.getKey()).getParts()), (Expression)entry.getValue());
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return this;
        }

        @Override
        @Nonnull
        public UpdateStatement.Builder withOption(StructuredQuery.QueryOptions ... options) {
            Arrays.stream(options).forEach(this.queryOptionsBuilder::add);
            return this;
        }

        @Override
        @Nonnull
        public Set<StructuredQuery.QueryOptions> getOptions() {
            return this.queryOptionsBuilder.build();
        }

        @Override
        @Nonnull
        public UpdateStatement build() throws RelationalException {
            Assert.notNull(this.table, ErrorCode.UNDEFINED_TABLE, "table is not set");
            Assert.that(!this.setClauses.isEmpty(), ErrorCode.INTERNAL_ERROR, "update set clauses is empty");
            return new UpdateStatementImpl(this.table, this.originalTableName, this.setClauses, this.whereClause, this.returning, (Set<StructuredQuery.QueryOptions>)((Object)this.queryOptionsBuilder.build()), this.connection);
        }

        @Nonnull
        public static UpdateStatement.Builder fromQuery(@Nonnull RelationalConnection relationalConnection, @Nonnull SchemaTemplate schemaTemplate, @Nonnull String updateQuery, @Nonnull Map<String, List<String>> columnSynonyms) {
            RelationalLexer tokenSource = new RelationalLexer(new CaseInsensitiveCharStream(updateQuery));
            RelationalParser parseTree = new RelationalParser(new CommonTokenStream(tokenSource));
            return BuilderImpl.fromParseTreeInfoImpl(relationalConnection, schemaTemplate, ParseTreeInfoImpl.from(parseTree.root()), columnSynonyms);
        }

        @Nonnull
        public static UpdateStatement.Builder fromParseTreeInfoImpl(@Nonnull RelationalConnection relationalConnection, @Nonnull SchemaTemplate schemaTemplate, @Nonnull ParseTreeInfoImpl parseTreeInfo, @Nonnull Map<String, List<String>> columnSynonyms) {
            Assert.thatUnchecked(parseTreeInfo.getQueryType().equals((Object)ParseTreeInfo.QueryType.UPDATE), String.format(Locale.ROOT, "Expecting update statement, got '%s' statement", parseTreeInfo.getQueryType().name()));
            UpdateVisitor updateVisitor = new UpdateVisitor(relationalConnection, schemaTemplate, parseTreeInfo.getRootContext(), columnSynonyms);
            return updateVisitor.getUpdateBuilder();
        }

        private static final class UpdateVisitor
        extends RelationalParserBaseVisitor<Void> {
            @Nonnull
            private final StringBuilder queryStringScratchpad = new StringBuilder();
            @Nonnull
            private final UpdateStatement.Builder updateBuilder;
            @Nonnull
            private final ExpressionFactory expressionFactory;
            private boolean isUpdateStatement;

            public UpdateVisitor(@Nonnull RelationalConnection connection, @Nonnull SchemaTemplate schemaTemplate, @Nonnull RelationalParser.RootContext ast) {
                this(connection, schemaTemplate, ast, Map.of());
            }

            public UpdateVisitor(@Nonnull RelationalConnection connection, @Nonnull SchemaTemplate schemaTemplate, @Nonnull RelationalParser.RootContext ast, @Nonnull Map<String, List<String>> columnSynonyms) {
                this.updateBuilder = new BuilderImpl(connection, schemaTemplate);
                try {
                    this.expressionFactory = connection.createExpressionBuilderFactory();
                }
                catch (SQLException e) {
                    throw new RelationalException(e).toUncheckedWrappedException();
                }
                this.isUpdateStatement = false;
                if (!columnSynonyms.isEmpty()) {
                    UidReplacer uidReplacer = new UidReplacer(columnSynonyms, (Boolean)connection.getOptions().getOption(Options.Name.CASE_SENSITIVE_IDENTIFIERS));
                    uidReplacer.visit(ast);
                }
                this.visit(ast);
                if (!this.isUpdateStatement) {
                    throw new RelationalException("expecting an update statement", ErrorCode.INTERNAL_ERROR).toUncheckedWrappedException();
                }
            }

            @Nonnull
            UpdateStatement.Builder getUpdateBuilder() {
                return this.updateBuilder;
            }

            @Nonnull
            private String withNewScratchPad(@Nonnull Consumer<Void> consumer) {
                this.queryStringScratchpad.setLength(0);
                consumer.accept(null);
                return this.queryStringScratchpad.toString().trim();
            }

            @Override
            public Void visitUpdateStatement(RelationalParser.UpdateStatementContext ctx) {
                this.isUpdateStatement = true;
                String table = this.withNewScratchPad(Null2 -> this.visit(ctx.tableName()));
                this.updateBuilder.setTable(table);
                if (ctx.uid() != null) {
                    Assert.failUnchecked(ErrorCode.UNSUPPORTED_QUERY, "Construction of 'UPDATE' query builder with aliased target table is not supported");
                }
                ctx.updatedElement().forEach(updatedElementContext -> {
                    List<String> updatedColumn = this.handleFullId(updatedElementContext.fullColumnName().fullId());
                    String setValue = this.withNewScratchPad(Null2 -> this.visit(updatedElementContext.expression()));
                    this.updateBuilder.addSetClause(this.expressionFactory.field(table, updatedColumn), this.expressionFactory.parseFragment(setValue));
                });
                if (ctx.WHERE() != null) {
                    String whereClauseParts = this.withNewScratchPad(Null2 -> this.visit(ctx.whereExpr().expression()));
                    this.updateBuilder.addWhereClause(this.expressionFactory.parseFragment(whereClauseParts).asBoolean());
                }
                if (ctx.RETURNING() != null) {
                    List<String> projectionList = this.handleReturningSelectElements(ctx.selectElements());
                    for (String projectionItem : projectionList) {
                        this.updateBuilder.addReturning(this.expressionFactory.parseFragment(projectionItem));
                    }
                }
                if (ctx.queryOptions() != null) {
                    this.visit(ctx.queryOptions());
                }
                return null;
            }

            @Override
            public Void visitQueryOption(RelationalParser.QueryOptionContext ctx) {
                if (ctx.NOCACHE() != null) {
                    this.updateBuilder.withOption(StructuredQuery.QueryOptions.NOCACHE);
                } else if (ctx.LOG() != null) {
                    this.updateBuilder.withOption(StructuredQuery.QueryOptions.LOG_QUERY);
                } else if (ctx.DRY() != null) {
                    this.updateBuilder.withOption(StructuredQuery.QueryOptions.DRY_RUN);
                }
                return null;
            }

            @Nonnull
            private List<String> handleFullId(RelationalParser.FullIdContext ctx) {
                Assert.thatUnchecked(!ctx.uid().isEmpty());
                return ctx.uid().stream().map(this::handleUid).map(Assert::notNullUnchecked).collect(Collectors.toList());
            }

            @Nonnull
            private String handleUid(RelationalParser.UidContext ctx) {
                if (ctx.simpleId() != null) {
                    return Assert.notNullUnchecked(ctx.simpleId().getText());
                }
                return Assert.notNullUnchecked(ctx.getText());
            }

            @Nonnull
            private List<String> handleReturningSelectElements(RelationalParser.SelectElementsContext selectElementsContext) {
                ImmutableList.Builder result = ImmutableList.builder();
                selectElementsContext.selectElement().forEach(selectElement -> result.add(this.withNewScratchPad(Null2 -> this.visit((ParseTree)selectElement))));
                return result.build();
            }

            @Override
            public Void visitTerminal(TerminalNode node) {
                if (node.getSymbol().getType() == -1) {
                    return null;
                }
                this.queryStringScratchpad.append(node.getText()).append(" ");
                return null;
            }
        }

        private static final class UidReplacer
        extends RelationalParserBaseVisitor<Void> {
            @Nonnull
            private final ImmutableMap<String, List<String>> synonymsMap;
            private final boolean isCaseSensitive;

            private UidReplacer(@Nonnull Map<String, List<String>> symnonymsMap, boolean isCaseSensitive) {
                ImmutableMap.Builder normalizedSynonymsMap = ImmutableMap.builder();
                for (Map.Entry<String, List<String>> synonymsPair : symnonymsMap.entrySet()) {
                    String normalizedKey = Assert.notNullUnchecked(SemanticAnalyzer.normalizeString(synonymsPair.getKey(), isCaseSensitive));
                    List normalizedValue = synonymsPair.getValue().stream().map(part -> Assert.notNullUnchecked(SemanticAnalyzer.normalizeString(part, isCaseSensitive))).collect(Collectors.toUnmodifiableList());
                    normalizedSynonymsMap.put(normalizedKey, normalizedValue);
                }
                this.synonymsMap = normalizedSynonymsMap.build();
                this.isCaseSensitive = isCaseSensitive;
            }

            @Override
            public Void visitUid(RelationalParser.UidContext ctx) {
                String normalizeUid = SemanticAnalyzer.normalizeString(ctx.getText(), this.isCaseSensitive);
                List<String> synonymsValueMaybe = this.synonymsMap.get(normalizeUid);
                if (synonymsValueMaybe != null) {
                    if (!(ctx.parent instanceof ParserRuleContext)) {
                        return null;
                    }
                    ParserRuleContext parent = (ParserRuleContext)ctx.parent;
                    int childIndex = -1;
                    for (int i = 0; i < parent.getChildCount(); ++i) {
                        if (parent.children.get(i) != ctx) continue;
                        childIndex = i;
                        break;
                    }
                    if (childIndex < 0) {
                        return null;
                    }
                    ImmutableList.Builder newNodes = ImmutableList.builder();
                    newNodes.addAll(parent.children.subList(0, childIndex));
                    for (int i = 0; i < synonymsValueMaybe.size(); ++i) {
                        newNodes.add(new CustomSimpleId(parent, 1, "\"" + synonymsValueMaybe.get(i) + "\""));
                        if (i >= synonymsValueMaybe.size() - 1) continue;
                        newNodes.add(new TerminalNodeImpl(new CustomSimpleId.CustomCommonToken(".")));
                    }
                    newNodes.addAll(parent.children.subList(childIndex + 1, parent.children.size()));
                    parent.children = newNodes.build();
                }
                return null;
            }
        }

        public static class CustomSimpleId
        extends RelationalParser.UidContext {
            public CustomSimpleId(ParserRuleContext parent, int invokingState, @Nonnull String name) {
                super(parent, invokingState);
                this.addChild(new TerminalNodeImpl(new CustomCommonToken(name)));
            }

            public static class CustomCommonToken
            extends CommonToken {
                private static final long serialVersionUID = 3459762348795L;
                @Nonnull
                private final String name;

                public CustomCommonToken(@Nonnull String name) {
                    super(0);
                    this.name = name;
                }

                @Override
                public String getText() {
                    return this.name;
                }
            }
        }
    }
}

