/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.util;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.provider.foundationdb.FDBExceptions;
import com.apple.foundationdb.record.provider.foundationdb.RecordAlreadyExistsException;
import com.apple.foundationdb.record.provider.foundationdb.RecordContextNotActiveException;
import com.apple.foundationdb.record.provider.foundationdb.RecordDeserializationException;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.UnableToPlanException;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.exceptions.UncheckedRelationalException;
import com.google.common.base.VerifyException;
import java.sql.SQLException;
import java.util.Map;

@API(value=API.Status.EXPERIMENTAL)
public final class ExceptionUtil {
    public static RelationalException toRelationalException(Throwable re) {
        if (re instanceof RelationalException) {
            return (RelationalException)re;
        }
        if (re instanceof SQLException) {
            return new RelationalException(re.getMessage(), ErrorCode.get(((SQLException)re).getSQLState()), re);
        }
        if (re instanceof RecordCoreException) {
            return ExceptionUtil.recordCoreToRelationalException((RecordCoreException)re);
        }
        if (re instanceof UncheckedRelationalException) {
            return ((UncheckedRelationalException)re).unwrap();
        }
        if (re instanceof VerifyException) {
            return new RelationalException(re.getMessage(), ErrorCode.INTERNAL_ERROR, re);
        }
        return new RelationalException(ErrorCode.UNKNOWN, re);
    }

    private static RelationalException recordCoreToRelationalException(RecordCoreException re) {
        if (re.getCause() instanceof RelationalException) {
            return (RelationalException)re.getCause();
        }
        ErrorCode code = ErrorCode.UNKNOWN;
        if (re instanceof FDBExceptions.FDBStoreTransactionTimeoutException) {
            code = ErrorCode.TRANSACTION_TIMEOUT;
        } else if (re instanceof RecordContextNotActiveException || re.getCause() instanceof RecordContextNotActiveException) {
            code = ErrorCode.TRANSACTION_INACTIVE;
        } else if (re instanceof RecordDeserializationException || re.getCause() instanceof RecordDeserializationException) {
            code = ErrorCode.DESERIALIZATION_FAILURE;
        } else if (re instanceof RecordAlreadyExistsException || re.getCause() instanceof RecordAlreadyExistsException) {
            code = ErrorCode.UNIQUE_CONSTRAINT_VIOLATION;
        } else if (re instanceof MetaDataException) {
            code = ErrorCode.SYNTAX_OR_ACCESS_VIOLATION;
        } else if (re instanceof SemanticException) {
            code = ((SemanticException)re).getErrorCode().equals((Object)SemanticException.ErrorCode.INCOMPATIBLE_TYPE) ? ErrorCode.CANNOT_CONVERT_TYPE : (((SemanticException)re).getErrorCode().equals((Object)SemanticException.ErrorCode.FUNCTION_UNDEFINED_FOR_GIVEN_ARGUMENT_TYPES) ? ErrorCode.INVALID_ARGUMENT_FOR_FUNCTION : ErrorCode.INTERNAL_ERROR);
        } else if (re instanceof UnableToPlanException) {
            code = ErrorCode.UNSUPPORTED_QUERY;
        }
        Map<String, Object> extraContext = re.getLogInfo();
        return new RelationalException(code, (Throwable)re).withContext(extraContext);
    }

    private ExceptionUtil() {
    }
}

