/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.util;

import com.google.common.base.Function;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class MemoizedFunction<T, U> {
    @Nonnull
    private final Map<T, U> cache = new ConcurrentHashMap<T, U>();

    private MemoizedFunction() {
    }

    private Function<T, U> wrap(@Nonnull Function<T, U> function) {
        return input -> this.cache.computeIfAbsent(input, function);
    }

    public static <T, U> Function<T, U> memoize(@Nonnull Function<T, U> function) {
        return new MemoizedFunction<T, U>().wrap(function);
    }
}

