/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.util;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.util.MapUtils;
import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class MetricRegistryStoreTimer
extends FDBStoreTimer {
    private final MetricRegistry registry;

    public MetricRegistryStoreTimer(MetricRegistry registry) {
        this.registry = registry;
    }

    @Override
    @Nullable
    protected StoreTimer.Counter getCounter(@Nonnull StoreTimer.Event event, boolean createIfNotExists) {
        if (event instanceof StoreTimer.Aggregate) {
            StoreTimer.Counter counter = ((StoreTimer.Aggregate)event).compute(this);
            if (counter == null && createIfNotExists) {
                return super.getCounter(event, true);
            }
            return counter;
        }
        if (event instanceof StoreTimer.Count) {
            return createIfNotExists ? MapUtils.computeIfAbsent(this.counters, event, ignore -> new RegistryCounter(event.title(), this.registry.counter(event.title()))) : (StoreTimer.Counter)this.counters.get(event);
        }
        return createIfNotExists ? MapUtils.computeIfAbsent(this.counters, event, ignore -> new RegistryTimer(event.title(), this.registry.timer(event.title()))) : (StoreTimer.Counter)this.counters.get(event);
    }

    @Override
    @Nullable
    protected StoreTimer.Counter getTimeoutCounter(@Nonnull StoreTimer.Event event, boolean createIfNotExists) {
        if (event instanceof StoreTimer.Count) {
            return MapUtils.computeIfAbsent(this.counters, event, evignore -> new RegistryCounter(event.title(), this.registry.counter(event.title())));
        }
        return MapUtils.computeIfAbsent(this.counters, event, evignore -> new RegistryTimer(event.title(), this.registry.timer(event.title())));
    }

    @Override
    public void reset() {
        this.registry.removeMatching(MetricFilter.ALL);
        super.reset();
    }

    private static class RegistryTimer
    extends StoreTimer.Counter {
        private final Timer timer;
        private final String name;

        public RegistryTimer(@Nonnull String name, Timer timer) {
            super(false);
            this.name = name;
            this.timer = timer;
        }

        @Override
        public void record(long timeDifferenceNanos) {
            this.timer.update(timeDifferenceNanos, TimeUnit.NANOSECONDS);
            super.record(timeDifferenceNanos);
        }

        @Override
        public void increment(int amount) {
            throw new UnsupportedOperationException("Programmer error: Timer(name = " + this.name + ") is not a counter");
        }
    }

    private static class RegistryCounter
    extends StoreTimer.Counter {
        private final Counter counter;
        private final String name;

        public RegistryCounter(@Nonnull String name, Counter counter) {
            super(false);
            this.name = name;
            this.counter = counter;
        }

        @Override
        public void record(long timeDifferenceNanos) {
            throw new UnsupportedOperationException("Programmer error: Counter(name = " + this.name + ") is not a timer");
        }

        @Override
        public void increment(int amount) {
            this.counter.inc(amount);
            super.increment(amount);
        }
    }
}

