/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer.util;

import com.apple.foundationdb.record.query.plan.cascades.predicates.CompatibleTypeEvolutionPredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class TypeUtils {
    @Nonnull
    public static Type setFieldNames(@Nonnull Type input, @Nonnull CompatibleTypeEvolutionPredicate.FieldAccessTrieNode fieldAccessTrieNode) {
        return TypeUtils.setFieldNamesInternal(input, fieldAccessTrieNode);
    }

    @Nonnull
    private static Type setFieldNamesInternal(@Nonnull Type input, @Nonnull CompatibleTypeEvolutionPredicate.FieldAccessTrieNode trie) {
        if (input.isPrimitive()) {
            return input;
        }
        if (trie.getChildrenMap() != null && trie.getChildrenMap().isEmpty()) {
            return input;
        }
        if (input.isArray()) {
            Type.Array array = (Type.Array)input;
            return array.withElementType(TypeUtils.setFieldNamesInternal(Assert.notNullUnchecked(array.getElementType()), trie));
        }
        Assert.thatUnchecked(input.isRecord(), ErrorCode.INCOMPATIBLE_TABLE_ALIAS, () -> "incompatible type found while renaming. Expected " + Type.Record.class.getSimpleName() + " got " + input.getJavaClass().getSimpleName());
        Type.Record record = (Type.Record)input;
        List<Type.Record.Field> recordFields = record.getFields();
        ImmutableList.Builder newlyNamedFields = ImmutableList.builder();
        ArrayList fieldAliases = new ArrayList(trie.getChildrenMap().keySet());
        Assert.thatUnchecked(fieldAliases.size() == recordFields.size(), ErrorCode.INCOMPATIBLE_TABLE_ALIAS, () -> "number of record fields mismatch");
        fieldAliases.sort(Comparator.comparingInt(FieldValue.ResolvedAccessor::getOrdinal));
        for (int i = 0; i < recordFields.size(); ++i) {
            FieldValue.ResolvedAccessor fieldAlias = (FieldValue.ResolvedAccessor)fieldAliases.get(i);
            Type.Record.Field recordField = recordFields.get(i);
            CompatibleTypeEvolutionPredicate.FieldAccessTrieNode fieldTrie = (CompatibleTypeEvolutionPredicate.FieldAccessTrieNode)trie.getChildrenMap().get(fieldAlias);
            Type renamedFieldType = TypeUtils.setFieldNamesInternal(recordField.getFieldType(), fieldTrie);
            Type.Record.Field newField = Type.Record.Field.of(renamedFieldType, Optional.ofNullable(fieldAlias.getName()), Optional.of(recordField.getFieldIndex()));
            newlyNamedFields.add(newField);
        }
        return record.getName() == null ? Type.Record.fromFieldsWithName(record.getName(), record.isNullable(), (List<Type.Record.Field>)((Object)newlyNamedFields.build())) : Type.Record.fromFields(record.isNullable(), (List<Type.Record.Field>)((Object)newlyNamedFields.build()));
    }
}

