/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.server;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseFactory;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpace;
import com.apple.foundationdb.relational.api.EmbeddedRelationalDriver;
import com.apple.foundationdb.relational.api.KeySet;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalConnection;
import com.apple.foundationdb.relational.api.RelationalDriver;
import com.apple.foundationdb.relational.api.RelationalPreparedStatement;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.RelationalStatement;
import com.apple.foundationdb.relational.api.RelationalStruct;
import com.apple.foundationdb.relational.api.SqlTypeNamesSupport;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metrics.NoOpMetricRegistry;
import com.apple.foundationdb.relational.jdbc.TypeConversion;
import com.apple.foundationdb.relational.jdbc.grpc.v1.Parameter;
import com.apple.foundationdb.relational.jdbc.grpc.v1.ResultSet;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.Column;
import com.apple.foundationdb.relational.recordlayer.DirectFdbConnection;
import com.apple.foundationdb.relational.recordlayer.FdbConnection;
import com.apple.foundationdb.relational.recordlayer.RecordLayerConfig;
import com.apple.foundationdb.relational.recordlayer.RecordLayerEngine;
import com.apple.foundationdb.relational.recordlayer.RelationalKeyspaceProvider;
import com.apple.foundationdb.relational.recordlayer.catalog.StoreCatalogProvider;
import com.apple.foundationdb.relational.recordlayer.ddl.RecordLayerMetadataOperationsFactory;
import com.apple.foundationdb.relational.recordlayer.query.cache.RelationalPlanCache;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import com.apple.foundationdb.relational.server.TransactionalToken;
import java.net.URI;
import java.sql.Array;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class FRL
implements AutoCloseable {
    private final FdbConnection fdbDatabase;
    private final RelationalDriver registeredDriver;
    private boolean registeredJDBCEmbedDriver;

    public FRL() throws RelationalException {
        this(Options.NONE, null);
    }

    public FRL(@Nonnull Options options) throws RelationalException {
        this(options, null);
    }

    public FRL(@Nonnull Options options, @Nullable String clusterFile) throws RelationalException {
        StoreCatalog storeCatalog;
        FDBDatabase fdbDb = FDBDatabaseFactory.instance().getDatabase(clusterFile);
        Long asyncToSyncTimeout = (Long)options.getOption(Options.Name.ASYNC_OPERATIONS_TIMEOUT_MILLIS);
        if (asyncToSyncTimeout > 0L) {
            fdbDb.setAsyncToSyncTimeout(asyncToSyncTimeout, TimeUnit.MILLISECONDS);
        }
        this.fdbDatabase = new DirectFdbConnection(fdbDb, NoOpMetricRegistry.INSTANCE);
        RelationalKeyspaceProvider keyspaceProvider = RelationalKeyspaceProvider.instance();
        keyspaceProvider.registerDomainIfNotExists("FRL");
        KeySpace keySpace = keyspaceProvider.getKeySpace();
        try (Transaction txn = this.fdbDatabase.getTransactionManager().createTransaction(Options.NONE);){
            storeCatalog = StoreCatalogProvider.getCatalog(txn, keySpace);
            txn.commit();
        }
        RecordLayerConfig rlConfig = RecordLayerConfig.getDefault();
        RecordLayerMetadataOperationsFactory ddlFactory = new RecordLayerMetadataOperationsFactory.Builder().setRlConfig(rlConfig).setBaseKeySpace(keySpace).setStoreCatalog(storeCatalog).build();
        try {
            this.registeredDriver = new EmbeddedRelationalDriver(RecordLayerEngine.makeEngine(rlConfig, Collections.singletonList(fdbDb), keySpace, storeCatalog, null, ddlFactory, ((RelationalPlanCache.RelationalCacheBuilder)((RelationalPlanCache.RelationalCacheBuilder)((RelationalPlanCache.RelationalCacheBuilder)((RelationalPlanCache.RelationalCacheBuilder)((RelationalPlanCache.RelationalCacheBuilder)((RelationalPlanCache.RelationalCacheBuilder)RelationalPlanCache.newRelationalCacheBuilder().setTtl((Long)options.getOption(Options.Name.PLAN_CACHE_PRIMARY_TIME_TO_LIVE_MILLIS))).setSize((Integer)options.getOption(Options.Name.PLAN_CACHE_PRIMARY_MAX_ENTRIES))).setSecondaryTtl((Long)options.getOption(Options.Name.PLAN_CACHE_SECONDARY_TIME_TO_LIVE_MILLIS))).setSecondarySize((Integer)options.getOption(Options.Name.PLAN_CACHE_SECONDARY_MAX_ENTRIES))).setTertiaryTtl((Long)options.getOption(Options.Name.PLAN_CACHE_TERTIARY_TIME_TO_LIVE_MILLIS))).setTertiarySize((Integer)options.getOption(Options.Name.PLAN_CACHE_TERTIARY_MAX_ENTRIES))).build()));
            DriverManager.registerDriver(this.registeredDriver);
            this.registeredJDBCEmbedDriver = true;
        }
        catch (SQLException ve) {
            throw new RelationalException(ve);
        }
    }

    private static String createEmbeddedJDBCURI(String database, String schema) {
        return "jdbc:embed:" + database + (String)(schema != null ? "?schema=" + schema : "");
    }

    @Nonnull
    public Response execute(String database, String schema, String sql, List<Parameter> parameters, Options options) throws SQLException {
        try (RelationalConnection connection = this.connect(database, schema, options);){
            Response response = this.executeInternal(connection, sql, parameters, null);
            return response;
        }
    }

    private RelationalConnection connect(String database, String schema, Options options) throws SQLException {
        RelationalDriver driver = (RelationalDriver)DriverManager.getDriver(FRL.createEmbeddedJDBCURI(database, schema));
        return driver.connect(URI.create(FRL.createEmbeddedJDBCURI(database, schema)), options);
    }

    /*
     * Exception decompiling
     */
    private Response executeInternal(@Nonnull RelationalConnection connection, @Nonnull String sql, @Nullable List<Parameter> parameters, @Nullable Options options) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setStatementOptions(@Nullable Options options, Statement statement) throws SQLException {
        if (options != null) {
            statement.setMaxRows((Integer)options.getOption(Options.Name.MAX_ROWS));
        }
    }

    private static void addPreparedStatementParameter(@Nonnull RelationalPreparedStatement relationalPreparedStatement, @Nonnull Parameter parameter, int index) throws SQLException {
        Column oneOfValue = parameter.getParameter();
        if (oneOfValue.hasString()) {
            relationalPreparedStatement.setString(index, oneOfValue.getString());
        } else if (oneOfValue.hasLong()) {
            relationalPreparedStatement.setLong(index, oneOfValue.getLong());
        } else if (oneOfValue.hasInteger()) {
            relationalPreparedStatement.setInt(index, oneOfValue.getInteger());
        } else if (oneOfValue.hasFloat()) {
            relationalPreparedStatement.setFloat(index, oneOfValue.getFloat());
        } else if (oneOfValue.hasDouble()) {
            relationalPreparedStatement.setDouble(index, oneOfValue.getDouble());
        } else if (oneOfValue.hasBoolean()) {
            relationalPreparedStatement.setBoolean(index, oneOfValue.getBoolean());
        } else if (oneOfValue.hasBinary()) {
            relationalPreparedStatement.setBytes(index, oneOfValue.getBinary().toByteArray());
        } else if (oneOfValue.hasNullType()) {
            relationalPreparedStatement.setNull(index, oneOfValue.getNullType());
        } else if (oneOfValue.hasUuid()) {
            relationalPreparedStatement.setUUID(index, new UUID(oneOfValue.getUuid().getMostSignificantBits(), oneOfValue.getUuid().getLeastSignificantBits()));
        } else if (oneOfValue.hasArray()) {
            com.apple.foundationdb.relational.jdbc.grpc.v1.column.Array arrayProto = parameter.getParameter().getArray();
            Array relationalArray = relationalPreparedStatement.getConnection().createArrayOf(SqlTypeNamesSupport.getSqlTypeName(arrayProto.getElementType()), TypeConversion.fromArray(arrayProto));
            relationalPreparedStatement.setArray(index, relationalArray);
        } else {
            throw new SQLException("Unsupported value: " + String.valueOf(parameter.getParameter()));
        }
    }

    public int update(String database, String schema, String sql, Options options) throws SQLException {
        try (RelationalConnection connection = this.connect(database, schema, options);){
            int n;
            block12: {
                RelationalStatement statement = connection.createStatement();
                try {
                    n = statement.executeUpdate(sql);
                    if (statement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return n;
        }
    }

    /*
     * Exception decompiling
     */
    public int insert(String database, String schema, String tableName, List<RelationalStruct> data, Options options) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public RelationalResultSet get(String database, String schema, String tableName, KeySet keySet, Options options) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public RelationalResultSet scan(String database, String schema, String tableName, KeySet keySet, Options options) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public TransactionalToken createTransactionalToken(String database, String schema, Options options) throws SQLException {
        RelationalDriver driver = (RelationalDriver)DriverManager.getDriver(FRL.createEmbeddedJDBCURI(database, schema));
        RelationalConnection transactionalConnection = driver.connect(URI.create(FRL.createEmbeddedJDBCURI(database, schema)), options);
        transactionalConnection.setAutoCommit(false);
        return new TransactionalToken(transactionalConnection);
    }

    @Nonnull
    public Response transactionalExecute(TransactionalToken token, String sql, List<Parameter> parameters, @Nullable Options options) throws SQLException {
        this.assertValidToken(token);
        return this.executeInternal(token.getConnection(), sql, parameters, options);
    }

    public int transactionalInsert(TransactionalToken token, String tableName, List<RelationalStruct> data) throws SQLException {
        this.assertValidToken(token);
        try (RelationalStatement statement = token.getConnection().createStatement();){
            int n;
            block12: {
                RelationalStatement relationalStatement = statement.unwrap(RelationalStatement.class);
                try {
                    n = relationalStatement.executeInsert(tableName, data, Options.NONE);
                    if (relationalStatement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (relationalStatement != null) {
                        try {
                            relationalStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                relationalStatement.close();
            }
            return n;
        }
    }

    public void transactionalCommit(TransactionalToken token) throws SQLException {
        this.assertValidToken(token);
        token.getConnection().commit();
    }

    public void transactionalRollback(TransactionalToken token) throws SQLException {
        this.assertValidToken(token);
        token.getConnection().rollback();
    }

    public void enableAutoCommit(TransactionalToken token) throws SQLException {
        this.assertValidToken(token);
        token.getConnection().setAutoCommit(true);
    }

    public void transactionalClose(TransactionalToken token) throws SQLException {
        if (token != null && !token.expired()) {
            token.close();
        }
    }

    private void assertValidToken(TransactionalToken token) throws SQLException {
        if (token == null) {
            throw new SQLException("Transaction was not initialized");
        }
        if (token.expired()) {
            throw new SQLException("Transaction had expired");
        }
    }

    @Override
    public void close() throws SQLException, RelationalException {
        try {
            this.fdbDatabase.close();
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
        if (this.registeredJDBCEmbedDriver) {
            DriverManager.deregisterDriver(this.registeredDriver);
        }
    }

    public static final class Response {
        private final Optional<ResultSet> resultSet;
        private final int rowCount;

        private Response(@Nullable ResultSet resultSet, int rowCount) {
            this.resultSet = Optional.ofNullable(resultSet);
            this.rowCount = rowCount;
        }

        public static Response query(@Nonnull ResultSet resultSet) {
            return new Response(resultSet, -1);
        }

        public static Response mutation(int rowCount) {
            return new Response(null, rowCount);
        }

        public boolean isQuery() {
            return this.resultSet.isPresent();
        }

        public boolean isMutation() {
            return this.resultSet.isEmpty();
        }

        public ResultSet getResultSet() {
            return this.resultSet.get();
        }

        public int getRowCount() {
            return this.rowCount;
        }
    }
}

