/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.server;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.server.FRL;
import com.apple.foundationdb.relational.server.jdbc.v1.JDBCService;
import io.grpc.Server;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.time.Instant;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class InProcessRelationalServer
implements Closeable {
    private Server grpcInProcessServer;
    private FRL frl;
    private final String serverName;
    @Nullable
    private final String clusterFile;

    public InProcessRelationalServer() {
        this(InProcessServerBuilder.generateName(), null);
    }

    public InProcessRelationalServer(@Nullable String clusterFile) {
        this(InProcessServerBuilder.generateName(), clusterFile);
    }

    InProcessRelationalServer(String serverName, @Nullable String clusterFile) {
        this.serverName = serverName;
        this.clusterFile = clusterFile;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String toString() {
        return this.getServerName();
    }

    public InProcessRelationalServer start() throws IOException {
        try {
            this.frl = new FRL(Options.NONE, this.clusterFile);
        }
        catch (RelationalException ve) {
            throw new IOException(ve);
        }
        this.grpcInProcessServer = ((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName(this.getServerName()).directExecutor()).addService(new JDBCService(this.frl))).build();
        this.grpcInProcessServer.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.err.println(String.valueOf(Instant.now()) + " Waiting on in-process Server " + InProcessRelationalServer.this.getServerName() + " termination");
                try {
                    InProcessRelationalServer.this.grpcInProcessServer.shutdown();
                    InProcessRelationalServer.this.awaitTermination();
                }
                catch (InterruptedIOException e) {
                    throw new RuntimeException(e);
                }
                System.err.println(String.valueOf(Instant.now()) + " Server shutdown");
            }
        });
        return this;
    }

    void awaitTermination() throws InterruptedIOException {
        try {
            if (this.grpcInProcessServer != null) {
                this.grpcInProcessServer.awaitTermination();
            }
        }
        catch (InterruptedException ioe) {
            InterruptedIOException iioe = new InterruptedIOException();
            iioe.initCause(ioe);
            throw iioe;
        }
    }

    @Override
    public void close() throws IOException {
        IOException ioe = null;
        if (this.frl != null) {
            try {
                this.frl.close();
            }
            catch (Exception e) {
                ioe = new IOException(e);
            }
        }
        if (this.grpcInProcessServer != null) {
            this.grpcInProcessServer.shutdown();
            this.awaitTermination();
        }
        if (ioe != null) {
            throw ioe;
        }
    }
}

