/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.server;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.server.FRL;
import com.apple.foundationdb.relational.server.jdbc.v1.JDBCService;
import com.google.common.annotations.VisibleForTesting;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptors;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.protobuf.services.HealthStatusManager;
import io.grpc.protobuf.services.ProtoReflectionService;
import io.grpc.util.TransmitStatusRuntimeExceptionInterceptor;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.time.Instant;
import java.util.stream.Collectors;
import me.dinowernli.grpc.prometheus.Configuration;
import me.dinowernli.grpc.prometheus.MonitoringServerInterceptor;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@API(value=API.Status.EXPERIMENTAL)
public class RelationalServer
implements Closeable {
    private static final Logger logger = LogManager.getLogger(RelationalServer.class.getName());
    private static final int DEFAULT_HTTP_PORT = 1112;
    private Server grpcServer;
    private final int grpcPort;
    private final int httpPort;
    private FRL frl;
    private final CollectorRegistry collectorRegistry;

    @VisibleForTesting
    RelationalServer(int grpcPort, int httpPort, CollectorRegistry collectorRegistry) {
        this.grpcPort = grpcPort;
        this.httpPort = httpPort;
        this.collectorRegistry = collectorRegistry;
    }

    public RelationalServer(int grpcPort, int httpPort) {
        this(grpcPort, httpPort, CollectorRegistry.defaultRegistry);
    }

    public String toString() {
        return "listening=" + String.valueOf(this.grpcServer.getListenSockets()) + ", services=" + String.valueOf(this.grpcServer.getServices().stream().map(m4 -> m4.getServiceDescriptor().getName()).collect(Collectors.toList())) + ", httpPort=" + this.httpPort;
    }

    public int getGrpcPort() {
        return this.grpcServer.getPort();
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    @VisibleForTesting
    CollectorRegistry getCollectorRegistry() {
        return this.collectorRegistry;
    }

    RelationalServer start() throws IOException {
        try {
            this.frl = new FRL();
        }
        catch (RelationalException ve) {
            throw new IOException(ve);
        }
        HealthStatusManager healthStatusManager = new HealthStatusManager();
        healthStatusManager.setStatus("grpc.health.v1.Health", HealthCheckResponse.ServingStatus.SERVING);
        healthStatusManager.setStatus("grpc.reflection.v1alpha.ServerReflection", HealthCheckResponse.ServingStatus.SERVING);
        healthStatusManager.setStatus("grpc.relational.jdbc.v1.JDBCService", HealthCheckResponse.ServingStatus.SERVING);
        MonitoringServerInterceptor grpcMetrics = MonitoringServerInterceptor.create(Configuration.allMetrics().withCollectorRegistry(this.collectorRegistry));
        this.grpcServer = ((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)ServerBuilder.forPort(this.grpcPort).addService(ServerInterceptors.intercept(healthStatusManager.getHealthService(), grpcMetrics))).addService(ServerInterceptors.intercept(ProtoReflectionService.newInstance(), grpcMetrics))).addService(ServerInterceptors.intercept((BindableService)new JDBCService(this.frl), grpcMetrics))).intercept(TransmitStatusRuntimeExceptionInterceptor.instance())).build();
        this.grpcServer.start();
        String services = this.grpcServer.getServices().stream().map(p -> p.getServiceDescriptor().getName()).collect(Collectors.joining(", "));
        new HTTPServer.Builder().withPort(this.httpPort).withRegistry(this.collectorRegistry).build();
        if (logger.isInfoEnabled()) {
            logger.info("Started on grpcPort={}/httpPort={} with services: {}", (Object)this.getGrpcPort(), (Object)this.getHttpPort(), (Object)services);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.err.println(String.valueOf(Instant.now()) + " Waiting on Server termination");
                try {
                    RelationalServer.this.grpcServer.shutdown();
                    RelationalServer.this.awaitTermination();
                }
                catch (InterruptedIOException e) {
                    throw new RuntimeException(e);
                }
                System.err.println(String.valueOf(Instant.now()) + " Server shutdown");
            }
        });
        return this;
    }

    void awaitTermination() throws InterruptedIOException {
        try {
            if (this.grpcServer != null) {
                this.grpcServer.awaitTermination();
            }
        }
        catch (InterruptedException ioe) {
            InterruptedIOException iioe = new InterruptedIOException();
            iioe.initCause(ioe);
            throw iioe;
        }
    }

    @Override
    public void close() throws IOException {
        IOException ioe = null;
        if (this.frl != null) {
            try {
                this.frl.close();
            }
            catch (Exception e) {
                ioe = new IOException(e);
            }
        }
        if (this.grpcServer != null) {
            this.grpcServer.shutdown();
            this.awaitTermination();
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    private static int getPort(CommandLine cli, Option option, int defaultPort) {
        int port = defaultPort;
        if (cli.hasOption(option.getOpt())) {
            try {
                port = ((Number)cli.getParsedOptionValue(option.getOpt())).intValue();
            }
            catch (ParseException pe) {
                System.err.println("Parse failed, option=" + option.getOpt() + ". " + pe.getMessage());
                System.exit(1);
            }
        }
        return port;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Options options = new Options();
        Option help = new Option("h", "help", false, "Output this help message.");
        options.addOption(help);
        Option grpcPortOption = Option.builder().option("g").longOpt("grpcPort").hasArg(true).type(Number.class).desc("Port for GRPC to listen on; default=1111.").build();
        options.addOption(grpcPortOption);
        Option httpPortOption = Option.builder().option("p").longOpt("httpPort").hasArg(true).type(Number.class).desc("Port for HTTP to listen on; default=1112.").build();
        options.addOption(httpPortOption);
        DefaultParser parser = new DefaultParser();
        CommandLine cli = null;
        try {
            cli = parser.parse(options, args);
        }
        catch (ParseException pe) {
            System.err.println("Parse of command-line failed: " + pe.getMessage());
            System.exit(1);
        }
        if (cli.hasOption(help.getOpt())) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("relational", options, true);
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("FDB_CLUSTER_FILE: " + System.getenv("FDB_CLUSTER_FILE"));
            logger.info("DYLD_LIBRARY_PATH: " + System.getenv("DYLD_LIBRARY_PATH"));
        }
        int grpcPort = RelationalServer.getPort(cli, grpcPortOption, 1111);
        int httpPort = RelationalServer.getPort(cli, httpPortOption, 1112);
        new RelationalServer(grpcPort, httpPort).start().awaitTermination();
    }
}

