/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.server.jdbc.v1;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.jdbc.TypeConversion;
import com.apple.foundationdb.relational.jdbc.grpc.GrpcSQLExceptionUtil;
import com.apple.foundationdb.relational.jdbc.grpc.v1.DatabaseMetaDataRequest;
import com.apple.foundationdb.relational.jdbc.grpc.v1.DatabaseMetaDataResponse;
import com.apple.foundationdb.relational.jdbc.grpc.v1.GetRequest;
import com.apple.foundationdb.relational.jdbc.grpc.v1.GetResponse;
import com.apple.foundationdb.relational.jdbc.grpc.v1.InsertRequest;
import com.apple.foundationdb.relational.jdbc.grpc.v1.InsertResponse;
import com.apple.foundationdb.relational.jdbc.grpc.v1.JDBCServiceGrpc;
import com.apple.foundationdb.relational.jdbc.grpc.v1.ResultSet;
import com.apple.foundationdb.relational.jdbc.grpc.v1.ScanRequest;
import com.apple.foundationdb.relational.jdbc.grpc.v1.ScanResponse;
import com.apple.foundationdb.relational.jdbc.grpc.v1.StatementRequest;
import com.apple.foundationdb.relational.jdbc.grpc.v1.StatementResponse;
import com.apple.foundationdb.relational.jdbc.grpc.v1.TransactionalRequest;
import com.apple.foundationdb.relational.jdbc.grpc.v1.TransactionalResponse;
import com.apple.foundationdb.relational.server.FRL;
import com.apple.foundationdb.relational.server.jdbc.v1.TransactionRequestHandler;
import com.apple.foundationdb.relational.util.BuildVersion;
import com.google.common.annotations.VisibleForTesting;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import io.grpc.stub.StreamObserver;
import java.sql.SQLException;

@API(value=API.Status.EXPERIMENTAL)
public class JDBCService
extends JDBCServiceGrpc.JDBCServiceImplBase {
    private final FRL frl;

    public JDBCService(FRL frl) {
        this.frl = frl;
    }

    @Override
    public void getMetaData(DatabaseMetaDataRequest request, StreamObserver<DatabaseMetaDataResponse> responseObserver) {
        DatabaseMetaDataResponse databaseMetaDataResponse = DatabaseMetaDataResponse.newBuilder().setDatabaseProductVersion(BuildVersion.getInstance().getVersion()).setUrl(BuildVersion.getInstance().getURL()).build();
        responseObserver.onNext(databaseMetaDataResponse);
        responseObserver.onCompleted();
    }

    @Override
    public void execute(StatementRequest request, StreamObserver<StatementResponse> responseObserver) {
        if (!JDBCService.checkStatementRequest(request, responseObserver)) {
            return;
        }
        try {
            StatementResponse.Builder statementResponseBuilder = StatementResponse.newBuilder();
            FRL.Response response = this.frl.execute(request.getDatabase(), request.getSchema(), request.getSql(), request.hasParameters() ? request.getParameters().getParameterList() : null, TypeConversion.fromProtobuf(request.getOptions()));
            if (response.isQuery()) {
                ResultSet rs = response.getResultSet();
                statementResponseBuilder.setRowCount(rs.getRowCount());
                statementResponseBuilder.setResultSet(rs);
            } else {
                statementResponseBuilder.setRowCount(response.getRowCount());
            }
            responseObserver.onNext(statementResponseBuilder.build());
            responseObserver.onCompleted();
        }
        catch (SQLException e) {
            responseObserver.onError(StatusProto.toStatusRuntimeException(GrpcSQLExceptionUtil.create(e)));
        }
        catch (RuntimeException e) {
            throw JDBCService.handleUncaughtException(e);
        }
    }

    @Override
    public StreamObserver<TransactionalRequest> handleAutoCommitOff(StreamObserver<TransactionalResponse> responseObserver) {
        return new TransactionRequestHandler(responseObserver, this.frl);
    }

    @Override
    public void update(StatementRequest request, StreamObserver<StatementResponse> responseObserver) {
        if (!JDBCService.checkStatementRequest(request, responseObserver)) {
            return;
        }
        try {
            int rowCount = this.frl.update(request.getDatabase(), request.getSchema(), request.getSql(), TypeConversion.fromProtobuf(request.getOptions()));
            StatementResponse statementResponse = StatementResponse.newBuilder().setRowCount(rowCount).build();
            responseObserver.onNext(statementResponse);
            responseObserver.onCompleted();
        }
        catch (SQLException e) {
            responseObserver.onError(StatusProto.toStatusRuntimeException(GrpcSQLExceptionUtil.create(e)));
        }
        catch (RuntimeException e) {
            throw JDBCService.handleUncaughtException(e);
        }
    }

    @VisibleForTesting
    static boolean checkStatementRequest(StatementRequest request, StreamObserver<?> responseObserver) {
        if (!request.hasDatabase() || request.getDatabase().isEmpty()) {
            responseObserver.onError(JDBCService.createStatusRuntimeException("Empty database name"));
            return false;
        }
        if (!request.hasSchema() || request.getSchema().isEmpty()) {
            responseObserver.onError(JDBCService.createStatusRuntimeException("Empty schema name"));
            return false;
        }
        if (!request.hasSql() || request.getSql().isEmpty()) {
            responseObserver.onError(JDBCService.createStatusRuntimeException("Empty sql statement"));
            return false;
        }
        return true;
    }

    @Override
    public void insert(InsertRequest request, StreamObserver<InsertResponse> responseObserver) {
        if (!JDBCService.checkInsertRequest(request, responseObserver)) {
            return;
        }
        try {
            int rowCount = this.frl.insert(request.getDatabase(), request.getSchema(), request.getTableName(), TypeConversion.fromResultSetProtobuf(request.getDataResultSet()), TypeConversion.fromProtobuf(request.getOptions()));
            InsertResponse insertResponse = InsertResponse.newBuilder().setRowCount(rowCount).build();
            responseObserver.onNext(insertResponse);
            responseObserver.onCompleted();
        }
        catch (SQLException e) {
            responseObserver.onError(StatusProto.toStatusRuntimeException(GrpcSQLExceptionUtil.create(e)));
        }
        catch (RuntimeException e) {
            throw JDBCService.handleUncaughtException(e);
        }
    }

    private static boolean checkInsertRequest(InsertRequest request, StreamObserver<InsertResponse> responseObserver) {
        if (!request.hasDatabase() || request.getDatabase().isEmpty()) {
            responseObserver.onError(JDBCService.createStatusRuntimeException("Empty database name"));
            return false;
        }
        if (!request.hasSchema() || request.getSchema().isEmpty()) {
            responseObserver.onError(JDBCService.createStatusRuntimeException("Empty schema name"));
            return false;
        }
        if (!request.hasTableName() || request.getTableName().isEmpty()) {
            responseObserver.onError(JDBCService.createStatusRuntimeException("Empty table name"));
            return false;
        }
        if (request.getDataResultSet().getRowCount() <= 0) {
            responseObserver.onError(JDBCService.createStatusRuntimeException("No data in insert"));
            return false;
        }
        return true;
    }

    @Override
    public void get(GetRequest request, StreamObserver<GetResponse> responseObserver) {
        if (!JDBCService.checkGetRequest(request, responseObserver)) {
            return;
        }
        try (RelationalResultSet rs = this.frl.get(request.getDatabase(), request.getSchema(), request.getTableName(), TypeConversion.fromProtobuf(request.getKeySet()), TypeConversion.fromProtobuf(request.getOptions()));){
            GetResponse getResponse = GetResponse.newBuilder().setResultSet(TypeConversion.toProtobuf(rs)).build();
            responseObserver.onNext(getResponse);
            responseObserver.onCompleted();
        }
        catch (SQLException e) {
            responseObserver.onError(StatusProto.toStatusRuntimeException(GrpcSQLExceptionUtil.create(e)));
        }
        catch (RuntimeException e) {
            throw JDBCService.handleUncaughtException(e);
        }
    }

    private static StatusRuntimeException createStatusRuntimeException(String invalidStr) {
        return Status.INVALID_ARGUMENT.withDescription(invalidStr).asRuntimeException();
    }

    private static boolean checkGetRequest(GetRequest request, StreamObserver<GetResponse> responseObserver) {
        if (!request.hasDatabase() || request.getDatabase().isEmpty()) {
            responseObserver.onError(JDBCService.createStatusRuntimeException("Empty database name"));
            return false;
        }
        if (!request.hasSchema() || request.getSchema().isEmpty()) {
            responseObserver.onError(JDBCService.createStatusRuntimeException("Empty schema name"));
            return false;
        }
        if (!request.hasTableName() || request.getTableName().isEmpty()) {
            responseObserver.onError(JDBCService.createStatusRuntimeException("Empty table name"));
            return false;
        }
        if (!request.hasKeySet()) {
            responseObserver.onError(JDBCService.createStatusRuntimeException("Has no keyset"));
            return false;
        }
        return true;
    }

    @Override
    public void scan(ScanRequest request, StreamObserver<ScanResponse> responseObserver) {
        if (!JDBCService.checkScanRequest(request, responseObserver)) {
            return;
        }
        try (RelationalResultSet rs = this.frl.scan(request.getDatabase(), request.getSchema(), request.getTableName(), TypeConversion.fromProtobuf(request.getKeySet()), TypeConversion.fromProtobuf(request.getOptions()));){
            ScanResponse scanResponse = ScanResponse.newBuilder().setResultSet(TypeConversion.toProtobuf(rs)).build();
            responseObserver.onNext(scanResponse);
            responseObserver.onCompleted();
        }
        catch (SQLException e) {
            responseObserver.onError(StatusProto.toStatusRuntimeException(GrpcSQLExceptionUtil.create(e)));
        }
        catch (RuntimeException e) {
            throw JDBCService.handleUncaughtException(e);
        }
    }

    private static boolean checkScanRequest(ScanRequest request, StreamObserver<ScanResponse> responseObserver) {
        if (!request.hasDatabase() || request.getDatabase().isEmpty()) {
            responseObserver.onError(JDBCService.createStatusRuntimeException("Empty database name"));
            return false;
        }
        if (!request.hasSchema() || request.getSchema().isEmpty()) {
            responseObserver.onError(JDBCService.createStatusRuntimeException("Empty schema name"));
            return false;
        }
        if (!request.hasTableName() || request.getTableName().isEmpty()) {
            responseObserver.onError(JDBCService.createStatusRuntimeException("Empty table name"));
            return false;
        }
        if (!request.hasKeySet()) {
            responseObserver.onError(JDBCService.createStatusRuntimeException("Has no keyset"));
            return false;
        }
        return true;
    }

    static StatusRuntimeException handleUncaughtException(Throwable t2) {
        return Status.INTERNAL.withDescription("Uncaught exception").augmentDescription(GrpcSQLExceptionUtil.stacktraceToString(t2)).withCause(t2).asRuntimeException();
    }
}

