/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.server.jdbc.v1;

import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.jdbc.TypeConversion;
import com.apple.foundationdb.relational.jdbc.grpc.GrpcSQLExceptionUtil;
import com.apple.foundationdb.relational.jdbc.grpc.v1.CommitResponse;
import com.apple.foundationdb.relational.jdbc.grpc.v1.EnableAutoCommitResponse;
import com.apple.foundationdb.relational.jdbc.grpc.v1.InsertRequest;
import com.apple.foundationdb.relational.jdbc.grpc.v1.InsertResponse;
import com.apple.foundationdb.relational.jdbc.grpc.v1.RollbackResponse;
import com.apple.foundationdb.relational.jdbc.grpc.v1.StatementRequest;
import com.apple.foundationdb.relational.jdbc.grpc.v1.StatementResponse;
import com.apple.foundationdb.relational.jdbc.grpc.v1.TransactionalRequest;
import com.apple.foundationdb.relational.jdbc.grpc.v1.TransactionalResponse;
import com.apple.foundationdb.relational.server.FRL;
import com.apple.foundationdb.relational.server.TransactionalToken;
import com.apple.foundationdb.relational.server.jdbc.v1.JDBCService;
import com.google.protobuf.Any;
import com.google.rpc.Status;
import io.grpc.stub.StreamObserver;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionRequestHandler
implements StreamObserver<TransactionalRequest> {
    private static final Logger logger = LoggerFactory.getLogger(TransactionRequestHandler.class);
    private final StreamObserver<TransactionalResponse> responseObserver;
    private final FRL frl;
    private TransactionalToken transactionalToken;

    public TransactionRequestHandler(StreamObserver<TransactionalResponse> responseObserver, FRL frl) {
        this.responseObserver = responseObserver;
        this.frl = frl;
    }

    @Override
    public void onNext(TransactionalRequest transactionRequest) {
        TransactionalResponse.Builder responseBuilder = TransactionalResponse.newBuilder();
        try {
            if (transactionRequest.hasExecuteRequest()) {
                StatementRequest request = transactionRequest.getExecuteRequest();
                Options options = TypeConversion.fromProtobuf(request.getOptions());
                if (logger.isInfoEnabled()) {
                    logger.info(KeyValueLogMessage.build("Handling execute request", new Object[0]).addKeyAndValue((Object)LogMessageKeys.QUERY, request.getSql()).toString());
                }
                if (this.transactionalToken == null || this.transactionalToken.expired()) {
                    this.transactionalToken = this.frl.createTransactionalToken(request.getDatabase(), request.getSchema(), options);
                }
                FRL.Response response = this.frl.transactionalExecute(this.transactionalToken, request.getSql(), request.getParameters().getParameterList(), options);
                StatementResponse.Builder statementResponseBuilder = StatementResponse.newBuilder();
                if (response.isQuery()) {
                    statementResponseBuilder.setResultSet(response.getResultSet());
                }
                if (response.isMutation()) {
                    statementResponseBuilder.setRowCount(response.getRowCount());
                }
                responseBuilder.setExecuteResponse(statementResponseBuilder);
            } else if (transactionRequest.hasInsertRequest()) {
                InsertRequest request = transactionRequest.getInsertRequest();
                Options options = TypeConversion.fromProtobuf(request.getOptions());
                if (logger.isInfoEnabled()) {
                    logger.info(KeyValueLogMessage.build("Handling insert request", new Object[0]).addKeyAndValue((Object)LogMessageKeys.RECORD_TYPE, request.getTableName()).toString());
                }
                if (this.transactionalToken == null || this.transactionalToken.expired()) {
                    this.transactionalToken = this.frl.createTransactionalToken(request.getDatabase(), request.getSchema(), options);
                }
                int recordsInserted = this.frl.transactionalInsert(this.transactionalToken, request.getTableName(), TypeConversion.fromResultSetProtobuf(request.getDataResultSet()));
                responseBuilder.setInsertResponse(InsertResponse.newBuilder().setRowCount(recordsInserted));
            } else if (transactionRequest.hasCommitRequest()) {
                logger.info("Handling commit request");
                this.frl.transactionalCommit(this.transactionalToken);
                responseBuilder.setCommitResponse(CommitResponse.newBuilder().build());
            } else if (transactionRequest.hasRollbackRequest()) {
                logger.info("Handling rollback request");
                this.frl.transactionalRollback(this.transactionalToken);
                responseBuilder.setRollbackResponse(RollbackResponse.newBuilder().build());
            } else if (transactionRequest.hasEnableAutoCommitRequest()) {
                logger.info("Enabling autoCommit");
                if (this.transactionalToken != null) {
                    this.frl.enableAutoCommit(this.transactionalToken);
                }
                responseBuilder.setEnableAutoCommitResponse(EnableAutoCommitResponse.newBuilder().build());
            } else {
                throw new IllegalArgumentException("Unknown transactional request type: " + String.valueOf(transactionRequest));
            }
            this.responseObserver.onNext(responseBuilder.build());
        }
        catch (SQLException e) {
            if (logger.isInfoEnabled()) {
                logger.info("Caught SQL exception: returning to client: {}", (Object)e.getMessage());
            }
            Status status = GrpcSQLExceptionUtil.create(e);
            responseBuilder.setErrorResponse(Any.pack(status));
            this.responseObserver.onNext(responseBuilder.build());
        }
        catch (RuntimeException e) {
            logger.warn("Caught unknown exception", e);
            throw JDBCService.handleUncaughtException(e);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        logger.warn("executeInTransaction: onError called", throwable);
        this.closeConnectionIfExists();
    }

    @Override
    public void onCompleted() {
        this.responseObserver.onCompleted();
        this.closeConnectionIfExists();
    }

    private void closeConnectionIfExists() {
        block2: {
            try {
                this.frl.transactionalClose(this.transactionalToken);
            }
            catch (SQLException e) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn(KeyValueLogMessage.build("Error while closing transactional connection", new Object[0]).toString(), e);
            }
        }
    }
}

