/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.transactionbound;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.EmbeddedRelationalEngine;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.StorageCluster;
import com.apple.foundationdb.relational.api.metrics.NoOpMetricRegistry;
import com.apple.foundationdb.relational.recordlayer.query.cache.RelationalPlanCache;
import com.apple.foundationdb.relational.transactionbound.TransactionBoundStorageCluster;
import java.util.Collection;
import java.util.List;

@API(value=API.Status.EXPERIMENTAL)
public class TransactionBoundEmbeddedRelationalEngine
extends EmbeddedRelationalEngine {
    private final RelationalPlanCache planCache;
    private final List<StorageCluster> clusters;

    public TransactionBoundEmbeddedRelationalEngine() {
        this(Options.NONE);
    }

    public TransactionBoundEmbeddedRelationalEngine(Options engineOptions) {
        super(List.of(new TransactionBoundStorageCluster(null)), NoOpMetricRegistry.INSTANCE);
        Integer primaryCacheSize = (Integer)engineOptions.getOption(Options.Name.PLAN_CACHE_PRIMARY_MAX_ENTRIES);
        Integer secondaryCacheSize = (Integer)engineOptions.getOption(Options.Name.PLAN_CACHE_SECONDARY_MAX_ENTRIES);
        Integer tertiaryCacheSize = (Integer)engineOptions.getOption(Options.Name.PLAN_CACHE_TERTIARY_MAX_ENTRIES);
        Long primaryCacheTtlMillis = (Long)engineOptions.getOption(Options.Name.PLAN_CACHE_PRIMARY_TIME_TO_LIVE_MILLIS);
        Long secondaryCacheTtlMillis = (Long)engineOptions.getOption(Options.Name.PLAN_CACHE_SECONDARY_TIME_TO_LIVE_MILLIS);
        Long tertiaryCacheTtlMillis = (Long)engineOptions.getOption(Options.Name.PLAN_CACHE_TERTIARY_TIME_TO_LIVE_MILLIS);
        this.planCache = primaryCacheSize == null || primaryCacheSize <= 0 ? null : ((RelationalPlanCache.RelationalCacheBuilder)((RelationalPlanCache.RelationalCacheBuilder)((RelationalPlanCache.RelationalCacheBuilder)((RelationalPlanCache.RelationalCacheBuilder)((RelationalPlanCache.RelationalCacheBuilder)((RelationalPlanCache.RelationalCacheBuilder)RelationalPlanCache.newRelationalCacheBuilder().setSize(primaryCacheSize)).setSecondarySize(secondaryCacheSize)).setTertiarySize(tertiaryCacheSize)).setTtl(primaryCacheTtlMillis)).setSecondaryTtl(secondaryCacheTtlMillis)).setTertiaryTtl(tertiaryCacheTtlMillis)).build();
        this.clusters = List.of(new TransactionBoundStorageCluster(this.planCache));
    }

    @Override
    public Collection<StorageCluster> getStorageClusters() {
        return this.clusters;
    }

    public RelationalPlanCache getPlanCache() {
        return this.planCache;
    }
}

