/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.transactionbound;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.StorageCluster;
import com.apple.foundationdb.relational.api.TransactionManager;
import com.apple.foundationdb.relational.api.catalog.RelationalDatabase;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.HollowTransactionManager;
import com.apple.foundationdb.relational.recordlayer.catalog.TransactionBoundDatabase;
import com.apple.foundationdb.relational.recordlayer.query.cache.RelationalPlanCache;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class TransactionBoundStorageCluster
implements StorageCluster {
    @Nullable
    private final RelationalPlanCache planCache;

    public TransactionBoundStorageCluster(@Nullable RelationalPlanCache planCache) {
        this.planCache = planCache;
    }

    @Override
    @Nullable
    public RelationalDatabase loadDatabase(@Nonnull URI url, @Nonnull Options connOptions) throws RelationalException {
        return new TransactionBoundDatabase(url, connOptions, this.planCache);
    }

    @Override
    public TransactionManager getTransactionManager() {
        return HollowTransactionManager.INSTANCE;
    }
}

