/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.util;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.exceptions.UncheckedRelationalException;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class Assert {
    public static void that(boolean mustBeTrue) throws RelationalException {
        Assert.that(mustBeTrue, "condition is not met!");
    }

    public static void that(boolean mustBeTrue, @Nonnull String messageIfNotTrue) throws RelationalException {
        Assert.that(mustBeTrue, ErrorCode.INTERNAL_ERROR, messageIfNotTrue);
    }

    public static void that(boolean mustBeTrue, @Nonnull ErrorCode errorCodeIfNotTrue, @Nonnull Supplier<String> messageSupplier) throws RelationalException {
        if (!mustBeTrue) {
            throw new RelationalException(messageSupplier.get(), errorCodeIfNotTrue);
        }
    }

    public static void that(boolean mustBeTrue, @Nonnull ErrorCode errorCodeIfNotTrue, @Nonnull String messageIfNotTrue) throws RelationalException {
        if (!mustBeTrue) {
            throw new RelationalException(messageIfNotTrue, errorCodeIfNotTrue);
        }
    }

    public static void that(boolean mustBeTrue, @Nonnull ErrorCode errorCodeIfNotTrue, @Nonnull String messageFormat, @Nonnull Object messageValue) throws RelationalException {
        if (!mustBeTrue) {
            throw new RelationalException(String.format(Locale.ROOT, messageFormat, messageValue), errorCodeIfNotTrue);
        }
    }

    public static void that(boolean mustBeTrue, @Nonnull ErrorCode errorCodeIfNotTrue, @Nonnull String messageFormat, @Nonnull Object messageValue1, @Nonnull Object messageValue2) throws RelationalException {
        if (!mustBeTrue) {
            throw new RelationalException(String.format(Locale.ROOT, messageFormat, messageValue1, messageValue2), errorCodeIfNotTrue);
        }
    }

    public static <T> T notNull(T object) throws RelationalException {
        return Assert.notNull(object, "unexpected null object");
    }

    public static <T> T notNull(T object, @Nonnull String messageIfNull) throws RelationalException {
        return Assert.notNull(object, ErrorCode.INTERNAL_ERROR, messageIfNull);
    }

    public static <T> T notNull(T object, @Nonnull ErrorCode errorCodeIfNotTrue, @Nonnull String messageIfNull) throws RelationalException {
        if (object == null) {
            throw new RelationalException(messageIfNull, errorCodeIfNotTrue);
        }
        return object;
    }

    public static void isNull(Object object) throws RelationalException {
        Assert.isNull(object, "expected object to be null");
    }

    public static void isNull(Object object, @Nonnull String messageIfNull) throws RelationalException {
        Assert.isNull(object, ErrorCode.INTERNAL_ERROR, messageIfNull);
    }

    public static void isNull(Object object, @Nonnull ErrorCode errorCodeIfNotTrue, @Nonnull String messageIfNull) throws RelationalException {
        if (object != null) {
            throw new RelationalException(messageIfNull, errorCodeIfNotTrue);
        }
    }

    public static RelationalException fail() throws RelationalException {
        throw Assert.fail("unexpected error");
    }

    public static RelationalException fail(@Nonnull String failMessage) throws RelationalException {
        throw Assert.fail(ErrorCode.INTERNAL_ERROR, failMessage);
    }

    public static RelationalException fail(@Nonnull ErrorCode failErrorCode, @Nonnull String failMessage) throws RelationalException {
        throw new RelationalException(failMessage, failErrorCode);
    }

    public static void thatUnchecked(boolean mustBeTrue) {
        Assert.thatUnchecked(mustBeTrue, "condition is not met!");
    }

    public static void thatUnchecked(boolean mustBeTrue, @Nonnull String messageIfNotTrue) {
        Assert.thatUnchecked(mustBeTrue, ErrorCode.INTERNAL_ERROR, messageIfNotTrue);
    }

    public static void thatUnchecked(boolean mustBeTrue, @Nonnull ErrorCode errorCodeIfNotTrue, @Nonnull Supplier<String> messageSupplier) {
        if (!mustBeTrue) {
            throw new RelationalException(messageSupplier.get(), errorCodeIfNotTrue).toUncheckedWrappedException();
        }
    }

    public static void thatUnchecked(boolean mustBeTrue, @Nonnull ErrorCode errorCodeIfNotTrue, @Nonnull String messageIfNotTrue) {
        if (!mustBeTrue) {
            throw new RelationalException(messageIfNotTrue, errorCodeIfNotTrue).toUncheckedWrappedException();
        }
    }

    public static void thatUnchecked(boolean mustBeTrue, @Nonnull ErrorCode errorCodeIfNotTrue, @Nonnull String messageTemplate, @Nonnull Object messageValue) {
        if (!mustBeTrue) {
            throw new RelationalException(String.format(Locale.ROOT, messageTemplate, messageValue), errorCodeIfNotTrue).toUncheckedWrappedException();
        }
    }

    public static void thatUnchecked(boolean mustBeTrue, @Nonnull ErrorCode errorCodeIfNotTrue, @Nonnull String messageTemplate, @Nonnull Object messageValue1, @Nonnull Object messageValue2) {
        if (!mustBeTrue) {
            throw new RelationalException(String.format(Locale.ROOT, messageTemplate, messageValue1, messageValue2), errorCodeIfNotTrue).toUncheckedWrappedException();
        }
    }

    public static <T> T notNullUnchecked(T object) {
        return Assert.notNullUnchecked(object, "unexpected null object");
    }

    public static <T> T notNullUnchecked(T object, @Nonnull String messageIfNull) {
        return Assert.notNullUnchecked(object, ErrorCode.INTERNAL_ERROR, messageIfNull);
    }

    public static <T> T notNullUnchecked(T object, @Nonnull ErrorCode errorCodeIfNull, @Nonnull Supplier<String> messageSupplier) {
        if (object == null) {
            throw new RelationalException(messageSupplier.get(), errorCodeIfNull).toUncheckedWrappedException();
        }
        return object;
    }

    public static <T> T notNullUnchecked(T object, @Nonnull ErrorCode errorCodeIfNull, @Nonnull String messageIfNull) {
        if (object == null) {
            throw new RelationalException(messageIfNull, errorCodeIfNull).toUncheckedWrappedException();
        }
        return object;
    }

    public static <T> T notNullUnchecked(T object, @Nonnull ErrorCode errorCodeIfNull, @Nonnull String messageTemplate, @Nonnull Object messageValue) {
        if (object == null) {
            throw new RelationalException(String.format(Locale.ROOT, messageTemplate, messageValue), errorCodeIfNull).toUncheckedWrappedException();
        }
        return object;
    }

    public static void isNullUnchecked(Object object) {
        Assert.isNullUnchecked(object, "expected object to be null");
    }

    public static void isNullUnchecked(Object object, @Nonnull String messageIfNotNull) {
        Assert.isNullUnchecked(object, ErrorCode.INTERNAL_ERROR, messageIfNotNull);
    }

    public static void isNullUnchecked(Object object, @Nonnull ErrorCode errorCodeIfNotNull, @Nonnull Supplier<String> messageSupplier) {
        if (object != null) {
            throw new RelationalException(messageSupplier.get(), errorCodeIfNotNull).toUncheckedWrappedException();
        }
    }

    public static void isNullUnchecked(Object object, @Nonnull ErrorCode errorCodeIfNotNull, @Nonnull String messageIfNotNull) {
        if (object != null) {
            throw new RelationalException(messageIfNotNull, errorCodeIfNotNull).toUncheckedWrappedException();
        }
    }

    public static UncheckedRelationalException failUnchecked() {
        throw Assert.failUnchecked("unexpected error");
    }

    public static UncheckedRelationalException failUnchecked(@Nonnull String failMessage) {
        throw Assert.failUnchecked(ErrorCode.INTERNAL_ERROR, failMessage);
    }

    public static UncheckedRelationalException failUnchecked(@Nonnull ErrorCode failErrorCode, @Nonnull String failMessage) {
        throw new RelationalException(failMessage, failErrorCode).toUncheckedWrappedException();
    }

    @Nonnull
    public static <S, T> S castUnchecked(T object, Class<S> clazz) {
        return Assert.castUnchecked(object, clazz, ErrorCode.INTERNAL_ERROR, () -> "expected " + clazz.getSimpleName() + " but got " + (object == null ? "null" : object.getClass().getSimpleName()));
    }

    @Nonnull
    public static <S, T> S castUnchecked(T object, Class<S> clazz, @Nonnull ErrorCode errorCodeIfCastFailed, @Nonnull Supplier<String> messageSupplier) {
        T notNullObject = Assert.notNullUnchecked(object, errorCodeIfCastFailed, messageSupplier);
        if (clazz.isInstance(notNullObject)) {
            return clazz.cast(object);
        }
        Assert.failUnchecked(errorCodeIfCastFailed, messageSupplier.get());
        return null;
    }

    @Nonnull
    public static <V> V optionalUnchecked(@Nonnull Optional<V> optional) {
        return Assert.optionalUnchecked(optional, ErrorCode.INTERNAL_ERROR, () -> "expected non-empty Optional");
    }

    @Nonnull
    public static <T> T optionalUnchecked(@Nonnull Optional<T> optional, @Nonnull ErrorCode errorCodeIfOptionalEmpty, @Nonnull Supplier<String> messageSupplier) {
        if (optional.isPresent()) {
            return optional.get();
        }
        Assert.failUnchecked(errorCodeIfOptionalEmpty, messageSupplier.get());
        return null;
    }

    private Assert() {
    }
}

