/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.util;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

@API(value=API.Status.EXPERIMENTAL)
public final class BuildVersion {
    private static BuildVersion instance;
    private static final String VERSIONS_PROPERTIES_FILENAME = "version.properties";
    private final Properties versionProperties = new Properties();

    private BuildVersion() {
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(VERSIONS_PROPERTIES_FILENAME);){
            this.versionProperties.load(stream);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed load of version.properties", e);
        }
    }

    public static synchronized BuildVersion getInstance() {
        if (instance == null) {
            instance = new BuildVersion();
        }
        return instance;
    }

    public String getURL() {
        return this.versionProperties.getProperty("url");
    }

    public String getVersion() {
        return this.versionProperties.getProperty("version");
    }

    static int parseDriverVersion(String version, int index) throws RelationalException {
        int[] v = new int[3];
        try {
            String[] splitVersion = version.split("[-.]");
            v[0] = Integer.parseInt(splitVersion[0]);
            v[1] = Integer.parseInt(splitVersion[1]);
            v[2] = "SNAPSHOT".equals(splitVersion[2]) ? -1 : Integer.parseInt(splitVersion[2]);
        }
        catch (RuntimeException ex) {
            throw new RelationalException("Cannot parse driver version: " + version, ErrorCode.INTERNAL_ERROR, ex);
        }
        return v[index];
    }

    public int getMajorVersion() throws RelationalException {
        return this.getMajorVersion(this.getVersion());
    }

    public int getMajorVersion(String version) throws RelationalException {
        return BuildVersion.parseDriverVersion(version, 0);
    }

    public int getMinorVersion() throws RelationalException {
        return this.getMinorVersion(this.getVersion());
    }

    public int getMinorVersion(String version) throws RelationalException {
        return BuildVersion.parseDriverVersion(version, 1);
    }
}

